/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import org.alov.map.DataStorage;
import org.alov.map.FloatRectangle;
import org.alov.map.Record;

public class DataStorageFast
extends DataStorage {
    protected Vector data = new Vector();

    public void afterDeserialization() {
        super.afterDeserialization();
    }

    public int size() {
        return this.data.size();
    }

    public void saveDataStorageRec(Record record, boolean bl) throws IOException {
        if (!this.data.contains(record)) {
            this.data.addElement(record);
        }
    }

    public void openDataStorageSave(boolean bl) {
    }

    public void openDataStorageSaveCoordinates() {
    }

    public void closeDataStorageSave() {
    }

    public void openDataStorage(boolean bl) {
    }

    public void closeDataStorage() {
    }

    public void skipAttribute(int n) throws IOException {
    }

    protected void skipAttribute2(int n, int n2) throws IOException {
    }

    protected void skipSpatial(int n) throws IOException {
    }

    protected void skipSpatial2(int n, int n2) throws IOException {
    }

    public void readRecAttribute(Record record) throws IOException {
    }

    public boolean readRecCoords(Record record, FloatRectangle floatRectangle) throws IOException {
        return floatRectangle == null || floatRectangle.intersects(record.getRecordExtent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Record newRecord(int n) {
        DataStorageFast dataStorageFast = this;
        synchronized (dataStorageFast) {
            Record record;
            if (n < 0 || n >= this.data.size()) {
                record = new Record(this.fieldOriginalCount);
                record.index = n;
            } else {
                record = (Record)this.data.elementAt(n);
            }
            return record;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Record getRecord(int n, int n2) {
        DataStorageFast dataStorageFast = this;
        synchronized (dataStorageFast) {
            if (n >= 0 && n < this.data.size()) {
                return (Record)this.data.elementAt(n);
            }
            return null;
        }
    }

    public void clear() {
        int n = this.data.size();
        for (int i = 0; i < n; ++i) {
            Record record = (Record)this.data.elementAt(i);
            record = null;
        }
        this.data.removeAllElements();
    }

    public DataStorage copy() {
        DataStorageFast dataStorageFast = new DataStorageFast();
        dataStorageFast.data = (Vector)this.data.clone();
        dataStorageFast.fieldOriginalCount = this.fieldOriginalCount;
        return dataStorageFast;
    }

    public void deleteRecord(Record record) {
        this.data.removeElementAt(record.index);
        int n = this.data.size();
        for (int i = record.index; i < n; ++i) {
            Record record2 = (Record)this.data.elementAt(i);
            --record2.index;
        }
        record = null;
    }

    public void changeRecord(Record record, int n) {
        int n2 = this.data.size();
        if (record.index < 0 || record.index >= n2) {
            this.data.addElement(record);
            record.index = n2;
        } else {
            this.data.setElementAt(record, record.index);
        }
    }

    protected void unionStorages(DataStorage dataStorage) {
        int n = dataStorage.size();
        for (int i = 0; i < n; ++i) {
            Record record = dataStorage.getRecord(i, 0);
            this.data.addElement(record);
            record.index = this.data.size() - 1;
        }
    }

    public void write(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(this.data);
        objectOutputStream.close();
    }

    public void read(InputStream inputStream) throws Exception {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        this.data = (Vector)objectInputStream.readObject();
        objectInputStream.close();
    }
}

