/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.io.Serializable;
import org.alov.map.FloatPoint;

public class FloatRectangle
implements Serializable {
    public double x;
    public double y;
    public double x2;
    public double y2;

    public FloatRectangle() {
    }

    public FloatRectangle(FloatRectangle floatRectangle) {
        this.setBounds(floatRectangle.x, floatRectangle.y, floatRectangle.x2, floatRectangle.y2);
    }

    public FloatRectangle(FloatPoint floatPoint, FloatPoint floatPoint2) {
        this.setBounds(floatPoint.x, floatPoint2.y, floatPoint2.x, floatPoint.y);
    }

    public FloatRectangle(double d, double d2, double d3, double d4) {
        this.setBounds(d, d2, d3, d4);
    }

    public FloatRectangle(boolean bl) {
        this.setBounds(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.x2 = d3;
        this.y2 = d4;
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.x2 == 0.0 && this.y2 == 0.0 || this.x > this.x2 || this.y > this.y2;
    }

    public boolean intersects(FloatRectangle floatRectangle) {
        return !(floatRectangle == null || floatRectangle.x2 <= this.x || floatRectangle.y2 <= this.y || floatRectangle.x >= this.x2 || floatRectangle.y >= this.y2);
    }

    public boolean contains(FloatRectangle floatRectangle) {
        return !(floatRectangle == null || floatRectangle.x2 > this.x2 || floatRectangle.x < this.x || floatRectangle.y2 > this.y2 || floatRectangle.y < this.y);
    }

    public boolean equals(FloatRectangle floatRectangle) {
        return floatRectangle != null && floatRectangle.x2 == this.x2 && floatRectangle.y2 == this.y2 && floatRectangle.x == this.x && floatRectangle.y == this.y;
    }

    public boolean contain(double d, double d2) {
        return !(d < this.x || d2 < this.y || d > this.x2 || d2 > this.y2);
    }

    public FloatRectangle intersection(FloatRectangle floatRectangle) {
        double d = Math.max(this.x, floatRectangle.x);
        double d2 = Math.min(this.x2, floatRectangle.x2);
        double d3 = Math.max(this.y, floatRectangle.y);
        double d4 = Math.min(this.y2, floatRectangle.y2);
        if (d2 - d < 0.0 || d4 - d3 < 0.0) {
            return null;
        }
        return new FloatRectangle(d, d3, d2, d4);
    }

    public void union(FloatRectangle floatRectangle) {
        if (floatRectangle != null) {
            this.x = Math.min(this.x, floatRectangle.x);
            this.x2 = Math.max(this.x2, floatRectangle.x2);
            this.y = Math.min(this.y, floatRectangle.y);
            this.y2 = Math.max(this.y2, floatRectangle.y2);
        }
    }

    public void add(double d, double d2) {
        this.x = Math.min(this.x, d);
        this.x2 = Math.max(this.x2, d);
        this.y = Math.min(this.y, d2);
        this.y2 = Math.max(this.y2, d2);
    }

    public FloatRectangle scale(double d) {
        double d2 = (this.x2 - this.x) * d / 2.0;
        double d3 = (this.y2 - this.y) * d / 2.0;
        double d4 = (this.x2 + this.x) / 2.0;
        double d5 = (this.y2 + this.y) / 2.0;
        return new FloatRectangle(d4 - d2, d5 - d3, d4 + d2, d5 + d3);
    }

    public FloatPoint getCentre() {
        return new FloatPoint((this.x + this.x2) / 2.0, (this.y + this.y2) / 2.0);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ") - (" + this.x2 + ", " + this.y2 + ")";
    }
}

