/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.alov.data.DataProvider;
import org.alov.data.SQLConst;
import org.alov.map.Carte;
import org.alov.map.ComplexFigure;
import org.alov.map.DataStorage;
import org.alov.map.DataStorageFast;
import org.alov.map.DisplayContext;
import org.alov.map.FieldDef;
import org.alov.map.FilterRecords;
import org.alov.map.FilterTime;
import org.alov.map.FloatPoint;
import org.alov.map.FloatRectangle;
import org.alov.map.LayerGroup;
import org.alov.map.LayerVector;
import org.alov.map.MapUtils;
import org.alov.map.Meta;
import org.alov.map.Project;
import org.alov.map.RadioGroup;
import org.alov.map.Record;
import org.alov.map.RecordsArray;
import org.alov.map.Renderer;
import org.alov.map.RendererDef;
import org.alov.map.Shape;
import org.alov.util.AlovMapException;
import org.alov.util.ExDate;
import org.alov.util.Log;
import org.alov.util.SimpleTimer;
import org.alov.util.Strings;
import org.alov.util.TimeInterval;
import org.alov.util.TimerListener;

public abstract class Layer
implements Serializable,
TimerListener {
    public DataStorage dataStorage;
    transient DisplayContext parentMap = null;
    static final String FILTER_TIME = "TF";
    static final String FILTER_VALUE = "SF";
    public DataProvider provider = null;
    public boolean initiallyVisible = true;
    public boolean setVisiblityOnce = false;
    public int serverType = -1;
    public Properties connectionData;
    public Meta metadata = new Meta();
    protected FloatRectangle layerExtent = null;
    ComplexFigure loadedExtent = new ComplexFigure();
    public String id = null;
    public String datasetId = null;
    public boolean isGeocoding = false;
    private String title;
    private boolean visible = true;
    public boolean visible_always = false;
    public boolean legendVisible = true;
    public int legendOrder = -1;
    public boolean legendWrapText = false;
    public String legendName = null;
    public boolean legendHideOutRange = false;
    boolean removeOutOfExtent = false;
    public boolean legendExpanded = true;
    public Shape legendSymbolShape = null;
    public int legendObjectType = 0;
    public Color legendColor = null;
    public boolean isKeyMap = false;
    protected Shape hotSpot = null;
    private RecordsArray selection = null;
    public Vector renderers = new Vector();
    public boolean canSearch = true;
    public boolean canSelectByMouse = true;
    public boolean withinZoom = false;
    public float zmin;
    public float zmax;
    public float zoom_for_select = -1.0f;
    public boolean withinDate = false;
    public boolean timeVarying = false;
    public ExDate timeMin;
    public ExDate timeMax;
    public int drawOrder = 0;
    public int fi_description = -1;
    public String linkMain = null;
    public String linkSearch = null;
    public String linkTips = null;
    public String linkLegend = null;
    public String tipsMask = null;
    public boolean notPrepared = true;
    public Vector themes = new Vector();
    public String style = null;
    public Hashtable controlledLayers = null;
    public Vector controlledLayersUnresolved = null;
    public RadioGroup radioGroup = null;
    public boolean isDataOnServer;
    public boolean isFullLoad;
    public boolean zoomToExtentAfterCustomLoad = false;
    public String url;
    public Hashtable filters = new Hashtable();
    private Properties fieldAliases = null;
    protected boolean hasChart = false;
    private SimpleTimer reloadTimer;
    protected boolean isAnimatedZoom = false;
    private static final String _LAYERNAME = "$LAYERNAME";
    private static final String _LAYERID = "$LAYERID";
    private static final String _DATASETID = "$DATASETID";
    private static final String _PASSTHR = "$PASSTHROUGH";
    private static final String _SEARCHVAL = "$SEARCH";
    private static final String _USER = "$USER";
    private static final String _RECORDID = "$RECID";
    private static final String _BBOX_ALL = "$BBOXALL";
    private static final String _BBOX_DR = "$BBOXDR";
    private static final String _BBOX_SEL = "$BBOXSEL";
    private static final String _BBXMIN = "$BBXMIN";
    private static final String _BBXMAX = "$BBXMAX";
    private static final String _BBYMIN = "$BBYMIN";
    private static final String _BBYMAX = "$BBYMAX";
    private static final String _DRXMIN = "$DRXMIN";
    private static final String _DRXMAX = "$DRXMAX";
    private static final String _DRYMIN = "$DRYMIN";
    private static final String _DRYMAX = "$DRYMAX";
    private static final String _SELXMIN = "$SELXMIN";
    private static final String _SELXMAX = "$SELXMAX";
    private static final String _SELYMIN = "$SELYMIN";
    private static final String _SELYMAX = "$SELYMAX";
    private static final String _TSTART = "$TSTART";
    private static final String _TEND = "$TEND";
    private static final String _EXTERNAL = "$EXTERNAL";
    private static final int _LOWER_CASE = 1;
    private static final int _UPPER_CASE = 2;

    public Layer() {
        this.dataStorage = new DataStorageFast();
    }

    public String getName() {
        return this.title;
    }

    public void setName(String string) {
        this.title = string;
    }

    public boolean isVisibleNow(DisplayContext displayContext) {
        return this.visible ? this.isOutOfRange(displayContext) == 0 && !this.isOutOfExtent(displayContext) && this.isPassResolved() && this.isTheme(displayContext) : false;
    }

    public boolean isBelongToLegend(String string) {
        return this.legendName == null || this.legendName.equalsIgnoreCase(string);
    }

    public boolean isInvisibleInLegend(DisplayContext displayContext) {
        return !this.isTheme(displayContext) || !this.legendVisible || this.metadata.loadFailed && Log.debugLevel == 0 || this.legendHideOutRange && (this.isOutOfRange(displayContext) != 0 || this.isOutOfExtent(displayContext));
    }

    public boolean isPassResolved() {
        return this.metadata.passResolved;
    }

    public void setTimeInterval(TimeInterval timeInterval) {
        if (this.filters == null) {
            return;
        }
        Enumeration enumeration = this.filters.elements();
        while (enumeration.hasMoreElements()) {
            FilterRecords filterRecords = (FilterRecords)enumeration.nextElement();
            if (!(filterRecords instanceof FilterTime)) continue;
            ((FilterTime)filterRecords).setTimeInterval(timeInterval);
        }
    }

    public RecordsArray getSelection() {
        return this.selection;
    }

    public void setSelection(RecordsArray recordsArray) {
        this.selection = recordsArray;
    }

    public int getFieldCount() {
        return this.dataStorage.getFields() == null ? 0 : this.dataStorage.getFields().length;
    }

    public int getFieldOriginalCount() {
        return this.dataStorage.fieldOriginalCount;
    }

    public FieldDef getFieldDef(int n) {
        FieldDef[] fieldDefArray = this.dataStorage.getFields();
        return fieldDefArray == null || n > fieldDefArray.length ? null : fieldDefArray[n];
    }

    public FieldDef getFieldDef_(int n) {
        FieldDef[] fieldDefArray = this.dataStorage.getFields();
        return fieldDefArray != null && n < fieldDefArray.length && n >= 0 ? fieldDefArray[n] : null;
    }

    public void setFieldDef(int n, FieldDef fieldDef) {
        FieldDef[] fieldDefArray = this.dataStorage.getFields();
        if (n >= 0 && n < fieldDefArray.length) {
            fieldDefArray[n] = fieldDef;
        }
    }

    public int getFieldIndex(String string) {
        FieldDef[] fieldDefArray = this.dataStorage.getFields();
        if (string != null && fieldDefArray != null) {
            int n = fieldDefArray.length;
            if (this.fieldAliases != null) {
                string = this.fieldAliases.getProperty(string.toLowerCase(), string);
            }
            for (int i = 0; i < n; ++i) {
                if (!string.equalsIgnoreCase(fieldDefArray[i].name)) continue;
                return i;
            }
        }
        return -1;
    }

    public Object getFieldValue(Record record, int n) {
        if (n >= 0) {
            FieldDef[] fieldDefArray = this.dataStorage.getFields();
            if (n < this.dataStorage.fieldOriginalCount) {
                return record.getField(n);
            }
            if (n < fieldDefArray.length) {
                FieldDef fieldDef = fieldDefArray[n];
                if (fieldDef.field != null) {
                    return fieldDef.field.getFieldValue(record, n);
                }
            }
        }
        return null;
    }

    public String getFieldString(Record record, int n) {
        Object object = this.getFieldValue(record, n);
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public double getFieldDouble(Record record, int n) {
        Object object = this.getFieldValue(record, n);
        return MapUtils.toDouble(object);
    }

    public boolean isSomethingVisible(DisplayContext displayContext) {
        if (this.isVisibleNow(displayContext) || this.isKeyMap) {
            int n = this.renderers.size();
            for (int i = 0; i < n; ++i) {
                Renderer renderer = (Renderer)this.renderers.elementAt(i);
                if (!renderer.isVisible(displayContext)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isTheme(DisplayContext displayContext) {
        String string = this.style;
        if (this.style == null) {
            if (displayContext == null || this.themes == null) {
                return true;
            }
            string = displayContext.getThematicMap();
        }
        return this.themes == null || this.themes.size() == 0 || string == null || this.themes.indexOf(string) >= 0;
    }

    public int isOutOfRange(DisplayContext displayContext) {
        TimeInterval timeInterval;
        int n = 0;
        if (this.withinZoom && displayContext != null) {
            double d = displayContext.getDistance(displayContext.getLastExtent());
            int n2 = this.zmin > 0.0f && (double)this.zmin > d ? -1 : (n = this.zmax > 0.0f && d > (double)this.zmax ? 1 : 0);
        }
        if (n == 0 && this.withinDate && displayContext != null && (timeInterval = displayContext.getTimeInterval()) != null) {
            n = timeInterval.inInterval(this.timeMin, this.timeMax);
        }
        return n;
    }

    public boolean isOutOfExtent(DisplayContext displayContext) {
        boolean bl = displayContext != null && !this.metadata.maxExtent.isZero() && !this.metadata.maxExtent.intersects(displayContext.getLastExtent());
        return bl;
    }

    public boolean isEmpty() {
        return this.dataStorage.size() == 0;
    }

    public abstract void paintRecords(Vector var1, Renderer var2, boolean var3, DisplayContext var4, int var5);

    public abstract RecordsArray paintRecords2(Renderer var1, DisplayContext var2, int var3);

    public abstract RecordsArray findWithinRect(FloatRectangle var1, boolean var2);

    public abstract RecordsArray findWithinShape(Shape var1, boolean var2, boolean var3);

    public abstract RecordsArray findWithinCircle(FloatPoint var1, double var2, boolean var4, boolean var5);

    public void setParentMap(DisplayContext displayContext) {
        this.parentMap = displayContext;
    }

    public DisplayContext getMap() {
        return this.parentMap;
    }

    public void clearRenderers() {
        int n = this.renderers.size();
        for (int i = 0; i < n; ++i) {
            Renderer renderer = (Renderer)this.renderers.elementAt(i);
            renderer.symbols = null;
            renderer = null;
        }
        this.renderers.removeAllElements();
        this.renderers = null;
    }

    public void clear(boolean bl) {
        this.dataStorage.clear();
        this.metadata.memsize = 0;
        this.layerExtent = null;
        this.setSelection(null);
        this.loadedExtent = null;
        if (bl) {
            if (this.reloadTimer != null) {
                this.reloadTimer.stop();
            }
            this.clearRenderers();
            this.provider = null;
            this.themes = null;
            this.filters = null;
        } else {
            this.metadata.loadFailed = false;
            this.metadata.forceClearCache = true;
            this.setLoadComplete(false);
        }
        System.gc();
        this.loadedExtent = new ComplexFigure();
    }

    public void setLoadComplete(boolean bl) {
        if (this.isGeocoding) {
            if (this.layerExtent != null) {
                this.metadata.maxExtent = this.layerExtent;
            }
        } else {
            this.metadata.isLoaded = bl;
            if (bl && this.layerExtent != null && this.metadata.maxExtent.isZero()) {
                this.metadata.maxExtent = this.layerExtent;
            }
        }
    }

    public boolean isLoadComplete() {
        return this.metadata.isLoaded;
    }

    public FloatRectangle getLayerExtent() {
        return this.layerExtent;
    }

    public void setLayerExtent(FloatRectangle floatRectangle) {
        if (this.layerExtent == null) {
            this.layerExtent = new FloatRectangle(floatRectangle);
        } else {
            this.layerExtent.setBounds(floatRectangle.x, floatRectangle.y, floatRectangle.x2, floatRectangle.y2);
        }
    }

    FloatRectangle getSelectionExtent() {
        if (this.selection != null) {
            return this.selection.getExtent();
        }
        return null;
    }

    public void addExtent(Record record) {
        FloatRectangle floatRectangle = record.getRecordExtent();
        if (floatRectangle != null) {
            if (this.layerExtent == null) {
                this.layerExtent = new FloatRectangle(floatRectangle);
            } else {
                this.layerExtent.union(floatRectangle);
            }
        }
    }

    public void prepareLayer() {
        int n = this.renderers.size();
        for (int i = 0; i < n; ++i) {
            Renderer renderer = (Renderer)this.renderers.elementAt(i);
            try {
                renderer.prepare();
                if (!renderer.isPrepared) continue;
                this.notPrepared = false;
                continue;
            }
            catch (Exception exception) {
                if (!(this.parentMap instanceof Carte)) continue;
                Log.addMessage(108, ((Component)((Object)this.parentMap)).getName(), this, exception.getMessage());
            }
        }
        if (this.parentMap instanceof Carte) {
            ((Carte)this.parentMap).broadcastMessage(15, this.id);
            if (this.reloadTimer == null && this.metadata.reloadTimeRange > 0) {
                this.reloadTimer = new SimpleTimer(this.metadata.reloadTimeRange * 1000, this);
            }
        }
    }

    public void afterDeserialization() {
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.setVisible(bl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setVisible(boolean bl, boolean bl2) {
        if (this.setVisiblityOnce) {
            return;
        }
        this.setVisiblityOnce = true;
        try {
            boolean bl3 = this.visible_always || bl;
            boolean bl4 = false;
            if (this.visible != bl3) {
                this.visible = bl3;
                if (this.controlledLayers != null) {
                    Enumeration enumeration = this.controlledLayers.elements();
                    Enumeration enumeration2 = this.controlledLayers.keys();
                    while (enumeration2.hasMoreElements()) {
                        Layer layer = (Layer)enumeration2.nextElement();
                        boolean bl5 = "1".equals((String)enumeration.nextElement()) ? bl3 : !bl3;
                        layer.setVisible(bl5, false);
                        bl4 = bl4 || bl5;
                    }
                }
                if (this.radioGroup != null) {
                    this.radioGroup.layerVisibleChanged(this, this.visible);
                }
                if (this.parentMap instanceof Carte) {
                    ((Carte)this.parentMap).broadcastMessage(101, this.id);
                    if (bl2 && (bl3 || bl4)) {
                        if (this.controlledLayers != null) {
                            ((Carte)this.parentMap).extentChanged();
                        } else {
                            ((Carte)this.parentMap).downloadLayer(this.id);
                        }
                    }
                }
            }
        }
        finally {
            this.setVisiblityOnce = false;
        }
    }

    public void setExpanded(boolean bl) {
        if (this.legendExpanded != bl) {
            this.legendExpanded = bl;
            if (this instanceof LayerGroup && this.controlledLayers != null) {
                Enumeration enumeration = this.controlledLayers.keys();
                while (enumeration.hasMoreElements()) {
                    Layer layer = (Layer)enumeration.nextElement();
                    layer.legendVisible = bl;
                    if (layer.controlledLayers == null) continue;
                    layer.setExpanded(bl);
                }
            }
        }
    }

    public Record findAtScreenPoint(Point point) {
        if (this.parentMap != null && this.parentMap instanceof Carte) {
            RecordsArray recordsArray = null;
            if (this.hotSpot != null && this.isObjectType(1) && this instanceof LayerVector) {
                recordsArray = ((LayerVector)this).findWithinScreenRect(point, true);
            } else {
                Carte carte = (Carte)this.parentMap;
                FloatPoint floatPoint = carte.screenToMap(new Point(point.x + 2, point.y + 2));
                FloatPoint floatPoint2 = carte.screenToMap(new Point(point.x - 4, point.y - 4));
                FloatRectangle floatRectangle = new FloatRectangle(floatPoint2.x, floatPoint.y, floatPoint.x, floatPoint2.y);
                recordsArray = this.findWithinRect(floatRectangle, true);
            }
            if (MapUtils.isNotEmptyRecs(recordsArray)) {
                return recordsArray.getRecord(0);
            }
        }
        return null;
    }

    void setDepend(Project project) {
        if (this.controlledLayers != null) {
            Enumeration enumeration = this.controlledLayers.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                if (!(k instanceof String)) continue;
                String string = (String)k;
                Layer layer = project.getLayerById(string);
                if (layer == null || layer == this) {
                    if (this.controlledLayersUnresolved == null) {
                        this.controlledLayersUnresolved = new Vector();
                    }
                    this.controlledLayersUnresolved.addElement(string);
                } else {
                    if (this instanceof LayerGroup) {
                        layer.legendVisible = this.legendExpanded;
                    }
                    this.controlledLayers.put(layer, this.controlledLayers.get(string));
                }
                this.controlledLayers.remove(string);
            }
            if (this.controlledLayers.size() == 0) {
                this.controlledLayers = null;
            }
        }
    }

    protected void readMetadata_(DataInputStream dataInputStream) throws Exception {
        short s;
        while ((s = dataInputStream.readShort()) != 0) {
            this.metadata.put(s, dataInputStream.readUTF());
        }
        if (this instanceof LayerVector) {
            String string = ',' + this.metadata.getStr(312).toUpperCase() + ',';
            this.dataStorage.setObjectType(dataInputStream.read());
            int n = dataInputStream.readShort();
            FieldDef[] fieldDefArray = this.dataStorage.initFields(n);
            for (int i = 0; i < n; ++i) {
                FieldDef fieldDef = new FieldDef();
                fieldDef.name = dataInputStream.readUTF();
                fieldDef.label = this.metadata.getFieldAlias(fieldDef.name, MapUtils.language);
                fieldDef.type = dataInputStream.readInt();
                fieldDef.index = i;
                fieldDef.visible = dataInputStream.read() == 1;
                fieldDef.editable = string.indexOf(',' + fieldDef.name.toUpperCase() + ',') >= 0;
                fieldDefArray[i] = fieldDef;
            }
        }
        this.resolveMetadata();
        this.prepareLayer();
    }

    public void resolveMetadata() throws AlovMapException {
        this.serverType = Meta.getSrvId(this.metadata.getVal(168));
        if (this.linkMain == null) {
            this.linkMain = this.metadata.getVal(63);
        }
        if (this.linkLegend == null) {
            this.linkLegend = this.metadata.getVal(320);
        }
        this.metadata.maxExtent.x = this.metadata.getDouble(4);
        this.metadata.maxExtent.x2 = this.metadata.getDouble(5);
        this.metadata.maxExtent.y = this.metadata.getDouble(6);
        this.metadata.maxExtent.y2 = this.metadata.getDouble(7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getWebLink(String string, Object object, String string2, FloatRectangle floatRectangle, String string3) {
        if (Strings.isNullOrBlank(string)) {
            return null;
        }
        int n = string.length();
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        boolean bl3 = true;
        int n4 = 0;
        int n5 = 0;
        n5 = object == null ? 0 : (object instanceof Record ? 1 : ((RecordsArray)object).size());
        FloatRectangle floatRectangle2 = this.parentMap.getLastExtent();
        TimeInterval timeInterval = this.parentMap.getTimeInterval();
        String string4 = this.parentMap.getParameter("external", "");
        if (floatRectangle == null) {
            floatRectangle = floatRectangle2;
        }
        FloatRectangle floatRectangle3 = this.getSelectionExtent();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (bl2 || c == '[') {
                if (c == ']' && stringBuffer3.length() > 0) {
                    int n6;
                    String string5 = stringBuffer3.toString().trim();
                    if (string5.length() > 0) {
                        string5 = string5.substring(1);
                        n6 = string5.lastIndexOf(44);
                        n2 = 0;
                        n3 = 0;
                        bl3 = true;
                        while (n6 > 0) {
                            String string6;
                            if (n6 < string5.length() && (string6 = string5.substring(n6 + 1, string5.length()).trim()).length() > 0) {
                                if (string6.equalsIgnoreCase("$u")) {
                                    n3 = 2;
                                } else if (string6.equalsIgnoreCase("$l")) {
                                    n3 = 1;
                                } else if (string6.equalsIgnoreCase("$ne")) {
                                    bl3 = false;
                                } else if (string6.startsWith("$f")) {
                                    n4 = Strings.strToInt(string6.substring(2), 0);
                                } else {
                                    n2 = Strings.strToInt(string6, 0);
                                }
                            }
                            string5 = string5.substring(0, n6);
                            n6 = string5.lastIndexOf(44);
                        }
                    }
                    if (string5.startsWith("#")) {
                        stringBuffer.append(this.parentMap.getParameter(string5.substring(1), ""));
                    } else if (string5.equalsIgnoreCase(_BBOX_ALL)) {
                        stringBuffer.append(floatRectangle2.x).append(',').append(floatRectangle2.y).append(',').append(floatRectangle2.x2).append(',').append(floatRectangle2.y2);
                    } else if (string5.equalsIgnoreCase(_BBXMIN)) {
                        stringBuffer.append(floatRectangle2.x);
                    } else if (string5.equalsIgnoreCase(_BBYMIN)) {
                        stringBuffer.append(floatRectangle2.y);
                    } else if (string5.equalsIgnoreCase(_BBXMAX)) {
                        stringBuffer.append(floatRectangle2.x2);
                    } else if (string5.equalsIgnoreCase(_BBYMAX)) {
                        stringBuffer.append(floatRectangle2.y2);
                    } else if (string5.equalsIgnoreCase(_BBOX_SEL)) {
                        stringBuffer.append(floatRectangle3.x).append(',').append(floatRectangle3.y).append(',').append(floatRectangle3.x2).append(',').append(floatRectangle3.y2);
                    } else if (string5.equalsIgnoreCase(_SELXMIN)) {
                        stringBuffer.append(floatRectangle3.x);
                    } else if (string5.equalsIgnoreCase(_SELYMIN)) {
                        stringBuffer.append(floatRectangle3.y);
                    } else if (string5.equalsIgnoreCase(_SELXMAX)) {
                        stringBuffer.append(floatRectangle3.x2);
                    } else if (string5.equalsIgnoreCase(_SELYMAX)) {
                        stringBuffer.append(floatRectangle3.y2);
                    } else if (string5.equalsIgnoreCase(_BBOX_DR)) {
                        stringBuffer.append(floatRectangle.x).append(',').append(floatRectangle.y).append(',').append(floatRectangle.x2).append(',').append(floatRectangle.y2);
                    } else if (string5.equalsIgnoreCase(_DRXMIN)) {
                        stringBuffer.append(floatRectangle.x);
                    } else if (string5.equalsIgnoreCase(_DRYMIN)) {
                        stringBuffer.append(floatRectangle.y);
                    } else if (string5.equalsIgnoreCase(_DRXMAX)) {
                        stringBuffer.append(floatRectangle.x2);
                    } else if (string5.equalsIgnoreCase(_DRYMAX)) {
                        stringBuffer.append(floatRectangle.y2);
                    } else if (string5.equalsIgnoreCase(_TSTART)) {
                        if (timeInterval != null) {
                            stringBuffer.append(timeInterval.date1().toString());
                        }
                    } else if (string5.equalsIgnoreCase(_TEND)) {
                        if (timeInterval != null) {
                            stringBuffer.append(timeInterval.date2().toString());
                        }
                    } else if (string5.equalsIgnoreCase(_LAYERNAME)) {
                        stringBuffer.append(this.title);
                    } else if (string5.equalsIgnoreCase(_LAYERID)) {
                        stringBuffer.append(this.id);
                    } else if (string5.equalsIgnoreCase(_DATASETID)) {
                        stringBuffer.append(this.datasetId);
                    } else if (string5.equalsIgnoreCase(_USER)) {
                        if (string3 != null) {
                            stringBuffer.append(string3);
                        }
                    } else if (string5.equalsIgnoreCase(_EXTERNAL)) {
                        stringBuffer.append(string4);
                    } else if (string5.equalsIgnoreCase(_SEARCHVAL)) {
                        if (string2 != null) {
                            stringBuffer.append(URLEncoder.encode(string2));
                        }
                    } else {
                        int n7 = this.getFieldIndex(string5);
                        if (object != null && (n7 >= 0 || string5.equalsIgnoreCase(_RECORDID))) {
                            int n8 = 0;
                            int n9 = this.dataStorage.size() - 1;
                            DataStorage dataStorage = this.dataStorage;
                            synchronized (dataStorage) {
                                this.dataStorage.openDataStorage(true);
                                try {
                                    for (int j = 0; j < n5; ++j) {
                                        String string7;
                                        int n10;
                                        Record record;
                                        if (object instanceof Record) {
                                            record = (Record)object;
                                        } else {
                                            n10 = ((RecordsArray)object).get(j);
                                            this.dataStorage.skipAttribute2(n10, n8);
                                            n8 = n10 < n9 ? n10 + 1 : 0;
                                            record = this.newRecord(n10);
                                            this.dataStorage.readRecAttribute(record);
                                        }
                                        String string8 = string7 = string5.equalsIgnoreCase(_RECORDID) ? ((LayerVector)this).getId(record) : this.getFieldString(record, n7);
                                        if (n4 != 0) {
                                            string7 = Strings.doubleToStr(MapUtils.toDouble(string7), n4);
                                        } else {
                                            if (n3 == 2) {
                                                string7 = string7.toUpperCase();
                                            }
                                            if (n3 == 1) {
                                                string7 = string7.toLowerCase();
                                            }
                                        }
                                        if (bl3) {
                                            string7 = URLEncoder.encode(string7);
                                        }
                                        n6 = string7.length();
                                        int n11 = stringBuffer.length();
                                        stringBuffer.append(string7);
                                        for (n10 = n6; n10 < n2; ++n10) {
                                            stringBuffer.insert(n11, '0');
                                        }
                                        if (n5 <= 1 || j + 1 >= n5) continue;
                                        stringBuffer.append(',');
                                    }
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                }
                                finally {
                                    this.dataStorage.closeDataStorage();
                                }
                            }
                        }
                    }
                    bl2 = false;
                    stringBuffer3.setLength(0);
                    continue;
                }
                stringBuffer3.append(c);
                bl2 = true;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public Record newRecord(int n) {
        return this.dataStorage.newRecord(n);
    }

    public void addRecord(Record record) {
        this.addExtent(record);
        if (this.hasChart) {
            FieldDef[] fieldDefArray = this.dataStorage.getFields();
            int n = fieldDefArray.length;
            for (int i = 0; i < n; ++i) {
                if (!SQLConst.isNumber(fieldDefArray[i].type)) continue;
                double d = this.getFieldDouble(record, i);
                if (fieldDefArray[i].minvalue > d) {
                    fieldDefArray[i].minvalue = d;
                }
                if (!(fieldDefArray[i].maxvalue < d)) continue;
                fieldDefArray[i].maxvalue = d;
            }
        }
        this.dataStorage.changeRecord(record, 0);
    }

    public void deleteRecord(Record record) {
        this.dataStorage.deleteRecord(record);
    }

    public Renderer getRenderer(String string) {
        if (!Strings.isNullOrBlank(string)) {
            int n = this.renderers.size();
            for (int i = 0; i < n; ++i) {
                if (!string.equals(((Renderer)this.renderers.elementAt((int)i)).name)) continue;
                return (Renderer)this.renderers.elementAt(i);
            }
        }
        return null;
    }

    public Renderer createDefaultRenderer() {
        return new RendererDef(this);
    }

    public void timerTick() {
        if (this.parentMap instanceof Carte) {
            this.clear(false);
            ((Carte)this.parentMap).extentChanged();
        }
    }

    public byte[] saveToByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this.dataStorage);
            objectOutputStream.writeObject(this.layerExtent);
            objectOutputStream.writeObject(this.metadata);
            objectOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void loadFromByteArray(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            this.dataStorage = (DataStorage)objectInputStream.readObject();
            this.layerExtent = (FloatRectangle)objectInputStream.readObject();
            this.metadata = (Meta)objectInputStream.readObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isObjectType(int n) {
        int n2 = this.dataStorage.getObjectType();
        if (n == -1) {
            return n2 < 1 || n2 > 4;
        }
        return n2 == n;
    }
}

