/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Color;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import org.alov.data.DataProviderImg;
import org.alov.map.DisplayContext;
import org.alov.map.FloatPoint;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.MapUtils;
import org.alov.map.RecordsArray;
import org.alov.map.Renderer;
import org.alov.map.RendererImage;
import org.alov.map.Shape;
import org.alov.util.AlovMapException;
import org.alov.util.Strings;
import org.alov.util.Utils;

public class LayerRaster
extends Layer {
    public Point fixedPosition = null;
    public Color transparentColor = null;
    public int transparency = -1;
    public int imgWidth = 0;
    public int imgHeight = 0;
    public int resolutionMaxLevel = 0;
    public int resolutionLevel = -1;
    public String wmsLayers = null;
    public String wmsStyles = null;
    public String wmsExtraParams = null;
    private transient byte[] imageBytes = null;
    private transient Image imageRaster = null;
    protected Rectangle loadedRectangle;
    public String imageUrl = null;

    public LayerRaster() {
        this.setSelection(null);
    }

    public void paintRecords(Vector vector, Renderer renderer, boolean bl, DisplayContext displayContext, int n) {
        if (!bl) {
            ((RendererImage)renderer).paintRecord(null, bl, displayContext);
        }
    }

    public RecordsArray paintRecords2(Renderer renderer, DisplayContext displayContext, int n) {
        if (displayContext == null || displayContext.getProjection() == null || this.isEmpty()) {
            return null;
        }
        ((RendererImage)renderer).paintRecord(null, false, displayContext);
        return null;
    }

    public boolean isEmpty() {
        return this.imageBytes == null && this.imageRaster == null;
    }

    public void resolveMetadata() throws AlovMapException {
        super.resolveMetadata();
        boolean bl = false;
        this.url = this.connectionData.getProperty("url");
        int n = Strings.strToInt(this.metadata.getVal(138), -1);
        int n2 = Strings.strToInt(this.metadata.getVal(139), -1);
        if (n != -1 && n2 != -1) {
            this.fixedPosition = new Point(n, n2);
        }
        try {
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.metadata.maxExtent.isZero() && !bl) {
            throw new AlovMapException(301, this.getName() + ". Extent of raster image is not defined. You have to define either worldfile, or worldfile or extent metadata elements");
        }
        try {
            String string = this.metadata.getVal(146);
            if (string != null) {
                this.imgWidth = Integer.parseInt(string);
            }
            if ((string = this.metadata.getVal(147)) != null) {
                this.imgHeight = Integer.parseInt(string);
            }
            if ((string = this.metadata.getVal(148)) != null) {
                this.resolutionMaxLevel = Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            throw new AlovMapException(301, this.getName());
        }
        if (this.metadata.maxExtent.isZero()) {
            this.calculateExtent();
        }
        this.wmsLayers = this.metadata.getVal(166);
        this.wmsStyles = this.metadata.getVal(167);
        this.wmsExtraParams = this.metadata.getVal(311);
    }

    public void prepareLayer() {
        if (!this.isDataOnServer) {
            this.layerExtent = this.metadata.maxExtent;
            this.setLoadComplete(true);
        }
        super.prepareLayer();
    }

    public FloatRectangle getLayerExtent() {
        if (this.metadata.maxExtent.isZero()) {
            this.calculateExtent();
            this.layerExtent = this.metadata.maxExtent;
        }
        if (!this.isDataOnServer) {
            this.layerExtent = this.metadata.maxExtent;
        }
        return this.layerExtent;
    }

    private void calculateExtent() {
        double d = this.metadata.getDouble(142);
        double d2 = this.metadata.getDouble(143);
        double d3 = this.metadata.getDouble(144);
        double d4 = Math.abs(this.metadata.getDouble(145));
        if (d3 != 0.0 && d4 != 0.0) {
            Image image;
            if (this.imgWidth <= 0 && this.imgHeight <= 0 && (image = this.getImage()) != null) {
                this.imgWidth = image.getWidth(null);
                this.imgHeight = image.getHeight(null);
            }
            if (this.imgWidth > 0 && this.imgHeight > 0) {
                this.metadata.maxExtent = new FloatRectangle(d - d3 / 2.0, d2 + d4 / 2.0 - Math.abs((double)this.imgHeight * d4), d - d3 / 2.0 + (double)this.imgWidth * d3, d2 + d4 / 2.0);
            }
        }
    }

    public RecordsArray findWithinRect(FloatRectangle floatRectangle, boolean bl) {
        if (this.getLayerExtent() == null || floatRectangle == null) {
            return null;
        }
        if (this.layerExtent.intersects(floatRectangle) || floatRectangle.intersects(this.layerExtent)) {
            RecordsArray recordsArray = new RecordsArray(this.dataStorage);
            recordsArray.setNotEmpty();
            return recordsArray;
        }
        return null;
    }

    public RecordsArray findWithinCircle(FloatPoint floatPoint, double d, boolean bl, boolean bl2) {
        if (this.getLayerExtent() == null || floatPoint == null) {
            return null;
        }
        double d2 = MapUtils.sqr(d);
        double d3 = this.layerExtent.x - floatPoint.x;
        double d4 = this.layerExtent.x2 - floatPoint.x;
        double d5 = this.layerExtent.y - floatPoint.y;
        double d6 = this.layerExtent.y2 - floatPoint.y;
        if (MapUtils.sqr(d3) + MapUtils.sqr(d5) <= d2 && MapUtils.sqr(d4) + MapUtils.sqr(d5) <= d2 && MapUtils.sqr(d3) + MapUtils.sqr(d6) <= d2 && MapUtils.sqr(d4) + MapUtils.sqr(d6) <= d2 || !bl && (this.layerExtent.contain(floatPoint.x, floatPoint.y) || MapUtils.intersectCircle(new FloatPoint(d3, d5), new FloatPoint(d4, d5), d) || MapUtils.intersectCircle(new FloatPoint(d4, d5), new FloatPoint(d4, d6), d) || MapUtils.intersectCircle(new FloatPoint(d4, d6), new FloatPoint(d3, d6), d) || MapUtils.intersectCircle(new FloatPoint(d3, d6), new FloatPoint(d3, d5), d))) {
            RecordsArray recordsArray = new RecordsArray(this.dataStorage);
            recordsArray.setNotEmpty();
            return recordsArray;
        }
        return null;
    }

    public RecordsArray findWithinShape(Shape shape, boolean bl, boolean bl2) {
        if (this.getLayerExtent() == null || shape == null) {
            return null;
        }
        FloatPoint floatPoint = new FloatPoint(this.layerExtent.x2, this.layerExtent.y);
        FloatPoint floatPoint2 = new FloatPoint(this.layerExtent.x, this.layerExtent.y);
        FloatPoint floatPoint3 = new FloatPoint(this.layerExtent.x2, this.layerExtent.y2);
        FloatPoint floatPoint4 = new FloatPoint(this.layerExtent.x, this.layerExtent.y2);
        boolean bl3 = Shape.containsPoint(shape, floatPoint.x, floatPoint.y);
        boolean bl4 = Shape.containsPoint(shape, floatPoint2.x, floatPoint2.y);
        boolean bl5 = Shape.containsPoint(shape, floatPoint3.x, floatPoint3.y);
        boolean bl6 = Shape.containsPoint(shape, floatPoint4.x, floatPoint4.y);
        if (bl && bl3 && bl4 && bl5 && bl6 || !bl && (bl3 || bl4 || bl5 || bl6 || MapUtils.intersectShape(floatPoint2, floatPoint, shape) || MapUtils.intersectShape(floatPoint, floatPoint3, shape) || MapUtils.intersectShape(floatPoint3, floatPoint4, shape) || MapUtils.intersectShape(floatPoint4, floatPoint2, shape))) {
            RecordsArray recordsArray = new RecordsArray(this.dataStorage);
            recordsArray.setNotEmpty();
            return recordsArray;
        }
        return null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            ((DataProviderImg)this.provider).loadRaster();
        }
        catch (AlovMapException alovMapException) {
            alovMapException.printStackTrace();
        }
    }

    public void applyRasterFilters(int n) {
        this.transparency = n;
        if (this.imageBytes != null) {
            this.imageRaster = null;
        }
    }

    public Image getImage() {
        return this.getImage(null);
    }

    public Image getImage(Rectangle rectangle) {
        Image image = null;
        try {
            long l = Utils.getMemoryUsage();
            if (l > 51200L && this.imageRaster != null && this.imageBytes != null) {
                this.imageRaster = null;
                System.gc();
            }
            if (this.imageRaster != null) {
                image = this.imageRaster;
            } else if (this.imageBytes != null) {
                image = MapUtils.createImageFromBytes(this.imageBytes);
                if (this.transparentColor != null || this.transparency >= 0 && this.transparency < 255) {
                    image = MapUtils.makeColorTransparent(image, this.transparentColor, 255 - this.transparency);
                }
                if (l < 41200L) {
                    this.imageRaster = image;
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        return image;
    }

    public byte[] getImageSrc() {
        return this.imageBytes;
    }

    public void setImage(byte[] byArray) {
        this.imageBytes = byArray;
        if (byArray != null) {
            this.imageRaster = null;
        }
    }

    public void setRaster(Image image) {
        this.imageBytes = null;
        this.imageRaster = image;
    }

    protected Image getImageRaster() {
        return this.imageRaster;
    }

    public void clear(boolean bl) {
        this.imageBytes = null;
        this.imageRaster = null;
        super.clear(bl);
    }

    public boolean isVisibleNow(DisplayContext displayContext) {
        boolean bl = super.isVisibleNow(displayContext);
        if (!bl && this.imageRaster != null && this.imageBytes != null) {
            this.imageRaster = null;
            System.gc();
        }
        return bl;
    }

    public Renderer createDefaultRenderer() {
        return new RendererImage(this);
    }
}

