/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Color;
import java.awt.Point;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.alov.map.Carte;
import org.alov.map.DataStorage;
import org.alov.map.DataStorageCompact;
import org.alov.map.DataStorageFast;
import org.alov.map.DisplayContext;
import org.alov.map.FieldDef;
import org.alov.map.FilterExpression;
import org.alov.map.FilterRecords;
import org.alov.map.FilterTime;
import org.alov.map.FloatPoint;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.MapUtils;
import org.alov.map.MathRec;
import org.alov.map.Projection;
import org.alov.map.Record;
import org.alov.map.RecordField;
import org.alov.map.RecordsArray;
import org.alov.map.Renderer;
import org.alov.map.Shape;
import org.alov.map.Symbol;
import org.alov.util.AlovMapException;
import org.alov.util.Log;
import org.alov.util.Strings;

public class LayerVector
extends Layer {
    public int fi_search = -1;
    public int fi_id = -1;
    public String f_dateLow = null;
    public String f_dateHigh = null;
    public int dateType = 0;
    public String f_id = null;
    public boolean f_id_istext = true;
    public String f_xmin;
    public String f_ymin;
    public String f_xmax;
    public String f_ymax;
    public String f_geoblob = null;
    public String f_x;
    public String f_y;
    public String f_description = null;
    public String tableName = null;
    public String selectSQL = null;
    public String linkInfo = null;
    public String localFilter = null;
    Boolean changed = Boolean.FALSE;
    public String serverFilter = null;
    public Symbol symbol = new Symbol(Color.yellow, Color.black, true, true, 4);
    public Symbol selectedSymbol = new Symbol(new Color(0, 255, 128), new Color(255, 0, 0), true, true, 6);
    private static final String _TRUE = "TRUE";

    public LayerVector() {
    }

    public LayerVector(boolean bl) {
        this.dataStorage = bl ? new DataStorageCompact() : new DataStorageFast();
    }

    public void paintRecords(Vector vector, Renderer renderer, boolean bl, DisplayContext displayContext, int n) {
        try {
            int n2 = vector.size();
            FloatRectangle floatRectangle = displayContext.getLastExtent();
            Projection projection = displayContext.getProjection();
            if (projection == null) {
                return;
            }
            Object var9_10 = null;
            renderer.beforePaint(bl, displayContext);
            for (int i = 0; i < n2; ++i) {
                Record record = (Record)vector.elementAt(i);
                FloatRectangle floatRectangle2 = record.getRecordExtent();
                if (floatRectangle == null || floatRectangle.intersects(floatRectangle2)) {
                    renderer.paintRecord(record, bl, displayContext);
                }
                if (n <= 0 || !displayContext.isStopPaint(n)) continue;
                return;
            }
            renderer.afterPaint(bl, displayContext);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public RecordsArray findBySearchField(String string) {
        return this.findByExpression(this.getSearchExpression(string));
    }

    public String getSearchExpression(String string) {
        if (this.fi_search < 0) {
            this.fi_search = this.fi_description;
        }
        if (!this.canSearch || Strings.isNullOrBlank(string) || this.fi_search < 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getFieldDef((int)this.fi_search).name).append(string.charAt(0) == '%' || string.charAt(string.length() - 1) == '%' ? " like '" : "='").append(string).append("'");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordsArray findByExpression(String string) {
        if (Strings.isNullOrBlank(string)) {
            return null;
        }
        if (string.equalsIgnoreCase(_TRUE)) {
            string = null;
        }
        RecordsArray recordsArray = new RecordsArray(this.dataStorage);
        DataStorage dataStorage = this.dataStorage;
        synchronized (dataStorage) {
            this.dataStorage.openDataStorage(true);
            try {
                FilterExpression filterExpression = new FilterExpression(string, this);
                int n = this.dataStorage.size();
                for (int i = 0; i < n; ++i) {
                    Record record = this.newRecord(i);
                    if (this.applyFilters(record) && filterExpression.checkRecord(record)) {
                        this.dataStorage.readRecCoords(record, null);
                        recordsArray.addRecord(record);
                    } else {
                        this.dataStorage.skipSpatial(i);
                    }
                    record = null;
                }
                if (recordsArray.size() == 0) {
                    recordsArray = null;
                }
            }
            catch (Exception exception) {
            }
            finally {
                this.dataStorage.closeDataStorage();
            }
        }
        return recordsArray;
    }

    public boolean applyFilters(Record record) throws IOException {
        boolean bl = true;
        this.dataStorage.readRecAttribute(record);
        if (this.filters != null) {
            Enumeration enumeration = this.filters.elements();
            while (enumeration.hasMoreElements()) {
                FilterRecords filterRecords = (FilterRecords)enumeration.nextElement();
                if (filterRecords.checkRecord(record)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordsArray paintRecords2(Renderer renderer, DisplayContext displayContext, int n) {
        boolean bl;
        int n2 = this.dataStorage.size();
        if (displayContext == null || displayContext.getProjection() == null || n2 == 0) {
            return null;
        }
        FloatRectangle floatRectangle = displayContext.getLastExtent();
        try {
            if (this.metadata.maxExtent.isZero() || floatRectangle.contains(this.metadata.maxExtent)) {
                floatRectangle = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        RecordsArray recordsArray = null;
        boolean bl2 = bl = this.renderers.size() > 1 && floatRectangle != null;
        if (bl) {
            recordsArray = new RecordsArray(this.dataStorage);
        }
        DataStorage dataStorage = this.dataStorage;
        synchronized (dataStorage) {
            this.dataStorage.openDataStorage(true);
            try {
                renderer.beforePaint(false, displayContext);
                for (int i = 0; i < n2; ++i) {
                    Record record = this.newRecord(i);
                    if (this.dataStorage.readRecCoords(record, floatRectangle)) {
                        if (this.applyFilters(record)) {
                            if (bl) {
                                recordsArray.addRecord(record);
                            }
                            renderer.paintRecord(record, false, displayContext);
                        }
                    } else {
                        this.dataStorage.skipAttribute(i);
                    }
                    record = null;
                }
                renderer.afterPaint(false, displayContext);
            }
            catch (IOException iOException) {
            }
            finally {
                this.dataStorage.closeDataStorage();
            }
        }
        return recordsArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintRecords3(RecordsArray recordsArray, Renderer renderer, boolean bl, DisplayContext displayContext, int n) {
        if (!MapUtils.isNotEmptyRecs(recordsArray) || displayContext == null || displayContext.getProjection() == null) {
            return;
        }
        FloatRectangle floatRectangle = displayContext.getLastExtent();
        boolean bl2 = false;
        DataStorage dataStorage = this.dataStorage;
        synchronized (dataStorage) {
            this.dataStorage.openDataStorage(true);
            try {
                int n2 = recordsArray.size();
                int n3 = 0;
                int n4 = 0;
                int n5 = this.dataStorage.size() - 1;
                renderer.beforePaint(bl, displayContext);
                for (int i = 0; i < n2; ++i) {
                    int n6 = recordsArray.get(i);
                    this.dataStorage.skipSpatial2(n6, n3);
                    n3 = n6 < n5 ? n6 + 1 : 0;
                    Record record = this.newRecord(n6);
                    if (this.dataStorage.readRecCoords(record, floatRectangle)) {
                        this.dataStorage.skipAttribute2(n6, n4);
                        n4 = n6 < n5 ? n6 + 1 : 0;
                        this.dataStorage.readRecAttribute(record);
                        renderer.paintRecord(record, bl, displayContext);
                    } else {
                        this.dataStorage.skipAttribute(i);
                    }
                    record = null;
                }
                renderer.afterPaint(bl, displayContext);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                this.dataStorage.closeDataStorage();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RecordsArray findWithinScreenRect(Point point, boolean bl) {
        if (this.dataStorage.size() == 0) {
            return null;
        }
        DataStorage dataStorage = this.dataStorage;
        synchronized (dataStorage) {
            RecordsArray recordsArray = new RecordsArray(this.dataStorage);
            this.dataStorage.openDataStorage(true);
            try {
                int n = this.dataStorage.size();
                for (int i = 0; i < n; ++i) {
                    Record record = this.newRecord(i);
                    this.dataStorage.readRecCoords(record, null);
                    int n2 = record.getShapeCount();
                    boolean bl2 = false;
                    for (int j = 0; j < n2 && !bl2; ++j) {
                        Shape shape = record.getShape(j);
                        if (shape.xCoords == null || shape.yCoords == null) continue;
                        double[] dArray = shape.xCoords;
                        double[] dArray2 = shape.yCoords;
                        Point point2 = ((Carte)this.parentMap).mapToScreen_(dArray[0], dArray2[0]);
                        int n3 = this.hotSpot.xCoords.length;
                        double[] dArray3 = new double[n3 * 2];
                        int n4 = 0;
                        for (int k = 0; k < n3 && !bl2; ++k) {
                            dArray3[n4] = (int)this.hotSpot.xCoords[k] + point2.x;
                            dArray3[++n4] = (int)this.hotSpot.yCoords[k] + point2.y;
                            ++n4;
                        }
                        Shape shape2 = new Shape(dArray3);
                        if (!Shape.containsPoint(shape2, point.x, point.y)) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) {
                        if (this.applyFilters(record)) {
                            recordsArray.addRecord(record);
                            if (bl) {
                                break;
                            }
                        }
                    } else {
                        this.dataStorage.skipAttribute(i);
                    }
                    record = null;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                this.dataStorage.closeDataStorage();
            }
            if (recordsArray.size() == 0) {
                recordsArray = null;
            }
            return recordsArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordsArray findWithinRect(FloatRectangle floatRectangle, boolean bl) {
        if (this.dataStorage.size() == 0) {
            return null;
        }
        DataStorage dataStorage = this.dataStorage;
        synchronized (dataStorage) {
            RecordsArray recordsArray = new RecordsArray(this.dataStorage);
            this.dataStorage.openDataStorage(true);
            try {
                double d = floatRectangle.x;
                double d2 = floatRectangle.y;
                double d3 = floatRectangle.x2;
                double d4 = floatRectangle.y2;
                MathRec mathRec = new MathRec(d, d2, d3, d4);
                MathRec mathRec2 = new MathRec(d3, d2, d, d4);
                if (this.isObjectType(1) && this.parentMap != null) {
                    FloatRectangle floatRectangle2 = this.parentMap.getLastExtent();
                    double d5 = Math.abs(floatRectangle2.x2 - floatRectangle2.x) / 200.0;
                    d3 = floatRectangle.x2 + d5;
                    d = floatRectangle.x - d5;
                    d5 = Math.abs(floatRectangle2.y2 - floatRectangle2.y) / 200.0;
                    d4 = floatRectangle.y2 + d5;
                    d2 = floatRectangle.y - d5;
                    floatRectangle = new FloatRectangle(d, d2, d3, d4);
                }
                int n = this.dataStorage.size();
                for (int i = 0; i < n; ++i) {
                    Record record = this.newRecord(i);
                    this.dataStorage.readRecCoords(record, null);
                    int n2 = record.getShapeCount();
                    boolean bl2 = false;
                    block9: for (int j = 0; j < n2 && !bl2; ++j) {
                        Shape shape = record.getShape(j);
                        if (shape.xCoords == null || shape.yCoords == null) continue;
                        double[] dArray = shape.xCoords;
                        double[] dArray2 = shape.yCoords;
                        if (this.isObjectType(1)) {
                            bl2 = floatRectangle.contain(dArray[0], dArray2[0]);
                            continue;
                        }
                        if (this.isObjectType(3)) {
                            bl2 = Shape.containsPoint(shape, d, d2);
                        }
                        for (int k = 1; k < dArray.length && !bl2; ++k) {
                            double d6 = dArray[k];
                            double d7 = dArray2[k];
                            if (floatRectangle.contain(d6, d7)) {
                                bl2 = true;
                                continue block9;
                            }
                            double d8 = dArray[k - 1];
                            double d9 = dArray2[k - 1];
                            if (!this.Intersects(d8, d9, d6, d7, d, d2, d3, d4, mathRec) && !this.Intersects(d8, d9, d6, d7, d3, d2, d, d4, mathRec2)) continue;
                            bl2 = true;
                            continue block9;
                        }
                    }
                    if (bl2) {
                        if (this.applyFilters(record)) {
                            recordsArray.addRecord(record);
                            if (bl) {
                                break;
                            }
                        }
                    } else {
                        this.dataStorage.skipAttribute(i);
                    }
                    record = null;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                this.dataStorage.closeDataStorage();
            }
            if (recordsArray.size() == 0) {
                recordsArray = null;
            }
            return recordsArray;
        }
    }

    private boolean Intersects(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, MathRec mathRec) {
        double d9;
        double d10;
        double d11;
        double d12 = d3 - d;
        double d13 = d4 - d2;
        if (d13 == 0.0) {
            d11 = 0.0;
        } else if (d12 != 0.0) {
            d11 = d13 / d12;
        } else {
            d11 = 1.0E21;
            if (d13 < 0.0) {
                d11 = -d11;
            }
        }
        if (mathRec.k == d11) {
            return false;
        }
        double d14 = d2 - d11 * d;
        if (Math.abs(mathRec.k) < Math.abs(d11)) {
            d10 = mathRec.dx == 0.0 ? d5 : (d12 == 0.0 ? d : (d14 - mathRec.b) / (mathRec.k - d11));
            d9 = mathRec.dx == 0.0 ? d11 * d10 + d14 : mathRec.k * d10 + mathRec.b;
        } else {
            d10 = d12 == 0.0 ? d : (mathRec.dx == 0.0 ? d5 : (mathRec.b - d14) / (d11 - mathRec.k));
            d9 = mathRec.dx == 0.0 ? d11 * d10 + d14 : mathRec.k * d10 + mathRec.b;
        }
        return this.Between(d5, d7, d10) && this.Between(d6, d8, d9) && this.Between(d, d3, d10) && this.Between(d2, d4, d9);
    }

    private boolean Between(double d, double d2, double d3) {
        if (d >= d2 && d3 <= d && d3 >= d2) {
            return true;
        }
        return d <= d2 && d3 >= d && d3 <= d2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordsArray findContainShape(Shape shape, boolean bl, boolean bl2) {
        if (null == shape || 0 == shape.xCoords.length || 0 == shape.yCoords.length || this.isObjectType(-1)) {
            return null;
        }
        RecordsArray recordsArray = new RecordsArray(this.dataStorage);
        DataStorage dataStorage = this.dataStorage;
        synchronized (dataStorage) {
            block18: {
                this.dataStorage.openDataStorage(true);
                try {
                    FloatRectangle floatRectangle = Shape.calculateExtent(shape);
                    int n = this.dataStorage.size();
                    if (0 >= n) break block18;
                    boolean bl3 = false;
                    double[] dArray = shape.xCoords;
                    double[] dArray2 = shape.yCoords;
                    int n2 = shape.xCoords.length;
                    for (int i = 0; i < n; ++i) {
                        Record record = this.newRecord(i);
                        if (this.dataStorage.readRecCoords(record, floatRectangle)) {
                            bl3 = bl;
                            int n3 = record.getShapeCount();
                            for (int j = 0; j < n3; ++j) {
                                Shape shape2 = record.getShape(j);
                                for (int k = 0; k < n2 && (bl ? bl3 : !bl3); ++k) {
                                    bl3 = Shape.containsPoint(shape2, dArray[k], dArray2[k]);
                                }
                                if (bl3 && bl2) break;
                            }
                        }
                        if (bl3) {
                            if (this.applyFilters(record)) {
                                recordsArray.addRecord(record);
                                if (bl2) {
                                    break;
                                }
                            }
                        } else {
                            this.dataStorage.skipAttribute(i);
                        }
                        record = null;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    this.dataStorage.closeDataStorage();
                }
            }
        }
        if (0 == recordsArray.size()) {
            recordsArray = null;
        }
        return recordsArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordsArray findWithinShape(Shape shape, boolean bl, boolean bl2) {
        if (null == shape || 0 == shape.xCoords.length || 0 == shape.yCoords.length || this.isObjectType(-1)) {
            return null;
        }
        RecordsArray recordsArray = new RecordsArray(this.dataStorage);
        DataStorage dataStorage = this.dataStorage;
        synchronized (dataStorage) {
            block25: {
                this.dataStorage.openDataStorage(true);
                try {
                    FloatRectangle floatRectangle = Shape.calculateExtent(shape);
                    int n = this.dataStorage.size();
                    if (0 >= n) break block25;
                    for (int i = 0; i < n; ++i) {
                        boolean bl3 = bl;
                        Record record = this.newRecord(i);
                        if (this.dataStorage.readRecCoords(record, floatRectangle)) {
                            int n2 = record.getShapeCount();
                            block13: for (int j = 0; j < n2 && (bl ? bl3 : !bl3); ++j) {
                                Shape shape2 = record.getShape(j);
                                double[] dArray = shape2.xCoords;
                                double[] dArray2 = shape2.yCoords;
                                int n3 = dArray.length;
                                if (bl || this.isObjectType(1)) {
                                    for (int k = 0; k < n3 && (bl ? bl3 : !bl3); ++k) {
                                        bl3 = Shape.containsPoint(shape, dArray[k], dArray2[k]);
                                    }
                                    continue;
                                }
                                switch (this.dataStorage.getObjectType()) {
                                    case 3: {
                                        FloatPoint floatPoint = new FloatPoint(dArray[n3 - 1], dArray2[n3 - 1]);
                                        bl3 = MapUtils.intersectShape(floatPoint, new FloatPoint(dArray[0], dArray2[0]), shape);
                                        if (bl3) continue block13;
                                        floatPoint = null;
                                    }
                                    case 2: {
                                        FloatPoint floatPoint = new FloatPoint(dArray[0], dArray2[0]);
                                        FloatPoint floatPoint2 = new FloatPoint(0.0, 0.0);
                                        bl3 = Shape.containsPoint(shape, floatPoint.x, floatPoint.y);
                                        for (int k = 1; !bl3 && k < n3; ++k) {
                                            floatPoint2.setLocation(dArray[k], dArray2[k]);
                                            bl3 = MapUtils.intersectShape(floatPoint, floatPoint2, shape);
                                            if (bl3) continue;
                                            floatPoint.setLocation(floatPoint2.x, floatPoint2.y);
                                        }
                                        floatPoint2 = null;
                                        floatPoint = null;
                                    }
                                }
                            }
                        } else {
                            boolean bl4 = bl3 = !bl;
                        }
                        if (bl3) {
                            if (this.applyFilters(record)) {
                                recordsArray.addRecord(record);
                                if (bl2) {
                                    break;
                                }
                            }
                        } else {
                            this.dataStorage.skipAttribute(i);
                        }
                        record = null;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    this.dataStorage.closeDataStorage();
                }
            }
        }
        if (0 == recordsArray.size()) {
            recordsArray = null;
        }
        return recordsArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordsArray findWithinCircle(FloatPoint floatPoint, double d, boolean bl, boolean bl2) {
        if (null == floatPoint || this.isObjectType(-1)) {
            return null;
        }
        RecordsArray recordsArray = new RecordsArray(this.dataStorage);
        DataStorage dataStorage = this.dataStorage;
        synchronized (dataStorage) {
            this.dataStorage.openDataStorage(true);
            try {
                FloatRectangle floatRectangle = new FloatRectangle(floatPoint.x - d, floatPoint.y - d, floatPoint.x + d, floatPoint.y + d);
                double d2 = MapUtils.sqr(d);
                int n = this.dataStorage.size();
                boolean bl3 = false;
                for (int i = 0; i < n; ++i) {
                    bl3 = bl;
                    Record record = this.newRecord(i);
                    if (this.dataStorage.readRecCoords(record, floatRectangle)) {
                        int n2 = record.getShapeCount();
                        block13: for (int j = 0; j < n2 && (bl ? bl3 : !bl3); ++j) {
                            Shape shape = record.getShape(j);
                            double[] dArray = shape.xCoords;
                            double[] dArray2 = shape.yCoords;
                            int n3 = dArray.length;
                            if (bl || this.isObjectType(1)) {
                                for (int k = 0; k < n3 && (bl ? bl3 : !bl3); ++k) {
                                    bl3 = MapUtils.sqr(dArray[k] - floatPoint.x) + MapUtils.sqr(dArray2[k] - floatPoint.y) <= d2;
                                }
                                continue;
                            }
                            switch (this.dataStorage.getObjectType()) {
                                case 3: {
                                    bl3 = Shape.containsPoint(shape, floatPoint.x, floatPoint.y) || MapUtils.intersectCircle(new FloatPoint(dArray[0], dArray2[0]), new FloatPoint(dArray[n3 - 1], dArray2[n3 - 1]), floatPoint, d);
                                    if (bl3) continue block13;
                                }
                                case 2: {
                                    FloatPoint floatPoint2 = new FloatPoint(dArray[1] - floatPoint.x, dArray2[1] - floatPoint.y);
                                    FloatPoint floatPoint3 = new FloatPoint(0.0, 0.0);
                                    for (int k = 1; k < n3 - 1 && !bl3; ++k) {
                                        floatPoint3.setLocation(dArray[k] - floatPoint.x, dArray2[k] - floatPoint.y);
                                        boolean bl4 = bl3 = Shape.containsPoint(shape, floatPoint.x, floatPoint.y) || MapUtils.intersectCircle(floatPoint2, floatPoint3, d);
                                        if (bl3) continue;
                                        floatPoint2.setLocation(floatPoint3.x, floatPoint3.y);
                                    }
                                    floatPoint3 = null;
                                    floatPoint2 = null;
                                }
                            }
                        }
                    } else {
                        boolean bl5 = bl3 = !bl;
                    }
                    if (bl3) {
                        if (this.applyFilters(record)) {
                            recordsArray.addRecord(record);
                            if (bl2) {
                                break;
                            }
                        }
                    } else {
                        this.dataStorage.skipAttribute(i);
                    }
                    record = null;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                this.dataStorage.closeDataStorage();
            }
        }
        if (0 == recordsArray.size()) {
            recordsArray = null;
        }
        return recordsArray;
    }

    public String getId(Record record) {
        return this.fi_id < 0 ? Integer.toString(record.index) : record.getField(this.fi_id).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Record findById(String string) {
        Record record = null;
        if (!Strings.isNullOrBlank(string)) {
            if (this.fi_id < 0) {
                int n = Strings.strToInt(string, -1);
                record = this.dataStorage.getRecord(n, 0);
            } else {
                DataStorage dataStorage = this.dataStorage;
                synchronized (dataStorage) {
                    this.dataStorage.openDataStorage(true);
                    try {
                        int n = this.dataStorage.size();
                        for (int i = 0; i < n; ++i) {
                            record = this.newRecord(i);
                            this.dataStorage.readRecAttribute(record);
                            String string2 = record.getField(this.fi_id).toString();
                            if (string.equals(string2)) {
                                this.dataStorage.readRecCoords(record, null);
                                break;
                            }
                            this.dataStorage.skipSpatial(i);
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    finally {
                        this.dataStorage.closeDataStorage();
                    }
                }
            }
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordsArray findByIds(String string) {
        if (Strings.isNullOrBlank(string)) {
            return null;
        }
        RecordsArray recordsArray = new RecordsArray(this.dataStorage);
        Record record = null;
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n,");
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken().trim());
        }
        if (this.fi_id < 0) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                int n2 = Strings.strToInt((String)vector.elementAt(i), -1);
                record = this.dataStorage.getRecord(n2, 0);
                if (record == null) continue;
                recordsArray.addRecord(record);
            }
        } else {
            DataStorage dataStorage = this.dataStorage;
            synchronized (dataStorage) {
                this.dataStorage.openDataStorage(true);
                try {
                    int n = this.dataStorage.size();
                    for (int i = 0; i < n; ++i) {
                        record = this.newRecord(i);
                        this.dataStorage.readRecAttribute(record);
                        String string2 = record.getField(this.fi_id).toString();
                        if (vector.contains(string2)) {
                            this.dataStorage.readRecCoords(record, null);
                            recordsArray.addRecord(record);
                            continue;
                        }
                        this.dataStorage.skipSpatial(i);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                finally {
                    this.dataStorage.closeDataStorage();
                }
            }
        }
        if (recordsArray.size() == 0) {
            recordsArray = null;
        }
        return recordsArray;
    }

    public void resolveMetadata() throws AlovMapException {
        String string;
        super.resolveMetadata();
        if (this.isObjectType(-1)) {
            this.dataStorage.setObjectType(this.metadata.getObjType());
        }
        if ((string = this.metadata.getVal(37)) != null) {
            try {
                this.dateType = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.dateType = string.equalsIgnoreCase("UniqueDate") || string.equalsIgnoreCase("InstanceDate") ? 2 : (string.equalsIgnoreCase("UniqueRange") || string.equalsIgnoreCase("InstanceRange") ? 1 : 0);
            }
        }
        if (this.dateType == 2) {
            this.f_dateLow = this.metadata.getVal(52);
        } else if (this.dateType == 1) {
            this.f_dateLow = this.metadata.getVal(53);
            this.f_dateHigh = this.metadata.getVal(54);
        }
        if (this.localFilter == null) {
            this.localFilter = this.metadata.getVal(150);
        }
        if (this.linkSearch == null) {
            this.linkSearch = this.metadata.getVal(301);
        }
        if (this.linkInfo == null) {
            this.linkInfo = this.metadata.getVal(302);
        }
        if (this.linkTips == null) {
            this.linkTips = this.metadata.getVal(310);
        }
        this.f_id = this.metadata.getVal(49);
        this.f_xmin = this.metadata.getVal(70);
        this.f_ymin = this.metadata.getVal(72);
        this.f_xmax = this.metadata.getVal(71);
        this.f_ymax = this.metadata.getVal(73);
        this.f_geoblob = this.metadata.getVal(74);
        this.f_x = this.metadata.getVal(75);
        this.f_y = this.metadata.getVal(76);
        this.f_description = this.metadata.getVal(51);
        this.tableName = this.metadata.getVal(43);
        if (!Strings.isNullOrBlank(this.tableName) && this.tableName.toUpperCase().startsWith("SELECT ")) {
            this.selectSQL = this.tableName;
        }
        this.fi_description = this.getFieldIndex(this.f_description);
    }

    public void prepareLayer() {
        FilterTime filterTime;
        block10: {
            Object object;
            int n;
            FieldDef[] fieldDefArray;
            int n2;
            this.selectedSymbol.loadSymbolImages(this);
            Vector vector = this.metadata.getList(309);
            int n3 = vector == null ? 0 : vector.size();
            Vector<FieldDef> vector2 = new Vector<FieldDef>();
            for (n2 = 0; n2 < n3; ++n2) {
                fieldDefArray = vector.elementAt(n2).toString();
                n = fieldDefArray.indexOf("=");
                if (n <= 0) continue;
                object = fieldDefArray.substring(0, n).trim();
                String string = fieldDefArray.substring(n + 1).trim();
                if (((String)object).length() <= 0 || string.length() <= 0) continue;
                try {
                    RecordField recordField;
                    FieldDef fieldDef = new FieldDef();
                    fieldDef.name = object;
                    fieldDef.field = recordField = (RecordField)Class.forName(string).newInstance();
                    recordField.init(this);
                    fieldDef.type = recordField.getFieldJdbcType();
                    vector2.addElement(fieldDef);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("Failed to initialize calculated field " + (String)object + " class " + string);
                }
            }
            n3 = vector2.size();
            if (n3 > 0) {
                n2 = this.getFieldCount();
                fieldDefArray = new FieldDef[n2 + n3];
                if (this.dataStorage.getFields() != null) {
                    System.arraycopy(this.dataStorage.getFields(), 0, fieldDefArray, 0, n2);
                }
                for (n = 0; n < n3; ++n) {
                    fieldDefArray[n2 + n] = object = (FieldDef)vector2.elementAt(n);
                    ((FieldDef)object).index = n2 + n;
                }
                this.dataStorage.assignFields(fieldDefArray);
            }
            try {
                if (this.localFilter != null) {
                    this.filters.put("SF", new FilterExpression(this.localFilter, this));
                }
            }
            catch (Exception exception) {
                System.out.println(">>. " + exception.getMessage());
                if (!(this.parentMap instanceof Carte)) break block10;
                Log.addMessage(305, this.parentMap.getName(), this, this.localFilter + ". " + exception.getClass().getName() + ". " + exception.getMessage());
            }
        }
        if (this.timeVarying && (this.dateType == 1 || this.dateType == 2) && (filterTime = new FilterTime(this)).isActive()) {
            this.filters.put("TF", filterTime);
            filterTime.setTimeInterval(this.parentMap.getTimeInterval());
        }
        super.prepareLayer();
    }

    public void afterDeserialization() {
        super.afterDeserialization();
    }
}

