/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.alov.map.Carte;
import org.alov.map.DataStorage;
import org.alov.map.DataStorageFast;
import org.alov.map.DisplayContext;
import org.alov.map.FilterExpression;
import org.alov.map.FloatRectangle;
import org.alov.map.LayerVector;
import org.alov.map.MapUtils;
import org.alov.map.Record;
import org.alov.map.Renderer;
import org.alov.map.RendererImageCatalog;
import org.alov.util.Log;
import org.alov.util.Strings;

public class LayerZoomify
extends LayerVector {
    private static final String FILTER_LEVEL = "level";
    double geoWidth;
    double geoHeight;
    double imageWidth;
    double imageHeight;
    double tileSize;
    int levelCount = 0;
    private Vector levelFilters = new Vector();
    private Hashtable images = new Hashtable();
    private int fieldIndex = -1;
    public Color transparentColor = null;
    public int transparency = -1;
    public double maxPixelSize = 2.0;

    public LayerZoomify() {
        this.dataStorage = new DataStorageFast();
        Renderer renderer = this.createDefaultRenderer();
        renderer.enabled = true;
        this.renderers.addElement(renderer);
        this.dataStorage.setObjectType(4);
    }

    public void setDimensions(double d, double d2, double d3, double d4, double d5, int n) {
        this.geoWidth = d;
        this.geoHeight = d2;
        this.imageWidth = d3;
        this.imageHeight = d4;
        this.tileSize = d5;
        this.levelCount = n;
        this.levelFilters.removeAllElements();
        try {
            for (int i = 0; i < n; ++i) {
                this.levelFilters.addElement(new FilterExpression("(level=" + i + ")", this));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setResolutionLevel(DisplayContext displayContext) {
        double d;
        double d2;
        if (displayContext == null || this.levelCount < 1) {
            return;
        }
        FloatRectangle floatRectangle = displayContext.getLastExtent();
        Dimension dimension = displayContext.getSize();
        double d3 = Math.abs(floatRectangle.x2 - floatRectangle.x);
        if (floatRectangle == null || dimension == null) {
            return;
        }
        double d4 = (double)dimension.width / (floatRectangle.x2 - floatRectangle.x);
        double d5 = 1.0;
        int n = this.levelCount - 1;
        int n2 = this.levelCount - 1;
        while (n2 >= 0 && !((d2 = d4 / (d = this.imageWidth / this.geoWidth * d5)) >= this.maxPixelSize)) {
            n = n2--;
            d5 *= 0.5;
        }
        if (n >= this.levelCount) {
            n = this.levelCount - 1;
        }
        if (n < 0) {
            n = 0;
        }
        this.filters.put(FILTER_LEVEL, (FilterExpression)this.levelFilters.elementAt(n));
    }

    public boolean isVisibleNow(DisplayContext displayContext) {
        boolean bl = super.isVisibleNow(displayContext);
        if (this.isKeyMap || bl) {
            this.setResolutionLevel(displayContext);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadZoomifyImages(FloatRectangle floatRectangle) {
        if (this.fieldIndex < 0 || this.dataStorage.size() == 0) {
            return;
        }
        boolean bl = false;
        DataStorage dataStorage = this.dataStorage;
        synchronized (dataStorage) {
            this.dataStorage.openDataStorage(true);
            try {
                int n = this.dataStorage.size();
                int n2 = 0;
                while (true) {
                    if (n2 >= n) break;
                    Record record = this.newRecord(n2);
                    if (this.dataStorage.readRecCoords(record, floatRectangle)) {
                        Integer n3;
                        if (this.applyFilters(record) && !this.images.containsKey(n3 = new Integer(n2))) {
                            block19: {
                                String string = (String)record.getField(this.fieldIndex);
                                if (string == null) {
                                    return;
                                }
                                try {
                                    this.setImageData(n2, MapUtils.loadImageToByteArray(this, string));
                                }
                                catch (Exception exception) {
                                    if (!(this.parentMap instanceof Carte)) break block19;
                                    Log.addMessage(306, this.parentMap.getName(), this, "Can't load raster image " + string + "  " + exception.getMessage());
                                }
                            }
                            bl = true;
                        }
                    } else {
                        this.dataStorage.skipAttribute(n2);
                    }
                    record = null;
                    ++n2;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                this.dataStorage.closeDataStorage();
            }
        }
        if (bl && this.parentMap instanceof Carte) {
            ((Carte)this.parentMap).updateMap();
        }
    }

    public void clear(boolean bl) {
        Enumeration enumeration = this.images.keys();
        while (enumeration.hasMoreElements()) {
            byte[] byArray = (byte[])this.images.get((Integer)enumeration.nextElement());
            byArray = null;
        }
        this.images.clear();
        super.clear(bl);
    }

    protected void setImageData(int n, byte[] byArray) {
        this.images.put(new Integer(n), byArray);
    }

    protected byte[] getImageData(int n) {
        return (byte[])this.images.get(new Integer(n));
    }

    protected Image getImage(int n, Record record) {
        return this.getImage(n, record, null);
    }

    protected Image getImage(int n, Record record, Rectangle rectangle) {
        Image image = null;
        try {
            image = MapUtils.createImageFromBytes(this.getImageData(n));
            if (image != null && (this.transparentColor != null || this.transparency >= 0 && this.transparency < 255)) {
                image = MapUtils.makeColorTransparent(image, this.transparentColor, 255 - this.transparency);
            }
        }
        catch (Exception exception) {
            System.out.println(">>>" + exception.getMessage());
        }
        return image;
    }

    public void prepareLayer() {
        super.prepareLayer();
        String string = this.metadata.getVal(310);
        if (Strings.isNullOrBlank(string)) {
            string = "image";
        }
        this.fieldIndex = this.getFieldIndex(string);
        if (this.fieldIndex < 0) {
            Log.addMessage(303, this.parentMap.getName(), this, "Field with Image path not found. " + string);
        }
    }

    public void applyRasterFilters(int n) {
        this.transparency = n;
    }

    public Renderer createDefaultRenderer() {
        return new RendererImageCatalog(this);
    }
}

