/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import org.alov.map.Layer;
import org.alov.map.LayerVector;
import org.alov.util.Strings;

class Load2D {
    private static Method transform = null;
    private static Method make = null;
    private static boolean projectionFail = false;
    private static Class ofClass = null;
    private static Class opClass = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage toBufferedImage(Image image, int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 6);
        Graphics graphics = bufferedImage.getGraphics();
        if (graphics != null) {
            try {
                graphics.drawImage(image, 0, 0, null);
            }
            finally {
                graphics.dispose();
            }
        }
        return bufferedImage;
    }

    private Load2D() {
    }

    static TexturePaint getTexturePaint(Image image, int n, int n2, Rectangle rectangle) {
        return new TexturePaint(Load2D.toBufferedImage(image, n, n2), rectangle);
    }

    static GradientPaint getGradientPaint(float f, float f2, Color color, float f3, float f4, Color color2, boolean bl) {
        return new GradientPaint(f, f2, color, f3, f4, color2, bl);
    }

    static BasicStroke getBasicStroke(float f, String string, String string2, float f2, float[] fArray, float f3) {
        int n = 0;
        int n2 = 2;
        if (string != null) {
            if ("round".equalsIgnoreCase(string)) {
                n = 1;
            } else if ("square".equalsIgnoreCase(string)) {
                n = 2;
            }
        }
        if (string2 != null) {
            if ("miter".equalsIgnoreCase(string2)) {
                n2 = 0;
            } else if ("round".equalsIgnoreCase(string2)) {
                n2 = 1;
            }
        }
        if (fArray == null) {
            return new BasicStroke(f, n, n2, f2);
        }
        return new BasicStroke(f, n, n2, f2, fArray, f3);
    }

    static AlphaComposite getAlphaComposite(String string, float f) {
        int n = 3;
        try {
            Class<?> clazz = Class.forName("java.awt.AlphaComposite");
            n = clazz.getField(string).getInt(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return AlphaComposite.getInstance(n, f);
    }

    static boolean isInvalidFont(Font font, String string) {
        if (null == font) {
            return true;
        }
        if (Strings.isNullOrBlank(string)) {
            return !font.canDisplay('A');
        }
        int n = font.canDisplayUpTo(string);
        return n >= 0 && n < string.length();
    }

    static void makeProjection(Layer layer, String string) {
        if (projectionFail) {
            return;
        }
        try {
            if (transform == null) {
                ofClass = Class.forName("org.alov.projections.OperationFactory");
                opClass = Class.forName("org.alov.projections.Operation");
                if (ofClass == null || opClass == null) {
                    projectionFail = true;
                    return;
                }
                make = ofClass.getMethod("make", new String().getClass(), new String().getClass());
                transform = opClass.getMethod("transform2", new LayerVector().getClass(), new Boolean(false).getClass());
            }
            Object t = ofClass.newInstance();
            Object object = null;
            if (t != null) {
                object = make.invoke(t, layer.metadata.getStr(162), string);
            }
            if (object != null) {
                transform.invoke(object, layer, new Boolean(false));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

