/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.alov.map.Domain;
import org.alov.map.FieldDef;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.LayerRaster;
import org.alov.map.LayerSetup;
import org.alov.map.LayerVector;
import org.alov.map.LayerZoomify;
import org.alov.map.Load2D;
import org.alov.map.MapUtils;
import org.alov.map.Project;
import org.alov.map.RadioGroup;
import org.alov.map.Renderer;
import org.alov.map.RendererAnalysis;
import org.alov.map.RendererChart;
import org.alov.map.RendererDef;
import org.alov.map.RendererDot;
import org.alov.map.RendererEvolution;
import org.alov.map.RendererGrad;
import org.alov.map.RendererLabel;
import org.alov.map.Shape;
import org.alov.map.Symbol;
import org.alov.map.Utils2D;
import org.alov.util.AlovMapException;
import org.alov.util.Const;
import org.alov.util.ExData;
import org.alov.util.ExDate;
import org.alov.util.Strings;
import org.alov.util.XmlConst;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

class Loader
implements Const,
XmlConst {
    static LayerSetup layerSetup;

    private Loader() {
    }

    static void parseProject(Project project, XmlElement xmlElement, LayerSetup layerSetup) throws Exception {
        Object object;
        Object object2;
        int n;
        Object object3;
        Object object4;
        XmlElement xmlElement2;
        int n2;
        Object object5;
        int n3;
        Vector vector;
        String string;
        Loader.layerSetup = layerSetup;
        if (xmlElement == null || !xmlElement.getNodeName().equalsIgnoreCase("project")) {
            Loader.layerSetup.addStatusInfo(101, null, null);
            throw new AlovMapException(101, null);
        }
        boolean bl = XmlUtils.getBoolean("dynamic", xmlElement, false);
        MapUtils.showCounter = XmlUtils.getBoolean("counter", xmlElement, false);
        if (!bl) {
            Object object6;
            project.name = XmlUtils.getLangString("name", xmlElement, "unnamed", project.language);
            project.zmin = XmlUtils.getFloat("zmin", xmlElement, -1.0f);
            project.zmax = XmlUtils.getFloat("zmax", xmlElement, -1.0f);
            project.mapBackground = XmlUtils.getColor("backcolor", xmlElement, Color.white);
            string = XmlUtils.getString("mapunits", xmlElement, null);
            project.MapUnits = MapUtils.setUnits(string, -1);
            string = XmlUtils.getString("zoomunits", xmlElement, null);
            project.ZoomUnits = MapUtils.setUnits(string, 1);
            project.isTimeEnabled = XmlUtils.getBoolean("usetime", xmlElement, false);
            project.animationDelay = XmlUtils.getInt("animationdelay", xmlElement, 1000);
            project.linkMain = xmlElement.getElValue("mainlink", xmlElement.getElValue("linkmask", null));
            project.linkSearch = xmlElement.getElValue("searchlink", null);
            project.linkInfo = xmlElement.getElValue("infolink", null);
            project.linkLegend = xmlElement.getElValue("legendlink", null);
            project.isCompactStorage = XmlUtils.getBoolean("compact", xmlElement, false);
            vector = xmlElement.getElementsByTagName("domain");
            n3 = vector.size();
            object5 = "full";
            for (n2 = 0; n2 < n3; ++n2) {
                xmlElement2 = (XmlElement)vector.elementAt(n2);
                object6 = XmlUtils.getRect(xmlElement2);
                object4 = XmlUtils.getLangString("name", xmlElement2, "unnamed", project.language);
                if (object6 != null) {
                    object3 = new Domain();
                    ((Domain)object3).ext = object6;
                    ((Domain)object3).minDate = ExDate.parseString(XmlUtils.getString("tmin", xmlElement2, "0"));
                    ((Domain)object3).maxDate = ExDate.parseString(XmlUtils.getString("tmax", xmlElement2, "2006"));
                    ((Domain)object3).layerId = XmlUtils.getString("layer", xmlElement2, null);
                    if (XmlUtils.getBoolean("full", xmlElement2, false)) {
                        project.startDate = ((Domain)object3).minDate;
                        project.endDate = ((Domain)object3).maxDate;
                        if (MapUtils.predefExtent != null) {
                            ((Domain)object3).ext = MapUtils.predefExtent;
                        }
                        project.maxExtent = ((Domain)object3).ext;
                        project.moveBeyondProject = XmlUtils.getBoolean("movebeyond", xmlElement2, false);
                        object5 = object4;
                    }
                    if (XmlUtils.getBoolean("startup", xmlElement2, false)) {
                        project.startExtentName = object4;
                    }
                    project.domains.put(object4, object3);
                    project.domainsNames = project.domainsNames + (String)object4 + "\n\r";
                    continue;
                }
                Loader.layerSetup.addStatusInfo(102, null, (String)object4);
            }
            if (project.maxExtent == null) {
                project.maxExtent = MapUtils.predefExtent != null ? MapUtils.predefExtent : new FloatRectangle(0.0, 0.0, 0.0, 0.0);
                Domain domain = new Domain();
                domain.ext = project.maxExtent;
                domain.minDate = new ExDate(0L, 1L, 1L);
                domain.maxDate = new ExDate(2006L, 1L, 1L);
                project.domains.put("full", domain);
                project.domainsNames = project.domainsNames + "full\n\r";
                project.startDate = domain.minDate;
                project.endDate = domain.maxDate;
            }
            if (MapUtils.predefExtentName != null) {
                project.startExtentName = MapUtils.predefExtentName;
            }
            if (project.startExtentName == null) {
                project.startExtentName = object5;
            }
            vector = xmlElement.getElementsByTagName("map");
            n3 = vector.size();
            for (n2 = 0; n2 < n3; ++n2) {
                xmlElement2 = (XmlElement)vector.elementAt(n2);
                object6 = XmlUtils.getString("index", xmlElement2, null);
                object4 = XmlUtils.getLangString("name", xmlElement2, "unnamed", project.language);
                if (object6 != null) {
                    project.themes.put(object4, object6);
                    project.themesNames = project.themesNames + (String)object4 + "\n\r";
                    object3 = XmlUtils.getString("layer", xmlElement2, null);
                    if (!Strings.isNullOrBlank((String)object3)) {
                        project.themesLayer.put(object4, object3);
                    }
                    if (((String)object6).equals(MapUtils.predefTheme)) {
                        MapUtils.predefTheme = object4;
                    }
                    if (n2 != 0 && !XmlUtils.getBoolean("startup", xmlElement2, false)) continue;
                    project.startTheme = object4;
                    continue;
                }
                Loader.layerSetup.addStatusInfo(103, null, (String)object4);
            }
            if (project.themes.size() == 0) {
                project.themes.put("unnamed", "0");
                project.startTheme = "unnamed";
                project.themesNames = "unnamed\n\r";
            } else if (MapUtils.predefTheme != null) {
                project.startTheme = MapUtils.predefTheme;
            }
            vector = xmlElement.getElementsByTagName("keymap");
            n3 = vector.size();
            if (n3 > 0) {
                xmlElement2 = (XmlElement)vector.elementAt(0);
                project.keyMapBackground = XmlUtils.getColor("backcolor", xmlElement2, project.mapBackground);
                project.keyMapOutline = XmlUtils.getColor("outline", xmlElement2, Color.red);
                project.keyMapTheme = XmlUtils.getString("map", xmlElement2, null);
            } else {
                project.keyMapOutline = Color.red;
                project.keyMapBackground = project.mapBackground;
                project.keyMapTheme = null;
            }
            xmlElement2 = xmlElement.getFirstElementByName("dynamic");
            boolean bl2 = project.isDynamic = xmlElement2 != null;
            if (project.isDynamic) {
                project.isDynamic_LayerVisible = XmlUtils.getBoolean("visible", xmlElement2, true);
                project.isDynamic_RemoveOutOfExtent = !XmlUtils.getBoolean("retain", xmlElement2, false);
                project.iDynamic_OrderOfLayers = XmlUtils.getInt("order", xmlElement2, 0);
                vector = xmlElement2.getElementsByTagName("meta");
                n3 = vector.size();
                for (n2 = 0; n2 < n3; ++n2) {
                    xmlElement2 = (XmlElement)vector.elementAt(n2);
                    object6 = XmlUtils.getString("id", xmlElement2, null);
                    object4 = XmlUtils.getString("content", xmlElement2, null);
                    if (Strings.isNullOrBlank((String)object4) || Strings.isNullOrBlank((String)object6)) continue;
                    project.sDynamoAdd = project.sDynamoAdd + (String)object6 + '@' + (String)object4 + ',';
                }
                if (project.sDynamoAdd.length() > 0) {
                    project.sDynamoAdd = project.sDynamoAdd.substring(0, project.sDynamoAdd.length() - 1);
                }
            }
        }
        if ((xmlElement2 = xmlElement.getFirstElementByName("projection")) != null && !Strings.isNullOrBlank(string = XmlUtils.getString("name", xmlElement2, null))) {
            object5 = new Properties();
            ((Hashtable)object5).put("name", string);
            if (string.indexOf("EPSG") < 0) {
                string = XmlUtils.getString("a", xmlElement2, null);
                if (Strings.isNumeric(string)) {
                    ((Hashtable)object5).put("a", string);
                }
                if (Strings.isNumeric(string = XmlUtils.getString("f", xmlElement2, null))) {
                    ((Hashtable)object5).put("f", string);
                }
                if (Strings.isNumeric(string = XmlUtils.getString("phi0", xmlElement2, null))) {
                    ((Hashtable)object5).put("phi0", string);
                }
                if (Strings.isNumeric(string = XmlUtils.getString("lambda0", xmlElement2, null))) {
                    ((Hashtable)object5).put("lambda0", string);
                }
                if (Strings.isNumeric(string = XmlUtils.getString("fe", xmlElement2, null))) {
                    ((Hashtable)object5).put("fe", string);
                }
                if (Strings.isNumeric(string = XmlUtils.getString("fn", xmlElement2, null))) {
                    ((Hashtable)object5).put("fn", string);
                }
                if (Strings.isNumeric(string = XmlUtils.getString("phi1", xmlElement2, null))) {
                    ((Hashtable)object5).put("phi1", string);
                }
                if (Strings.isNumeric(string = XmlUtils.getString("phi2", xmlElement2, null))) {
                    ((Hashtable)object5).put("phi2", string);
                }
                if (Strings.isNumeric(string = XmlUtils.getString("ef", xmlElement2, null))) {
                    ((Hashtable)object5).put("ef", string);
                }
                if (Strings.isNumeric(string = XmlUtils.getString("nf", xmlElement2, null))) {
                    ((Hashtable)object5).put("nf", string);
                }
                if (Strings.isNumeric(string = XmlUtils.getString("k0", xmlElement2, null))) {
                    ((Hashtable)object5).put("k0", string);
                }
                if (Strings.isNumeric(string = XmlUtils.getString("phi_f", xmlElement2, null))) {
                    ((Hashtable)object5).put("phi_f", string);
                }
                if (Strings.isNumeric(string = XmlUtils.getString("lambda_f", xmlElement2, null))) {
                    ((Hashtable)object5).put("lambda_f", string);
                }
            }
            project.geoProjection = MapUtils.getPropAsString((Properties)object5, ',');
        }
        vector = xmlElement.getElementsByTagName("layer");
        n3 = vector.size();
        for (n = 0; n < n3; ++n) {
            xmlElement2 = (XmlElement)vector.elementAt(n);
            object5 = XmlUtils.getString("name", xmlElement2, null);
            if (object5 == null) {
                object5 = XmlUtils.getLangString("label", xmlElement2, "unnamed", project.language);
            }
            Vector vector2 = xmlElement2.getElementsByTagName("dataset");
            int n4 = vector2.size();
            for (int i = 0; i < n4; ++i) {
                Layer layer;
                boolean bl3;
                object4 = (XmlElement)vector2.elementAt(i);
                if (object4 == null) {
                    Loader.layerSetup.addStatusInfo(104, null, (String)object5);
                    continue;
                }
                Properties properties = XmlUtils.getText("connection", (XmlElement)object4);
                if (properties == null) {
                    properties = new Properties();
                }
                if ((object3 = XmlUtils.getString("type", (XmlElement)object4, null)) != null) {
                    ((Hashtable)properties).put("type", object3);
                }
                if ((object3 = XmlUtils.getString("id", (XmlElement)object4, null)) != null) {
                    if (XmlUtils.getBoolean("geocode", (XmlElement)object4, false)) {
                        object3 = "geocode" + (String)object3;
                    }
                    if (bl && project.getLayerByDsId((String)object3) != null) continue;
                    if (MapUtils.isRunFromDisk) {
                        Loader.layerSetup.addStatusInfo(0, null, "WARNING#116  dataset id#" + (String)object3);
                    } else {
                        ((Hashtable)properties).put("id", object3);
                        object5 = (String)object3 + ": " + (String)object5;
                    }
                }
                if ((object3 = XmlUtils.getString("url", (XmlElement)object4, null)) != null) {
                    ((Hashtable)properties).put("url", ExData.getURL((String)object3));
                    object2 = ExData.getUser((String)object3);
                    if (object2 != null) {
                        ((Hashtable)properties).put("user", object2);
                    }
                    if ((object2 = ExData.getPass((String)object3)) != null) {
                        ((Hashtable)properties).put("pass", object2);
                    }
                }
                if (XmlUtils.getBoolean("direct", (XmlElement)object4, true)) {
                    ((Hashtable)properties).put("direct", "yes");
                }
                try {
                    object2 = Loader.layerSetup.createLayer(properties);
                }
                catch (AlovMapException alovMapException) {
                    Loader.layerSetup.addStatusInfo(alovMapException.getCode(), null, (String)object5 + "  " + alovMapException.getMessage());
                    continue;
                }
                object = ((XmlElement)object4).getFirstElementByName("metadata");
                if (object != null && ((Layer)object2).metadata.isNotLoaded) {
                    ((Layer)object2).metadata.loadMetadata((XmlElement)object);
                }
                if (bl3 = XmlUtils.getBoolean("animatedzoom", xmlElement2, false)) {
                    project.isAnimatedZoom = true;
                }
                ((Layer)object2).isAnimatedZoom = bl3;
                if (!Loader.loadLayer(project, (Layer)object2, xmlElement2)) continue;
                Layer layer2 = layer = object2 instanceof LayerRaster && ((LayerRaster)object2).resolutionLevel > 0 || object2 instanceof LayerZoomify ? null : project.getLayerByDsId(((Layer)object2).datasetId);
                if (layer != null && object2.getClass().getName().equals(layer.getClass().getName())) {
                    ((Layer)object2).metadata = layer.metadata;
                    ((Layer)object2).dataStorage = layer.dataStorage;
                } else {
                    ((Layer)object2).metadata.cachesize = XmlUtils.getInt("cache", (XmlElement)object4, 0);
                }
                if (((Layer)object2).id == null) {
                    ((Layer)object2).id = project.getLayerCount() + 1 + "-" + ((Layer)object2).datasetId;
                }
                project.layers.addElement(object2);
                ((Layer)object2).isFullLoad = ((Layer)object2).isKeyMap || XmlUtils.getBoolean("full", (XmlElement)object4, true);
                ((Layer)object2).metadata.forceEmptyLoad = XmlUtils.getBoolean("forceload", (XmlElement)object4, false);
                ((Layer)object2).metadata.forceLoad = XmlUtils.getBoolean("forceloadall", (XmlElement)object4, false);
                ((Layer)object2).metadata.reloadTimeRange = XmlUtils.getInt("reloadtime", (XmlElement)object4, 0);
                ((Layer)object2).metadata.loadOnSearchRequestOnly = XmlUtils.getBoolean("searchonly", (XmlElement)object4, false);
                if (((Layer)object2).metadata.loadOnSearchRequestOnly) {
                    ((Layer)object2).metadata.forceEmptyLoad = true;
                }
                boolean bl4 = project.hasKeyMap = project.hasKeyMap || ((Layer)object2).isKeyMap;
                if (XmlUtils.getBoolean("startup", xmlElement2, false)) {
                    project.startLayer = ((Layer)object2).id;
                }
                if (!bl) continue;
                ((Layer)object2).removeOutOfExtent = project.isDynamic_RemoveOutOfExtent;
                ((Layer)object2).drawOrder = project.iDynamic_OrderOfLayers;
            }
        }
        n3 = project.getLayerCount();
        if (n3 == 0) {
            Loader.layerSetup.addStatusInfo(109, null, project.name);
            throw new AlovMapException(109, project.name);
        }
        vector = xmlElement.getElementsByTagName("radiogroup");
        n3 = vector.size();
        for (n = 0; n < n3; ++n) {
            xmlElement2 = (XmlElement)vector.elementAt(n);
            object5 = XmlUtils.getString("name", xmlElement2, null);
            n2 = XmlUtils.getInt("levels", xmlElement2, 1);
            if (Strings.isNullOrBlank((String)object5) || n2 < 1 || project.getRadioGroupByName((String)object5) != null) {
                Loader.layerSetup.addStatusInfo(117, null, (String)object5);
                continue;
            }
            RadioGroup radioGroup = new RadioGroup((String)object5, n2);
            object4 = XmlUtils.getString("dependent", xmlElement2, null);
            if (!Strings.isNullOrBlank((String)object4)) {
                object3 = new StringTokenizer((String)object4, " ,;");
                while (((StringTokenizer)object3).hasMoreTokens()) {
                    object2 = ((StringTokenizer)object3).nextToken();
                    object = project.getLayerById((String)object2);
                    if (object == null) continue;
                    radioGroup.addLayer((Layer)object);
                }
            }
            if (radioGroup.size() > 1) {
                project.radioGroups.addElement(radioGroup);
                continue;
            }
            Loader.layerSetup.addStatusInfo(117, null, (String)object5);
        }
    }

    protected static Shape loadMarkerShape(String string) {
        Shape shape = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,;");
        double[] dArray = new double[1000];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            dArray[n] = MapUtils.toDouble(stringTokenizer.nextToken());
            ++n;
        }
        if (n > 0) {
            double[] dArray2 = new double[n];
            System.arraycopy(dArray, 0, dArray2, 0, n);
            shape = new Shape(dArray2);
        }
        dArray = null;
        return shape;
    }

    private static boolean loadLayer(Project project, Layer layer, XmlElement xmlElement) {
        try {
            Object object;
            Object object2;
            Object object3;
            layer.id = XmlUtils.getString("name", xmlElement, null);
            if (layer.id == null) {
                layer.id = XmlUtils.getString("id", xmlElement, null);
            }
            layer.setName(XmlUtils.getLangString("label", xmlElement, layer.id, project.language));
            if (layer.getName() == null) {
                layer.setName("unnamed#" + project.getLayerCount() + 1);
            }
            layerSetup.addStatusInfo(0, layer, "Parse");
            if (layer.id != null && project.getLayerById(layer.id) != null) {
                layerSetup.addStatusInfo(106, layer, layer.id + " isn't unique");
                layer.id = null;
            }
            layer.metadata.passResolved = XmlUtils.getBoolean("password", xmlElement, true);
            layer.metadata.passFirstTime = !project.isDynamic;
            layer.zmin = XmlUtils.getFloat("zmin", xmlElement, 0.0f);
            layer.zmax = XmlUtils.getFloat("zmax", xmlElement, 0.0f);
            layer.zoom_for_select = XmlUtils.getFloat("zoom", xmlElement, 0.0f);
            layer.withinZoom = layer.zmin != 0.0f || layer.zmax != 0.0f;
            layer.timeVarying = true;
            layer.timeMin = ExDate.parseString(XmlUtils.getString("tmin", xmlElement, null));
            layer.timeMax = ExDate.parseString(XmlUtils.getString("tmax", xmlElement, null));
            layer.withinDate = layer.timeMin != null || layer.timeMax != null;
            layer.visible_always = XmlUtils.getBoolean("alwaysvisible", xmlElement, false);
            layer.setVisible(layer.visible_always ? true : XmlUtils.getBoolean("visible", xmlElement, true));
            layer.initiallyVisible = layer.isVisible();
            layer.isKeyMap = XmlUtils.getBoolean("keymap", xmlElement, false);
            layer.legendVisible = XmlUtils.getBoolean("showlegend", xmlElement, true);
            layer.legendExpanded = XmlUtils.getBoolean("legendexpanded", xmlElement, true);
            layer.legendName = XmlUtils.getString("legend", xmlElement, null);
            layer.legendOrder = XmlUtils.getInt("legendOrder", xmlElement, -1);
            layer.legendWrapText = XmlUtils.getBoolean("WrapLayerTitles", xmlElement, false);
            String string = XmlUtils.getString("map", xmlElement, "all");
            if (!string.equalsIgnoreCase("all")) {
                object3 = new StringTokenizer(string, " ,;");
                while (((StringTokenizer)object3).hasMoreTokens()) {
                    String string2 = ((StringTokenizer)object3).nextToken();
                    if (Strings.isNullOrBlank(string2 = string2.trim()) || string2.equalsIgnoreCase("all")) continue;
                    layer.themes.addElement(string2);
                }
            }
            layer.legendObjectType = XmlUtils.getInt("LegType", xmlElement, 0);
            object3 = XmlUtils.getString("legendsymbolshape", xmlElement, null);
            if (!Strings.isNullOrBlank((String)object3)) {
                layer.legendSymbolShape = Loader.loadMarkerShape((String)object3);
            }
            if (!Strings.isNullOrBlank((String)(object3 = XmlUtils.getString("hotspot", xmlElement, null)))) {
                layer.hotSpot = Loader.loadMarkerShape((String)object3);
            }
            layer.legendHideOutRange = XmlUtils.getBoolean("hidelegend_zoom", xmlElement, false);
            layer.canSearch = XmlUtils.getBoolean("cansearch", xmlElement, true);
            layer.canSelectByMouse = XmlUtils.getBoolean("canselect", xmlElement, true);
            layer.linkMain = xmlElement.getElValue("linkmask", layer.linkMain);
            layer.linkMain = xmlElement.getElValue("mainlink", layer.linkMain);
            layer.drawOrder = XmlUtils.getInt("order", xmlElement, 0);
            String string3 = XmlUtils.getString("dependent", xmlElement, null);
            if (!Strings.isNullOrBlank(string3)) {
                object2 = string3.indexOf(44) > 0 ? "," : " ,;";
                object = new StringTokenizer(string3, (String)object2);
                layer.controlledLayers = new Hashtable();
                while (((StringTokenizer)object).hasMoreTokens()) {
                    layer.controlledLayers.put(((StringTokenizer)object).nextToken(), "1");
                }
            }
            if (!Strings.isNullOrBlank(string3 = XmlUtils.getString("dependent_inverse", xmlElement, null))) {
                object2 = string3.indexOf(44) > 0 ? "," : " ,;";
                object = new StringTokenizer(string3, (String)object2);
                if (layer.controlledLayers == null) {
                    layer.controlledLayers = new Hashtable();
                }
                while (((StringTokenizer)object).hasMoreTokens()) {
                    layer.controlledLayers.put(((StringTokenizer)object).nextToken(), "0");
                }
            }
            layer.linkSearch = xmlElement.getElValue("searchlink", layer.linkSearch);
            layer.linkLegend = xmlElement.getElValue("legendlink", project.linkLegend);
            layer.linkTips = xmlElement.getElValue("tipslink", layer.linkTips);
            layer.tipsMask = XmlUtils.getLangString("tipsmask", xmlElement, null, project.language);
            if (layer instanceof LayerVector) {
                if (layer instanceof LayerZoomify) {
                    ((LayerZoomify)layer).maxPixelSize = XmlUtils.getFloat("resolution", xmlElement, 2.0f);
                    ((LayerZoomify)layer).transparency = XmlUtils.getInt("transparency", xmlElement, -1);
                    layer.canSearch = false;
                }
                object2 = (LayerVector)layer;
                ((LayerVector)object2).linkInfo = xmlElement.getElValue("infolink", ((LayerVector)object2).linkInfo);
                ((LayerVector)object2).localFilter = XmlUtils.getString("filter", xmlElement, ((LayerVector)object2).localFilter);
                ((LayerVector)object2).serverFilter = XmlUtils.getString("serverfilter", xmlElement, ((LayerVector)object2).serverFilter);
                Loader.loadSymbol(project, ((LayerVector)object2).symbol, xmlElement.getFirstElementByName("symbol"), false);
                object = xmlElement.getFirstElementByName("selsymbol");
                if (object != null) {
                    Loader.loadSymbol(project, ((LayerVector)object2).selectedSymbol, (XmlElement)object, false);
                } else {
                    ((LayerVector)object2).selectedSymbol.style = ((LayerVector)object2).symbol.style;
                    ((LayerVector)object2).selectedSymbol.size = ((LayerVector)object2).symbol.size;
                    ((LayerVector)object2).selectedSymbol.step = ((LayerVector)object2).symbol.step;
                }
                Vector vector = xmlElement.getElementsByTagName("renderer");
                int n = vector.size();
                if (n < 1 && layer.renderers.size() < 1) {
                    layer.renderers.addElement(layer.createDefaultRenderer());
                } else {
                    for (int i = 0; i < n; ++i) {
                        XmlElement xmlElement2 = (XmlElement)vector.elementAt(i);
                        String string4 = XmlUtils.getString("type", xmlElement2, "default");
                        if (string4 == null) continue;
                        Renderer renderer = null;
                        if (string4.equalsIgnoreCase("label")) {
                            renderer = new RendererLabel(layer);
                        } else if (string4.equalsIgnoreCase("gradcolor")) {
                            renderer = new RendererGrad(layer);
                        } else if (string4.equalsIgnoreCase("gradmarker")) {
                            renderer = new RendererGrad(layer);
                            renderer.drawMarker = true;
                        } else if (string4.equalsIgnoreCase("chart")) {
                            renderer = new RendererChart(layer);
                        } else if (string4.equalsIgnoreCase("dot")) {
                            renderer = new RendererDot(layer);
                        } else if (string4.equalsIgnoreCase("progress")) {
                            renderer = new RendererEvolution(layer);
                        } else if (string4.equalsIgnoreCase("analysis")) {
                            renderer = new RendererAnalysis(layer);
                        } else if (string4.equalsIgnoreCase("default")) {
                            renderer = new RendererDef(layer);
                        }
                        if (renderer != null) {
                            if (!Loader.loadRenderer(project, layer, renderer, xmlElement2)) continue;
                            if (renderer.name == null) {
                                renderer.name = String.valueOf(i);
                            }
                            layer.renderers.addElement(renderer);
                            continue;
                        }
                        layerSetup.addStatusInfo(107, layer, "renderer#" + i + "  " + string4);
                    }
                }
            } else if (layer instanceof LayerRaster) {
                ((LayerRaster)layer).resolutionLevel = XmlUtils.getInt("resolution", xmlElement, 0);
                ((LayerRaster)layer).transparentColor = XmlUtils.getColor("transparentColor", xmlElement, null);
                ((LayerRaster)layer).transparency = XmlUtils.getInt("transparency", xmlElement, -1);
                object2 = xmlElement.getElementsByTagName("renderer");
                int n = ((Vector)object2).size();
                Renderer renderer = layer.createDefaultRenderer();
                if (n > 0) {
                    XmlElement xmlElement3 = (XmlElement)((Vector)object2).elementAt(0);
                    Loader.loadRenderer(project, layer, renderer, xmlElement3);
                } else {
                    renderer.name = XmlUtils.getString("name", xmlElement, "1");
                    renderer.label = XmlUtils.getLangString("imagelabel", xmlElement, null, project.language);
                    renderer.legendVisible = renderer.label != null;
                }
                layer.renderers.addElement(renderer);
            }
            return true;
        }
        catch (Exception exception) {
            layerSetup.addStatusInfo(106, layer, null);
            return false;
        }
    }

    private static boolean loadRenderer(Project project, Layer layer, Renderer renderer, XmlElement xmlElement) {
        try {
            Object object;
            renderer.name = XmlUtils.getString("name", xmlElement, null);
            renderer.label = XmlUtils.getLangString("label", xmlElement, null, project.language);
            renderer.legendVisible = XmlUtils.getBoolean("showlegend", xmlElement, true);
            renderer.allowToggle = XmlUtils.getBoolean("AllowOnOffInLegend", xmlElement, false);
            renderer.enabled = XmlUtils.getBoolean("visible", xmlElement, true);
            renderer.radioGroupLevel = XmlUtils.getInt("radiogrouplevel", xmlElement, 0);
            renderer.zmin = XmlUtils.getFloat("zmin", xmlElement, 0.0f);
            renderer.zmax = XmlUtils.getFloat("zmax", xmlElement, 0.0f);
            renderer.withinZoom = renderer.zmin != 0.0f || renderer.zmax != 0.0f;
            String string = XmlUtils.getString("map", xmlElement, "all");
            if (!string.equalsIgnoreCase("all")) {
                String string2 = string.indexOf(44) > 0 ? "," : " ,;";
                StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (Strings.isNullOrBlank(string3 = string3.trim()) || string3.equalsIgnoreCase("all")) continue;
                    renderer.themes.addElement(string3);
                }
            }
            Vector vector = xmlElement.getElementsByTagName("symbol");
            int n = vector.size();
            renderer.symbolsUnprepared = new Vector();
            boolean bl = false;
            boolean bl2 = renderer instanceof RendererLabel;
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    XmlElement xmlElement2 = (XmlElement)vector.elementAt(i);
                    object = new Symbol();
                    Loader.loadSymbol(project, (Symbol)object, xmlElement2, bl2);
                    bl = ((Symbol)object).drawMarker = ((Symbol)object).drawMarker || renderer.drawMarker;
                    renderer.symbolsUnprepared.addElement(object);
                }
                renderer.drawMarker = bl;
            }
            if (renderer instanceof RendererDef && renderer.symbolsUnprepared.size() > 0) {
                renderer.symbols = new Symbol[1];
                renderer.symbols[0] = (Symbol)renderer.symbolsUnprepared.elementAt(0);
            }
            if (renderer instanceof RendererChart) {
                RendererChart rendererChart = (RendererChart)renderer;
                rendererChart.width = XmlUtils.getInt("width", xmlElement, 0);
                rendererChart.height = XmlUtils.getInt("height", xmlElement, 0);
                int n2 = 0;
                if (rendererChart.width > 0 && rendererChart.height > 0) {
                    n2 = rendererChart.width;
                } else {
                    rendererChart.height = rendererChart.width = (n2 = XmlUtils.getInt("size", xmlElement, 32));
                }
                object = XmlUtils.getString("charttype", xmlElement, "pie");
                rendererChart.type = ((String)object).equalsIgnoreCase("bar") ? 2 : 1;
                Color color = rendererChart.outlineColor = XmlUtils.getBoolean("outlined", xmlElement, true) ? XmlUtils.getColor("outline", xmlElement, Color.black) : null;
                if (rendererChart.type == 2) {
                    rendererChart.normalization = XmlUtils.getFloat("normalization", xmlElement, 0.0f);
                } else {
                    rendererChart.sizeFieldName = XmlUtils.getString("sizefield", xmlElement, null);
                    if (rendererChart.sizeFieldName != null) {
                        rendererChart.minSize = XmlUtils.getInt("minsize", xmlElement, 16);
                        rendererChart.maxSize = XmlUtils.getInt("maxsize", xmlElement, 48);
                    }
                }
                vector = xmlElement.getElementsByTagName("field");
                int n3 = vector.size();
                rendererChart.fieldsUnprepared = new Vector();
                if (n3 > 0) {
                    for (int i = 0; i < n3; ++i) {
                        XmlElement xmlElement3 = (XmlElement)vector.elementAt(i);
                        object = XmlUtils.getString("name", xmlElement3, null);
                        if (object == null) continue;
                        FieldDef fieldDef = new FieldDef();
                        fieldDef.index = -1;
                        fieldDef.name = object;
                        fieldDef.color = XmlUtils.getColor("fill", xmlElement3, Color.white);
                        fieldDef.label = XmlUtils.getLangString("label", xmlElement3, null, project.language);
                        rendererChart.fieldsUnprepared.addElement(fieldDef);
                    }
                }
                if (rendererChart.fieldsUnprepared.size() <= 0) {
                    layerSetup.addStatusInfo(108, layer, "  Renderer: " + renderer.name);
                    return false;
                }
                layer.hasChart = true;
            } else if (renderer instanceof RendererGrad) {
                RendererGrad rendererGrad = (RendererGrad)renderer;
                rendererGrad.fieldName = XmlUtils.getString("field", xmlElement, null);
                if (rendererGrad.symbolsUnprepared.size() <= 0) {
                    layerSetup.addStatusInfo(108, layer, "  Renderer: " + renderer.name);
                    return false;
                }
                rendererGrad.equal = Strings.strToInt(XmlUtils.getString("equal", xmlElement, null), 2);
                if (rendererGrad.equal > 1) {
                    rendererGrad.equal = XmlUtils.getBoolean("equal", xmlElement, false) ? 0 : 1;
                }
                rendererGrad.drawDefault = XmlUtils.getBoolean("drawdefault", xmlElement, false);
            } else if (renderer instanceof RendererDot) {
                RendererDot rendererDot = (RendererDot)renderer;
                rendererDot.fieldName = XmlUtils.getString("field", xmlElement, null);
                rendererDot.dotSize = XmlUtils.getFloat("dotsize", xmlElement, 10000.0f);
                if (rendererDot.fieldName == null || rendererDot.dotSize <= 0.0f) {
                    layerSetup.addStatusInfo(108, layer, "  Renderer: " + renderer.name);
                    return false;
                }
                renderer.symbols = new Symbol[1];
                renderer.symbols[0] = rendererDot.symbolsUnprepared.size() < 1 ? new Symbol(Color.black, Color.black, true, false, 3) : (Symbol)renderer.symbolsUnprepared.elementAt(0);
            } else if (renderer instanceof RendererEvolution) {
                RendererEvolution rendererEvolution = (RendererEvolution)renderer;
                rendererEvolution.arrowHeadLength = XmlUtils.getInt("headlength", xmlElement, -1);
                rendererEvolution.arrowHeadWidth = XmlUtils.getInt("headwidth", xmlElement, -1);
                rendererEvolution.arrowHeadFeather = XmlUtils.getInt("headfeather", xmlElement, -1);
                rendererEvolution.arrowTailLength = XmlUtils.getInt("taillength", xmlElement, -1);
                rendererEvolution.arrowTailWidth = XmlUtils.getInt("tailwidth", xmlElement, -1);
                rendererEvolution.arrowTailFeather = XmlUtils.getInt("tailfeather", xmlElement, -1);
            } else if (renderer instanceof RendererAnalysis) {
                RendererAnalysis rendererAnalysis = (RendererAnalysis)renderer;
                rendererAnalysis.loadParameters(xmlElement);
            } else if (renderer instanceof RendererLabel) {
                RendererLabel rendererLabel = (RendererLabel)renderer;
                rendererLabel.labelFieldName = XmlUtils.getLangString("labelfield", xmlElement, null, project.language);
                if (rendererLabel.labelFieldName == null || rendererLabel.symbolsUnprepared.size() <= 0) {
                    layerSetup.addStatusInfo(108, layer, "  Renderer: " + renderer.name);
                    return false;
                }
                rendererLabel.houseNumberFieldNames = XmlUtils.getLangString("housenumberfields", xmlElement, null, project.language);
                rendererLabel.symbolFieldName = XmlUtils.getString("symbolfield", xmlElement, null);
                rendererLabel.drawDefault = XmlUtils.getBoolean("drawdefault", xmlElement, false);
                rendererLabel.equal = Strings.strToInt(XmlUtils.getString("equal", xmlElement, null), 2);
                if (rendererLabel.equal > 1) {
                    rendererLabel.equal = XmlUtils.getBoolean("equal", xmlElement, false) ? 0 : 1;
                }
                rendererLabel.rotationFieldName = XmlUtils.getString("rotationfield", xmlElement, null);
                rendererLabel.sizeFieldName = XmlUtils.getString("sizefield", xmlElement, null);
                rendererLabel.notOverlap = !XmlUtils.getBoolean("overlap", xmlElement, false);
                rendererLabel.streetDrawingMode = XmlUtils.getInt("streetdrawmode", xmlElement, rendererLabel.streetDrawingMode);
            }
            return true;
        }
        catch (Exception exception) {
            layerSetup.addStatusInfo(106, layer, "  Renderer: " + renderer.name);
            exception.printStackTrace();
            return false;
        }
    }

    private static void loadSymbol(Project project, Symbol symbol, XmlElement xmlElement, boolean bl) {
        String string;
        if (xmlElement == null) {
            return;
        }
        symbol.size = XmlUtils.getInt("size", xmlElement, bl ? 12 : 1);
        if (symbol.size > 100) {
            symbol.size = 100;
        }
        symbol.minSize = XmlUtils.getInt("minsize", xmlElement, 2);
        symbol.maxSize = XmlUtils.getInt("maxsize", xmlElement, 25);
        symbol.useZoom = XmlUtils.getBoolean("usezoom", xmlElement, false) && symbol.minSize < symbol.maxSize;
        symbol.step = XmlUtils.getInt("step", xmlElement, 20);
        if (symbol.step < 3) {
            symbol.step = 3;
        } else if (symbol.step > 50) {
            symbol.step = 50;
        }
        symbol.fill = XmlUtils.getBoolean("filled", xmlElement, true);
        if (symbol.fill) {
            symbol.fillColor = XmlUtils.getColor("fill", xmlElement, bl ? Color.black : Color.yellow);
        }
        symbol.outline = XmlUtils.getBoolean("outlined", xmlElement, true);
        if (symbol.outline) {
            symbol.outlineColor = XmlUtils.getColor("outline", xmlElement, bl ? null : Color.black);
            symbol.outline = symbol.outlineColor != null;
        }
        symbol.style = XmlUtils.getInt("style", xmlElement, 0);
        if (!bl && !Strings.isNullOrBlank(string = XmlUtils.getString("symbolshape", xmlElement, null))) {
            symbol.symbolShape = Loader.loadMarkerShape(string);
            if (symbol.symbolShape != null) {
                symbol.style = 5;
            }
        }
        symbol.fontStyle = XmlUtils.getInt("fontstyle", xmlElement, symbol.style > 3 ? 0 : symbol.style);
        symbol.drawMarker = XmlUtils.getBoolean("marker", xmlElement, false);
        symbol.label = XmlUtils.getLangString("label", xmlElement, null, project.language);
        symbol.valueStr = XmlUtils.getString("val", xmlElement, null);
        symbol.imageUrl = XmlUtils.getString("image", xmlElement, null);
        symbol.fontName = XmlUtils.getString("font", xmlElement, MapUtils.defaultPlainFont.getName());
        symbol.legendVisible = XmlUtils.getBoolean("showlegend", xmlElement, true);
        symbol.visible = XmlUtils.getBoolean("visible", xmlElement, true);
        symbol.imageAnimated = XmlUtils.getBoolean("animated", xmlElement, false);
        symbol.align = XmlUtils.getInt("align", xmlElement, -1);
        if (symbol.align == -1) {
            symbol.align = XmlUtils.getInt("labelstyle", xmlElement, 2);
        }
        symbol.position = XmlUtils.getInt("position", xmlElement, 1);
        char c = (char)XmlUtils.getElInt("CharIndex", xmlElement, 0);
        symbol.charMarker = new Character(c).toString();
        symbol.offsetMin = Strings.time2DeltaExtDate(XmlUtils.getString("offsetmin", xmlElement, null));
        symbol.offsetMax = Strings.time2DeltaExtDate(XmlUtils.getString("offsetmax", xmlElement, null));
        symbol.rotation = XmlUtils.getFloat("rotation", xmlElement, 0.0f);
        symbol.rotation = symbol.rotation / 180.0f * (float)Math.PI;
        symbol.xOffset = XmlUtils.getInt("xoffset", xmlElement, 0);
        symbol.yOffset = XmlUtils.getInt("yoffset", xmlElement, 0);
        symbol.factor = XmlUtils.getFloat("factor", xmlElement, 1.0f);
        symbol.sizeFieldName = XmlUtils.getString("sizefield", xmlElement, null);
        symbol.rotationFieldName = XmlUtils.getString("rotationfield", xmlElement, null);
        Loader.load2Dfeatures(xmlElement, symbol);
    }

    static void load2Dfeatures(XmlElement xmlElement, Symbol symbol) {
        int n;
        Object object;
        float f;
        Object object2;
        Object object3;
        XmlElement xmlElement2;
        if (!Utils2D.have2d()) {
            return;
        }
        XmlElement xmlElement3 = xmlElement2 = Utils2D.have2d() ? xmlElement.getFirstElementByName("paint") : null;
        if (xmlElement2 != null) {
            XmlElement xmlElement4;
            object3 = XmlUtils.getElString("type", xmlElement2, XmlUtils.getString("type", xmlElement2, null));
            if (object3 != null) {
                symbol.fill = true;
                if ("color".equalsIgnoreCase((String)object3)) {
                    symbol.g2dPaint = symbol.fillColor;
                } else if ("texture".equalsIgnoreCase((String)object3)) {
                    xmlElement4 = xmlElement2.getFirstElementByName("texture");
                    if (xmlElement4 != null) {
                        FloatRectangle floatRectangle = XmlUtils.getRect(xmlElement4);
                        object2 = XmlUtils.getString("image", xmlElement4, null);
                        if (floatRectangle == null) {
                            floatRectangle = new FloatRectangle(0.0, 0.0, 100.0, 100.0);
                        }
                        if (object2 != null) {
                            symbol.textureAnchor = new Rectangle((int)floatRectangle.x, (int)floatRectangle.y, (int)(floatRectangle.x2 - floatRectangle.x), (int)(floatRectangle.y2 - floatRectangle.y));
                            symbol.textureUrl = object2;
                        }
                    }
                } else if ("gradient".equalsIgnoreCase((String)object3)) {
                    xmlElement4 = xmlElement2.getFirstElementByName("gradient");
                    if (xmlElement4 == null) {
                        xmlElement4 = xmlElement2;
                    }
                    if (xmlElement4 != null) {
                        float f2 = XmlUtils.getElFloat("x1", xmlElement4, XmlUtils.getFloat("x1", xmlElement4, 0.0f));
                        float f3 = XmlUtils.getElFloat("y1", xmlElement4, XmlUtils.getFloat("y1", xmlElement4, 0.0f));
                        f = XmlUtils.getElFloat("x2", xmlElement4, XmlUtils.getFloat("x2", xmlElement4, 100.0f));
                        float f4 = XmlUtils.getElFloat("y2", xmlElement4, XmlUtils.getFloat("y2", xmlElement4, 100.0f));
                        object = XmlUtils.getElColor("color1", xmlElement4, XmlUtils.getColor("color1", xmlElement4, Color.white));
                        Color color = XmlUtils.getElColor("color2", xmlElement4, XmlUtils.getColor("color2", xmlElement4, Color.black));
                        boolean bl = XmlUtils.getElBoolean("cyclic", xmlElement4, XmlUtils.getBoolean("cyclic", xmlElement4, true));
                        symbol.g2dPaint = Load2D.getGradientPaint(f2, f3, (Color)object, f, f4, color, bl);
                    }
                }
            }
            if ((xmlElement4 = xmlElement2.getFirstElementByName("composite")) != null) {
                symbol.g2dPaintComposite = Load2D.getAlphaComposite(XmlUtils.getString("rule", xmlElement4, null), XmlUtils.getFloat("alpha", xmlElement4, 1.0f));
            }
        }
        if ((n = ((Vector)(object3 = xmlElement.getElementsByTagName("stroke"))).size()) > 0) {
            symbol.g2dStroke = new Vector();
            symbol.g2dStrokeColours = new Vector();
            for (int i = 0; i < n; ++i) {
                Object object4;
                object2 = (XmlElement)((Vector)object3).elementAt(i);
                f = XmlUtils.getFloat("width", (XmlElement)object2, 1.0f);
                String string = XmlUtils.getString("cap", (XmlElement)object2, null);
                object = XmlUtils.getString("join", (XmlElement)object2, null);
                float f5 = XmlUtils.getFloat("miterlimit", (XmlElement)object2, 10.0f);
                float f6 = XmlUtils.getFloat("dashphase", (XmlElement)object2, 0.0f);
                float[] fArray = null;
                String string2 = ((XmlElement)object2).getElValue("dashpattern", null, true);
                if (string2 != null) {
                    object4 = new StringTokenizer(string2, " ,\n\t\r;|");
                    Vector<Float> vector = new Vector<Float>();
                    while (((StringTokenizer)object4).hasMoreTokens()) {
                        String string3 = ((StringTokenizer)object4).nextToken();
                        try {
                            Float f7 = new Float(string3);
                            vector.addElement(f7);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    int n2 = vector.size();
                    if (n2 > 0) {
                        fArray = new float[n2];
                        for (int j = 0; j < n2; ++j) {
                            fArray[j] = ((Float)vector.elementAt(j)).floatValue();
                        }
                    }
                }
                symbol.g2dStroke.addElement(Load2D.getBasicStroke(f, string, (String)object, f5, fArray, f6));
                symbol.g2dStrokeColours.addElement(XmlUtils.getColor("color", (XmlElement)object2, symbol.outlineColor));
                object4 = ((XmlElement)object2).getFirstElementByName("composite");
                if (object4 == null) continue;
                symbol.g2dStrokeComposite = Load2D.getAlphaComposite(XmlUtils.getString("rule", (XmlElement)object4, null), XmlUtils.getFloat("alpha", (XmlElement)object4, 1.0f));
            }
        }
    }
}

