/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.RGBImageFilter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.alov.map.Carte;
import org.alov.map.CarteHost;
import org.alov.map.FloatPoint;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.Load2D;
import org.alov.map.Record;
import org.alov.map.RecordsArray;
import org.alov.map.Shape;
import org.alov.map.StreamCounter;
import org.alov.map.Utils2D;
import org.alov.util.Const;
import org.alov.util.Readers;
import org.alov.util.Strings;
import org.alov.util.Utils;
import org.alov.viewer.ImageButton;

public class MapUtils
implements Const {
    static int TotalImageSize = 0;
    private static final String _AUTHORIZ = "Authorization";
    public static Font defaultBoldFont = null;
    public static Font defaultPlainFont = null;
    public static String codeBase = null;
    public static String projectBase = null;
    public static boolean isRunFromDisk = false;
    public static boolean isApplication = false;
    public static boolean isServerSide = false;
    public static boolean isTipsActive = false;
    public static String language = null;
    public static FloatRectangle predefExtent = null;
    public static String predefTheme = null;
    public static String servletURL = "mapserv";
    public static String predefExtentName = null;
    private static ImageObserver imageObserver = null;
    public static boolean showCounter = false;
    private static byte SLD_Enabled = 0;
    private static byte MIF_Enabled = 0;
    public static int MAX_IMAGE_SIZE = 10240000;
    private static final String DEGREE_SIGN = "\u00b0";
    private static final double EARTH_RADIUS_KM = 6378.137;
    private static final double Degree = 57.29577951308232;
    private static Hashtable images;
    private static Hashtable imgUrls;
    private static Object zero;
    private static int requestedImages;

    private MapUtils() {
    }

    protected static boolean isSLD_Enabled() {
        if (SLD_Enabled == 0) {
            SLD_Enabled = 1;
            try {
                Class<?> clazz = Class.forName("org.alov.map.SLD");
                clazz = Class.forName("org.alov.map.SLD_Loader");
                SLD_Enabled = (byte)2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return SLD_Enabled == 2;
    }

    public static boolean isMIF_Enabled() {
        if (MIF_Enabled == 0) {
            MIF_Enabled = 1;
            try {
                Class<?> clazz = Class.forName("org.alov.data.Mif");
                MIF_Enabled = (byte)2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return MIF_Enabled == 2;
    }

    public static int compare(Object object, Object object2) {
        if (object.equals(object2)) {
            return 0;
        }
        if (object instanceof Number) {
            if (((Number)object).doubleValue() >= ((Number)object2).doubleValue()) {
                return 1;
            }
            return -1;
        }
        if (object instanceof String) {
            return ((String)object).compareTo((String)object2);
        }
        if (object instanceof Date) {
            if (((Date)object2).before((Date)object)) {
                return 1;
            }
            return -1;
        }
        return -2;
    }

    public static StreamCounter openURL(String string) throws IOException {
        return MapUtils.openURL(string, null, null);
    }

    public static StreamCounter openURL(String string, String string2, Layer layer) throws IOException {
        if (string != null && codeBase != null && string.indexOf("://") < 0 && string.indexOf("file:/") < 0) {
            return MapUtils.openURL_(codeBase + string, string2, layer);
        }
        return MapUtils.openURL_(string, string2, layer);
    }

    private static StreamCounter openURL_(String string, String string2, Layer layer) throws IOException {
        InputStream inputStream;
        Object object;
        long l = 0L;
        if (string.startsWith("file:/") && isServerSide) {
            object = new File(Strings.decode(string.substring("file:/".length())));
            inputStream = new FileInputStream((File)object);
            l = ((File)object).length();
        } else {
            boolean bl = false;
            if (!MapUtils.isUrlInCodeBase(string)) {
                string = "?rq=GetImage&rd=" + string;
                string = MapUtils.getRealPath(servletURL) + string;
                bl = true;
            }
            URL uRL = (string = string.replace('\\', '/')).startsWith("file:/") ? new URL(string) : new URL(Strings.setObj(string, ' ', "%20"));
            URLConnection uRLConnection = uRL.openConnection();
            if (!Strings.isNullOrBlank(string2)) {
                uRLConnection.setRequestProperty(_AUTHORIZ, string2);
                inputStream = uRLConnection.getInputStream();
            } else {
                inputStream = uRL.openStream();
            }
            if (layer != null && layer.getMap() instanceof Carte && showCounter) {
                l = uRLConnection.getContentLength();
            }
            if (bl) {
                Readers.readInt(inputStream);
                Readers.readInt(inputStream);
            }
        }
        if (layer != null && l > 5000L && layer.getMap() instanceof Carte) {
            object = new StreamCounter(inputStream, 1024, (Carte)layer.getMap());
            ((StreamCounter)object).setCounter(l, "[ " + layer.getName() + ']');
        } else {
            object = new StreamCounter(inputStream, 1024, null);
        }
        ((StreamCounter)object).url = string;
        return object;
    }

    private static int getUByte(byte by) {
        return by & 0xFF;
    }

    private static int getUWord(byte by, byte by2) {
        return by & 0xFF | (by2 & 0xFF) << 8;
    }

    private static boolean checkImageSize(byte[] byArray) throws Exception {
        Dimension dimension = MapUtils.getImageSize(byArray);
        long l = dimension.width * dimension.height;
        if (Utils.isJava14) {
            long l2 = Utils.getFreeMemorySpace();
            boolean bl = (float)(l *= 4L) / (float)l2 * 100.0f <= 50.0f;
            return bl;
        }
        return l < (long)MAX_IMAGE_SIZE;
    }

    static Dimension getImageSize(byte[] byArray) throws Exception {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        String string = new String(byArray, 0, 6);
        if (string.equals("GIF87a")) {
            bl = false;
        } else if (string.equals("GIF89a")) {
            bl = true;
        } else if (string.substring(1).equals("PNG\r\n")) {
            bl2 = true;
        } else {
            if (MapUtils.getUByte(byArray[0]) != 255 || MapUtils.getUByte(byArray[1]) != 216) {
                throw new Exception("Unknown image format");
            }
            boolean bl3 = true;
            int n3 = 2;
            int n4 = byArray.length;
            while (n3 < n4) {
                if (MapUtils.getUByte(byArray[n3]) == 255) {
                    int n5 = MapUtils.getUByte(byArray[n3 + 1]);
                    int n6 = MapUtils.getUWord(byArray[n3 + 3], byArray[n3 + 2]);
                    switch (n5) {
                        case 217: {
                            return null;
                        }
                        case 192: 
                        case 193: 
                        case 194: 
                        case 195: 
                        case 197: 
                        case 198: 
                        case 199: 
                        case 201: 
                        case 202: 
                        case 203: 
                        case 205: 
                        case 206: 
                        case 207: {
                            bl3 = false;
                            n2 = MapUtils.getUWord(byArray[n3 + 6], byArray[n3 + 5]);
                            n = MapUtils.getUWord(byArray[n3 + 8], byArray[n3 + 7]);
                            return new Dimension(n, n2);
                        }
                    }
                    n3 += n6 + 2;
                    continue;
                }
                ++n3;
            }
            return null;
        }
        if (bl2) {
            n = (byArray[19] & 0xFF) + 256 * (byArray[18] & 0xFF);
            n2 = (byArray[23] & 0xFF) + 256 * (byArray[22] & 0xFF);
        } else {
            n = (byArray[6] & 0xFF) + 256 * (byArray[7] & 0xFF);
            n2 = (byArray[8] & 0xFF) + 256 * (byArray[9] & 0xFF);
        }
        return new Dimension(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadImageToByteArray(Layer layer, String string) throws Exception {
        byte[] byArray = null;
        StreamCounter streamCounter = layer != null && layer.provider != null ? layer.provider.openURL(string) : MapUtils.openURL(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        try {
            int n;
            byte[] byArray2 = new byte[8192];
            while ((n = ((InputStream)streamCounter).read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            ((InputStream)streamCounter).close();
            byte[] byArray3 = byArray = byteArrayOutputStream.toByteArray();
            return byArray3;
        }
        finally {
            byteArrayOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image loadImage2(Layer layer, String string) throws Exception {
        StreamCounter streamCounter = layer != null && layer.provider != null ? layer.provider.openURL(string) : MapUtils.openURL(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        try {
            Image image;
            int n;
            byte[] byArray = null;
            byte[] byArray2 = new byte[8192];
            while ((n = ((InputStream)streamCounter).read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            ((InputStream)streamCounter).close();
            byArray = byteArrayOutputStream.toByteArray();
            if (!isApplication && !MapUtils.checkImageSize(byArray)) {
                if (Utils.isJava14) {
                    throw new Exception("\nImage exceeding threshold size (would use 50% of available memory)");
                }
                throw new Exception("\nImage is too large. Maximum width*height value is " + MAX_IMAGE_SIZE);
            }
            Image image2 = image = MapUtils.createImageFromBytes(byArray);
            return image2;
        }
        finally {
            byteArrayOutputStream.close();
        }
    }

    public static Image createImageFromBytes(byte[] byArray) throws Exception {
        if (byArray != null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image image = toolkit.createImage(byArray);
            return MapUtils.prepareImage(toolkit, image);
        }
        return null;
    }

    private static Image prepareImage(Toolkit toolkit, Image image) throws Exception {
        int n;
        toolkit.prepareImage(image, 1000, 1000, imageObserver);
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        while (((n2 = image.getHeight(imageObserver)) < 0 || (n3 = image.getWidth(imageObserver)) < 0) && n4 < 10) {
            try {
                ++n4;
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        for (n4 = 0; n4 < 100 && ((n = toolkit.checkImage(image, n2, n3, imageObserver)) & 0x20) == 0; ++n4) {
            if ((n & 0x10) != 0) {
                if ((n & 4) != 0) break;
            }
            Thread.sleep(100L);
        }
        return image;
    }

    public static ImageObserver getGlobalImageObserver() {
        return imageObserver;
    }

    public static void setGlobalImageObserver(ImageObserver imageObserver) {
        MapUtils.imageObserver = imageObserver;
    }

    public static int setUnits(String string, int n) {
        if (string == null) {
            return n;
        }
        if (string.equalsIgnoreCase("meters")) {
            return 1;
        }
        if (string.equalsIgnoreCase("degrees")) {
            return 0;
        }
        if (string.equalsIgnoreCase("km")) {
            return 2;
        }
        if (string.equalsIgnoreCase("feet")) {
            return 4;
        }
        if (string.equalsIgnoreCase("miles")) {
            return 5;
        }
        if (string.equalsIgnoreCase("inches")) {
            return 3;
        }
        if (string.equalsIgnoreCase("m")) {
            return 1;
        }
        if (string.equalsIgnoreCase("km")) {
            return 2;
        }
        if (string.equalsIgnoreCase("ft")) {
            return 4;
        }
        if (string.equalsIgnoreCase("mi")) {
            return 5;
        }
        if (string.equalsIgnoreCase("nmi")) {
            return 6;
        }
        if (string.equalsIgnoreCase("in")) {
            return 3;
        }
        return n;
    }

    public static String formatDistance(double d, int n, int n2, int n3, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        d = MapUtils.convertDistance(d, n, n2);
        stringBuffer.append(Strings.doubleToStr(d, n3));
        stringBuffer.append(" ");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static double convertDistance(double d, int n, int n2) {
        switch (n) {
            case 1: {
                d *= (double)39.37f;
                break;
            }
            case 0: 
            case 2: {
                d = d * 1000.0 * (double)39.37f;
                break;
            }
            case 4: {
                d *= 12.0;
                break;
            }
            case 5: {
                d *= 63360.0;
                break;
            }
            case 6: {
                d *= 72913.2421875;
            }
        }
        switch (n2) {
            case 1: {
                d /= (double)39.37f;
                break;
            }
            case 0: 
            case 2: {
                d = d / 1000.0 / (double)39.37f;
                break;
            }
            case 4: {
                d /= 12.0;
                break;
            }
            case 5: {
                d /= 63360.0;
                break;
            }
            case 6: {
                d /= 72913.2421875;
            }
        }
        return d;
    }

    public static String formatDegree(double d, boolean bl, boolean bl2) {
        char c;
        if (bl2) {
            if (bl) {
                char c2 = c = d > 0.0 && d < 180.0 ? (char)'E' : 'W';
                if (Math.abs(d) > 180.0) {
                    d = 360.0 - Math.abs(d);
                }
            } else {
                c = d > 0.0 ? (char)'N' : 'S';
            }
            d = Math.abs(d);
        } else {
            c = ' ';
        }
        double d2 = Math.abs((d - (double)((int)d)) * 60.0);
        int n = (int)Math.round((d2 - (double)((int)d2)) * 60.0);
        return (int)d + DEGREE_SIGN + (int)d2 + '\'' + n + "'' " + c;
    }

    public static double getDistance(FloatPoint floatPoint, FloatPoint floatPoint2, int n) {
        if (n == 0) {
            return MapUtils.lengthDegrees(floatPoint.x, floatPoint.y, floatPoint2.x, floatPoint2.y);
        }
        double d = floatPoint2.x - floatPoint.x;
        double d2 = floatPoint2.y - floatPoint.y;
        return Math.sqrt(d * d + d2 * d2);
    }

    private static double lengthDegrees(double d, double d2, double d3, double d4) {
        double d5;
        if ((d5 = Math.acos(Math.cos(d2 *= Math.PI / 180) * Math.cos(d *= Math.PI / 180) * Math.cos(d4 *= Math.PI / 180) * Math.cos(d3 *= Math.PI / 180) + Math.cos(d2) * Math.sin(d) * Math.cos(d4) * Math.sin(d3) + Math.sin(d2) * Math.sin(d4)) * 6378.137) == Double.NaN) {
            d5 = 0.0;
        }
        return d5;
    }

    public static double getDistance(FloatRectangle floatRectangle, int n, int n2) {
        if (floatRectangle == null) {
            return 0.0;
        }
        double d = 0.0;
        double d2 = 1.0;
        switch (n) {
            case 0: {
                double d3 = Math.abs(floatRectangle.y2 - (floatRectangle.y2 - floatRectangle.y) / 2.0);
                if (d3 >= 90.0) {
                    d3 = 89.99999237060547;
                }
                d2 = Math.cos(d3 * Math.PI / 180.0) * (double)68.8f * 63360.0;
                break;
            }
            case 1: {
                d2 = 39.37f;
                break;
            }
            case 2: {
                d2 = 39370.0;
                break;
            }
            case 4: {
                d2 = 12.0;
                break;
            }
            case 5: {
                d2 = 63360.0;
                break;
            }
            case 6: {
                d2 = 72913.2421875;
            }
        }
        d = Math.abs(floatRectangle.x2 - floatRectangle.x) * d2;
        switch (n2) {
            case 1: {
                d = d * (double)2.54f / 100.0;
                break;
            }
            case 2: {
                d = d * (double)2.54f / 100000.0;
                break;
            }
            case 4: {
                d /= 12.0;
                break;
            }
            case 5: {
                d /= 63360.0;
                break;
            }
            case 6: {
                d /= 72913.2421875;
            }
        }
        return d;
    }

    public static double toMapUnits(double d, FloatRectangle floatRectangle, int n, int n2) {
        if (d <= 0.0) {
            return 0.0;
        }
        double d2 = 0.0;
        double d3 = 1.0;
        double d4 = 0.0;
        switch (n2) {
            case 1: {
                d2 = d * 100.0 / (double)2.54f;
                break;
            }
            case 2: {
                d2 = d * 100000.0 / (double)2.54f;
                break;
            }
            case 4: {
                d2 = d * 12.0;
                break;
            }
            case 5: {
                d2 = d * 63360.0;
            }
            case 6: {
                d2 = d * 72913.2421875;
            }
        }
        switch (n) {
            case 0: {
                if (floatRectangle != null && (d4 = Math.abs(floatRectangle.y2 - (floatRectangle.y2 - floatRectangle.y) / 2.0)) >= 90.0) {
                    d4 = 89.99999237060547;
                }
                d3 = Math.cos(d4 * Math.PI / 180.0) * (double)68.8f * 63360.0;
                break;
            }
            case 1: {
                d3 = 39.37f;
                break;
            }
            case 2: {
                d3 = 39370.0;
                break;
            }
            case 4: {
                d3 = 12.0;
                break;
            }
            case 5: {
                d3 = 63360.0;
                break;
            }
            case 6: {
                d3 = 72913.2421875;
            }
        }
        return d2 / d3;
    }

    public static double toDouble(Object object) {
        return MapUtils.toDoubleDef(object, 0.0);
    }

    public static double toDoubleDef(Object object, double d) {
        try {
            if (object == null) {
                return d;
            }
            if (object instanceof Number) {
                return ((Number)object).doubleValue();
            }
            return Double.valueOf((String)object);
        }
        catch (Exception exception) {
            return d;
        }
    }

    public static String getRealPath(String string) {
        if (codeBase != null && string != null && string.indexOf("http://") != 0 && string.indexOf("file:/") < 0 && string.indexOf("javascript:") < 0) {
            if (string.indexOf(":\\") == 1) {
                return "file:/" + string;
            }
            if (string.indexOf("\\") == 0) {
                return "file://" + string.substring(2);
            }
            return codeBase + string;
        }
        return string;
    }

    private static boolean isUrlInCodeBase(String string) {
        if (codeBase != null && string != null && codeBase.indexOf("file:/") < 0 && string.indexOf(":\\") != 1 && (string.indexOf("http://") == 0 || string.indexOf("file:/") == 0)) {
            return string.toLowerCase().startsWith(codeBase.toLowerCase()) && string.indexOf("?rq=GetImage&rd=") < 0;
        }
        return true;
    }

    public static Component findComp(Container container, String string) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (string.equalsIgnoreCase(component.getName())) {
                return component;
            }
            if (!(component instanceof Container) || (component = MapUtils.findComp((Container)component, string)) == null) continue;
            return component;
        }
        return null;
    }

    public static boolean isNotEmpty(Vector vector) {
        return vector != null && vector.size() > 0;
    }

    public static boolean isNotEmptyRecs(RecordsArray recordsArray) {
        return recordsArray != null && recordsArray.size() > 0;
    }

    public static void addActionListener(ActionListener actionListener, Container container, String string) {
        Component component = MapUtils.findComp(container, string);
        if (component != null && actionListener != null) {
            if (component instanceof Button) {
                ((Button)component).addActionListener(actionListener);
            } else if (component instanceof ImageButton) {
                ((ImageButton)component).addActionListener(actionListener);
            }
        }
    }

    public static void addActionListener(ActionListener actionListener, Container container) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (component instanceof Button) {
                ((Button)component).addActionListener(actionListener);
                continue;
            }
            if (component instanceof ImageButton) {
                ((ImageButton)component).addActionListener(actionListener);
                continue;
            }
            if (!(component instanceof Container)) continue;
            MapUtils.addActionListener(actionListener, (Container)component);
        }
    }

    private static double Hav(double d) {
        return (1.0 - Math.cos(d)) / 2.0;
    }

    static double sphericalPolyArea(double[] dArray, double[] dArray2) {
        int n = dArray.length - 1;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i <= n; ++i) {
            double d5;
            double d6;
            double d7;
            int n2 = i + 1;
            if (i == 0) {
                d7 = dArray2[i];
                d6 = dArray[i];
                d = dArray2[i + 1];
                d2 = dArray[i + 1];
                d5 = Math.cos(d6);
                d3 = Math.cos(d2);
            } else {
                n2 = (i + 1) % (n + 1);
                d7 = d;
                d6 = d2;
                d = dArray2[n2];
                d2 = dArray[n2];
                d5 = d3;
                d3 = Math.cos(d2);
            }
            if (d7 == d) continue;
            double d8 = MapUtils.Hav(d2 - d6) + d5 * d3 * MapUtils.Hav(d - d7);
            double d9 = 2.0 * Math.asin(Math.sqrt(d8));
            double d10 = 1.5707963267948966 - d2;
            double d11 = 1.5707963267948966 - d6;
            double d12 = 0.5 * (d9 + d10 + d11);
            double d13 = Math.tan(d12 / 2.0) * Math.tan((d12 - d9) / 2.0) * Math.tan((d12 - d10) / 2.0) * Math.tan((d12 - d11) / 2.0);
            double d14 = Math.abs(4.0 * Math.atan(Math.sqrt(Math.abs(d13)))) * 57.29577951308232;
            if (d < d7) {
                d14 = -d14;
            }
            d4 += d14;
        }
        return Math.abs(d4);
    }

    public static double getAreaSqKm(Record record) {
        double d = 0.0;
        int n = record.getShapeCount();
        for (int i = 0; i < n; ++i) {
            Shape shape = record.getShape(i);
            int n2 = shape.xCoords.length;
            if (n2 <= 2) continue;
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            for (int j = 0; j < n2; ++j) {
                dArray[j] = shape.yCoords[j] / 57.29577951308232;
                dArray2[j] = shape.xCoords[j] / 57.29577951308232;
            }
            double d2 = MapUtils.sphericalPolyArea(dArray, dArray2) * 707632.4;
            d += d2;
        }
        return d;
    }

    public static Vector wrapString(Graphics graphics, String string, int n) {
        Vector<String> vector = new Vector<String>();
        if (graphics == null) {
            vector.addElement(string);
            return vector;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r", true);
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.indexOf(10) == 0) {
                vector.addElement(string2);
                string2 = "";
                continue;
            }
            String string4 = string2;
            int n2 = fontMetrics.stringWidth(string4 = string4 + string3);
            if (n2 < n || string2.length() <= 0) {
                string2 = string4;
                continue;
            }
            vector.addElement(string2);
            string2 = string3;
        }
        if (string2.length() >= 0) {
            vector.addElement(string2);
        }
        return vector;
    }

    public static int getCurrentFontHeight(Graphics graphics) {
        return graphics != null ? graphics.getFontMetrics().getHeight() : defaultBoldFont.getSize();
    }

    public static int textHeight(String string, Graphics graphics, int n, boolean bl) {
        int n2 = MapUtils.getCurrentFontHeight(graphics);
        if (bl && string != null) {
            Vector vector = MapUtils.wrapString(graphics, string, n);
            return n2 * vector.size();
        }
        return n2;
    }

    public static Dimension getTextDimension(String string, Graphics graphics, int n, boolean bl) {
        int n2 = MapUtils.getCurrentFontHeight(graphics);
        if (bl && string != null) {
            Vector vector = MapUtils.wrapString(graphics, string, n);
            int n3 = 0;
            if (graphics != null) {
                FontMetrics fontMetrics = graphics.getFontMetrics();
                for (int i = 0; i < vector.size(); ++i) {
                    n3 = Math.max(n3, fontMetrics.stringWidth((String)vector.elementAt(i)));
                }
            } else {
                int n4 = defaultBoldFont.getSize();
                for (int i = 0; i < vector.size(); ++i) {
                    n3 = Math.max(n3, ((String)vector.elementAt(i)).length() * n4);
                }
            }
            return new Dimension(n3, n2 * vector.size());
        }
        return new Dimension(graphics != null ? graphics.getFontMetrics().stringWidth(string) : defaultBoldFont.getSize(), n2);
    }

    public static void drawText(Graphics graphics, String string, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        if (string == null) {
            return;
        }
        try {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n5 = fontMetrics.getHeight();
            if (bl) {
                Vector vector = MapUtils.wrapString(graphics, string, n3);
                int n6 = vector.size();
                if (n4 > n6 * n5) {
                    n2 += (n4 - n6 * n5) / 2;
                }
                for (int i = 0; i < n6; ++i) {
                    n2 += n5;
                    String string2 = (String)vector.elementAt(i);
                    if (string2 == null) continue;
                    graphics.drawString(string2, n, n2);
                    if (!bl2) continue;
                    int n7 = n + fontMetrics.stringWidth(string2);
                    graphics.drawLine(n, n2 + 1, n7, n2 + 1);
                }
            } else {
                if (n4 > n5) {
                    n2 += (n4 - n5) / 2;
                }
                graphics.drawString(string, n, n2 + n5);
                if (bl2) {
                    int n8 = n + fontMetrics.stringWidth(string);
                    graphics.drawLine(n, n2 + n5 + 1, n8, n2 + n5 + 1);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImageUrl(Image image) {
        Hashtable hashtable = images;
        synchronized (hashtable) {
            return (String)imgUrls.get(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void imageAborted(String string) {
        Hashtable hashtable = images;
        synchronized (hashtable) {
            images.put(string, zero);
        }
    }

    public static Font createAndVerifyFont(String string, int n, int n2, String string2) {
        Font font = null;
        try {
            if (Utils2D.have2d() && Strings.checkSuffix(string, ".ttf")) {
                StreamCounter streamCounter = MapUtils.openURL(string);
                font = Font.createFont(0, streamCounter);
                font = Utils2D.createTTF(font, n, n2);
            } else {
                font = new Font(string, n, n2);
            }
            if (Utils2D.have2d() && Load2D.isInvalidFont(font, string2)) {
                font = null;
                return null;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return font;
    }

    static void rotate_coords(int[] nArray, int[] nArray2, int n, int n2, float f) {
        if (f != 0.0f) {
            int n3 = nArray.length;
            for (int i = 0; i < n3; ++i) {
                int n4 = nArray[i] - n;
                int n5 = nArray2[i] - n2;
                float f2 = (float)Math.sqrt(n4 * n4 + n5 * n5);
                float f3 = (float)Math.atan2(n5, n4) + f;
                nArray[i] = (int)Math.round((double)f2 * Math.cos(f3)) + n;
                nArray2[i] = (int)Math.round((double)f2 * Math.sin(f3)) + n2;
            }
        }
    }

    public static String parameterArgument(CarteHost carteHost, String string) {
        int n;
        int n2;
        if (carteHost == null) {
            return string;
        }
        int n3 = -1;
        while ((n2 = string.indexOf("[", n3)) > n3 && (n = string.indexOf("]", n3)) != -1) {
            String string2 = string.substring(n2 + 1, n);
            String string3 = carteHost.getParameter(string2, null);
            n3 = n2;
            if (string3 == null) continue;
            string = string.substring(0, n2) + string3 + string.substring(n + 1);
        }
        return string;
    }

    public static double sqr(double d) {
        return d * d;
    }

    static boolean intersectCircle(FloatPoint floatPoint, FloatPoint floatPoint2, FloatPoint floatPoint3, double d) {
        return MapUtils.intersectCircle(new FloatPoint(floatPoint.x - floatPoint3.x, floatPoint.y - floatPoint3.y), new FloatPoint(floatPoint2.x - floatPoint3.x, floatPoint2.y - floatPoint3.y), d);
    }

    static boolean intersectCircle(FloatPoint floatPoint, FloatPoint floatPoint2, double d) {
        double d2;
        double d3 = MapUtils.sqr(d);
        double d4 = MapUtils.sqr(floatPoint.x);
        double d5 = MapUtils.sqr(floatPoint.y);
        double d6 = floatPoint2.x - floatPoint.x;
        double d7 = floatPoint2.y - floatPoint.y;
        if (0.0 == d6) {
            if (0.0 == d7) {
                return d4 + d5 <= d3;
            }
            if (Math.abs(floatPoint.x) <= d) {
                double d8 = Math.sqrt(d3 - d4);
                return 1.0 >= d8 / Math.abs(d7);
            }
            return false;
        }
        double d9 = d7 / d6;
        double d10 = MapUtils.sqr(d9);
        double d11 = d3 * (d10 + 1.0) - (d2 = floatPoint.y - d9 * floatPoint.x) * d2;
        if (0.0 > d11) {
            return false;
        }
        double d12 = (-d9 * d2 + Math.sqrt(d11)) / (d10 + 1.0);
        double d13 = (-d9 * d2 - Math.sqrt(d11)) / (d10 + 1.0);
        double d14 = d9 * d12 + d2;
        double d15 = d9 * d13 + d2;
        return Math.abs((d12 - floatPoint.x) / d6 - 0.5) <= 0.5 || Math.abs((d13 - floatPoint.x) / d6 - 0.5) <= 0.5 || d4 + d5 <= d3 || MapUtils.sqr(floatPoint2.x) + MapUtils.sqr(floatPoint2.y) <= d3;
    }

    static boolean intersectShape(FloatPoint floatPoint, FloatPoint floatPoint2, Shape shape) {
        if (null == floatPoint || null == floatPoint2 || null == shape) {
            return false;
        }
        double[] dArray = shape.xCoords;
        double[] dArray2 = shape.yCoords;
        int n = dArray.length;
        double d = floatPoint2.x - floatPoint.x;
        double d2 = floatPoint2.y - floatPoint.y;
        double d3 = Double.POSITIVE_INFINITY;
        if (0.0 == d) {
            if (0.0 == d2) {
                return Shape.containsPoint(shape, floatPoint.x, floatPoint.y);
            }
        } else {
            d3 = d2 / d;
        }
        double d4 = floatPoint.y - d3 * floatPoint.x;
        double d5 = dArray[n - 1];
        double d6 = dArray2[n - 1];
        FloatPoint floatPoint3 = new FloatPoint(0.0, 0.0);
        for (int i = 0; i < n; ++i) {
            boolean bl;
            double d7 = dArray[i];
            double d8 = dArray2[i];
            double d9 = d7 - d5;
            double d10 = d8 - d6;
            double d11 = 0.0 != d9 ? d10 / d9 : Double.POSITIVE_INFINITY;
            double d12 = d6 - d11 * d5;
            boolean bl2 = bl = 0.0 == d9 && 0.0 == d10 ? MapUtils.intersectPoint(d5, d6, floatPoint.x, d, floatPoint.y, d2, d3, d4, floatPoint3) : MapUtils.intersectsSegments(floatPoint.x, d, floatPoint.y, d2, d3, d4, d5, d7 - d5, d6, d8 - d6, d11, d12, floatPoint3);
            if (bl) {
                return true;
            }
            d5 = d7;
            d6 = d8;
        }
        return false;
    }

    public static boolean shapeContainsShape(Shape shape, Shape shape2) {
        int n = shape2.xCoords.length - 1;
        for (int i = 0; i < n; ++i) {
            if (!MapUtils.intersectShape(new FloatPoint(shape2.xCoords[i], shape2.xCoords[i]), new FloatPoint(shape2.xCoords[i + 1], shape2.xCoords[i + 1]), shape)) continue;
            return false;
        }
        return Shape.containsPoint(shape, shape2.xCoords[0], shape2.xCoords[0]);
    }

    static boolean intersectsLines(double d, double d2, double d3, double d4, FloatPoint floatPoint) {
        if (null != floatPoint) {
            if (d == d3) {
                floatPoint.x = 0.0;
                floatPoint.y = d2;
                return d2 == d4;
            }
            floatPoint.x = -(d2 - d4) / (d - d3);
            floatPoint.y = Double.POSITIVE_INFINITY == d ? d * floatPoint.x + d2 : d3 * floatPoint.x + d4;
            return true;
        }
        return false;
    }

    static boolean intersectPoint(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, FloatPoint floatPoint) {
        if (null != floatPoint) {
            floatPoint.x = d;
            floatPoint.y = d7 * floatPoint.x + d8;
            return 1.0E-5 >= Math.abs(d2 - floatPoint.y) && (0.0 != d4 ? 1.0 >= Math.abs(2.0 * (floatPoint.x - d3) / d4 - 1.0) : 1.0 >= Math.abs(2.0 * (floatPoint.y - d5) / d6 - 1.0));
        }
        return false;
    }

    static boolean intersectsSegments(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, FloatPoint floatPoint) {
        return null != floatPoint ? MapUtils.intersectsLines(d5, d6, d11, d12, floatPoint) && (0.0 != d2 ? 1.0 >= Math.abs(2.0 * (floatPoint.x - d) / d2 - 1.0) : 1.0 >= Math.abs(2.0 * (floatPoint.y - d3) / d4 - 1.0)) && (0.0 != d8 ? 1.0 >= Math.abs(2.0 * (floatPoint.x - d7) / d8 - 1.0) : 1.0 >= Math.abs(2.0 * (floatPoint.y - d9) / d10 - 1.0)) : false;
    }

    public static boolean intersectSegments(FloatPoint floatPoint, FloatPoint floatPoint2, FloatPoint floatPoint3, FloatPoint floatPoint4, FloatPoint floatPoint5) {
        double d = floatPoint2.x - floatPoint.x;
        double d2 = floatPoint2.y - floatPoint.y;
        double d3 = floatPoint4.x - floatPoint3.x;
        double d4 = floatPoint4.y - floatPoint3.y;
        double d5 = d2 / d;
        double d6 = d4 / d3;
        return MapUtils.intersectsSegments(floatPoint.x, d, floatPoint.y, d2, d5, floatPoint.y - d5 * floatPoint.x, floatPoint3.x, d3, floatPoint3.y, d4, d6, floatPoint3.y - d6 * floatPoint3.x, floatPoint5);
    }

    public static Image makeColorTransparent(Image image, final Color color, int n) throws Exception {
        final int n2 = 255 - (n & 0xFF);
        RGBImageFilter rGBImageFilter = new RGBImageFilter(){
            public boolean changeColor;
            public int markerRGB;
            public int alphaSet;
            {
                this.changeColor = color != null;
                this.markerRGB = this.changeColor ? color.getRGB() | 0xFF000000 : 0;
                this.alphaSet = (n2 & 0xFF) << 24;
            }

            public final int filterRGB(int n, int n22, int n3) {
                if ((n3 & 0xFF000000) == 0) {
                    return n3;
                }
                if (this.changeColor && (n3 | 0xFF000000) == this.markerRGB) {
                    return 0xFFFFFF & n3;
                }
                return this.alphaSet + (0xFFFFFF & n3);
            }
        };
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), rGBImageFilter);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        return MapUtils.prepareImage(toolkit, toolkit.createImage(filteredImageSource));
    }

    public static String getPropAsString(Properties properties, char c) {
        if (properties == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            stringBuffer.append(string).append('=').append(properties.getProperty(string)).append(c);
        }
        return stringBuffer.toString().substring(0, stringBuffer.length() - 1);
    }

    protected static FloatPoint roundToSphere(double d, double d2, double d3) {
        double d4 = 0.95;
        double d5 = d * d + d2 * d2;
        while (d5 > d3 * d3) {
            d = d4 * d;
            d2 = d4 * d2;
            d5 = d * d + d2 * d2;
        }
        return new FloatPoint(d, d2);
    }

    static {
        try {
            defaultBoldFont = new Font("SansSerif", 1, 12);
            defaultPlainFont = new Font("SansSerif", 0, 11);
        }
        catch (Exception exception) {
            System.out.println("Headless environment !" + System.getProperty("java.awt.headless"));
        }
        images = new Hashtable();
        imgUrls = new Hashtable();
        zero = new Object();
        requestedImages = 0;
    }
}

