/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;
import org.alov.map.FloatRectangle;
import org.alov.map.MapUtils;
import org.alov.map.MetaElement;
import org.alov.util.AlovMapException;
import org.alov.util.Strings;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

public class Meta
extends Vector {
    public static final int MD_TITLE = 8;
    public static final int MD_AUTHOR = 41;
    public static final int MD_DESCRIPTION = 11;
    public static final int MD_RIGHTS = 24;
    public static final int MD_LAYER_TYPE = 34;
    public static final int MD_OBJECT_TYPE = 36;
    public static final int MD_TABLENAME = 43;
    public static final int MD_F_ID = 49;
    public static final int MD_F_FEATURE_ID = 50;
    public static final int MD_F_DESCRIPTION = 51;
    public static final int MD_F_DATE = 52;
    public static final int MD_F_DATE_LOW = 53;
    public static final int MD_F_DATE_HIGH = 54;
    public static final int MD_F_XMIN = 70;
    public static final int MD_F_XMAX = 71;
    public static final int MD_F_YMIN = 72;
    public static final int MD_F_YMAX = 73;
    public static final int MD_F_GEOBLOB = 74;
    public static final int MD_F_X = 75;
    public static final int MD_F_Y = 76;
    public static final int MD_F_LOAD = 80;
    public static final int MD_DEF_SYMBOLOGY = 125;
    public static final int MD_MAINLINK = 63;
    public static final int MD_SEARCHLINK = 301;
    public static final int MD_INFOLINK = 302;
    public static final int MD_TIPSLINK = 310;
    public static final int MD_LEGENDLINK = 320;
    public static final int MD_F_ALIASES_TM = 57;
    public static final int MD_F_ALIASES = 304;
    public static final int MD_DB_ENCODING = 305;
    public static final int MD_TABLENAME_XY = 306;
    public static final int MD_F_VISIBLE = 307;
    public static final int MD_F_VERTEXORDER = 308;
    public static final int MD_VIRTUAL_FIELD = 309;
    public static final int MD_IMAGEPATH = 310;
    public static final int MD_F_EDITABLE = 312;
    public static final int MD_GEOFORMAT = 313;
    public static final int MD_DATE_TYPE = 37;
    public static final int MD_XMIN = 4;
    public static final int MD_XMAX = 5;
    public static final int MD_YMIN = 6;
    public static final int MD_YMAX = 7;
    public static final int MD_THUMBNAIL_FILE = 119;
    public static final int MD_DOC_FILE = 120;
    public static final int MD_SAMPLE_FILE = 121;
    public static final int MD_SYSTEMID = 133;
    public static final int MD_SYSTEREGDATE = 127;
    public static final int MD_IMAGEFILE = 123;
    public static final int MD_IMAGE_SCRN_X = 138;
    public static final int MD_IMAGE_SCRN_Y = 139;
    public static final int MD_IMAGE_X = 142;
    public static final int MD_IMAGE_Y = 143;
    public static final int MD_IMAGE_SX = 144;
    public static final int MD_IMAGE_SY = 145;
    public static final int MD_IMAGE_WIDTH = 146;
    public static final int MD_IMAGE_HEIGHT = 147;
    public static final int MD_MAX_RESOLUTION_LEVEL = 148;
    public static final int MD_BASE_SQL_FILTER = 149;
    public static final int MD_SQL_FILTER = 150;
    public static final int MD_SRS = 162;
    public static final int MD_WMS_LAYERS = 166;
    public static final int MD_WMS_STYLES = 167;
    public static final int MD_WMS_EXTRA = 311;
    public static final int MD_SRV_DRIVER = 168;
    public static final int MD_SRV_HOST = 169;
    public static final int MD_SRV_DATABASE = 170;
    public static final int MD_SRV_PATH = 171;
    public static final int MD_SRV_URL = 172;
    public static final int MD_SRV_PORT = 173;
    public static final int MD_SRV_USER = 174;
    public static final int MD_SRV_PASS = 175;
    public static final int MD_SRV_SCRIPT = 176;
    public static final int MD_SRV_VERSION = 177;
    public static final int MD_SRV_FORMAT = 178;
    public static final int MD_SRV_OPSYS = 179;
    public static final int MD_SRV_SID_CLIENT = 180;
    public static final int MD_SRV_SID_IMAGE = 181;
    public static final int MD_AUTH_PASSWORD = 303;
    public static final int MD_CITY = 315;
    public static final int MD_CITY_LAYER = 316;
    public static final int MD_FILTER_REQUIRED = 317;
    public static final int MD_GEOCODING_TYPE = 318;
    public static final int MD_GEOCODING_FLDS = 319;
    public boolean isNotLoaded = true;
    boolean isLoaded = false;
    public boolean forceEmptyLoad = false;
    public boolean forceLoad = false;
    public int reloadTimeRange = 0;
    public boolean forceClearCache = false;
    public boolean loadFailed = false;
    public boolean networkActivity = false;
    boolean passResolved = true;
    public boolean passFirstTime = true;
    public boolean loadOnSearchRequestOnly = true;
    public FloatRectangle maxExtent = new FloatRectangle();
    public int memsize = 0;
    public int cachesize = 0;

    public String getVal(int n) {
        return this.getVal(n, MapUtils.language);
    }

    public String getVal(int n, String string) {
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            MetaElement metaElement = (MetaElement)this.elementAt(i);
            if (metaElement.id != n || metaElement.lang != null && !metaElement.lang.equalsIgnoreCase(string)) continue;
            return metaElement.value;
        }
        return null;
    }

    public double getDouble(int n) {
        return MapUtils.toDouble(this.getVal(n, MapUtils.language));
    }

    public void delElement(int n) {
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            if (((MetaElement)this.elementAt((int)i)).id != n) continue;
            this.removeElementAt(i);
            break;
        }
    }

    public void replace(int n, String string) {
        this.delElement(n);
        this.put(n, string);
    }

    public String getHtmlStr(int n) {
        String string = this.getVal(n, null);
        if (string == null) {
            return "";
        }
        string = Strings.setObj(string, '&', "&amp;");
        string = Strings.setObj(string, '<', "&lt;");
        return Strings.setObj(string, '>', "&gt;");
    }

    public String getStr(int n) {
        String string = this.getVal(n, null);
        return string == null ? "" : string;
    }

    public Vector getList(int n) {
        int n2 = this.size();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < n2; ++i) {
            if (((MetaElement)this.elementAt((int)i)).id != n) continue;
            vector.addElement(((MetaElement)this.elementAt((int)i)).value);
        }
        return vector;
    }

    void put_(int n, int n2, String string, String string2, String string3) {
        if (string2 != null) {
            MetaElement metaElement = new MetaElement();
            metaElement.id = n;
            metaElement.scheme = string;
            metaElement.scheme_id = n2;
            metaElement.value = string2.trim();
            metaElement.lang = string3;
            this.addElement(metaElement);
        }
    }

    public void put(int n, String string) {
        this.put_(n, 0, null, string, null);
    }

    public void loadWorldfile(InputStream inputStream) throws Exception {
        String string;
        this.delElement(144);
        this.delElement(145);
        this.delElement(142);
        this.delElement(143);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader, 2048);
        int n = 0;
        int n2 = 0;
        while ((string = bufferedReader.readLine()) != null) {
            ++n2;
            if (string.length() <= 0) continue;
            try {
                Double.valueOf(string).doubleValue();
            }
            catch (Exception exception) {
                throw new AlovMapException(301, "Content of line#" + n2 + ": '" + string + "' is inconsistent with ESRI Worldfile");
            }
            switch (n) {
                case 0: {
                    this.put(144, string);
                    break;
                }
                case 3: {
                    this.put(145, string);
                    break;
                }
                case 4: {
                    this.put(142, string);
                    break;
                }
                case 5: {
                    this.put(143, string);
                }
            }
            if (++n != 6) continue;
        }
        if (n < 6) {
            throw new AlovMapException(301, "Invalid Worldfile");
        }
        this.isNotLoaded = false;
    }

    public void loadMetadata(InputStream inputStream) throws Exception {
        XmlElement xmlElement = XmlUtils.parseStream(inputStream, "");
        this.loadMetadata(xmlElement);
    }

    public void loadMetadata(XmlElement xmlElement) {
        this.removeAllElements();
        Vector vector = xmlElement.getElementsByTagName("meta");
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            XmlElement xmlElement2 = (XmlElement)vector.elementAt(i);
            int n2 = XmlUtils.getInt("id", xmlElement2, 0);
            if (n2 == 0) {
                n2 = XmlUtils.getInt("tmcode", xmlElement2, 0);
            }
            String string = XmlUtils.getString("content", xmlElement2, "");
            String string2 = xmlElement2.getAttributeValue("xml:lang");
            this.put_(n2, XmlUtils.getInt("schemecode", xmlElement2, 0), XmlUtils.getString("scheme", xmlElement2, null), string, string2);
        }
        this.isNotLoaded = this.size() == 0;
    }

    public String getFieldAlias(String string, String string2) {
        if (string2 != null) {
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                MetaElement metaElement = (MetaElement)this.elementAt(i);
                if (metaElement.id != 304 && metaElement.id != 57 || metaElement.lang != null && !string2.equalsIgnoreCase(metaElement.lang) || metaElement.value == null) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(metaElement.value, ",;", false);
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (!string3.toUpperCase().startsWith(string + '=')) continue;
                    return string3.substring(string3.indexOf("=") + 1);
                }
            }
        }
        return string;
    }

    public int getObjType() {
        return Meta.getObjType(this.getVal(36));
    }

    public static int getObjType(String string) {
        int n;
        if (string == null) {
            return 0;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = string.equalsIgnoreCase("point") ? 1 : (string.equalsIgnoreCase("line") ? 2 : (string.equalsIgnoreCase("polygon") ? 3 : (string.equalsIgnoreCase("BoundingBox") ? 4 : 0)));
        }
        return n;
    }

    public static int getSrvId(String string) {
        if (string == null) {
            return -1;
        }
        if (string.equalsIgnoreCase("odbc")) {
            return 0;
        }
        if (string.equalsIgnoreCase("mysql")) {
            return 1;
        }
        if (string.equalsIgnoreCase("interbase") || string.equalsIgnoreCase("intrbase")) {
            return 2;
        }
        if (string.equalsIgnoreCase("sybase")) {
            return 3;
        }
        if (string.equalsIgnoreCase("mssql") || string.equalsIgnoreCase("ms sql")) {
            return 4;
        }
        if (string.equalsIgnoreCase("oracle")) {
            return 5;
        }
        if (string.equalsIgnoreCase("informix")) {
            return 6;
        }
        if (string.equalsIgnoreCase("db2")) {
            return 7;
        }
        if (string.equalsIgnoreCase("shapefile")) {
            return 8;
        }
        if (string.equalsIgnoreCase("imagefile") || string.equalsIgnoreCase("localfile")) {
            return 9;
        }
        if (string.equalsIgnoreCase("mrsid")) {
            return 11;
        }
        if (string.equalsIgnoreCase("mrsides")) {
            return 34;
        }
        if (string.equalsIgnoreCase("ogcwms")) {
            return 15;
        }
        if (string.equalsIgnoreCase("ogcwfs")) {
            return 35;
        }
        if (string.equalsIgnoreCase("mapspace_internal")) {
            return 19;
        }
        if (string.equalsIgnoreCase("mapspace")) {
            return 20;
        }
        if (string.equalsIgnoreCase("macnet")) {
            return 23;
        }
        if (string.equalsIgnoreCase("ms access")) {
            return 30;
        }
        if (string.equalsIgnoreCase("hypersonic")) {
            return 31;
        }
        if (string.equalsIgnoreCase("sapdb") || string.equalsIgnoreCase("sap db")) {
            return 32;
        }
        if (string.equalsIgnoreCase("postgresql")) {
            return 33;
        }
        return Strings.strToInt(string, -1);
    }
}

