/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.alov.map.FieldRef;
import org.alov.map.Layer;
import org.alov.map.Record;
import org.alov.map.ValueParser;

class ParsedExpression
implements Serializable {
    Vector expr;
    Hashtable fieldRefs;
    FieldRef[] cachedRefs;

    ParsedExpression() {
    }

    protected boolean isTrue(Record record) throws Exception {
        boolean bl = false;
        Object object = ValueParser.calculate(this.expr, record).getValue(record);
        if (null != object && object instanceof Boolean) {
            bl = (Boolean)object;
        }
        return bl;
    }

    protected void resolveFields(Layer layer) throws Exception {
        if (this.fieldRefs != null) {
            Enumeration enumeration = this.fieldRefs.elements();
            Vector<FieldRef> vector = new Vector<FieldRef>();
            while (enumeration.hasMoreElements()) {
                FieldRef fieldRef = (FieldRef)enumeration.nextElement();
                String string = fieldRef.fieldName;
                int n = layer.getFieldIndex(string);
                if (n < 0) {
                    throw new Exception("Field " + string + " not found in layer: " + layer.getName());
                }
                layer.getFieldDef((int)n).isUsedInFilterOrRenderer = true;
                fieldRef.fieldIndex = n;
                vector.addElement(fieldRef);
            }
            int n = vector.size();
            this.cachedRefs = new FieldRef[n];
            for (int i = 0; i < n; ++i) {
                this.cachedRefs[i] = (FieldRef)vector.elementAt(i);
            }
        } else {
            this.cachedRefs = new FieldRef[0];
        }
    }
}

