/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Color;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.LayerRaster;
import org.alov.map.LayerSetup;
import org.alov.map.LayerVector;
import org.alov.map.LayerZoomify;
import org.alov.map.Loader;
import org.alov.map.RadioGroup;
import org.alov.map.Record;
import org.alov.map.Renderer;
import org.alov.util.Const;
import org.alov.util.ExDate;
import org.alov.util.Strings;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

public class Project
implements Const,
Serializable {
    public String name;
    public String language = "en";
    public int MapUnits;
    public String geoProjection = null;
    public int ZoomUnits;
    public Vector layers = new Vector();
    public Vector radioGroups = new Vector();
    public Hashtable domains = new Hashtable();
    public Hashtable themes = new Hashtable();
    public Hashtable themesLayer = new Hashtable();
    public String domainsNames = "";
    public String themesNames = "";
    public FloatRectangle maxExtent = null;
    protected boolean isAnimatedZoom = false;
    public String startExtentName = null;
    public String startTheme = null;
    public String startLayer = null;
    public double zmin;
    public double zmax;
    public Color mapBackground;
    public boolean moveBeyondProject = false;
    public boolean hasKeyMap = false;
    public Color keyMapOutline;
    public Color keyMapBackground;
    public String keyMapTheme = "unnamed";
    public String linkSearch = null;
    public String linkLegend = null;
    public String linkInfo = null;
    public String linkMain = null;
    public boolean isDynamic = true;
    public boolean isDynamic_LayerVisible = true;
    public boolean isDynamic_RemoveOutOfExtent = true;
    public int iDynamic_OrderOfLayers = 0;
    public boolean isDynamic_AddDialogue = false;
    public boolean isTimeMap = false;
    public boolean isDynamic_SearchAlways = true;
    public boolean isDynamic_AcceptAll = false;
    public String sDynamoAdd = "";
    public boolean forceSearchForDynamic = false;
    public Vector dynamicLayers = null;
    public Vector renderers = new Vector();
    public int rendererDynamicCount = 0;
    public int animationDelay = 1000;
    boolean isLoaded = false;
    boolean isCompactStorage = false;
    public boolean isTimeEnabled = false;
    public ExDate startDate;
    public ExDate endDate;

    public String getWebLink(Layer layer, Record record) {
        return layer.getWebLink(layer.linkMain != null ? layer.linkMain : this.linkMain, record, null, null, null);
    }

    public void sortRenderersByLevels() {
        int n;
        Serializable serializable;
        int n2;
        int n3;
        Integer[] integerArray;
        Hashtable<Integer, Vector<Renderer>> hashtable = new Hashtable<Integer, Vector<Renderer>>();
        Vector<Renderer> vector = new Vector<Renderer>();
        int n4 = this.getLayerCount();
        for (int i = 0; i < n4; ++i) {
            Layer layer = (Layer)this.layers.elementAt(i);
            integerArray = layer.renderers;
            n3 = integerArray.size();
            for (n2 = 0; n2 < n3; ++n2) {
                serializable = (Renderer)integerArray.elementAt(n2);
                if (serializable.isDynamic()) {
                    vector.addElement((Renderer)serializable);
                    continue;
                }
                Integer n5 = new Integer(serializable.getLevel());
                Vector<Renderer> vector2 = (Vector<Renderer>)hashtable.get(n5);
                if (vector2 == null) {
                    vector2 = new Vector<Renderer>();
                    hashtable.put(n5, vector2);
                }
                vector2.addElement((Renderer)serializable);
            }
        }
        Enumeration enumeration = hashtable.keys();
        int n6 = 0;
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            ++n6;
        }
        integerArray = new Integer[n6];
        enumeration = hashtable.keys();
        for (n3 = 0; n3 < n6; ++n3) {
            integerArray[n3] = (Integer)enumeration.nextElement();
        }
        n3 = 0;
        while (n3 == 0) {
            n3 = 1;
            for (n2 = 0; n2 < n6 - 1; ++n2) {
                if (integerArray[n2] <= integerArray[n2 + 1]) continue;
                serializable = integerArray[n2];
                integerArray[n2] = integerArray[n2 + 1];
                integerArray[n2 + 1] = serializable;
                n3 = 0;
            }
        }
        n2 = this.renderers.size();
        for (n = 0; n < n2; ++n) {
            ((Vector)this.renderers.elementAt(n)).removeAllElements();
        }
        this.renderers.removeAllElements();
        for (n = 0; n < n6; ++n) {
            this.renderers.addElement(hashtable.get(integerArray[n]));
        }
        if (vector.size() > 0) {
            this.renderers.addElement(vector);
            this.rendererDynamicCount = 1;
        }
    }

    public int getLayerCount() {
        return this.layers == null ? 0 : this.layers.size();
    }

    public Layer getLayerById(String string) {
        int n = this.getLayerCount();
        for (int i = 0; i < n; ++i) {
            Layer layer = (Layer)this.layers.elementAt(i);
            if (!layer.id.equals(string)) continue;
            return layer;
        }
        return null;
    }

    public Layer getLayerByDsId(String string) {
        if (!Strings.isNullOrBlank(string)) {
            int n = this.getLayerCount();
            for (int i = 0; i < n; ++i) {
                Layer layer = (Layer)this.layers.elementAt(i);
                if (!layer.datasetId.equals(string)) continue;
                return layer;
            }
        }
        return null;
    }

    public Layer getLayerByName(String string) {
        int n = this.getLayerCount();
        if (string != null) {
            for (int i = 0; i < n; ++i) {
                Layer layer = (Layer)this.layers.elementAt(i);
                if (!string.equalsIgnoreCase(layer.getName())) continue;
                return layer;
            }
        }
        return null;
    }

    public Layer getLayerByIndex(int n) {
        return (Layer)this.layers.elementAt(n);
    }

    public RadioGroup getRadioGroupByName(String string) {
        if (string != null) {
            int n = this.radioGroups.size();
            for (int i = 0; i < n; ++i) {
                RadioGroup radioGroup = (RadioGroup)this.radioGroups.elementAt(i);
                if (!string.equalsIgnoreCase(radioGroup.name)) continue;
                return radioGroup;
            }
        }
        return null;
    }

    public XmlElement load(InputStream inputStream, LayerSetup layerSetup) throws Exception {
        XmlElement xmlElement = XmlUtils.parseStream(inputStream, "");
        Loader.parseProject(this, xmlElement, layerSetup);
        int n = this.getLayerCount();
        for (int i = 0; i < n; ++i) {
            Layer layer = this.getLayerByIndex(i);
            layer.setDepend(this);
        }
        layerSetup.addStatusInfo(0, null, "end parse " + n);
        this.isLoaded = true;
        return xmlElement;
    }

    public void kill() {
        this.isLoaded = false;
        int n = this.layers.size();
        for (int i = 0; i < n; ++i) {
            Layer layer = this.getLayerByIndex(i);
            layer.clear(true);
            layer = null;
        }
        this.renderers.removeAllElements();
        this.layers.removeAllElements();
        this.layers = null;
        this.domains = null;
        this.themes = null;
        this.themesLayer = null;
    }

    void clearSameLayers(Layer layer) {
        layer.clear(false);
        int n = this.getLayerCount();
        for (int i = 0; i < n; ++i) {
            Layer layer2 = this.getLayerByIndex(i);
            if (!layer2.datasetId.equals(layer.datasetId) || layer2.id.equals(layer.id)) continue;
            layer2.clear(false);
        }
    }

    public void setSameLayers(Layer layer, LayerSetup layerSetup) {
        block14: {
            block13: {
                String string = layer.getClass().getName();
                if (!(layer instanceof LayerVector)) break block13;
                int n = this.getLayerCount();
                for (int i = 0; i < n; ++i) {
                    Layer layer2 = this.getLayerByIndex(i);
                    if (!layer2.datasetId.equals(layer.datasetId) || !string.equals(layer2.getClass().getName()) || layer2.id.equals(layer.id)) continue;
                    LayerVector layerVector = (LayerVector)layer;
                    LayerVector layerVector2 = (LayerVector)layer2;
                    layerVector2.fi_description = layerVector.fi_description;
                    layerVector2.fi_id = layerVector.fi_id;
                    layerVector2.dateType = layerVector.dateType;
                    layerVector2.f_dateLow = layerVector.f_dateLow;
                    layerVector2.f_dateHigh = layerVector.f_dateHigh;
                    if (layer instanceof LayerZoomify && layer2 instanceof LayerZoomify) {
                        LayerZoomify layerZoomify = (LayerZoomify)layerVector;
                        ((LayerZoomify)layerVector2).setDimensions(layerZoomify.geoWidth, layerZoomify.geoHeight, layerZoomify.imageWidth, layerZoomify.imageHeight, layerZoomify.tileSize, layerZoomify.levelCount);
                    }
                    try {
                        layer2.prepareLayer();
                        continue;
                    }
                    catch (Exception exception) {
                        layer2.metadata.loadFailed = true;
                        layerSetup.addStatusInfo(0, layer2, exception.getMessage());
                    }
                }
                break block14;
            }
            if (!(layer instanceof LayerRaster)) break block14;
            int n = this.getLayerCount();
            for (int i = 0; i < n; ++i) {
                Layer layer3 = this.getLayerByIndex(i);
                if (!layer3.datasetId.equals(layer.datasetId) || layer3.id.equals(layer.id)) continue;
                LayerRaster layerRaster = (LayerRaster)layer;
                LayerRaster layerRaster2 = (LayerRaster)layer3;
                if (layerRaster.resolutionLevel > 0 || layerRaster2.resolutionLevel > 0) continue;
                if (layerRaster2.linkMain == null) {
                    layerRaster2.linkMain = layerRaster.linkMain;
                }
                if (layerRaster2.linkSearch == null) {
                    layerRaster2.linkSearch = layerRaster.linkSearch;
                }
                if (layerRaster2.linkTips == null) {
                    layerRaster2.linkTips = layerRaster.linkTips;
                }
                if (layerRaster.getImageSrc() != null) {
                    layerRaster2.setImage(layerRaster.getImageSrc());
                } else {
                    layerRaster2.setRaster(layerRaster.getImage());
                }
                if (!layerRaster.isDataOnServer || layerRaster2.notPrepared) {
                    try {
                        layer3.prepareLayer();
                    }
                    catch (Exception exception) {
                        layer3.metadata.loadFailed = true;
                        layerSetup.addStatusInfo(0, layer3, exception.getMessage());
                    }
                }
                layerRaster2.layerExtent = layerRaster.layerExtent;
            }
        }
    }

    public void saveToRawFile(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.close();
            gZIPOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Project loadFromRawFile(InputStream inputStream) throws IOException, ClassNotFoundException {
        GZIPInputStream gZIPInputStream = new GZIPInputStream(inputStream);
        ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
        Project project = (Project)objectInputStream.readObject();
        gZIPInputStream.close();
        return project;
    }
}

