/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.alov.data.DataProviderFile;
import org.alov.map.Carte;
import org.alov.map.ComplexFigure;
import org.alov.map.DataStorageCompact;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.LayerRaster;
import org.alov.map.LayerVector;
import org.alov.map.LayerZoomify;
import org.alov.map.MapUtils;
import org.alov.map.Project;
import org.alov.map.ProxyLocal;
import org.alov.map.ProxyRequest;
import org.alov.map.Record;
import org.alov.map.RecordsArray;
import org.alov.map.StreamCounter;
import org.alov.util.AlovMapException;
import org.alov.util.Readers;
import org.alov.util.Strings;

public class ProxyServer
extends ProxyLocal {
    public String servletURL = "";
    private String maxsidkb = "";
    private String additionalParams = "";
    private String lastQueryProjStr = "";
    private static final int version = 20060708;
    private int requestNo = 0;
    private boolean bHandshake = false;
    private FloatRectangle previousRect = null;

    void setProjectURLServer() {
        this.projectURL = this.servletURL + '?' + "pid" + '=' + this.projectId + '&' + "rq" + '=' + "GetProject";
    }

    void processGeoResponse(ProxyLocal.GeoReqParams geoReqParams) throws Exception {
        if (this.sessionUser != 0 && this.sessionMagic != 0) {
            geoReqParams.getReq.append("&id=").append(this.sessionUser).append("&m=").append(this.sessionMagic);
        }
        if (!Strings.isNullOrBlank(this.maxsidkb) && geoReqParams.hasImage) {
            geoReqParams.getReq.append('&').append("maxsidsize").append('=').append(this.maxsidkb);
        }
        this.map.broadcastMessage(10, "");
        geoReqParams.url = new URL(geoReqParams.getReq.toString());
        this.map.broadcastMessage(0, "");
        try {
            geoReqParams.input = geoReqParams.url.openStream();
            if (geoReqParams.input == null) {
                throw new AlovMapException(202, "Server busy or inaccessible");
            }
            geoReqParams.counter = new StreamCounter(geoReqParams.input, 1024, null);
        }
        catch (Exception exception) {
            this.bHandshake = false;
            this.addStatusInfo(202, null, exception.getMessage());
            this.map.broadcastMessage(-6, "");
            throw exception;
        }
        geoReqParams.errorCode = Readers.readInt(geoReqParams.counter);
        if (geoReqParams.errorCode == 0) {
            int n;
            Layer layer;
            int n2;
            String string;
            int n3 = Readers.readInt(geoReqParams.counter);
            geoReqParams.counter.setCounter(n3, "");
            ZipInputStream zipInputStream = new ZipInputStream(geoReqParams.counter);
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            StreamCounter streamCounter = new StreamCounter(zipInputStream, 1024, this.map);
            DataInputStream dataInputStream = new DataInputStream(streamCounter);
            int n4 = dataInputStream.readInt();
            if (n4 != 20060708) {
                this.map.broadcastMessage(-9, "");
                this.addStatusInfo(206, null, "Versions mismatch: server - " + n4 + " client - " + 20060708);
                return;
            }
            this.sessionUser = dataInputStream.readInt();
            this.sessionMagic = dataInputStream.readInt();
            this.bHandshake = false;
            geoReqParams.layerCount = dataInputStream.readInt();
            boolean bl = dataInputStream.readBoolean();
            if (bl) {
                String string2 = string = dataInputStream.readUTF();
                for (n2 = 0; n2 < geoReqParams.layerCount; ++n2) {
                    geoReqParams.errorCode = Readers.readInt(dataInputStream);
                    layer = geoReqParams.project.getLayerByDsId(string);
                    if (layer != null) {
                        if (geoReqParams.errorCode != 0) {
                            if (geoReqParams.errorCode == 221) {
                                layer.metadata.passResolved = false;
                                layer.metadata.delElement(303);
                            } else {
                                layer.metadata.loadFailed = true;
                                this.map.broadcastMessage(-8, layer.getName());
                            }
                            this.addStatusInfo(geoReqParams.errorCode, layer, dataInputStream.readUTF());
                        } else {
                            String string3 = dataInputStream.readUTF();
                            if (!Strings.isNullOrBlank(string3)) {
                                this.addStatusInfo(0, layer, "WARNING#" + string3);
                            }
                            n = dataInputStream.readBoolean();
                            string3 = layer instanceof LayerVector && n == 0 ? "Layer defined as vector but it is raster in fact" : (layer instanceof LayerRaster && n != 0 ? "Layer defined as raster but it is vector in fact" : null);
                            if (string3 != null) {
                                layer.metadata.loadFailed = true;
                                this.map.broadcastMessage(-8, layer.getName());
                                this.addStatusInfo(205, layer, string3);
                                return;
                            }
                            try {
                                layer.readMetadata_(dataInputStream);
                                layer.metadata.forceEmptyLoad = false;
                                layer.metadata.forceLoad = false;
                                geoReqParams.project.setSameLayers(layer, this);
                                geoReqParams.project.sortRenderersByLevels();
                            }
                            catch (Exception exception) {
                                layer.metadata.loadFailed = true;
                                this.map.broadcastMessage(-8, layer.getName());
                                this.addStatusInfo(0, layer, "Can't read metadata. " + exception.getMessage());
                            }
                        }
                    } else {
                        this.addStatusInfo(205, null, string);
                    }
                    string = dataInputStream.readUTF();
                    if (string.equals(string2)) break;
                }
            }
            for (n2 = 0; n2 < geoReqParams.layerCount; ++n2) {
                string = dataInputStream.readUTF();
                geoReqParams.errorCode = Readers.readInt(dataInputStream);
                layer = geoReqParams.project.getLayerByDsId(string);
                if (layer != null) {
                    if (geoReqParams.errorCode != 0) {
                        layer.metadata.networkActivity = false;
                        boolean bl2 = layer.metadata.loadFailed = geoReqParams.errorCode == 205;
                        if (geoReqParams.errorCode == 221) {
                            this.map.broadcastMessage(11, "");
                        } else {
                            this.map.broadcastMessage(-8, layer.getName());
                        }
                        this.addStatusInfo(geoReqParams.errorCode, layer, dataInputStream.readUTF());
                        continue;
                    }
                    n3 = Readers.readInt(dataInputStream);
                    streamCounter.setCounter(n3, "[ " + layer.getName() + ']');
                    if (n3 > 0) {
                        this.map.broadcastMessage(2, layer.getName());
                        try {
                            this.receiveData(dataInputStream, layer, n3);
                            if (layer.serverType != 23 && layer instanceof LayerVector) {
                                int n5 = geoReqParams.project.getLayerCount();
                                for (n = 0; n < n5; ++n) {
                                    Layer layer2 = geoReqParams.project.getLayerByIndex(n);
                                    if (!layer2.datasetId.equals(layer.datasetId) || geoReqParams.rect == null) continue;
                                    layer2.loadedExtent.combineRect(geoReqParams.rect);
                                }
                            }
                            if (layer instanceof LayerZoomify && layer.isLoadComplete()) {
                                ((LayerZoomify)layer).loadZoomifyImages(geoReqParams.rect);
                            }
                        }
                        catch (Exception exception) {
                            layer.metadata.loadFailed = true;
                            this.map.broadcastMessage(-8, layer.getName());
                            this.addStatusInfo(0, layer, exception.getMessage());
                        }
                    }
                    layer.metadata.forceClearCache = false;
                    layer.metadata.networkActivity = false;
                    this.map.broadcastMessage(11, "");
                    continue;
                }
                this.addStatusInfo(205, null, string);
            }
            n3 = (int)streamCounter.getReceived();
            dataInputStream.close();
            streamCounter.close();
            geoReqParams.counter.close();
            this.map.broadcastMessage(14, "");
        } else if (geoReqParams.errorCode == 215) {
            this.addStatusInfo(215, null, "Server busy");
            geoReqParams.counter.close();
            this.map.broadcastMessage(-7, "");
        } else if (geoReqParams.errorCode == 222) {
            this.bHandshake = false;
            this.restoreSession(geoReqParams);
        } else {
            DataInputStream dataInputStream = new DataInputStream(geoReqParams.counter);
            this.addStatusInfo(geoReqParams.errorCode, null, dataInputStream.readUTF());
            dataInputStream.close();
            geoReqParams.counter.close();
            this.map.broadcastMessage(-5, "");
        }
    }

    private int restoreSession(ProxyLocal.GeoReqParams geoReqParams) throws Exception {
        this.sessionUser = 0;
        this.sessionMagic = 0;
        Project project = this.map.getProject();
        int n = project.getLayerCount();
        for (int i = 0; i < n; ++i) {
            Layer layer = project.getLayerByIndex(i);
            layer.metadata.memsize = 0;
            layer.clear(false);
        }
        this.map.extentChanged();
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    int processGeoRequest(ProxyLocal.GeoReqParams geoReqParams) throws Exception {
        Object object;
        int n2;
        if (this.sessionUser == 0 && this.sessionMagic == 0 && this.bHandshake) {
            return -1;
        }
        if (geoReqParams.project.isDynamic && (geoReqParams.project.forceSearchForDynamic || !geoReqParams.rect.equals(this.previousRect) && geoReqParams.project.isDynamic_SearchAlways)) {
            geoReqParams.project.forceSearchForDynamic = false;
            int n3 = geoReqParams.project.getLayerCount();
            n2 = 0;
            while (n2 < n3) {
                object = geoReqParams.project.getLayerByIndex(n2);
                if (((Layer)object).removeOutOfExtent && (((Layer)object).isOutOfRange(this.map) != 0 || ((Layer)object).isOutOfExtent(this.map))) {
                    geoReqParams.project.layers.removeElementAt(n2);
                    this.addStatusInfo(0, (Layer)object, "Removed");
                    this.map.broadcastMessage(116, null);
                    geoReqParams.lyrList = geoReqParams.lyrList + ((Layer)object).datasetId + ',';
                    ((Layer)object).clear(true);
                    object = null;
                    --n3;
                    continue;
                }
                ++n2;
            }
            this.bHandshake = true;
            geoReqParams.getReq.append(this.servletURL).append('?').append("rq").append('=').append("GetDs").append('&').append("bbox").append('=').append(geoReqParams.rect.x).append(',').append(geoReqParams.rect.y).append(',').append(geoReqParams.rect.x2).append(',').append(geoReqParams.rect.y2).append("&z=").append(this.map.getDistance(null));
            if (!Strings.isNullOrBlank(geoReqParams.lyrList)) {
                geoReqParams.lyrList = geoReqParams.lyrList.substring(0, geoReqParams.lyrList.length() - 1);
                geoReqParams.getReq.append('&').append("l").append('=').append(geoReqParams.lyrList);
                geoReqParams.lyrList = "";
            }
            if (geoReqParams.project.isDynamic_LayerVisible) {
                geoReqParams.getReq.append("&visible=ON");
            }
            if (this.sessionUser != 0 && this.sessionMagic != 0) {
                geoReqParams.getReq.append("&id=").append(this.sessionUser).append("&m=").append(this.sessionMagic);
            }
            if (geoReqParams.project.sDynamoAdd.length() > 0) {
                geoReqParams.getReq.append("&d=").append(geoReqParams.project.sDynamoAdd);
            }
            if (geoReqParams.project.isTimeMap) {
                geoReqParams.getReq.append("&tm=ON");
            }
            try {
                geoReqParams.input = new URL(geoReqParams.getReq.toString()).openStream();
                if (geoReqParams.input == null) {
                    throw new AlovMapException(202, "Server busy or inaccessible");
                }
            }
            catch (Exception exception) {
                this.bHandshake = false;
                this.addStatusInfo(202, null, exception.getMessage());
                this.map.broadcastMessage(-6, "");
                throw exception;
            }
            this.bHandshake = false;
            geoReqParams.errorCode = Readers.readInt(geoReqParams.input);
            if (geoReqParams.errorCode == 0) {
                object = new DataInputStream(geoReqParams.input);
                this.sessionUser = ((DataInputStream)object).readInt();
                this.sessionMagic = ((DataInputStream)object).readInt();
                try {
                    geoReqParams.project.load((InputStream)object, this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ((FilterInputStream)object).close();
                this.map.broadcastMessage(14, "");
                this.previousRect = new FloatRectangle(geoReqParams.rect);
                int n4 = geoReqParams.project.getLayerCount();
                if (geoReqParams.layerCount < n4) {
                    void var6_12;
                    boolean n = false;
                    while (var6_12 < n4) {
                        geoReqParams.project.getLayerByIndex((int)var6_12).setParentMap(this.map);
                        ++var6_12;
                    }
                    this.map.broadcastMessage(111, null);
                }
            } else if (geoReqParams.errorCode == 215) {
                this.addStatusInfo(215, null, "Server busy");
                this.map.broadcastMessage(-7, "");
            } else {
                object = new DataInputStream(geoReqParams.input);
                this.addStatusInfo(geoReqParams.errorCode, null, ((DataInputStream)object).readUTF());
                ((FilterInputStream)object).close();
                this.map.broadcastMessage(-5, "");
            }
        }
        geoReqParams.layerCount = geoReqParams.project.getLayerCount();
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < geoReqParams.layerCount; ++n2) {
            boolean bl;
            Object object2 = object = geoReqParams.req.layerId != null ? geoReqParams.project.getLayerById(geoReqParams.req.layerId) : geoReqParams.project.getLayerByIndex(n2);
            if (object == null) {
                geoReqParams.req.layerId = null;
                object = geoReqParams.project.getLayerByIndex(n2);
            }
            String string = ((Layer)object).metadata.getVal(303);
            boolean bl2 = ((Layer)object).isLoadComplete();
            boolean bl3 = ((Layer)object).isSomethingVisible(this.map) || ((Layer)object).metadata.forceLoad;
            ((Layer)object).metadata.forceEmptyLoad = ((Layer)object).metadata.forceEmptyLoad && !bl3;
            boolean bl4 = bl = (((Layer)object).isPassResolved() || Strings.isNullOrBlank(string)) && !((Layer)object).metadata.forceEmptyLoad && !bl3;
            if (object instanceof LayerZoomify && bl2 && bl3) {
                ((LayerZoomify)object).loadZoomifyImages(geoReqParams.rect);
            }
            if (this.map.loadedExtent != null && (bl2 || ((Layer)object).metadata.loadFailed || bl || ((Layer)object).isGeocoding)) {
                if (geoReqParams.req.layerId == null) continue;
                break;
            }
            if (!((Layer)object).isDataOnServer) {
                super.loadDirect(geoReqParams, (Layer)object);
            } else {
                ComplexFigure complexFigure = ((Layer)object).loadedExtent.rectSubtract(geoReqParams.rect);
                FloatRectangle floatRectangle = complexFigure.getExtent();
                if (geoReqParams.newRect == null) {
                    geoReqParams.newRect = floatRectangle;
                } else {
                    geoReqParams.newRect.union(floatRectangle);
                }
                if (floatRectangle != null && geoReqParams.lyrList.indexOf(((Layer)object).datasetId + ',') < 0) {
                    geoReqParams.lyrList = geoReqParams.lyrList + ((Layer)object).datasetId + ',';
                    if (!((Layer)object).isPassResolved() && !Strings.isNullOrBlank(string)) {
                        stringBuffer.append("&pwd_").append(((Layer)object).datasetId).append("=").append(URLEncoder.encode(string));
                        ((Layer)object).metadata.passResolved = true;
                    }
                    if (object instanceof LayerVector && !Strings.isNullOrBlank(((LayerVector)object).serverFilter)) {
                        stringBuffer.append("&flt_").append(((Layer)object).datasetId).append("=").append(URLEncoder.encode(((LayerVector)object).serverFilter));
                    }
                    if (((Layer)object).isFullLoad) {
                        geoReqParams.getMode = geoReqParams.getMode + '0';
                    } else if (((Layer)object).metadata.cachesize > 0 && ((Layer)object).metadata.memsize > ((Layer)object).metadata.cachesize || ((Layer)object).metadata.forceClearCache) {
                        geoReqParams.getMode = geoReqParams.getMode + '2';
                        ((Layer)object).metadata.forceClearCache = false;
                    } else {
                        geoReqParams.getMode = ((Layer)object).metadata.forceEmptyLoad || ((Layer)object).metadata.loadOnSearchRequestOnly ? geoReqParams.getMode + '3' : geoReqParams.getMode + '1';
                    }
                    geoReqParams.getMode = geoReqParams.getMode + ",";
                    ++geoReqParams.k;
                    ((Layer)object).metadata.networkActivity = true;
                    boolean bl5 = geoReqParams.hasImage = geoReqParams.hasImage || object instanceof LayerRaster;
                }
            }
            if (geoReqParams.req.layerId != null) break;
        }
        geoReqParams.layerCount = geoReqParams.k;
        if (geoReqParams.layerCount == 0 || this.sessionUser == 0 && this.sessionMagic == 0 && this.bHandshake) {
            return -1;
        }
        this.bHandshake = true;
        geoReqParams.lyrList = geoReqParams.lyrList.substring(0, geoReqParams.lyrList.length() - 1);
        geoReqParams.getMode = geoReqParams.getMode.substring(0, geoReqParams.getMode.length() - 1);
        geoReqParams.getReq.setLength(0);
        geoReqParams.getReq.append(this.servletURL).append('?').append("rq").append('=').append("GetMap").append('&').append("bbox").append('=').append(geoReqParams.newRect.x).append(',').append(geoReqParams.newRect.y).append(',').append(geoReqParams.newRect.x2).append(',').append(geoReqParams.newRect.y2).append('&').append("l").append('=').append(geoReqParams.lyrList).append('&').append("gm").append('=').append(geoReqParams.getMode).append(Strings.isNullOrBlank(this.additionalParams) ? "" : '&' + this.additionalParams);
        geoReqParams.getReq.append(stringBuffer.toString());
        if (geoReqParams.project.geoProjection != null) {
            String string = URLEncoder.encode(geoReqParams.project.geoProjection);
            if (this.lastQueryProjStr.equals(string)) {
                string = "sa";
            } else {
                this.lastQueryProjStr = string;
            }
            geoReqParams.getReq.append('&').append("projection").append('=').append(string);
        }
        return 0;
    }

    public void setupProxy(Carte carte) {
        this.servletURL = MapUtils.getRealPath(carte.getParameter("servlet", "mapserv"));
        this.additionalParams = carte.getParameter("external", "");
        super.setupProxy(carte);
        this.maxsidkb = carte.getParameter("maxsidsize", "");
    }

    void loadProjectServer(InputStream inputStream) throws Exception {
        if (inputStream == null) {
            throw new AlovMapException(202, "Server busy or inaccessible");
        }
        int n = Readers.readInt(inputStream);
        if (n == 215) {
            throw new AlovMapException(215, "Server busy");
        }
        if (n != 0) {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            throw new AlovMapException(n, dataInputStream.readUTF());
        }
    }

    int searchQuery(ProxyLocal.GeoReqParams geoReqParams) {
        Layer layer = geoReqParams.project.getLayerById(geoReqParams.req.layerId);
        if (layer != null && layer.isPassResolved()) {
            geoReqParams.getReq.append(this.servletURL).append('?').append("rq").append('=').append("GetMap").append('&').append("q").append('=').append(URLEncoder.encode(geoReqParams.req.query)).append(Strings.isNullOrBlank(this.additionalParams) ? "" : '&' + this.additionalParams).append('&').append("l").append('=');
            if (layer.isGeocoding) {
                layer.clear(false);
                geoReqParams.getReq.append(layer.datasetId.substring(7)).append('&').append("t").append('=').append("geocode").append('&').append("gm").append("=0");
            } else {
                geoReqParams.getReq.append(layer.datasetId);
                if (geoReqParams.req.type == 34 || geoReqParams.req.type == 35) {
                    geoReqParams.getReq.append('&').append("t").append("=query");
                } else if (geoReqParams.req.type <= 32 && geoReqParams.req.type < 32) {
                    geoReqParams.getReq.append('&').append("t").append("=id");
                }
                geoReqParams.getReq.append('&').append("gm").append('=');
                if (layer.isFullLoad || geoReqParams.req.type == 34) {
                    geoReqParams.getReq.append('0');
                } else if (layer.metadata.cachesize > 0 && layer.metadata.memsize > layer.metadata.cachesize || layer.metadata.forceClearCache) {
                    geoReqParams.getReq.append('2');
                    layer.metadata.forceClearCache = false;
                } else if (layer.metadata.forceEmptyLoad || layer.metadata.loadOnSearchRequestOnly) {
                    geoReqParams.getReq.append('3');
                } else {
                    geoReqParams.getReq.append('1');
                }
            }
        } else {
            return -1;
        }
        geoReqParams.k = 1;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveData(DataInputStream dataInputStream, Layer layer, int n) throws Exception {
        Project project = this.map.getProject();
        if (layer instanceof LayerRaster) {
            LayerRaster layerRaster = (LayerRaster)layer;
            int n2 = Readers.readInt(dataInputStream);
            if (layerRaster.imgWidth <= 0) {
                layerRaster.imgWidth = n2;
            }
            int n3 = Readers.readInt(dataInputStream);
            if (layerRaster.imgHeight <= 0) {
                layerRaster.imgHeight = n3;
            }
            double d = dataInputStream.readDouble();
            double d2 = dataInputStream.readDouble();
            double d3 = dataInputStream.readDouble();
            double d4 = dataInputStream.readDouble();
            int n4 = dataInputStream.read();
            layer.setLoadComplete(n4 != 0);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n - 32);
            try {
                int n5 = n - 32;
                for (int i = 0; i < n5; ++i) {
                    byteArrayOutputStream.write(dataInputStream.read());
                }
                layerRaster.setImage(byteArrayOutputStream.toByteArray());
            }
            finally {
                byteArrayOutputStream.close();
            }
            layerRaster.setLayerExtent(new FloatRectangle(d, d2, d3, d4));
            project.setSameLayers(layer, this);
            this.addStatusInfo(0, layer, "Download image. " + (n - 32) + " bytes" + (layer.isLoadComplete() ? ". COMPLETE" : ""));
            FloatRectangle floatRectangle = layer.getLayerExtent();
            this.map.addExtent(floatRectangle);
            if (this.map.getLastExtent().intersects(floatRectangle)) {
                this.map.updateMap();
            }
        } else {
            int n6 = Readers.readInt(dataInputStream);
            if (n6 < 0 && layer instanceof LayerZoomify) {
                String string = dataInputStream.readUTF();
                DataProviderFile dataProviderFile = (DataProviderFile)((LayerZoomify)layer).provider;
                dataProviderFile.loadZoomify(string);
                this.addStatusInfo(0, layer, "Download Zoomify image config " + string);
                project.setSameLayers(layer, this);
                FloatRectangle floatRectangle = layer.getLayerExtent();
                this.map.addExtent(floatRectangle);
                if (this.map.getLastExtent().intersects(floatRectangle)) {
                    this.map.updateMap();
                }
            } else {
                if (layer.serverType == 23 || layer.metadata.cachesize > 0 && layer.metadata.memsize > layer.metadata.cachesize) {
                    project.clearSameLayers(layer);
                }
                boolean bl = "1".equals(layer.metadata.getVal(313));
                String string = "";
                boolean bl2 = true;
                int n7 = 0;
                int n8 = 0;
                DataStorageCompact dataStorageCompact = new DataStorageCompact();
                dataStorageCompact.fieldOriginalCount = layer.dataStorage.fieldOriginalCount;
                dataStorageCompact.assignFields(layer.dataStorage.getFields());
                try {
                    dataStorageCompact.openDataStorageSave(true);
                    for (int i = 0; i < n6; ++i) {
                        String string2 = dataInputStream.readUTF();
                        if (bl2 && string2.equals(string)) {
                            bl2 = false;
                            this.addStatusInfo(0, layer, "WARNING#115");
                        }
                        string = string2;
                        Record record = layer.newRecord(-1);
                        try {
                            n8 = Record.readFromStream(record, dataInputStream, true, bl);
                            if (layer.isObjectType(-1)) {
                                layer.dataStorage.setObjectType(n8);
                                project.setSameLayers(layer, this);
                            }
                        }
                        catch (Exception exception) {
                            throw new Exception("Data packet contains damaged data. Can't read geo data \n Record id=" + string2 + "    " + exception.getMessage());
                        }
                        block20: for (int j = 0; j < layer.dataStorage.fieldOriginalCount; ++j) {
                            int n9 = 0;
                            switch (layer.getFieldDef((int)j).type) {
                                case -7: 
                                case -6: {
                                    record.setField(j, new Byte(dataInputStream.readByte()));
                                    n9 = 1;
                                    continue block20;
                                }
                                case 5: {
                                    record.setField(j, new Short(dataInputStream.readShort()));
                                    n9 = 2;
                                    continue block20;
                                }
                                case 4: {
                                    record.setField(j, new Integer(dataInputStream.readInt()));
                                    n9 = 4;
                                    continue block20;
                                }
                                case -5: {
                                    record.setField(j, new Long(dataInputStream.readLong()));
                                    n9 = 8;
                                    continue block20;
                                }
                                case 2: 
                                case 3: 
                                case 6: 
                                case 7: {
                                    record.setField(j, new Float(dataInputStream.readFloat()));
                                    n9 = 4;
                                    continue block20;
                                }
                                case 8: {
                                    record.setField(j, new Double(dataInputStream.readDouble()));
                                    n9 = 8;
                                    continue block20;
                                }
                                case -1: 
                                case 1: 
                                case 12: {
                                    String string3 = new String(dataInputStream.readUTF());
                                    n9 = string3.length();
                                    record.setField(j, string3);
                                    continue block20;
                                }
                                case 91: 
                                case 92: 
                                case 93: {
                                    record.setField(j, new Date(dataInputStream.readLong()));
                                    n9 = 8;
                                    continue block20;
                                }
                                default: {
                                    record.setField(j, "");
                                }
                            }
                        }
                        layer.addRecord(record);
                        ++n7;
                    }
                }
                finally {
                    dataStorageCompact.closeDataStorageSave();
                }
                dataInputStream.readUTF();
                layer.setLoadComplete(dataInputStream.read() != 0);
                if (n7 > 0) {
                    layer.dataStorage.unionStorages(dataStorageCompact);
                    FloatRectangle floatRectangle = layer.getLayerExtent();
                    this.map.addExtent(floatRectangle);
                    if (this.map.getLastExtent().intersects(floatRectangle)) {
                        this.map.updateMap();
                    }
                }
                layer.metadata.memsize += n;
                this.addStatusInfo(0, layer, "Download " + n7 + '/' + n6 + " records. " + n + " bytes" + (layer.isLoadComplete() ? ". COMPLETE" : ""));
            }
        }
    }

    static String getParam(String string, String string2, String string3) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                int n = string4.indexOf(61);
                if (n <= 0 || n >= string4.length() - 1 || !string4.substring(0, n).equalsIgnoreCase(string2)) continue;
                return string4.substring(n + 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string3;
    }

    private void doAttribRequest(ProxyRequest proxyRequest) throws Exception {
        LayerVector layerVector;
        String string;
        if (proxyRequest.layerId == null) {
            return;
        }
        Project project = this.map.getProject();
        Layer layer = project.getLayerById(proxyRequest.layerId);
        if (layer == null || !layer.canSearch) {
            return;
        }
        String string2 = null;
        RecordsArray recordsArray = null;
        if (proxyRequest.type == 32 || proxyRequest.type == 35) {
            string = layer.linkSearch != null ? layer.linkSearch : project.linkSearch;
        } else {
            recordsArray = layer.getSelection();
            if (layer instanceof LayerVector && (proxyRequest.type == 30 || MapUtils.isNotEmptyRecs(recordsArray) && recordsArray.size() > 1)) {
                layerVector = (LayerVector)layer;
                String string3 = string = layerVector.linkInfo != null ? layerVector.linkInfo : project.linkInfo;
                if (string != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    int n = recordsArray.size();
                    if (n > 255) {
                        n = 255;
                    }
                    for (int i = 0; i < n; ++i) {
                        Record record = recordsArray.getRecord(i, 1);
                        stringBuffer.append(layerVector.getId(record)).append(',');
                    }
                    proxyRequest.query = stringBuffer.toString().substring(0, stringBuffer.length() - 1);
                }
            } else {
                string = layer.linkMain != null ? layer.linkMain : project.linkMain;
            }
        }
        string2 = layer.getWebLink(string, recordsArray, proxyRequest.query, proxyRequest.extent, "id=" + this.sessionUser + "&m=" + this.sessionMagic);
        if (string2 != null) {
            this.map.showURL(string2);
        } else if (layer instanceof LayerVector) {
            if (this.map.supressAttributeFrame) {
                return;
            }
            layerVector = (LayerVector)layer;
            if (proxyRequest.type == 32 || proxyRequest.type == 35) {
                if (!layer.isLoadComplete() && layer.isDataOnServer && layer.serverType != 23) {
                    this.doGeoRequest(proxyRequest);
                }
                if ((recordsArray = proxyRequest.type == 32 ? layerVector.findBySearchField(proxyRequest.query) : layerVector.findByExpression(proxyRequest.query)) == null || recordsArray.size() == 0) {
                    this.map.broadcastMessage(114, "");
                } else {
                    this.map.broadcastMessage(115, String.valueOf(recordsArray.size()));
                }
            }
            if (recordsArray != null && recordsArray.size() == 1 && this.zoomToOneResult && proxyRequest.type == 32) {
                this.map.selectObjects(layerVector, recordsArray);
            } else {
                this.map.host.showAttributes(layerVector, recordsArray);
            }
        }
    }
}

