/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import org.alov.map.FloatRectangle;
import org.alov.map.Shape;
import org.alov.util.ExDate;
import org.alov.util.Readers;

public class Record
implements Serializable {
    public int index = -1;
    private FloatRectangle extent = null;
    private Shape[] shapes = null;
    private Object[] fields = null;
    public boolean isNotSent = true;
    public boolean isDownloading = false;
    public ExDate dateLow = null;
    public ExDate dateHigh = null;
    public boolean dateInvalid = false;

    public Record() {
    }

    public Record(int n) {
        if (n > 0) {
            this.fields = new Object[n];
        }
    }

    public Object getField(int n) {
        return n < 0 || n >= this.fields.length ? null : this.fields[n];
    }

    public void setField(int n, Object object) {
        this.fields[n] = object;
    }

    public static int readFromStream(Record record, DataInputStream dataInputStream, boolean bl, boolean bl2) throws IOException {
        if (bl2) {
            return Record.readFromWkb(record, dataInputStream, bl);
        }
        int n = dataInputStream.read();
        int n2 = 0;
        if (n == 255) {
            Shape shape = record.newShape(1);
            shape.setVertex(0, dataInputStream.readFloat(), dataInputStream.readFloat());
            n = 1;
        } else if (n == 254) {
            Shape shape = record.newShape(4);
            float f = dataInputStream.readFloat();
            float f2 = dataInputStream.readFloat();
            float f3 = dataInputStream.readFloat();
            float f4 = dataInputStream.readFloat();
            shape.xCoords[0] = f;
            shape.yCoords[0] = f2;
            shape.xCoords[1] = f;
            shape.yCoords[1] = f4;
            shape.xCoords[2] = f3;
            shape.yCoords[2] = f4;
            shape.xCoords[3] = f3;
            shape.yCoords[3] = f2;
            n = 4;
        } else {
            ++n;
            boolean bl3 = false;
            int n3 = Readers.readInt(dataInputStream);
            int n4 = Readers.readInt(dataInputStream);
            record.initShapes(n4);
            switch (n3) {
                case 1: {
                    for (int i = 0; i < n4; ++i) {
                        Shape shape = new Shape();
                        int n5 = Readers.readInt(dataInputStream);
                        n2 += n5;
                        shape.xCoords = new double[n5];
                        shape.yCoords = new double[n5];
                        float f = Readers.readFloat(dataInputStream);
                        float f5 = Readers.readFloat(dataInputStream);
                        float f6 = Readers.readFloat(dataInputStream);
                        float f7 = Readers.readFloat(dataInputStream);
                        for (int j = 0; j < n5; ++j) {
                            shape.xCoords[j] = (float)Readers.readShort(dataInputStream) * f6 + f;
                            shape.yCoords[j] = (float)Readers.readShort(dataInputStream) * f7 + f5;
                        }
                        record.setShape(i, shape);
                        if (!bl) continue;
                        bl3 = bl3 || n == 3 && Shape.isClockWise(shape);
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < n4; ++i) {
                        Shape shape = new Shape();
                        int n6 = Readers.readInt(dataInputStream);
                        n2 += n6;
                        shape.xCoords = new double[n6];
                        shape.yCoords = new double[n6];
                        for (int j = 0; j < n6; ++j) {
                            shape.xCoords[j] = Readers.readDouble(dataInputStream);
                            shape.yCoords[j] = Readers.readDouble(dataInputStream);
                        }
                        record.setShape(i, shape);
                        if (!bl) continue;
                        bl3 = bl3 || n == 3 && Shape.isClockWise(shape);
                    }
                    break;
                }
                default: {
                    for (int i = 0; i < n4; ++i) {
                        Shape shape = new Shape();
                        int n7 = Readers.readInt(dataInputStream);
                        n2 += n7;
                        shape.xCoords = new double[n7];
                        shape.yCoords = new double[n7];
                        for (int j = 0; j < n7; ++j) {
                            shape.xCoords[j] = Readers.readFloat(dataInputStream);
                            shape.yCoords[j] = Readers.readFloat(dataInputStream);
                        }
                        record.setShape(i, shape);
                        if (!bl) continue;
                        bl3 = bl3 || n == 3 && Shape.isClockWise(shape);
                    }
                }
            }
            if (bl3) {
                Record.addDoughnutShape(record, n2);
            }
        }
        return n;
    }

    private static int readInt(DataInputStream dataInputStream, byte by) throws IOException {
        return by == 1 ? Readers.readInt(dataInputStream) : dataInputStream.readInt();
    }

    private static double readDouble(DataInputStream dataInputStream, byte by) throws IOException {
        return by == 1 ? Readers.readDouble(dataInputStream) : dataInputStream.readDouble();
    }

    private static Shape readWkbLineString(DataInputStream dataInputStream, byte by) throws IOException {
        int n = Record.readInt(dataInputStream, by);
        Shape shape = new Shape();
        shape.xCoords = new double[n];
        shape.yCoords = new double[n];
        if (by == 1) {
            for (int i = 0; i < n; ++i) {
                shape.xCoords[i] = Readers.readDouble(dataInputStream);
                shape.yCoords[i] = Readers.readDouble(dataInputStream);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                shape.xCoords[i] = dataInputStream.readDouble();
                shape.yCoords[i] = dataInputStream.readDouble();
            }
        }
        return shape;
    }

    private static int readFromWkb(Record record, DataInputStream dataInputStream, boolean bl) throws IOException {
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        byte by = dataInputStream.readByte();
        int n3 = Record.readInt(dataInputStream, by);
        switch (n3) {
            case 1: {
                n = 1;
                double d = Record.readDouble(dataInputStream, by);
                double d2 = Record.readDouble(dataInputStream, by);
                record.initShapes(1);
                Shape shape = new Shape();
                shape.setVertex(0, d, d2);
                record.setShape(0, shape);
                break;
            }
            case 2: {
                n = 2;
                record.initShapes(1);
                Shape shape = Record.readWkbLineString(dataInputStream, by);
                n2 += shape.xCoords.length;
                record.setShape(0, shape);
                break;
            }
            case 3: {
                n = 3;
                int n4 = Record.readInt(dataInputStream, by);
                record.initShapes(n4);
                for (int i = 0; i < n4; ++i) {
                    Shape shape = Record.readWkbLineString(dataInputStream, by);
                    n2 += shape.xCoords.length;
                    record.setShape(i, shape);
                    if (!bl) continue;
                    bl2 = bl2 || Shape.isClockWise(shape);
                }
                break;
            }
            case 4: {
                n = 1;
                int n5 = Record.readInt(dataInputStream, by);
                record.initShapes(n5);
                for (int i = 0; i < n5; ++i) {
                    byte by2 = dataInputStream.readByte();
                    int n6 = Record.readInt(dataInputStream, by2);
                    if (n6 != 1) {
                        throw new IOException("wkbMultiPoint can contain wkbPoints only");
                    }
                    Shape shape = new Shape();
                    shape.setVertex(0, Record.readDouble(dataInputStream, by2), Record.readDouble(dataInputStream, by2));
                    record.setShape(i, shape);
                }
                break;
            }
            case 5: {
                n = 2;
                int n7 = Record.readInt(dataInputStream, by);
                record.initShapes(n7);
                for (int i = 0; i < n7; ++i) {
                    byte by3 = dataInputStream.readByte();
                    int n8 = Record.readInt(dataInputStream, by);
                    Shape shape = Record.readWkbLineString(dataInputStream, by3);
                    if (n8 != 2) {
                        throw new IOException("wkbMultiLineString can contain readWkbLineString only");
                    }
                    record.setShape(i, shape);
                }
                break;
            }
            default: {
                throw new IOException("Unsupported wkbType: " + n3);
            }
        }
        if (bl2) {
            Record.addDoughnutShape(record, n2);
        }
        return n;
    }

    public void setRecordExtent(FloatRectangle floatRectangle) {
        this.extent = floatRectangle;
    }

    public FloatRectangle getRecordExtent() {
        if (this.extent == null) {
            FloatRectangle floatRectangle = new FloatRectangle();
            int n = this.getShapeCount();
            double d = Double.NEGATIVE_INFINITY;
            double d2 = Double.NEGATIVE_INFINITY;
            double d3 = Double.POSITIVE_INFINITY;
            double d4 = Double.POSITIVE_INFINITY;
            for (int i = 0; i < n; ++i) {
                Shape shape = this.getShape(i);
                FloatRectangle floatRectangle2 = Shape.calculateExtent(shape);
                if (floatRectangle2 == null) continue;
                if (floatRectangle2.x < d3) {
                    d3 = floatRectangle2.x;
                }
                if (floatRectangle2.x2 > d) {
                    d = floatRectangle2.x2;
                }
                if (floatRectangle2.y < d4) {
                    d4 = floatRectangle2.y;
                }
                if (!(floatRectangle2.y2 > d2)) continue;
                d2 = floatRectangle2.y2;
            }
            floatRectangle.x = d3;
            floatRectangle.y = d4;
            floatRectangle.x2 = d;
            floatRectangle.y2 = d2;
            this.extent = floatRectangle;
        }
        return this.extent;
    }

    public int getShapeCount() {
        return this.shapes == null ? 0 : this.shapes.length;
    }

    public Shape getShape(int n) {
        return n >= 0 && n < this.getShapeCount() ? this.shapes[n] : null;
    }

    public void setShape(int n, Shape shape) {
        if (n >= 0 && n < this.getShapeCount()) {
            this.shapes[n] = shape;
        }
    }

    public Shape newShape(int n) {
        Shape shape = new Shape();
        shape.xCoords = new double[n];
        shape.yCoords = new double[n];
        int n2 = this.getShapeCount();
        if (n2 == 0) {
            this.shapes = new Shape[1];
        } else {
            Shape[] shapeArray = this.shapes;
            this.shapes = new Shape[n2 + 1];
            for (int i = 0; i < n2; ++i) {
                this.shapes[i + 1] = shapeArray[i];
            }
        }
        this.shapes[0] = shape;
        return shape;
    }

    public void initShapes(int n) {
        this.clearShapes();
        this.shapes = new Shape[n];
    }

    public static void addDoughnutShape(Record record, int n) {
        int n2 = record.getShapeCount();
        if (n2 > 1) {
            n += n2 - 1;
        }
        Shape shape = record.newShape(n);
        shape.typeFill = 1;
        int n3 = 0;
        double d = 0.0;
        double d2 = 0.0;
        ++n2;
        for (int i = 1; i < n2; ++i) {
            Shape shape2 = record.getShape(i);
            shape2.typeFill = (byte)2;
            int n4 = shape2.xCoords.length;
            for (int j = 0; j < n4; ++j) {
                shape.xCoords[j + n3] = shape2.xCoords[j];
                shape.yCoords[j + n3] = shape2.yCoords[j];
            }
            if (i == 1) {
                d = shape2.xCoords[n3 + n4 - 1];
                d2 = shape2.yCoords[n3 + n4 - 1];
            } else {
                shape.xCoords[n3 + n4] = d;
                shape.yCoords[n3 + n4] = d2;
                ++n3;
            }
            n3 += n4;
        }
    }

    public static Shape getDoughnutShape(Record record) {
        int n;
        int n2 = 0;
        int n3 = record.getShapeCount();
        if (n3 > 1) {
            int n4 = 0;
            for (n = 0; n < n3; ++n) {
                Shape shape = record.getShape(n);
                if (shape.xCoords == null || shape.yCoords == null) continue;
                ++n4;
                n2 += shape.xCoords.length;
            }
            n2 += n4 - 1;
        }
        if (n2 <= 0) {
            return null;
        }
        Shape shape = new Shape();
        shape.xCoords = new double[n2];
        shape.yCoords = new double[n2];
        shape.typeFill = 1;
        n = 0;
        double d = 0.0;
        double d2 = 0.0;
        boolean bl = true;
        for (int i = 0; i < n3; ++i) {
            Shape shape2 = record.getShape(i);
            shape2.typeFill = (byte)2;
            if (shape2.xCoords == null && shape2.yCoords == null) continue;
            int n5 = shape2.xCoords.length;
            for (int j = 0; j < n5; ++j) {
                shape.xCoords[j + n] = shape2.xCoords[j];
                shape.yCoords[j + n] = shape2.yCoords[j];
            }
            if (bl) {
                d = shape2.xCoords[n + n5 - 1];
                d2 = shape2.yCoords[n + n5 - 1];
                bl = false;
            } else {
                shape.xCoords[n + n5] = d;
                shape.yCoords[n + n5] = d2;
                ++n;
            }
            n += n5;
        }
        return shape;
    }

    public void setFieldValues(Object[] objectArray) {
        this.fields = objectArray;
    }

    public Object[] getFieldValues() {
        return this.fields;
    }

    protected void finalize() {
        this.clearShapes();
        if (this.fields != null) {
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i] = null;
            }
            this.fields = null;
        }
        this.extent = null;
    }

    public void clearShapes() {
        int n = this.getShapeCount();
        for (int i = 0; i < n; ++i) {
            Shape shape = this.getShape(i);
            shape.xCoords = null;
            shape.yCoords = null;
            shape = null;
        }
        this.shapes = null;
    }
}

