/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Color;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.alov.map.DisplayContext;
import org.alov.map.FieldDef;
import org.alov.map.FloatPoint;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.MapUtils;
import org.alov.map.Projection;
import org.alov.map.Record;
import org.alov.map.RecordsArray;
import org.alov.map.Renderer;
import org.alov.map.Shape;
import org.alov.map.Symbol;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

public class RendererAnalysis
extends Renderer {
    public int fieldIndex;
    public String fieldName;
    public double minValue;
    public double maxValue;
    public boolean isRate;
    public int cellCountLimit;
    public int cellSizeLimit;
    CellStorage cellStorage;
    boolean needPaint = false;

    public RendererAnalysis(Layer layer) {
        super(layer);
    }

    public void paintRecord(Record record, boolean bl, DisplayContext displayContext) {
        try {
            if (this.needPaint) {
                this.needPaint = false;
                if (this.isRate) {
                    this.maxValue = 1.0;
                }
                Vector vector = this.cellStorage.getCellsAsRecords();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    Record record2 = (Record)enumeration.nextElement();
                    Projection projection = displayContext.getProjection();
                    double d = ((Float)record2.getField(0)).doubleValue();
                    if (d > this.maxValue) {
                        d = this.maxValue;
                    }
                    double d2 = d / this.maxValue;
                    if (this.isRate) {
                        d2 = 1.0 - d2;
                    }
                    if (d != 0.0 || !this.isRate) {
                        Symbol.setTransparency(this.symbols[0], (int)(d2 * 200.0) + 25);
                        Shape.paintShape(record2.getShape(0), displayContext.getDrawToGraphics(), projection, this.symbols[0], 3);
                    }
                    if (this.symbols.length <= 1) continue;
                    Shape.paintShape(record2.getShape(0), displayContext.getDrawToGraphics(), projection, this.symbols[1], 3);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void beforePaint(boolean bl, DisplayContext displayContext) {
        FloatRectangle floatRectangle = displayContext.getLastExtent();
        RecordsArray recordsArray = this.layer.findWithinRect(floatRectangle, false);
        if (recordsArray == null) {
            return;
        }
        this.cellStorage = new CellStorage(floatRectangle, this.cellCountLimit, this.cellSizeLimit);
        int n = recordsArray.count;
        for (int i = 0; i < n; ++i) {
            Record record = recordsArray.getRecord(i);
            Object object = record.getField(this.fieldIndex);
            double d = object instanceof Float ? ((Float)object).doubleValue() : 0.0;
            this.cellStorage.addCell(record.getRecordExtent().getCentre(), d);
        }
        this.needPaint = true;
    }

    public void afterPaint(boolean bl, DisplayContext displayContext) {
        this.cellStorage = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        InputStream inputStream = null;
        try {
            this.startRequest();
            String string = this.layer.parentMap.getParameter("servlet", "mapserv");
            string = string.substring(0, string.indexOf("mapserv"));
            String string2 = "SELECT min(B." + this.fieldName + "), max(B." + this.fieldName + ") FROM ei_cells C left join b_nettest2 B on (C.cellid=B.cell_id)and(B.DATE_ID=1790)";
            String string3 = string + "tmv?con=res=1;opr=1;ECAIID=32;sql=" + string2;
            inputStream = MapUtils.openURL(string3);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            String string4 = dataInputStream.readUTF();
            String string5 = dataInputStream.readUTF();
            this.minValue = Double.parseDouble(string4);
            this.maxValue = Double.parseDouble(string5);
        }
        catch (Exception exception) {
        }
        finally {
            this.endRequest();
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    private void startRequest() {
    }

    private void endRequest() {
    }

    protected void prepare() throws Exception {
        FieldDef fieldDef = this.layer.getFieldDef_(this.layer.getFieldIndex(this.fieldName));
        int n = this.fieldIndex = fieldDef == null ? -1 : fieldDef.index;
        if (this.fieldIndex < 0 && this.fieldName != null) {
            throw new Exception("  Renderer: " + this.name + "  " + this.fieldName);
        }
        int n2 = this.symbolsUnprepared.size();
        if (n2 == 0) {
            this.symbols = new Symbol[1];
            this.symbols[0] = new Symbol(Color.black, Color.black, true, false, 3);
        } else {
            this.symbols = new Symbol[n2];
            for (int i = 0; i < n2; ++i) {
                this.symbols[i] = (Symbol)this.symbolsUnprepared.elementAt(i);
            }
        }
        this.isPrepared = true;
    }

    public void loadParameters(XmlElement xmlElement) {
        this.fieldName = XmlUtils.getString("field", xmlElement, null);
        this.cellCountLimit = XmlUtils.getInt("cellcountlimit", xmlElement, 10);
        this.cellSizeLimit = XmlUtils.getInt("cellsizelimit", xmlElement, 10);
    }

    class CellStorage {
        double[][] cells;
        int[][] counter;
        double cellSide;
        double xmin;
        double ymin;
        double xmax;
        double ymax;
        int cellX;
        int cellY;
        final int[] SIZE_ALIGN = new int[]{5, 10, 20, 50, 100, 200, 500, 1000, 2000, 5000, 10000, 20000};

        CellStorage(FloatRectangle floatRectangle, int n, int n2) {
            int n3;
            double d = Math.max((floatRectangle.x2 - floatRectangle.x) / (double)n, (floatRectangle.y2 - floatRectangle.y) / (double)n);
            d = this.align(d);
            this.cellSide = Math.max((double)n2, d);
            this.xmin = this.floor(floatRectangle.x, this.cellSide);
            this.ymin = this.floor(floatRectangle.y, this.cellSide);
            this.xmax = this.ceil(floatRectangle.x2, this.cellSide);
            this.ymax = this.ceil(floatRectangle.y2, this.cellSide);
            this.cellX = (int)((this.xmax - this.xmin) / this.cellSide + 1.0);
            this.cellY = (int)((this.ymax - this.ymin) / this.cellSide + 1.0);
            this.cells = new double[this.cellX][];
            for (n3 = 0; n3 < this.cellX; ++n3) {
                this.cells[n3] = new double[this.cellY];
            }
            this.counter = new int[this.cellX][];
            for (n3 = 0; n3 < this.cellX; ++n3) {
                this.counter[n3] = new int[this.cellY];
            }
        }

        private double floor(double d, double d2) {
            return Math.floor(d / d2) * d2;
        }

        private double ceil(double d, double d2) {
            return Math.ceil(d / d2) * d2;
        }

        private double align(double d) {
            double d2 = Math.floor(Math.log(d) / Math.log(10.0));
            double d3 = Math.pow(10.0, d2);
            double d4 = d3 * 2.0;
            double d5 = d3 * 5.0;
            return d < d4 ? d3 : (d < d5 ? d4 : d5);
        }

        void addCell(FloatPoint floatPoint, double d) {
            double d2 = floatPoint.x;
            double d3 = floatPoint.y;
            int n = (int)((d2 - this.xmin) / this.cellSide);
            int n2 = (int)((d3 - this.ymin) / this.cellSide);
            if (n >= 0 && n < this.cellX && n2 >= 0 && n2 < this.cellY && d > 0.0) {
                double[] dArray = this.cells[n];
                int n3 = n2;
                dArray[n3] = dArray[n3] + d;
                int[] nArray = this.counter[n];
                int n4 = n2;
                nArray[n4] = nArray[n4] + 1;
            }
        }

        private void calculate() {
            for (int i = 0; i < this.cellX; ++i) {
                for (int j = 0; j < this.cellY; ++j) {
                    if (this.counter[i][j] <= 1) continue;
                    double[] dArray = this.cells[i];
                    int n = j;
                    dArray[n] = dArray[n] / (double)this.counter[i][j];
                }
            }
        }

        Vector getCellsAsRecords() {
            this.calculate();
            Vector<Record> vector = new Vector<Record>();
            for (int i = 0; i < this.cellX; ++i) {
                for (int j = 0; j < this.cellY; ++j) {
                    Record record = new Record(1);
                    record.setField(0, new Float(this.cells[i][j]));
                    FloatRectangle floatRectangle = new FloatRectangle();
                    floatRectangle.x = (double)i * this.cellSide + this.xmin;
                    floatRectangle.y = (double)j * this.cellSide + this.ymin;
                    floatRectangle.x2 = (double)(i + 1) * this.cellSide + this.xmin;
                    floatRectangle.y2 = (double)(j + 1) * this.cellSide + this.ymin;
                    record.setRecordExtent(floatRectangle);
                    double d = this.xmin + (double)i * this.cellSide;
                    double d2 = this.ymin + (double)j * this.cellSide;
                    double[] dArray = new double[]{d, d2, d + this.cellSide, d2, d + this.cellSide, d2 + this.cellSide, d, d2 + this.cellSide};
                    Shape shape = new Shape(dArray);
                    record.initShapes(1);
                    record.setShape(0, shape);
                    vector.addElement(record);
                }
            }
            return vector;
        }
    }
}

