/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;
import org.alov.data.SQLConst;
import org.alov.map.DisplayContext;
import org.alov.map.FieldDef;
import org.alov.map.FloatPoint;
import org.alov.map.Layer;
import org.alov.map.MapUtils;
import org.alov.map.Projection;
import org.alov.map.Record;
import org.alov.map.Renderer;
import org.alov.util.AlovMapException;

public class RendererChart
extends Renderer {
    public static final int CHART_PIE = 1;
    public static final int CHART_BAR = 2;
    public int type;
    public FieldDef[] fields;
    public Vector fieldsUnprepared = null;
    public Color outlineColor;
    public float normalization = 0.0f;
    public String normFieldName;
    int normField;
    public int minSize;
    public int maxSize;
    public String sizeFieldName;
    int sizeField;
    public int width;
    public int height;
    public float nullValue = Float.NaN;
    private double[] values;
    private static final int startAngle = 90;
    private static final int deltaAngle = 270;
    private static final int radius = 8;
    private static final int dx1 = (int)(8.0 * Math.cos(1.5707963267948966));
    private static final int dy1 = (int)(8.0 * Math.sin(1.5707963267948966));
    private static final int dx2 = (int)(8.0 * Math.cos(Math.PI * 2));
    private static final int dy2 = (int)(8.0 * Math.sin(Math.PI * 2));

    public RendererChart(Layer layer) {
        super(layer);
    }

    int getLevel() {
        return 100 * (this.layer.drawOrder + 1) + 50;
    }

    public void paintRecord(Record record, boolean bl, DisplayContext displayContext) {
        Object var4_4 = null;
        Projection projection = displayContext.getProjection();
        Graphics graphics = displayContext.getDrawToGraphics();
        double[] dArray = this.values;
        double d = 0.0;
        int n = this.fields.length;
        double d2 = 0.0;
        FloatPoint floatPoint = projection.shift;
        double d3 = projection.zoom;
        FloatPoint floatPoint2 = record.getRecordExtent().getCentre();
        int n2 = (int)((floatPoint2.x + floatPoint.x) * d3);
        int n3 = (int)((-floatPoint2.y + floatPoint.y) * d3);
        if (this.type == 1) {
            int n4;
            int n5;
            for (int i = 0; i < n; ++i) {
                d2 = this.layer.getFieldDouble(record, this.fields[i].index);
                if (d2 == (double)this.nullValue) {
                    return;
                }
                double d4 = Math.abs(d2);
                d += d4;
                dArray[i] = d4;
            }
            Object object = this.layer.getFieldValue(record, this.sizeField);
            if (object != null) {
                n5 = ((Number)object).intValue();
                FieldDef fieldDef = this.layer.getFieldDef(this.sizeField);
                if (fieldDef.maxvalue > (double)this.maxSize || fieldDef.minvalue < (double)this.minSize) {
                    double d5 = (fieldDef.maxvalue - fieldDef.minvalue) / (double)((float)(this.maxSize - this.minSize) * 1.0f);
                    n5 = (int)((double)n5 / d5);
                }
                if (this.minSize > 0 || this.maxSize > 0) {
                    if (n5 < this.minSize) {
                        n5 = this.minSize;
                    } else if (n5 > this.maxSize) {
                        n5 = this.maxSize;
                    }
                }
            } else {
                n5 = this.maxSize;
            }
            int n6 = n5 > (n4 = n5) ? (int)(Math.atan(12.0 / (double)n5) / Math.PI * 180.0) : (int)(Math.atan(12.0 / (double)n4) / Math.PI * 180.0);
            int n7 = n2;
            int n8 = n3;
            int n9 = n5 / 2;
            int n10 = n4 / 2;
            n2 -= n9;
            n3 -= n10;
            double d6 = 0.0;
            int[] nArray = new int[3];
            int[] nArray2 = new int[3];
            nArray[0] = n7;
            nArray2[0] = n8;
            for (int i = 0; i < n; ++i) {
                d6 = dArray[i] / d * 360.0;
                graphics.setColor(this.fields[i].color);
                int n11 = (int)d2;
                int n12 = (int)d6;
                if (n12 >= n6) {
                    graphics.fillArc(n2, n3, n5, n4, n11, n12 + 5);
                    d2 += d6;
                    continue;
                }
                double d7 = -d2 / 180.0 * Math.PI;
                int n13 = n7 + (int)Math.round(Math.cos(d7) * (double)n9);
                int n14 = n8 + (int)Math.round(Math.sin(d7) * (double)n10);
                double d8 = -(d2 + d6 * 1.1) / 180.0 * Math.PI;
                int n15 = n7 + (int)Math.round(Math.cos(d8) * (double)n9);
                int n16 = n8 + (int)Math.round(Math.sin(d8) * (double)n10);
                nArray[1] = n13;
                nArray2[1] = n14;
                nArray[2] = n15;
                nArray2[2] = n16;
                graphics.fillPolygon(nArray, nArray2, 3);
                d2 += d6;
            }
            if (this.outlineColor != null && d2 > 0.0) {
                graphics.setColor(this.outlineColor);
                graphics.drawOval(n2, n3, n5, n4);
            }
        } else {
            int n17 = this.width / n;
            if (n17 < 2) {
                n17 = 2;
            }
            int n18 = n17 * n;
            int n19 = this.height;
            n2 -= n18 / 2;
            double d9 = Double.POSITIVE_INFINITY;
            double d10 = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < n; ++i) {
                dArray[i] = this.layer.getFieldDouble(record, this.fields[i].index);
                if (dArray[i] == (double)this.nullValue) {
                    return;
                }
                FieldDef fieldDef = this.layer.getFieldDef_(this.fields[i].index);
                if (d9 > fieldDef.minvalue) {
                    d9 = fieldDef.minvalue;
                }
                if (!(d10 < fieldDef.maxvalue)) continue;
                d10 = fieldDef.maxvalue;
            }
            double d11 = 1.0;
            if (Math.abs(d10) > (double)this.height || Math.abs(d9) < 2.0) {
                d11 = (d10 - d9) / (double)((float)(this.height - 2) * 1.0f);
            }
            int n20 = n2;
            int n21 = 0;
            while (n21 < n) {
                graphics.setColor(this.fields[n21].color);
                int n22 = (int)(dArray[n21] / d11);
                graphics.fillRect(n20, n3 - n22, n17, n22);
                if (this.outlineColor != null) {
                    graphics.setColor(this.outlineColor);
                    graphics.drawRect(n20, n3 - n22, n17, n22);
                }
                ++n21;
                n20 += n17;
            }
        }
    }

    public void paintSampleChart(Graphics graphics, Rectangle rectangle) {
        Color color = graphics.getColor();
        int n = MapUtils.getCurrentFontHeight(graphics);
        int n2 = this.fields.length;
        int n3 = 8;
        int n4 = rectangle.x + 10 - n3;
        for (int i = 0; i < n2; ++i) {
            int n5;
            FieldDef fieldDef = this.fields[i];
            graphics.setColor(fieldDef.color);
            if (this.type == 1) {
                n5 = rectangle.y + 20 * i + 10 - n3;
                graphics.fillArc(n4, n5, n3 * 2, n3 * 2, 90, 270);
                graphics.setColor(Color.black);
                graphics.drawArc(n4, n5, n3 * 2, n3 * 2, 90, 270);
                graphics.drawLine(n4 + 8, n5 + 8, n4 + 8 + dx1, n5 + 8 - dy1);
                graphics.drawLine(n4 + 8, n5 + 8, n4 + 8 + dx2, n5 + 8 - dy2);
            } else {
                n5 = rectangle.x + 10 - 3;
                int n6 = rectangle.y + 20 * i + 10 - 6;
                graphics.fillRect(n5, n6, 6, 12);
                graphics.setColor(color);
                graphics.drawRect(n5, n6, 6, 12);
            }
            String string = fieldDef.label;
            if (string == null) {
                string = this.layer.getFieldDef((int)this.fields[i].index).name;
            }
            graphics.drawString(string, rectangle.x + 30, rectangle.y + 10 + n / 2 + 20 * i);
        }
    }

    protected void prepare() throws Exception {
        FieldDef fieldDef;
        int n;
        FieldDef fieldDef2;
        if (this.height < 5) {
            this.height = 50;
        }
        if (this.width == 0) {
            this.width = 25;
        }
        if (this.minSize < 8) {
            this.minSize = 8;
        }
        if (this.maxSize < 8) {
            this.maxSize = 50;
        }
        if (this.maxSize <= this.minSize) {
            this.minSize = this.maxSize - 2;
        }
        this.sizeField = (fieldDef2 = this.layer.getFieldDef_(this.layer.getFieldIndex(this.sizeFieldName))) != null && SQLConst.isNumber(fieldDef2.type) ? fieldDef2.index : -1;
        fieldDef2 = this.layer.getFieldDef_(this.layer.getFieldIndex(this.normFieldName));
        int n2 = this.normField = fieldDef2 != null && SQLConst.isNumber(fieldDef2.type) ? fieldDef2.index : -1;
        if (this.fieldsUnprepared == null) {
            return;
        }
        int n3 = this.fieldsUnprepared.size();
        int n4 = 0;
        for (n = 0; n < n3; ++n) {
            fieldDef = (FieldDef)this.fieldsUnprepared.elementAt(n);
            fieldDef2 = this.layer.getFieldDef_(this.layer.getFieldIndex(fieldDef.name));
            if (fieldDef2 != null && SQLConst.isNumber(fieldDef2.type)) {
                fieldDef.index = fieldDef2.index;
                ++n4;
                continue;
            }
            fieldDef.index = -1;
            throw new AlovMapException("  Renderer: " + this.name + "  " + fieldDef.name);
        }
        if (n4 > 0) {
            this.fields = new FieldDef[n4];
            this.values = new double[n4];
            n4 = 0;
            for (n = 0; n < n3; ++n) {
                fieldDef = (FieldDef)this.fieldsUnprepared.elementAt(n);
                if (fieldDef.index < 0) continue;
                this.fields[n4] = fieldDef;
                ++n4;
            }
        }
        this.fieldsUnprepared.removeAllElements();
        this.fieldsUnprepared = null;
        this.isPrepared = this.fields.length > 0;
    }
}

