/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Color;
import org.alov.map.DisplayContext;
import org.alov.map.FieldDef;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.Projection;
import org.alov.map.Record;
import org.alov.map.Renderer;
import org.alov.map.Shape;
import org.alov.map.Symbol;

public class RendererDot
extends Renderer {
    public int fieldIndex;
    public String fieldName;
    public float dotSize;

    public RendererDot(Layer layer) {
        super(layer);
    }

    public void paintRecord(Record record, boolean bl, DisplayContext displayContext) {
        if (this.fieldIndex >= 0) {
            int n;
            int n2;
            double d = this.layer.getFieldDouble(record, this.fieldIndex);
            int n3 = (int)(d / (double)this.dotSize);
            double[] dArray = new double[n3];
            double[] dArray2 = new double[n3];
            int n4 = record.getShapeCount();
            for (n2 = 0; n2 < n3; ++n2) {
                n = 0;
                double d2 = 0.0;
                double d3 = 0.0;
                while (n == 0) {
                    FloatRectangle floatRectangle = record.getRecordExtent();
                    d2 = (floatRectangle.x2 - floatRectangle.x) * Math.random() + floatRectangle.x;
                    d3 = (floatRectangle.y2 - floatRectangle.y) * Math.random() + floatRectangle.y;
                    for (int i = 0; i < n4 && n == 0; ++i) {
                        if (!Shape.containsPoint(record.getShape(i), d2, d3)) continue;
                        n = 1;
                    }
                }
                dArray[n2] = d2;
                dArray2[n2] = d3;
            }
            for (n2 = 0; n2 < n3; ++n2) {
                Projection projection = displayContext.getProjection();
                n = (int)((dArray[n2] + projection.shift.x) * projection.zoom);
                int n5 = (int)((-dArray2[n2] + projection.shift.y) * projection.zoom);
                Shape.drawPoint(displayContext.getDrawToGraphics(), this.symbols[0], n, n5);
            }
        }
    }

    protected void prepare() throws Exception {
        FieldDef fieldDef = this.layer.getFieldDef_(this.layer.getFieldIndex(this.fieldName));
        int n = this.fieldIndex = fieldDef == null ? -1 : fieldDef.index;
        if (this.fieldIndex < 0 && this.fieldName != null) {
            throw new Exception("  Renderer: " + this.name + "  " + this.fieldName);
        }
        if (this.symbols == null) {
            this.symbols = new Symbol[1];
            this.symbols[0] = new Symbol(Color.black, Color.black, true, false, 3);
        }
        this.symbols[0].drawMarker = true;
        this.isPrepared = true;
    }
}

