/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import org.alov.map.DisplayContext;
import org.alov.map.FieldDef;
import org.alov.map.FloatPoint;
import org.alov.map.Layer;
import org.alov.map.MapUtils;
import org.alov.map.Meta;
import org.alov.map.Projection;
import org.alov.map.Record;
import org.alov.map.Renderer;
import org.alov.map.Shape;
import org.alov.map.Symbol;
import org.alov.map.Utils2D;
import org.alov.util.ExDate;
import org.alov.util.TimeInterval;

public class RendererEvolution
extends Renderer {
    private final int SYMBOL_START = 0;
    private final int SYMBOL_END = 1;
    private final int SYMBOL_LINE = 2;
    private final int SYMBOL_ARROW_HEAD = 3;
    private final int SYMBOL_ARROW_TAIL = 4;
    private final int MAX_SYMBOLS = 5;
    private static final String STRING_SYMBOL_START = "start";
    private static final String STRING_SYMBOL_END = "end";
    public static final String STRING_SYMBOL_LINE = "line";
    private static final String STRING_SYMBOL_ARROW_HEAD = "arrowhead";
    private static final String STRING_SYMBOL_ARROW_TAIL = "arrowtail";
    public int arrowHeadWidth;
    public int arrowHeadLength;
    public int arrowHeadFeather;
    public int arrowTailWidth;
    public int arrowTailLength;
    public int arrowTailFeather;
    private int startDateFieldIndex;
    private int endDateFieldIndex;
    private final int defaultArrowHeadLength = 7;
    private final int defaultArrowHeadWidth = 5;
    private final int defaultArrowHeadFeather = 1;
    private final int defaultArrowTailLength = 30;
    private final int defaultArrowTailWidth = 5;
    private final int defaultArrowTailFeather = 2;

    public RendererEvolution(Layer layer) {
        super(layer);
    }

    public void paintRecord(Record record, boolean bl, DisplayContext displayContext) {
        String string = this.layer.getFieldString(record, this.startDateFieldIndex);
        String string2 = this.layer.getFieldString(record, this.endDateFieldIndex);
        TimeInterval timeInterval = displayContext.getTimeInterval();
        ExDate exDate = ExDate.parseString(string);
        ExDate exDate2 = ExDate.parseString(string2);
        if (exDate == null || exDate2 == null) {
            return;
        }
        ExDate exDate3 = timeInterval.date1();
        ExDate exDate4 = timeInterval.date2();
        double d = exDate.getDays();
        double d2 = exDate2.getDays();
        double d3 = exDate3.getDays();
        double d4 = exDate4.getDays();
        int n = record.getShapeCount();
        for (int i = 0; i < n; ++i) {
            Shape shape = record.getShape(i);
            if (shape.typeFill == 1) continue;
            double[] dArray = shape.xCoords;
            double[] dArray2 = shape.yCoords;
            int n2 = dArray.length;
            PointOnShape pointOnShape = d < d3 ? this.findMarkPosition(shape, d, d2, d3) : new PointOnShape(0, dArray[0], dArray2[0]);
            PointOnShape pointOnShape2 = d2 > d4 ? this.findMarkPosition(shape, d, d2, d2 > d4 ? d4 : d2) : new PointOnShape(n2 - 1, dArray[n2 - 1], dArray2[n2 - 1]);
            int n3 = pointOnShape2.segmentNumber - pointOnShape.segmentNumber + 2;
            double[] dArray3 = new double[n3];
            double[] dArray4 = new double[n3];
            dArray3[0] = pointOnShape.x;
            dArray4[0] = pointOnShape.y;
            if (n3 > 2) {
                System.arraycopy(dArray, pointOnShape.segmentNumber + 1, dArray3, 1, n3 - 2);
                System.arraycopy(dArray2, pointOnShape.segmentNumber + 1, dArray4, 1, n3 - 2);
            }
            dArray3[n3 - 1] = pointOnShape2.x;
            dArray4[n3 - 1] = pointOnShape2.y;
            if (this.symbols[2] != null) {
                Shape shape2 = new Shape();
                shape2.xCoords = dArray3;
                shape2.yCoords = dArray4;
                shape2.typeFill = (byte)2;
                int n4 = 2;
                Shape.paintShape(shape2, displayContext.getDrawToGraphics(), displayContext.getProjection(), this.symbols[2], n4);
            }
            this.drawArrow(displayContext, dArray3, dArray4, this.arrowHeadLength, this.arrowHeadWidth, this.arrowHeadFeather, this.symbols[3], this.arrowTailLength, this.arrowTailWidth, this.arrowTailFeather, this.symbols[4]);
            if (this.symbols[0] != null) {
                this.drawMarkPoint(displayContext, 0, pointOnShape.x, pointOnShape.y);
            }
            if (this.symbols[1] == null) continue;
            this.drawMarkPoint(displayContext, 1, pointOnShape2.x, pointOnShape2.y);
        }
    }

    private PointOnShape findMarkPosition(Shape shape, double d, double d2, double d3) {
        PointOnShape pointOnShape = null;
        double d4 = d2 - d;
        double d5 = d4 > 0.0 ? (d3 - d) / d4 : 0.0;
        double[] dArray = shape.xCoords;
        double[] dArray2 = shape.yCoords;
        int n = dArray.length;
        double[] dArray3 = new double[n - 1];
        pointOnShape = new PointOnShape(n - 1, dArray[n - 1], dArray2[n - 1]);
        double d6 = 0.0;
        for (int i = 1; i < n; ++i) {
            double d7;
            dArray3[i - 1] = d7 = MapUtils.getDistance(new FloatPoint(dArray[i - 1], dArray2[i - 1]), new FloatPoint(dArray[i], dArray2[i]), 0);
            d6 += d7;
        }
        double d8 = d5 * d6;
        double d9 = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            double d10;
            double d11;
            if (!((d9 += dArray3[i]) >= d8)) continue;
            double d12 = dArray3[i];
            double d13 = d8 - (d9 - d12);
            double d14 = dArray[i];
            double d15 = dArray[i + 1];
            double d16 = dArray2[i];
            double d17 = dArray2[i + 1];
            if (d12 < 1.0) {
                d11 = d14;
                d10 = d16;
            } else {
                d11 = d14 + d13 * (d15 - d14) / d12;
                d10 = d16 + d13 * (d17 - d16) / d12;
            }
            pointOnShape = new PointOnShape(i, d11, d10);
            break;
        }
        return pointOnShape;
    }

    private void drawMarkPoint(DisplayContext displayContext, int n, double d, double d2) {
        Projection projection = displayContext.getProjection();
        int n2 = (int)((d + projection.shift.x) * projection.zoom);
        int n3 = (int)((-d2 + projection.shift.y) * projection.zoom);
        Shape.drawPoint(displayContext.getDrawToGraphics(), this.symbols[n], n2, n3);
    }

    private void drawArrow(DisplayContext displayContext, double[] dArray, double[] dArray2, int n, int n2, int n3, Symbol symbol, int n4, int n5, int n6, Symbol symbol2) {
        int n7 = dArray.length;
        int[] nArray = new int[n7];
        int[] nArray2 = new int[n7];
        int n8 = 0;
        Projection projection = displayContext.getProjection();
        for (int i = n7 - 1; i > 0; --i) {
            int n9 = (int)((dArray[i] + projection.shift.x) * projection.zoom);
            int n10 = (int)((-dArray2[i] + projection.shift.y) * projection.zoom);
            if (n8 == 0) {
                nArray[n8] = n9;
                nArray2[n8] = n10;
                ++n8;
                continue;
            }
            if (nArray[n8 - 1] == n9 && nArray2[n8 - 1] == n10) continue;
            nArray[n8] = n9;
            nArray2[n8] = n10;
            ++n8;
        }
        if (n8 < 2) {
            return;
        }
        if (symbol2 != null) {
            this.drawArrowTail(displayContext, nArray, nArray2, n8, n4, n5, n6, symbol2);
        }
        if (symbol != null) {
            this.drawArrowHead(displayContext, nArray[1], nArray2[1], nArray[0], nArray2[0], n, n2, n3, symbol);
        }
    }

    private void drawArrowTail(DisplayContext displayContext, int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, Symbol symbol) {
        double d = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            d += this.hypot(nArray[i], nArray2[i], nArray[i + 1], nArray2[i + 1]);
        }
        if ((double)n2 > d) {
            n2 = (int)d;
        }
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n];
        int[] nArray5 = new int[n];
        int[] nArray6 = new int[n];
        int n5 = 0;
        double d2 = 0.0;
        int n6 = 0;
        int n7 = 0;
        for (int i = 0; i < n - 1 && d2 < (double)n2; ++i) {
            double d3 = nArray[i + 1];
            double d4 = nArray2[i + 1];
            double d5 = nArray[i];
            double d6 = nArray2[i];
            double d7 = this.hypot(d3, d4, d5, d6);
            double d8 = (d2 += d7) > (double)n2 ? (double)n2 - (d2 - d7) : d7;
            double d9 = (d2 > (double)n2 ? (double)n2 : d2) * (double)n3 / (double)n2;
            double d10 = d7 == 0.0 ? 0.0 : (d5 - d3) / d7;
            double d11 = d7 == 0.0 ? 0.0 : (d6 - d4) / d7;
            double d12 = d5 - d8 * d10;
            double d13 = d6 - d8 * d11;
            double d14 = d12 + d9 * d11;
            double d15 = d13 - d9 * d10;
            double d16 = d12 - d9 * d11;
            double d17 = d13 + d9 * d10;
            n6 = (int)(d12 + (double)n4 * d10);
            n7 = (int)(d13 + (double)n4 * d11);
            nArray3[n5] = (int)d16;
            nArray4[n5] = (int)d17;
            nArray5[n5] = (int)d14;
            nArray6[n5] = (int)d15;
            ++n5;
        }
        int[] nArray7 = new int[n5 * 2 + 2];
        int[] nArray8 = new int[n5 * 2 + 2];
        for (int i = 0; i < n5; ++i) {
            nArray7[i] = nArray3[i];
            nArray8[i] = nArray4[i];
            nArray7[n5 + i + 1] = nArray5[n5 - i - 1];
            nArray8[n5 + i + 1] = nArray6[n5 - i - 1];
        }
        nArray7[n5] = n6;
        nArray8[n5] = n7;
        nArray7[n5 * 2 + 1] = nArray[0];
        nArray8[n5 * 2 + 1] = nArray2[0];
        Utils2D.polygon(displayContext.getDrawToGraphics(), nArray7, nArray8, n5 * 2 + 2, symbol);
    }

    private void drawArrowHead(DisplayContext displayContext, double d, double d2, double d3, double d4, int n, int n2, int n3, Symbol symbol) {
        double d5 = this.hypot(d, d2, d3, d4);
        if (d5 == 0.0) {
            return;
        }
        double d6 = (d3 - d) / d5;
        double d7 = (d4 - d2) / d5;
        double d8 = d3 - (double)n * d6;
        double d9 = d4 - (double)n * d7;
        double d10 = d8 + (double)n2 * d7;
        double d11 = d9 - (double)n2 * d6;
        double d12 = d8 - (double)n2 * d7;
        double d13 = d9 + (double)n2 * d6;
        d8 += (double)n3 * d6;
        d9 += (double)n3 * d7;
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        nArray[0] = (int)d3;
        nArray2[0] = (int)d4;
        nArray[1] = (int)d12;
        nArray2[1] = (int)d13;
        nArray[2] = (int)d8;
        nArray2[2] = (int)d9;
        nArray[3] = (int)d10;
        nArray2[3] = (int)d11;
        Utils2D.polygon(displayContext.getDrawToGraphics(), nArray, nArray2, 4, symbol);
    }

    private double hypot(double d, double d2, double d3, double d4) {
        return Math.sqrt((d3 - d) * (d3 - d) + (d4 - d2) * (d4 - d2));
    }

    protected void prepare() throws Exception {
        Meta meta = this.layer.metadata;
        String string = meta.getStr(53);
        String string2 = meta.getStr(54);
        FieldDef fieldDef = this.layer.getFieldDef_(this.layer.getFieldIndex(string));
        FieldDef fieldDef2 = this.layer.getFieldDef_(this.layer.getFieldIndex(string2));
        this.startDateFieldIndex = fieldDef == null ? -1 : fieldDef.index;
        int n = this.endDateFieldIndex = fieldDef2 == null ? -1 : fieldDef2.index;
        if (this.startDateFieldIndex < 0) {
            throw new Exception("  Renderer: " + this.name + "  " + string);
        }
        if (this.endDateFieldIndex < 0) {
            throw new Exception("  Renderer: " + this.name + "  " + string2);
        }
        FieldDef fieldDef3 = new FieldDef();
        fieldDef3.type = 12;
        this.prepareSymbols(fieldDef3);
        Symbol[] symbolArray = new Symbol[5];
        if (this.symbols != null) {
            for (int i = 0; i < this.symbols.length; ++i) {
                Object object = this.symbols[i].value;
                if (!(object instanceof String)) continue;
                String string3 = (String)object;
                if (STRING_SYMBOL_START.equalsIgnoreCase(string3)) {
                    symbolArray[0] = this.symbols[i];
                    continue;
                }
                if (STRING_SYMBOL_END.equalsIgnoreCase(string3)) {
                    symbolArray[1] = this.symbols[i];
                    continue;
                }
                if (STRING_SYMBOL_LINE.equalsIgnoreCase(string3)) {
                    symbolArray[2] = this.symbols[i];
                    continue;
                }
                if (STRING_SYMBOL_ARROW_HEAD.equalsIgnoreCase(string3)) {
                    symbolArray[3] = this.symbols[i];
                    continue;
                }
                if (!STRING_SYMBOL_ARROW_TAIL.equalsIgnoreCase(string3)) continue;
                symbolArray[4] = this.symbols[i];
            }
        }
        this.symbols = symbolArray;
        if (this.arrowHeadLength < 0) {
            this.arrowHeadLength = 7;
        }
        if (this.arrowHeadWidth < 0) {
            this.arrowHeadWidth = 5;
        }
        if (this.arrowHeadFeather < 0) {
            this.arrowHeadFeather = 1;
        }
        if (this.arrowTailLength < 0) {
            this.arrowTailLength = 30;
        }
        if (this.arrowTailWidth < 0) {
            this.arrowTailWidth = 5;
        }
        if (this.arrowTailFeather < 0) {
            this.arrowTailFeather = 2;
        }
        this.isPrepared = true;
    }

    private class PointOnShape {
        int segmentNumber;
        double x;
        double y;

        PointOnShape(int n, double d, double d2) {
            this.segmentNumber = n;
            this.x = d;
            this.y = d2;
        }
    }
}

