/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.io.Serializable;
import org.alov.map.DisplayContext;
import org.alov.map.FieldDef;
import org.alov.map.FilterExpression;
import org.alov.map.FilterTime;
import org.alov.map.FloatPoint;
import org.alov.map.Layer;
import org.alov.map.LayerVector;
import org.alov.map.MapUtils;
import org.alov.map.Projection;
import org.alov.map.Record;
import org.alov.map.Renderer;
import org.alov.map.Shape;
import org.alov.map.Symbol;
import org.alov.util.ExDate;
import org.alov.util.Strings;
import org.alov.util.TimeInterval;

public class RendererGrad
extends Renderer {
    public int fieldIndex;
    public String fieldName;
    public boolean drawDefault = false;

    public RendererGrad(Layer layer) {
        super(layer);
    }

    public boolean isDynamic() {
        int n = this.symbols != null ? this.symbols.length : 0;
        for (int i = 0; i < n; ++i) {
            if (!this.symbols[i].imageAnimated) continue;
            return true;
        }
        return false;
    }

    public void paintRecord(Record record, boolean bl, DisplayContext displayContext) {
        Serializable serializable;
        Serializable serializable2;
        Symbol symbol = null;
        Symbol[] symbolArray = this.symbols;
        int n = symbolArray.length;
        if (this.fieldIndex < 0) {
            for (int i = 0; i < n; ++i) {
                serializable2 = symbolArray[i];
                if (serializable2.value == null) continue;
                if (serializable2.value.equals("")) {
                    symbol = serializable2;
                } else if (serializable2.value instanceof FilterExpression) {
                    if (!((FilterExpression)serializable2.value).checkRecord(record)) continue;
                    symbol = serializable2;
                } else {
                    double d;
                    if (!(serializable2.value instanceof FilterTime)) continue;
                    serializable = new TimeInterval(displayContext.getTimeInterval().date1(), displayContext.getTimeInterval().date2());
                    double d2 = serializable2.offsetMin >= 0.0 ? ((TimeInterval)serializable).date1().getDays() + serializable2.offsetMin : ((TimeInterval)serializable).date2().getDays() + serializable2.offsetMin;
                    double d3 = d = serializable2.offsetMax > 0.0 ? ((TimeInterval)serializable).date1().getDays() + serializable2.offsetMax : ((TimeInterval)serializable).date2().getDays() + serializable2.offsetMax;
                    if (d2 > d) {
                        double d4 = d;
                        d = d2;
                        d2 = d4;
                    }
                    ((TimeInterval)serializable).setDate1(new ExDate(d2));
                    ((TimeInterval)serializable).setDate2(new ExDate(d));
                    ((FilterTime)serializable2.value).setTimeInterval((TimeInterval)serializable);
                    if (!((FilterTime)serializable2.value).checkRecord(record)) continue;
                    symbol = serializable2;
                }
                break;
            }
        } else {
            Object object = this.layer.getFieldValue(record, this.fieldIndex);
            for (int i = 0; i < n; ++i) {
                serializable = symbolArray[i];
                int n2 = MapUtils.compare(object, ((Symbol)serializable).value);
                if (n2 != this.equal) continue;
                if (symbol == null || MapUtils.compare(((Symbol)serializable).value, symbol.value) == this.equal) {
                    symbol = serializable;
                }
                if (this.equal != 0) {
                    continue;
                }
                break;
            }
        }
        if (symbol == null && this.drawDefault) {
            symbol = ((LayerVector)this.layer).symbol;
        }
        if (symbol != null && symbol.visible) {
            if (bl) {
                Symbol symbol2;
                symbol = symbol2 = ((LayerVector)this.layer).selectedSymbol;
            }
            if (symbol.sizeFieldIndex >= 0) {
                Object object = this.layer.getFieldValue(record, symbol.sizeFieldIndex);
                symbol.size = (int)((float)Strings.objToInt(object, symbol.size) * symbol.factor);
            }
            if (symbol.rotationFieldIndex >= 0) {
                Object object = this.layer.getFieldValue(record, symbol.rotationFieldIndex);
                symbol.rotation = (float)(MapUtils.toDoubleDef(object, symbol.rotation) / 180.0 * Math.PI);
            }
            if (symbol.drawMarker) {
                Projection projection = displayContext.getProjection();
                serializable2 = record.getRecordExtent().getCentre();
                int n3 = (int)((((FloatPoint)serializable2).x + projection.shift.x) * projection.zoom);
                int n4 = (int)((-((FloatPoint)serializable2).y + projection.shift.y) * projection.zoom);
                Shape.drawPoint(displayContext.getDrawToGraphics(), symbol, n3, n4);
            } else {
                this.defaultPaintRecord(record, symbol, displayContext);
            }
        }
    }

    protected void prepare() throws Exception {
        FieldDef fieldDef = this.layer.getFieldDef_(this.layer.getFieldIndex(this.fieldName));
        this.prepareSymbols(fieldDef);
        int n = this.fieldIndex = fieldDef == null ? -1 : fieldDef.index;
        if (this.fieldIndex < 0 && this.fieldName != null) {
            throw new Exception("  Renderer: " + this.name + "  " + this.fieldName);
        }
        if (this.symbols == null || this.symbols.length == 0) {
            throw new Exception("  Renderer: " + this.name + "  " + "No Symbols");
        }
        int n2 = this.symbols.length;
        int n3 = this.equal > 0 ? 1 : 0;
        int n4 = this.equal < 0 ? 1 : 0;
        int n5 = 0;
        if (this.equal != 2) {
            for (int i = 0; i < n2; ++i) {
                String string = this.symbols[i].label;
                if (string != null) continue;
                if (this.equal == 0) {
                    string = "" + this.symbols[i].value;
                } else if (n2 >= 2) {
                    string = i == 0 ? "... " + this.symbols[i + n3].value : (i < n2 - 1 ? this.symbols[i + n5].value + " ... " + this.symbols[i + n5 + 1].value : this.symbols[i - n4].value + " ...");
                }
                this.symbols[i].label = string;
            }
        }
        this.isPrepared = true;
    }
}

