/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import org.alov.map.DisplayContext;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.LayerRaster;
import org.alov.map.Projection;
import org.alov.map.Record;
import org.alov.map.Renderer;

public class RendererImage
extends Renderer {
    public RendererImage(Layer layer) {
        super(layer);
    }

    public void paintRecord(Record record, boolean bl, DisplayContext displayContext) {
        LayerRaster layerRaster = (LayerRaster)this.layer;
        Image image = layerRaster.getImage();
        if (image != null) {
            if (layerRaster.fixedPosition != null) {
                Graphics graphics = displayContext.getDrawToGraphics();
                if (graphics == null) {
                    return;
                }
                graphics.drawImage(image, layerRaster.fixedPosition.x, layerRaster.fixedPosition.y, displayContext.getComponent());
            } else {
                RendererImage.drawImage(image, layerRaster.getLayerExtent(), displayContext);
            }
        }
    }

    public static boolean calculateImageCoords(Dimension dimension, Rectangle rectangle, Rectangle rectangle2, FloatRectangle floatRectangle, DisplayContext displayContext) {
        boolean bl = false;
        Graphics graphics = displayContext.getDrawToGraphics();
        FloatRectangle floatRectangle2 = displayContext.getLastExtent();
        if (dimension.width > 0 && dimension.height > 0 && graphics != null && floatRectangle2 != null) {
            double d = floatRectangle2.x;
            double d2 = floatRectangle2.y2;
            double d3 = floatRectangle2.x2;
            double d4 = floatRectangle2.y;
            double d5 = floatRectangle.x;
            double d6 = floatRectangle.y2;
            double d7 = floatRectangle.x2;
            double d8 = floatRectangle.y;
            double d9 = (d7 - d5) / (1.0 * (double)dimension.width);
            double d10 = (d6 - d8) / (1.0 * (double)dimension.height);
            if (d <= d7 && d3 >= d5 && d2 >= d8 && d4 <= d6) {
                d = Math.max(d, d5);
                d3 = Math.min(d3, d7);
                d2 = Math.min(d2, d6);
                d4 = Math.max(d4, d8);
                int n = Math.max(0, (int)Math.floor((d - d5) / d9 - 0.0));
                int n2 = Math.max(0, (int)Math.floor((d6 - d2) / d10 - 0.0));
                int n3 = Math.min(dimension.width, (int)Math.ceil((d3 - d5) / d9 + 1.0));
                int n4 = Math.min(dimension.height, (int)Math.ceil((d6 - d4) / d10 + 1.0));
                d = d5 + (double)n * d9;
                d3 = d5 + (double)n3 * d9;
                d2 = d6 - (double)n2 * d10;
                d4 = d6 - (double)n4 * d10;
                Projection projection = displayContext.getProjection();
                double d11 = projection.zoom;
                double d12 = projection.shift.x;
                double d13 = projection.shift.y;
                int n5 = (int)((d + d12) * d11);
                int n6 = (int)((d3 + d12) * d11);
                int n7 = (int)((d13 - d2) * d11);
                int n8 = (int)((d13 - d4) * d11);
                rectangle.x = n;
                rectangle.y = n2;
                rectangle.width = n3 - n;
                rectangle.height = n4 - n2;
                rectangle2.x = n5;
                rectangle2.y = n7;
                rectangle2.width = n6 - n5;
                rectangle2.height = n8 - n7;
                bl = rectangle.width * rectangle.height > 0 && rectangle2.width * rectangle2.height > 0;
            }
        }
        return bl;
    }

    public static void drawImage(Image image, FloatRectangle floatRectangle, DisplayContext displayContext) {
        Dimension dimension;
        boolean bl;
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        if (image != null && (bl = RendererImage.calculateImageCoords(dimension = new Dimension(image.getWidth(displayContext.getComponent()), image.getHeight(displayContext.getComponent())), rectangle, rectangle2, floatRectangle, displayContext))) {
            displayContext.getDrawToGraphics().drawImage(image, rectangle2.x, rectangle2.y, rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, displayContext.getComponent());
        }
    }
}

