/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.alov.map.DisplayContext;
import org.alov.map.FieldDef;
import org.alov.map.FilterExpression;
import org.alov.map.FloatPoint;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.MapUtils;
import org.alov.map.Projection;
import org.alov.map.Record;
import org.alov.map.Renderer;
import org.alov.map.Shape;
import org.alov.map.Symbol;
import org.alov.map.Utils2D;
import org.alov.util.Strings;

public class RendererLabel
extends Renderer {
    public int[] labelFieldIndex = null;
    public int symbolFieldIndex = 0;
    public int houseFromLeftFieldIndex = 0;
    public int houseToLeftFieldIndex = 0;
    public int houseFromRightFieldIndex = 0;
    public int houseToRightFieldIndex = 0;
    public String labelFieldName = null;
    public String symbolFieldName = null;
    public String houseNumberFieldNames = null;
    public String rotationFieldName = null;
    public String sizeFieldName = null;
    protected int rotationFieldIndex = -1;
    protected int sizeFieldIndex = -1;
    public boolean drawDefault = false;
    public boolean notOverlap = true;
    private static final byte DRAW_IN_CENTROID = 0;
    private static final byte DRAW_ALONG_LINE = 1;
    private static final byte DRAW_ROTATE = 2;
    private static final byte DRAW_IN_FRAME = 3;
    private static final byte DRAW_IN_BULB = 4;
    static final double UNION_EPS = 1.0E-5;
    private static final byte STREETS_DRAW_ALL = 0;
    private static final byte STREETS_DRAW_FIRST = 1;
    private static final byte STREETS_DRAW_UNITED = 2;
    public int streetDrawingMode = 0;
    private Vector recordsToPaint = null;
    private Vector recsAndStreets = null;
    private boolean unitedPainting = false;
    private Vector drawedStreets = null;
    static final double std_offset_from_line = 20.0;
    static final double std_offset_from_ends = 20.0;

    public RendererLabel(Layer layer) {
        super(layer);
    }

    private String getLabelString(Record record) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.labelFieldIndex.length; ++i) {
            stringBuffer.append(this.layer.getFieldString(record, this.labelFieldIndex[i])).append(" ");
        }
        return stringBuffer.toString().trim();
    }

    public void paintRecord(Record record, boolean bl, DisplayContext displayContext) {
        int n;
        int n2;
        Serializable serializable;
        if (bl) {
            return;
        }
        Graphics graphics = displayContext.getDrawToGraphics();
        int n3 = record.getShapeCount();
        String string = this.getDrawStreetName(this.getLabelString(record));
        if (graphics == null || n3 == 0 || Strings.isNullOrBlank(string)) {
            return;
        }
        if (!this.unitedPainting && this.streetDrawingMode == 2) {
            this.recordsToPaint.addElement(record);
            return;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (this.houseNumberFieldNames != null) {
            n4 = (int)this.layer.getFieldDouble(record, this.houseFromLeftFieldIndex);
            n5 = (int)this.layer.getFieldDouble(record, this.houseToLeftFieldIndex);
            n6 = (int)this.layer.getFieldDouble(record, this.houseFromRightFieldIndex);
            n7 = (int)this.layer.getFieldDouble(record, this.houseToRightFieldIndex);
        }
        Symbol symbol = null;
        Symbol[] symbolArray = this.symbols;
        boolean bl2 = false;
        int n8 = symbolArray.length;
        if (this.symbolFieldIndex < 0) {
            for (int i = 0; i < n8; ++i) {
                Symbol symbol2 = symbolArray[i];
                if (symbol2.value == null || !symbol2.value.equals("") && !((FilterExpression)symbol2.value).checkRecord(record)) continue;
                symbol = symbol2;
                break;
            }
        } else {
            Object object = this.layer.getFieldValue(record, this.symbolFieldIndex);
            for (int i = 0; i < n8; ++i) {
                serializable = symbolArray[i];
                n2 = MapUtils.compare(object, serializable.value);
                if (n2 != this.equal) continue;
                if (symbol == null || MapUtils.compare(serializable.value, symbol.value) == this.equal) {
                    symbol = serializable;
                }
                if (this.equal != 0) {
                    continue;
                }
                break;
            }
        }
        if (symbol == null || !symbol.visible || Strings.isNullOrBlank(symbol.fontName)) {
            return;
        }
        Projection projection = displayContext.getProjection();
        int n9 = n = symbol.sizeFieldIndex >= 0 ? symbol.sizeFieldIndex : this.sizeFieldIndex;
        if (n >= 0 || symbol.useZoom || symbol.font == null) {
            int n10 = symbol.size;
            if (n >= 0) {
                Object object = this.layer.getFieldValue(record, n);
                n10 = (int)((float)Strings.objToInt(object, n10) * symbol.factor);
            } else if (symbol.useZoom) {
                double d = (double)(symbol.maxSize - symbol.minSize) / (Math.log(projection.minzoom) - Math.log(projection.maxzoom));
                n10 = (int)Math.abs(Math.round((Math.log(projection.zoom) - Math.log(projection.maxzoom)) * d));
                if (n10 < symbol.minSize) {
                    n10 = symbol.minSize;
                }
            }
            symbol.font = MapUtils.createAndVerifyFont(symbol.fontName, symbol.fontStyle, n10, string);
            if (symbol.useZoom || n10 > 20 || n10 < 8) {
                int n11 = symbol.size > 20 || symbol.size < 8 ? 12 : symbol.size;
                symbol.sampleFont = MapUtils.createAndVerifyFont(symbol.fontName, symbol.fontStyle, n11, string);
            } else {
                symbol.sampleFont = symbol.font;
            }
            if (symbol.font == null) {
                System.out.println(">>Can't set font " + symbol.fontName);
                symbol.fontName = null;
                return;
            }
        }
        graphics.setFont(symbol.font);
        serializable = record.getRecordExtent().getCentre();
        n2 = (int)((((FloatPoint)serializable).x + projection.shift.x) * projection.zoom);
        int n12 = (int)((-((FloatPoint)serializable).y + projection.shift.y) * projection.zoom);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n13 = fontMetrics.stringWidth(string);
        int n14 = fontMetrics.getHeight();
        int n15 = n2;
        int n16 = n12;
        if (symbol.style >= 4) {
            graphics.setColor(symbol.fillColor);
            for (int i = 0; i < n3; ++i) {
                Shape shape = record.getShape(i);
                if (shape.xCoords == null || shape.yCoords == null) continue;
                int n17 = shape.xCoords.length;
                double d = 0.0;
                for (int j = 1; j < n17; ++j) {
                    double d2 = (shape.xCoords[j] + shape.xCoords[j - 1]) / 2.0;
                    double d3 = (shape.yCoords[j] + shape.yCoords[j - 1]) / 2.0;
                    int n18 = (int)((d2 + projection.shift.x) * projection.zoom);
                    int n19 = (int)((-d3 + projection.shift.y) * projection.zoom);
                    FloatPoint floatPoint = new FloatPoint(shape.xCoords[j - 1], shape.yCoords[j - 1]);
                    FloatPoint floatPoint2 = new FloatPoint(shape.xCoords[j], shape.yCoords[j]);
                    double d4 = MapUtils.getDistance(floatPoint, floatPoint2, 0);
                    d4 = MapUtils.convertDistance(d4, 2, 6);
                    double d5 = Math.atan2(floatPoint2.y - floatPoint.y, floatPoint2.x - floatPoint.x);
                    if ((d5 = Math.toDegrees(d5) - 90.0) < 0.0) {
                        d5 = 360.0 + d5;
                    }
                    double d6 = d5 = d5 == 0.0 ? d5 : 360.0 - d5;
                    if (symbol.style == 4) {
                        d = 0.0;
                    }
                    graphics.drawString(Strings.doubleToStr(d5 - d >= 0.0 ? d5 - d : d5 - d + 360.0, 100) + " x " + Strings.doubleToStr(d4, 10), n18, n19);
                    d = d5;
                }
            }
            return;
        }
        if (symbol.position != 1) {
            switch (symbol.position) {
                case 0: {
                    n2 -= n13 / 2;
                    n12 += n14 / 2;
                    break;
                }
                case 1: {
                    n12 -= 2;
                    break;
                }
                case 2: {
                    n12 += n14 / 2;
                    break;
                }
                case 3: {
                    n12 = n12 + 2 + n14;
                    break;
                }
                case 4: {
                    n2 -= n13 / 2;
                    n12 = n12 + 2 + n14;
                    break;
                }
                case 5: {
                    n2 -= n13;
                    n12 = n12 + 2 + n14;
                    break;
                }
                case 6: {
                    n2 -= n13;
                    n12 += n14 / 2;
                    break;
                }
                case 7: {
                    n2 -= n13;
                    n12 -= 2;
                    break;
                }
                case 8: {
                    n2 -= n13 / 2;
                    n12 -= 2;
                }
            }
        }
        n2 += symbol.xOffset;
        n12 += symbol.yOffset;
        Shape shape = record.getShape(0);
        int n20 = symbol.rotationFieldIndex >= 0 ? symbol.rotationFieldIndex : this.rotationFieldIndex;
        double d = 0.0;
        if (n20 >= 0) {
            Object object = this.layer.getFieldValue(record, n20);
            d = -(MapUtils.toDoubleDef(object, d) / 180.0 * 3.1415927410125732);
        } else {
            d = symbol.rotation;
        }
        boolean bl3 = d != 0.0;
        Object object = null;
        if (symbol.align > 2) {
            graphics.setColor(symbol.outlineColor);
            if (bl3) {
                object = Utils2D.getTransform(graphics);
                Utils2D.rotateGraphics(graphics, n2, n12, d);
            }
            if (symbol.align == 4) {
                int[] nArray = new int[7];
                int[] nArray2 = new int[7];
                nArray[0] = n2;
                nArray2[0] = n12;
                nArray[1] = nArray[0];
                nArray2[1] = nArray2[0] - 10;
                nArray[2] = nArray[0] - 5;
                nArray2[2] = nArray2[1];
                nArray[3] = nArray[0] - 5;
                nArray2[3] = nArray2[1] - n14 - 2;
                nArray[4] = nArray[3] + n13 + 3;
                nArray2[4] = nArray2[3];
                nArray[5] = nArray[4];
                nArray2[5] = nArray2[1];
                nArray[6] = nArray[0] + 5;
                nArray2[6] = nArray2[1];
                nArray[0] = n15;
                nArray2[0] = n16;
                graphics.fillPolygon(nArray, nArray2, 7);
                graphics.setColor(symbol.fillColor);
                graphics.drawPolygon(nArray, nArray2, 7);
                graphics.drawString(string, nArray[3] + 2, nArray2[1] - 2);
            } else {
                int[] nArray = new int[4];
                int[] nArray3 = new int[4];
                nArray[0] = n2;
                nArray3[0] = n12;
                nArray[1] = n2;
                nArray3[1] = n12 - n14 - 2;
                nArray[2] = n2 + n13 + 3;
                nArray3[2] = nArray3[1];
                nArray[3] = nArray[2];
                nArray3[3] = nArray3[0];
                graphics.fillPolygon(nArray, nArray3, 4);
                graphics.setColor(symbol.fillColor);
                graphics.drawPolygon(nArray, nArray3, 4);
                graphics.drawString(string, nArray[1] + 2, nArray3[0] - 2);
            }
            if (bl3) {
                Utils2D.setTransform(graphics, object);
            }
        } else if (this.layer.isObjectType(2) && symbol.align > 0) {
            Dimension dimension = displayContext.getSize();
            if (Utils2D.have2d() && symbol.align == 2) {
                if (MapUtils.isNotEmpty(this.recsAndStreets)) {
                    int n21 = this.recsAndStreets.indexOf(record);
                    symbol.position = 0;
                    Utils2D.textAlongLine(graphics, (Shape)this.recsAndStreets.elementAt(n21 + 1), string, projection, symbol, dimension);
                } else {
                    Utils2D.textAlongLine(graphics, shape, string, projection, symbol, dimension, this.streetDrawingMode == 0);
                }
                if (this.houseNumberFieldNames != null) {
                    FloatPoint floatPoint = null;
                    int[] nArray = new int[]{n4, n5, n6, n7};
                    for (int i = 0; i < nArray.length; ++i) {
                        int n22;
                        double d7;
                        double d8;
                        int n23 = nArray[i];
                        if (n23 <= 0 || (floatPoint = RendererLabel.findHouseXY(this.layer, record, n23, n4, n5, n6, n7, d8 = 10.0 / projection.zoom, d7 = 10.0 / projection.zoom)) == null) continue;
                        String string2 = "" + n23;
                        int n24 = (int)((floatPoint.x + projection.shift.x) * projection.zoom);
                        int n25 = (int)((-floatPoint.y + projection.shift.y) * projection.zoom);
                        int n26 = fontMetrics.stringWidth(string2);
                        if (!this.needDraw(displayContext, n24 -= n26 / 2, n25, n26, n22 = fontMetrics.getHeight())) continue;
                        graphics.setColor(symbol.fillColor);
                        graphics.drawString(string2, n24, n25);
                    }
                }
            } else {
                RendererLabel.textAlongLine(graphics, shape, string, projection, symbol, dimension);
            }
        } else if (this.needDraw(displayContext, n2, n12, n13, n14)) {
            if (bl3) {
                object = Utils2D.getTransform(graphics);
                Utils2D.rotateGraphics(graphics, n2, n12, d);
            }
            if (symbol.outline) {
                graphics.setColor(symbol.outlineColor);
                graphics.drawString(string, n2 + 1, n12 + 1);
            }
            graphics.setColor(symbol.fillColor);
            graphics.drawString(string, n2, n12);
            if (bl3) {
                Utils2D.setTransform(graphics, object);
            }
        }
    }

    private boolean needDraw(DisplayContext displayContext, int n, int n2, int n3, int n4) {
        boolean bl = true;
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        if (this.notOverlap) {
            int n5 = displayContext.getUsedSpaces().size();
            for (int i = 0; i < n5; ++i) {
                Rectangle rectangle2 = (Rectangle)displayContext.getUsedSpaces().elementAt(i);
                if (!rectangle2.intersects(rectangle)) continue;
                bl = false;
                break;
            }
        }
        if (bl && this.notOverlap) {
            displayContext.getUsedSpaces().addElement(rectangle);
        }
        return bl;
    }

    protected void prepare() throws Exception {
        String string;
        int n;
        int n2;
        FieldDef fieldDef = this.layer.getFieldDef_(this.layer.getFieldIndex(this.symbolFieldName));
        this.symbolFieldIndex = fieldDef != null ? fieldDef.index : -1;
        this.prepareSymbols(fieldDef);
        if (this.symbolFieldName != null && this.symbolFieldIndex < 0) {
            throw new Exception("  Renderer: " + this.name + "  " + this.symbolFieldName);
        }
        this.rotationFieldIndex = this.layer.getFieldIndex(this.rotationFieldName);
        this.sizeFieldIndex = this.layer.getFieldIndex(this.sizeFieldName);
        if (this.rotationFieldName != null && this.rotationFieldIndex < 0) {
            throw new Exception("  Renderer: " + this.name + "  " + this.rotationFieldName);
        }
        if (this.sizeFieldName != null && this.sizeFieldIndex < 0) {
            throw new Exception("  Renderer: " + this.name + "  " + this.sizeFieldName);
        }
        if (this.symbols == null || this.symbols.length == 0) {
            throw new Exception("  Renderer: " + this.name + "  " + "No Symbols");
        }
        if (!Strings.isNullOrBlank(this.labelFieldName)) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.labelFieldName, " ,;");
            this.labelFieldIndex = new int[stringTokenizer.countTokens()];
            n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                n = this.layer.getFieldIndex(string2);
                if (n < 0) {
                    throw new Exception("  Renderer: " + this.name + "  " + string2);
                }
                this.labelFieldIndex[n2] = n;
                ++n2;
            }
        }
        if (this.labelFieldIndex == null || this.labelFieldIndex.length == 0) {
            throw new Exception("  Renderer: " + this.name + "  " + this.labelFieldName);
        }
        int n3 = this.symbols.length;
        n2 = this.equal > 0 ? 1 : 0;
        int n4 = this.equal < 0 ? 1 : 0;
        for (n = 0; n < n3; ++n) {
            string = this.symbols[n].label;
            if (string != null) continue;
            if (this.symbolFieldIndex >= 0) {
                if (this.equal == 0) {
                    string = "" + this.symbols[n].value;
                } else if (n3 >= 2) {
                    string = n == 0 ? "... " + this.symbols[n + n2].value : (n < n3 - 1 ? this.symbols[n].value + " ... " + this.symbols[n + 1].value : this.symbols[n - n4].value + " ...");
                }
            } else {
                string = "Sample";
            }
            this.symbols[n].label = string;
        }
        if (this.houseNumberFieldNames != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.houseNumberFieldNames, " ,;");
            string = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
            String string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
            String string4 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
            String string5 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
            this.houseFromLeftFieldIndex = this.layer.getFieldIndex(string);
            this.houseToLeftFieldIndex = this.layer.getFieldIndex(string3);
            this.houseFromRightFieldIndex = this.layer.getFieldIndex(string4);
            this.houseToRightFieldIndex = this.layer.getFieldIndex(string5);
            if (this.houseFromLeftFieldIndex < 0 || this.houseToLeftFieldIndex < 0 || this.houseFromRightFieldIndex < 0 || this.houseToRightFieldIndex < 0) {
                throw new Exception("  Renderer: " + this.name + "  " + this.houseNumberFieldNames);
            }
        }
        this.isPrepared = true;
    }

    int getLevel() {
        return 100 * (this.layer.drawOrder + 1) + 60;
    }

    static void textAlongLine(Graphics graphics, Shape shape, String string, Projection projection, Symbol symbol, Dimension dimension) {
        int n;
        int n2;
        int n3;
        int n4;
        if (string == null || shape == null || shape.xCoords == null) {
            return;
        }
        double[] dArray = shape.xCoords;
        int n5 = dArray.length;
        if (n5 < 2) {
            return;
        }
        int n6 = string.length();
        if (n6 <= 0) {
            return;
        }
        char[] cArray = new char[n6];
        int[] nArray = new int[n6];
        int[] nArray2 = new int[n6];
        int n7 = 0;
        int n8 = dimension.width;
        int n9 = dimension.height;
        double[] dArray2 = shape.yCoords;
        int[] nArray3 = new int[n5];
        int[] nArray4 = new int[n5];
        for (int i = 0; i < n5; ++i) {
            n4 = (int)((dArray[i] + projection.shift.x) * projection.zoom);
            int n10 = (int)((-dArray2[i] + projection.shift.y) * projection.zoom);
            nArray3[i] = n4;
            nArray4[i] = n10;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        n4 = fontMetrics.getAscent() + fontMetrics.getLeading();
        char[] cArray2 = new char[n6];
        int[] nArray5 = new int[n6];
        int n11 = 0;
        for (n3 = 0; n3 < n6; ++n3) {
            int n12;
            cArray2[n3] = string.charAt(n3);
            nArray5[n3] = n12 = fontMetrics.charWidth(cArray2[n3]);
            if (n11 >= n12) continue;
            n11 = n12;
        }
        int n13 = n3 = n4 > n11 ? n4 : n11;
        if (n3 <= 0) {
            return;
        }
        if (nArray3[0] > nArray3[1]) {
            n2 = -1;
            n = n6 - 1;
        } else {
            n2 = 1;
            n = 0;
        }
        int n14 = n;
        Color color = symbol.outline ? symbol.outlineColor : null;
        Color color2 = symbol.fillColor;
        boolean bl = false;
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < n5 - 1; ++i) {
            float f3;
            float f4;
            int n15 = nArray3[i];
            int n16 = nArray4[i];
            float f5 = nArray3[i + 1] - n15;
            float f6 = nArray4[i + 1] - n16;
            float f7 = Math.abs(f5) / (float)n3;
            float f8 = Math.abs(f6) / (float)n3;
            f = f2;
            if (f7 > f8) {
                f4 = f5 / f7;
                f3 = f6 / f7;
                f += f7;
            } else {
                f4 = f5 / f8;
                f3 = f6 / f8;
                f += f8;
            }
            int n17 = (int)f;
            float f9 = f2;
            f2 = f - (float)n17;
            for (int j = 0; j < n17; ++j) {
                float f10 = (float)n15 + f4 * ((float)j + 0.5f - f9);
                float f11 = (float)n16 + f3 * ((float)j + 0.5f - f9);
                if (f10 > 0.0f && f10 < (float)n8 && f11 > 0.0f && f11 < (float)n9) {
                    int n18;
                    if (!bl) {
                        n14 = n;
                        n7 = 0;
                        bl = true;
                    }
                    nArray[n7] = (int)(f10 - (float)(nArray5[n14] / 2));
                    nArray2[n7] = (int)((double)f11 + (double)n4 * 0.3);
                    cArray[n7] = cArray2[n14];
                    if ((n14 += n2) >= n6) {
                        n14 = 0;
                    } else if (n14 < 0) {
                        n14 = n6 - 1;
                    }
                    if (++n7 < n6 && j != n17) continue;
                    if (color != null) {
                        graphics.setColor(color);
                        for (n18 = 0; n18 < n7; ++n18) {
                            graphics.drawChars(cArray, n18, 1, nArray[n18] + 1, nArray2[n18] + 1);
                        }
                    }
                    graphics.setColor(color2);
                    for (n18 = 0; n18 < n7; ++n18) {
                        graphics.drawChars(cArray, n18, 1, nArray[n18], nArray2[n18]);
                    }
                    return;
                }
                bl = false;
            }
        }
    }

    private boolean pointsNear(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int n, int n2) {
        boolean bl = Math.abs(dArray[n] - dArray3[n2]) < 1.0E-5 && Math.abs(dArray2[n] - dArray4[n2]) < 1.0E-5;
        return bl;
    }

    private Shape tryUnitShapes(Shape shape, Shape shape2) {
        Shape shape3;
        block4: {
            int n;
            int n2;
            int n3;
            double[] dArray;
            double[] dArray2;
            double[] dArray3;
            double[] dArray4;
            block5: {
                int n4;
                shape3 = null;
                if (shape == null || shape2 == null) break block4;
                dArray4 = shape.xCoords;
                dArray3 = shape.yCoords;
                dArray2 = shape2.xCoords;
                dArray = shape2.yCoords;
                n3 = dArray4.length;
                n2 = dArray2.length;
                if (!this.pointsNear(dArray4, dArray3, dArray2, dArray, n3 - 1, 0)) break block5;
                shape3 = new Shape();
                shape3.xCoords = new double[n3 + n2];
                shape3.yCoords = new double[n3 + n2];
                for (n4 = 0; n4 < n3; ++n4) {
                    shape3.xCoords[n4] = dArray4[n4];
                    shape3.yCoords[n4] = dArray3[n4];
                }
                for (n4 = 0; n4 < n2; ++n4) {
                    shape3.xCoords[n3 + n4] = dArray2[n4];
                    shape3.yCoords[n3 + n4] = dArray[n4];
                }
                break block4;
            }
            if (!this.pointsNear(dArray4, dArray3, dArray2, dArray, 0, n2 - 1)) break block4;
            shape3 = new Shape();
            shape3.xCoords = new double[n3 + n2];
            shape3.yCoords = new double[n3 + n2];
            for (n = 0; n < n2; ++n) {
                shape3.xCoords[n] = dArray2[n];
                shape3.yCoords[n] = dArray[n];
            }
            for (n = 0; n < n3; ++n) {
                shape3.xCoords[n2 + n] = dArray4[n];
                shape3.yCoords[n2 + n] = dArray3[n];
            }
        }
        return shape3;
    }

    private static boolean valuesOddOrEven(int n, int n2) {
        return n % 2 == n2 % 2;
    }

    private static FloatPoint findHouseXY(Layer layer, Record record, int n, int n2, int n3, int n4, int n5, double d, double d2) {
        double d3 = 20.0 + d;
        double d4 = 20.0 + d2;
        boolean bl = false;
        boolean bl2 = false;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if (record.getShapeCount() == 1) {
            FloatRectangle floatRectangle;
            Shape shape = record.getShape(0);
            if (shape.xCoords.length > 1 && (floatRectangle = new FloatRectangle(shape.xCoords[0], shape.yCoords[0], shape.xCoords[shape.xCoords.length - 1], shape.yCoords[shape.xCoords.length - 1])) != null) {
                boolean bl3;
                double d5 = Math.atan((floatRectangle.y2 - floatRectangle.y) / (floatRectangle.x2 - floatRectangle.x));
                double d6 = Math.sin(d5);
                double d7 = Math.cos(d5);
                boolean bl4 = bl3 = floatRectangle.x > floatRectangle.x2;
                if (bl3) {
                    d4 *= -1.0;
                }
                double d8 = d4 * d7;
                double d9 = d4 * d6;
                floatRectangle.setBounds(floatRectangle.x + d8, floatRectangle.y + d9, floatRectangle.x2 - d8, floatRectangle.y2 - d9);
                if (n2 != 0 && RendererLabel.valuesOddOrEven(n2, n) && n >= n2 && n <= n3) {
                    n6 = n2;
                    n7 = n3;
                    bl = true;
                } else if (n4 != 0 && RendererLabel.valuesOddOrEven(n4, n) && n >= n4 && n <= n5) {
                    n6 = n4;
                    n7 = n5;
                    bl2 = true;
                }
                if (bl || bl2) {
                    n8 = (n7 - n6) / 2 + 1;
                    n9 = (n - n6) / 2 + 1;
                    FloatPoint floatPoint = n8 > 1 ? new FloatPoint(floatRectangle.x + (floatRectangle.x2 - floatRectangle.x) / (double)(n8 - 1) * (double)(n9 - 1), floatRectangle.y + (floatRectangle.y2 - floatRectangle.y) / (double)(n8 - 1) * (double)(n9 - 1)) : floatRectangle.getCentre();
                    if (bl3) {
                        d3 *= -1.0;
                    }
                    d8 = d3 * d6;
                    d9 = d3 * d7;
                    if (bl) {
                        floatPoint.x += d8;
                        floatPoint.y -= d9;
                    }
                    if (bl2) {
                        floatPoint.x -= d8;
                        floatPoint.y += d9;
                    }
                    return floatPoint;
                }
            }
        }
        return null;
    }

    private void prepareStreet(int n, Record record, Shape shape, String string) {
        for (int i = 0; shape != null && i < n; ++i) {
            Shape shape2 = (Shape)this.recsAndStreets.elementAt(i * 3 + 1);
            String string2 = (String)this.recsAndStreets.elementAt(i * 3 + 2);
            if (string.compareTo(string2) != 0 || (shape2 = this.tryUnitShapes(shape, shape2)) == null) continue;
            shape = null;
            this.recsAndStreets.setElementAt(shape2, n * 3 + 1);
            this.recsAndStreets.setElementAt(shape, i * 3 + 1);
            this.prepareStreet(n, record, shape2, string2);
        }
    }

    private void prepareRecsAndStreets(Vector vector) {
        if (this.recsAndStreets == null) {
            this.recsAndStreets = new Vector();
        }
        this.recsAndStreets.removeAllElements();
        for (int i = 0; i < vector.size(); ++i) {
            Record record = (Record)vector.elementAt(i);
            Shape shape = record.getShape(0);
            String string = this.getLabelString(record);
            this.recsAndStreets.addElement(record);
            this.recsAndStreets.addElement(shape);
            this.recsAndStreets.addElement(string);
            this.prepareStreet(i, record, shape, string);
        }
    }

    protected String getDrawStreetName(String string) {
        if (this.drawedStreets != null) {
            String string2 = string + '\u0000';
            int n = this.drawedStreets.size();
            for (int i = 0; i < n; ++i) {
                if (!string2.startsWith((String)this.drawedStreets.elementAt(i))) continue;
                return "";
            }
            this.drawedStreets.addElement(string2);
        }
        return string;
    }

    public void beforePaint(boolean bl, DisplayContext displayContext) {
        if (this.streetDrawingMode == 1) {
            if (this.drawedStreets == null) {
                this.drawedStreets = new Vector();
            }
        } else {
            this.drawedStreets = null;
        }
        if (this.streetDrawingMode == 2) {
            if (this.recordsToPaint == null) {
                this.recordsToPaint = new Vector();
            }
            if (this.recsAndStreets == null) {
                this.recsAndStreets = new Vector();
            }
        } else {
            this.recordsToPaint = null;
            this.recsAndStreets = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPaint(boolean bl, DisplayContext displayContext) {
        if (this.streetDrawingMode == 1) {
            this.drawedStreets.removeAllElements();
        }
        if (this.streetDrawingMode == 2) {
            this.unitedPainting = true;
            try {
                this.prepareRecsAndStreets(this.recordsToPaint);
                int n = this.recordsToPaint.size();
                for (int i = 0; i < n; ++i) {
                    this.paintRecord((Record)this.recordsToPaint.elementAt(i), bl, displayContext);
                }
                Object var6_5 = null;
                this.unitedPainting = false;
                this.recordsToPaint.removeAllElements();
                this.recsAndStreets.removeAllElements();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.unitedPainting = false;
                this.recordsToPaint.removeAllElements();
                this.recsAndStreets.removeAllElements();
                throw throwable;
            }
        }
    }
}

