/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.io.Serializable;
import org.alov.map.FloatRectangle;
import org.alov.map.MapUtils;
import org.alov.map.Projection;
import org.alov.map.Symbol;
import org.alov.map.Utils2D;

public class Shape
implements Serializable {
    private static final int MARKER_CIRCLE = 0;
    public static final int MARKER_SQUARE = 1;
    public static final int MARKER_TRIANGLE = 2;
    public static final int MARKER_CROSS = 3;
    public static final int MARKER_CHAR = 4;
    public static final int MARKER_SHAPE = 5;
    private static final int LINE_SOLID = 0;
    private static final int LINE_DASH = 1;
    private static final int LINE_DOT = 2;
    private static final int LINE_DASHDOT = 3;
    private static final int LINE_DASHDOTDOT = 4;
    private static final int LINE_STRIPE = 5;
    private static final int LINE_ARROW = 6;
    public double[] xCoords = null;
    public double[] yCoords = null;
    public static final byte _BOTH = 0;
    public static final byte _FILL = 1;
    public static final byte _OUTLINE = 2;
    public byte typeFill = 0;

    public Shape() {
    }

    public Shape(double[] dArray) {
        int n = dArray.length / 2;
        this.xCoords = new double[n];
        this.yCoords = new double[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            this.xCoords[n3] = dArray[n2];
            this.yCoords[n3] = dArray[n2 + 1];
            ++n3;
            n2 += 2;
        }
    }

    public static void drawBoldLine(Graphics graphics, int n, int n2, int n3, int n4) {
        if (n < 0 && n2 < 0 && n3 < 0 && n4 < 0) {
            return;
        }
        int[] nArray = new int[]{n, n3};
        int[] nArray2 = new int[]{n2, n4};
        graphics.drawPolyline(nArray, nArray2, 2);
        if (n3 != n) {
            float f = (n4 - n2) / (n3 - n);
            if (!((double)Math.abs(f) > 2.7)) {
                // empty if block
            }
        } else {
            ++n;
            ++n3;
        }
        nArray[0] = ++n;
        nArray[1] = ++n3;
        nArray2[0] = ++n2;
        nArray2[1] = ++n4;
        graphics.drawPolyline(nArray, nArray2, 2);
    }

    private static void drawBoldPolyline(Graphics graphics, int[] nArray, int[] nArray2, int n) {
        if (n < 2) {
            return;
        }
        for (int i = 1; i < n; ++i) {
            Shape.drawBoldLine(graphics, nArray[i - 1], nArray2[i - 1], nArray[i], nArray2[i]);
        }
    }

    private static void drawCustomLine(Graphics graphics, int[] nArray, int[] nArray2, Symbol symbol) {
        int n = nArray.length;
        if (symbol.style == 0 || symbol.style == 5 || symbol.style == 6) {
            if (symbol.size == 2) {
                Shape.drawBoldPolyline(graphics, nArray, nArray2, n);
                return;
            }
            graphics.drawPolyline(nArray, nArray2, n);
            if (symbol.style == 0) {
                return;
            }
        }
        double d = (double)symbol.step / 4.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n2 = 1;
        int n3 = 0;
        boolean bl = symbol.style == 1 || symbol.style == 3 || symbol.style == 4;
        int n4 = 1;
        for (int i = 1; i < n; ++i) {
            int n5 = nArray[i] - nArray[i - n4];
            int n6 = nArray2[i] - nArray2[i - n4];
            double d6 = Math.sqrt(n5 * n5 + n6 * n6);
            if (d6 > 0.0) {
                double d7;
                double d8;
                double d9;
                d2 = (double)n6 / d6;
                d3 = (double)n5 / d6;
                if (n5 == 0) {
                    d9 = d2 * (double)symbol.step;
                    d8 = d2 * (double)symbol.step / 2.0;
                    d7 = d2 * d;
                    d4 = 0.0;
                } else {
                    d4 = 1.0 * (double)n6 / (double)n5;
                    d5 = (double)nArray2[i - n4] - d4 * (double)nArray[i - n4];
                    d9 = d3 * (double)symbol.step;
                    d8 = d3 * (double)symbol.step / 2.0;
                    d7 = d3 * d;
                }
                int n7 = (int)(d3 * 3.0);
                int n8 = (int)(d2 * 3.0);
                double d10 = nArray[i - n4];
                double d11 = nArray2[i - n4];
                double d12 = nArray[i - n4];
                double d13 = nArray2[i - n4];
                double d14 = 0.0;
                while (true) {
                    boolean bl2;
                    boolean bl3 = bl2 = bl && n2 > 0 && n3 == 0;
                    if (n5 == 0) {
                        d13 = d11 + d7;
                        d14 = (d13 - (double)nArray2[i - n4]) / d2;
                    } else {
                        d12 = d10 + d7;
                        d13 = d4 * d12 + d5;
                        d14 = (d12 - (double)nArray[i - n4]) / d3;
                    }
                    if (d14 > d6 || d6 == 0.0 || d14 <= 0.0) {
                        if (!bl2) break;
                        if (symbol.size == 2) {
                            Shape.drawBoldLine(graphics, (int)d10, (int)d11, nArray[i], nArray2[i]);
                            break;
                        }
                        graphics.drawLine((int)d10, (int)d11, nArray[i], nArray2[i]);
                        break;
                    }
                    if (bl2) {
                        if (symbol.size == 2) {
                            Shape.drawBoldLine(graphics, (int)d10, (int)d11, (int)d12, (int)d13);
                        } else {
                            graphics.drawLine((int)d10, (int)d11, (int)d12, (int)d13);
                        }
                        n2 = 0;
                    } else {
                        ++n2;
                    }
                    d10 = d12;
                    d11 = d13;
                    if (symbol.style == 5) {
                        graphics.drawLine((int)(d10 - (double)n8), (int)(d11 + (double)n7), (int)(d10 + (double)n8), (int)(d11 - (double)n7));
                    } else if (symbol.style == 2 || n3 == 1 || symbol.style == 4 && n3 == 2) {
                        if (symbol.size == 2) {
                            graphics.fillRect((int)d10 - 1, (int)d11 - 1, 2, 2);
                        } else {
                            graphics.fillRect((int)d10, (int)d11, 1, 1);
                        }
                    }
                    if (symbol.style == 3 && n3 < 2 || symbol.style == 4 && n3 < 3) {
                        n2 = 0;
                        ++n3;
                        d = symbol.step / 2;
                        d7 = d8;
                        continue;
                    }
                    n3 = 0;
                    d = symbol.step;
                    d7 = d9;
                }
                if (symbol.style == 6) {
                    int[] nArray3 = new int[]{nArray[i], nArray[i] - 6, nArray[i] - 6};
                    int[] nArray4 = new int[]{nArray2[i], nArray2[i] - 3, nArray2[i] + 3};
                    float f = (float)Math.atan2(n6, n5);
                    MapUtils.rotate_coords(nArray3, nArray4, nArray[i], nArray2[i], f);
                    graphics.fillPolygon(nArray3, nArray4, 3);
                }
                d = d14 - d6;
                n4 = 1;
                continue;
            }
            ++n4;
        }
    }

    public static void drawPoint(Graphics graphics, Symbol symbol, int n, int n2) {
        n += symbol.xOffset;
        n2 += symbol.yOffset;
        Image image = symbol.image;
        if (image != null) {
            int n3 = image.getWidth(null);
            int n4 = image.getHeight(null);
            if (n3 < 0) {
                n3 = 0;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            n3 = n - n3 / 2;
            n4 = n2 - n4 / 2;
            Object object = null;
            if (symbol.rotation != 0.0f) {
                object = Utils2D.getTransform(graphics);
                Utils2D.rotateGraphics(graphics, n, n2, symbol.rotation);
            }
            graphics.drawImage(image, n3, n4, MapUtils.getGlobalImageObserver());
            if (symbol.rotation != 0.0f) {
                Utils2D.setTransform(graphics, object);
            }
            return;
        }
        int n5 = symbol.size;
        int n6 = n - n5 / 2;
        int n7 = n2 - n5 / 2;
        int[] nArray = null;
        int[] nArray2 = null;
        int n8 = 3;
        switch (symbol.style) {
            case 1: {
                nArray = new int[]{n6, n6 + n5, n6 + n5, n6};
                nArray2 = new int[]{n7, n7, n7 + n5, n7 + n5};
                n8 = 4;
            }
            case 2: {
                if (symbol.style == 2) {
                    nArray = new int[]{n6, n, n + n5 / 2};
                    nArray2 = new int[]{n2 + n5 / 2, n7, n2 + n5 / 2};
                }
                MapUtils.rotate_coords(nArray, nArray2, n, n2, symbol.rotation);
                if (symbol.fill) {
                    graphics.setColor(symbol.fillColor);
                    graphics.fillPolygon(nArray, nArray2, n8);
                }
                if (!symbol.outline) break;
                graphics.setColor(symbol.outlineColor);
                graphics.drawPolygon(nArray, nArray2, n8);
                break;
            }
            case 3: {
                if (!symbol.outline) {
                    return;
                }
                nArray = new int[]{n6, n + n5 / 2, n, n};
                nArray2 = new int[]{n2, n2, n7, n2 + n5 / 2};
                MapUtils.rotate_coords(nArray, nArray2, n, n2, symbol.rotation);
                graphics.setColor(symbol.fillColor);
                graphics.drawLine(nArray[0], nArray2[0], nArray[1], nArray2[1]);
                graphics.drawLine(nArray[2], nArray2[2], nArray[3], nArray2[3]);
                break;
            }
            case 4: {
                if (symbol.fontName == null) break;
                if (symbol.font == null) {
                    symbol.font = MapUtils.createAndVerifyFont(symbol.fontName, symbol.fontStyle, symbol.size > 0 ? symbol.size : MapUtils.defaultPlainFont.getSize(), symbol.charMarker);
                    if (symbol.font == null) {
                        System.out.println("Can't set font " + symbol.fontName + " for character " + symbol.charMarker);
                        symbol.fontName = null;
                        return;
                    }
                }
                graphics.setFont(symbol.font);
                graphics.setColor(symbol.fillColor);
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n9 = fontMetrics.stringWidth(symbol.charMarker);
                int n10 = fontMetrics.getHeight();
                n6 = n - n9 / 2;
                n7 = n2 + n10 / 2;
                graphics.drawString(symbol.charMarker, n6, n7);
                break;
            }
            case 5: {
                int n11 = symbol.symbolShape.xCoords.length;
                int[] nArray3 = new int[n11];
                int[] nArray4 = new int[n11];
                for (int i = 0; i < n11; ++i) {
                    nArray3[i] = (int)symbol.symbolShape.xCoords[i] + n;
                    nArray4[i] = (int)symbol.symbolShape.yCoords[i] + n2;
                }
                MapUtils.rotate_coords(nArray3, nArray4, n, n2, symbol.rotation);
                Utils2D.polygon(graphics, nArray3, nArray4, n11, symbol);
                break;
            }
            default: {
                if (symbol.fill) {
                    graphics.setColor(symbol.fillColor);
                    graphics.fillOval(n6, n7, n5, n5);
                }
                if (!symbol.outline) break;
                graphics.setColor(symbol.outlineColor);
                graphics.drawOval(n6, n7, n5, n5);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void paintShape(Shape var0, Graphics var1_1, Projection var2_2, Symbol var3_3, int var4_4) {
        block33: {
            if (var0.xCoords == null || var0.yCoords == null) {
                return;
            }
            var5_5 = true;
            if (var0.typeFill != 0) {
                if (var0.typeFill == 1) {
                    if (!var3_3.fill) {
                        return;
                    }
                    var5_5 = var3_3.outline;
                    var3_3.outline = false;
                } else {
                    if (!var3_3.outline) {
                        return;
                    }
                    var5_5 = var3_3.fill;
                    var3_3.fill = false;
                }
            }
            var6_6 = var0.xCoords.length;
            var7_8 = new int[var0.xCoords.length];
            var8_9 = new int[var0.yCoords.length];
            for (var9_10 = 0; var9_10 < var6_6; ++var9_10) {
                var7_8[var9_10] = (int)((var0.xCoords[var9_10] + var2_2.shift.x) * var2_2.zoom);
                var8_9[var9_10] = (int)((-var0.yCoords[var9_10] + var2_2.shift.y) * var2_2.zoom);
                if (var7_8[var9_10] > 31999) {
                    var7_8[var9_10] = 31999;
                } else if (var7_8[var9_10] < -31999) {
                    var7_8[var9_10] = -31999;
                }
                if (var8_9[var9_10] > 31999) {
                    var8_9[var9_10] = 31999;
                    continue;
                }
                if (var8_9[var9_10] >= -31999) continue;
                var8_9[var9_10] = -31999;
            }
            switch (var4_4) {
                case 1: {
                    Shape.drawPoint(var1_1, var3_3, var7_8[0], var8_9[0]);
                    ** break;
                }
                case 3: {
                    Utils2D.polygon(var1_1, var7_8, var8_9, var6_6, var3_3);
                    ** break;
                }
                case 2: {
                    if (!var3_3.outline) {
                        var11_11 = null;
                        if (var0.typeFill != 0) {
                            if (var0.typeFill == 1) {
                                var3_3.outline = var5_5;
                            } else {
                                var3_3.fill = var5_5;
                            }
                        }
                        return;
                    }
                    ** GOTO lbl53
lbl52:
                    // 2 sources

                    break;
lbl53:
                    // 1 sources

                    if (Utils2D.have2d() && var3_3.g2dStroke != null) {
                        Utils2D.line(var1_1, var7_8, var8_9, var6_6, var3_3);
                        break;
                    }
                    var1_1.setColor(var3_3.outlineColor);
                    Shape.drawCustomLine(var1_1, var7_8, var8_9, var3_3);
                }
            }
            var11_12 = null;
            if (var0.typeFill == 0) break block33;
            if (var0.typeFill == 1) {
                var3_3.outline = var5_5;
            } else {
                var3_3.fill = var5_5;
                {
                    break block33;
                    catch (Exception var6_7) {
                        var11_13 = null;
                        if (var0.typeFill != 0) {
                            if (var0.typeFill == 1) {
                                var3_3.outline = var5_5;
                            } else {
                                var3_3.fill = var5_5;
                            }
                        }
                    }
                }
                catch (Throwable var10_15) {
                    var11_14 = null;
                    if (var0.typeFill != 0) {
                        if (var0.typeFill == 1) {
                            var3_3.outline = var5_5;
                        } else {
                            var3_3.fill = var5_5;
                        }
                    }
                    throw var10_15;
                }
            }
        }
    }

    public static FloatRectangle calculateExtent(Shape shape) {
        if (shape.xCoords == null || shape.yCoords == null) {
            return null;
        }
        double d = shape.xCoords[0];
        double d2 = shape.yCoords[0];
        double d3 = d;
        double d4 = d2;
        for (int i = 1; i < shape.xCoords.length; ++i) {
            if (d < shape.xCoords[i]) {
                d = shape.xCoords[i];
            } else if (d3 > shape.xCoords[i]) {
                d3 = shape.xCoords[i];
            }
            if (d2 < shape.yCoords[i]) {
                d2 = shape.yCoords[i];
                continue;
            }
            if (!(d4 > shape.yCoords[i])) continue;
            d4 = shape.yCoords[i];
        }
        return new FloatRectangle(d3, d4, d, d2);
    }

    public static boolean containsPoint(Shape shape, double d, double d2) {
        if (shape.xCoords == null || shape.yCoords == null) {
            return false;
        }
        if (shape.typeFill == 2) {
            return false;
        }
        double[] dArray = shape.xCoords;
        double[] dArray2 = shape.yCoords;
        int n = 0;
        int n2 = dArray.length;
        double d3 = dArray[n2 - 1];
        double d4 = dArray2[n2 - 1];
        for (int i = 0; i < n2; ++i) {
            double d5 = dArray[i];
            double d6 = dArray2[i];
            if ((d < d3 || d < d5) && (d2 < d4 && d2 >= d6 || d2 < d6 && d2 >= d4)) {
                if (d < d3 && d < d5) {
                    ++n;
                } else if ((d2 - d4) * (d5 - d3) / (d6 - d4) + d3 > d) {
                    ++n;
                }
            }
            d3 = d5;
            d4 = d6;
        }
        return n & true;
    }

    public static boolean isClockWise(Shape shape) {
        int n = shape.xCoords.length - 1;
        double d = shape.xCoords[n] * shape.yCoords[0] - shape.xCoords[0] * shape.yCoords[n];
        for (int i = 0; i < n; ++i) {
            d += shape.xCoords[i] * shape.yCoords[i + 1] - shape.xCoords[i + 1] * shape.yCoords[i];
        }
        return d >= 0.0;
    }

    public void setVertex(int n, double d, double d2) {
        if (n >= 0 && n < this.xCoords.length) {
            this.xCoords[n] = d;
            this.yCoords[n] = d2;
        }
    }
}

