/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.io.IOException;
import java.io.InputStream;
import org.alov.map.Carte;
import org.alov.util.Const;
import org.alov.util.Strings;

public class StreamCounter
extends InputStream
implements Const {
    private InputStream input;
    private long received = 0L;
    private long receivedTot = 0L;
    private long nextStep = 0L;
    private int stepThreshold;
    private long completeSize = 0L;
    private String layerName = "";
    private String completeSizeFormatted = null;
    private Carte map = null;
    public String url = null;
    static final String _MB = " MB";
    static final String _KB = " KB";

    StreamCounter(InputStream inputStream, int n, Carte carte) {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        this.input = inputStream;
        this.stepThreshold = n;
        this.map = carte;
    }

    long getReceived() {
        return this.receivedTot;
    }

    void setCounter(long l, String string) {
        this.received = 0L;
        this.completeSize = l;
        this.layerName = string;
        this.completeSizeFormatted = l > 0x100000L ? Strings.doubleToStr((float)l / 1048576.0f, 10) + _MB : (l > 20480L ? Strings.doubleToStr((float)l / 1024.0f, 10) + _KB : (l > 1024L ? l / 1024L + _KB : String.valueOf(l)));
    }

    void checkStep(int n) {
        if (n > 0) {
            this.received += (long)n;
            this.receivedTot += (long)n;
            if (this.map != null) {
                if (this.completeSize > 0L) {
                    long l = this.received * 100L / this.completeSize;
                    if (l - this.nextStep >= 1L) {
                        String string = l + "% of " + this.completeSizeFormatted + this.layerName;
                        this.map.broadcastMessage(4, string);
                    }
                    this.nextStep = l;
                } else {
                    if (this.received - this.nextStep >= (long)this.stepThreshold) {
                        this.map.broadcastMessage(11, this.received + this.layerName);
                    }
                    this.nextStep = this.received;
                }
            }
        }
    }

    public int read() throws IOException {
        int n = this.input.read();
        this.checkStep(1);
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.input.read(byArray);
        this.checkStep(n);
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.input.read(byArray, n, n2);
        this.checkStep(n3);
        return n3;
    }

    public long skip(long l) throws IOException {
        long l2 = this.input.skip(l);
        this.checkStep(new Long(l2).intValue());
        return l2;
    }

    public int available() throws IOException {
        return this.input.available();
    }

    public void close() throws IOException {
        this.input.close();
    }

    public void mark(int n) {
        this.input.mark(n);
    }

    public void reset() throws IOException {
        this.input.reset();
    }

    public boolean markSupported() {
        return this.input.markSupported();
    }
}

