/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import org.alov.map.MapUtils;
import org.alov.map.Projection;
import org.alov.map.Shape;
import org.alov.map.Symbol;

public class Utils2D {
    private static boolean have2d;
    private Graphics graphics;
    private static Method setStroke;
    private static Method setPaint;
    private static Method setComposite;
    private static Method setTransform;
    private static Method getStroke;
    private static Method getPaint;
    private static Method getComposite;
    private static Method getTransform;
    private static Method setRenderingHint;
    private static Method rotate;
    private static Method createCustomCursor;
    private static Class graphics2dClass;
    private static Class renderingHintsClass;
    private static Object[] oneArgument;
    private static Method deriveFont;

    private Utils2D() {
    }

    public static boolean have2d() {
        return have2d;
    }

    static void setRenderingHint(Graphics graphics, String string, String string2) {
        if (setRenderingHint == null || renderingHintsClass == null) {
            return;
        }
        try {
            Object object = renderingHintsClass.getField(string).get(null);
            Object object2 = renderingHintsClass.getField(string2).get(null);
            setRenderingHint.invoke((Object)graphics, object, object2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static synchronized void setStroke(Graphics graphics, Object object) {
        if (setStroke == null) {
            return;
        }
        Utils2D.oneArgument[0] = object;
        try {
            setStroke.invoke((Object)graphics, oneArgument);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static synchronized void setComposite(Graphics graphics, Object object) {
        if (setComposite == null) {
            return;
        }
        Utils2D.oneArgument[0] = object;
        try {
            setComposite.invoke((Object)graphics, oneArgument);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized void setTransform(Graphics graphics, Object object) {
        if (setTransform == null) {
            return;
        }
        Utils2D.oneArgument[0] = object;
        try {
            setTransform.invoke((Object)graphics, oneArgument);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static synchronized void setPaint(Graphics graphics, Object object) {
        if (setPaint == null) {
            return;
        }
        Utils2D.oneArgument[0] = object;
        try {
            setPaint.invoke((Object)graphics, oneArgument);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Object getStroke(Graphics graphics) {
        if (getStroke == null) {
            return null;
        }
        try {
            return getStroke.invoke((Object)graphics, null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Object getComposite(Graphics graphics) {
        if (getComposite == null) {
            return null;
        }
        try {
            return getComposite.invoke((Object)graphics, null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object getTransform(Graphics graphics) {
        if (getTransform == null) {
            return null;
        }
        try {
            return getTransform.invoke((Object)graphics, null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Object getPaint(Graphics graphics) {
        if (getPaint == null) {
            return null;
        }
        try {
            return getPaint.invoke((Object)graphics, null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static void drawStringRotated(Graphics graphics, String string, int n, int n2, double d, double d2, double d3) {
        Object object = null;
        if (d3 != 0.0) {
            object = Utils2D.getTransform(graphics);
            AffineTransform affineTransform = AffineTransform.getRotateInstance(d, d2, d3);
            Utils2D.setTransform(graphics, affineTransform);
        }
        graphics.drawString(string, n, n2);
        if (object != null) {
            Utils2D.setTransform(graphics, object);
        }
    }

    public static void rotateGraphics(Graphics graphics, double d, double d2, double d3) {
        if (have2d) {
            Utils2D.do_rotate(graphics, d, d2, d3);
        }
    }

    private static void do_rotate(Graphics graphics, double d, double d2, double d3) {
        if (rotate != null) {
            try {
                Object object = Utils2D.getTransform(graphics);
                rotate.invoke(object, new Double(d3), new Double(d), new Double(d2));
                Utils2D.setTransform(graphics, object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static void polygon(Graphics graphics, int[] nArray, int[] nArray2, int n, Symbol symbol) {
        Object object = Utils2D.getStroke(graphics);
        Object object2 = Utils2D.getPaint(graphics);
        Object object3 = Utils2D.getComposite(graphics);
        if (symbol.fill) {
            if (symbol.g2dPaint != null) {
                Utils2D.setPaint(graphics, symbol.g2dPaint);
            } else {
                graphics.setColor(symbol.fillColor);
            }
            if (symbol.g2dPaintComposite != null) {
                Utils2D.setComposite(graphics, symbol.g2dPaintComposite);
            }
            graphics.fillPolygon(nArray, nArray2, n);
        }
        if (symbol.outline) {
            if (symbol.g2dStrokeComposite != null) {
                Utils2D.setComposite(graphics, symbol.g2dStrokeComposite);
            }
            if (MapUtils.isNotEmpty(symbol.g2dStroke)) {
                int n2 = symbol.g2dStroke.size();
                for (int i = 0; i < n2; ++i) {
                    Utils2D.setStroke(graphics, symbol.g2dStroke.elementAt(i));
                    graphics.setColor((Color)symbol.g2dStrokeColours.elementAt(i));
                    graphics.drawPolygon(nArray, nArray2, n);
                }
            } else {
                graphics.setColor(symbol.outlineColor);
                graphics.drawPolygon(nArray, nArray2, n);
            }
        }
        Utils2D.setStroke(graphics, object);
        Utils2D.setPaint(graphics, object2);
        Utils2D.setComposite(graphics, object3);
    }

    static void line(Graphics graphics, int[] nArray, int[] nArray2, int n, Symbol symbol) {
        if (symbol.outline) {
            Object object = null;
            Object object2 = null;
            if (symbol.g2dStrokeComposite != null) {
                object2 = Utils2D.getComposite(graphics);
                Utils2D.setComposite(graphics, symbol.g2dStrokeComposite);
            }
            if (MapUtils.isNotEmpty(symbol.g2dStroke)) {
                object = Utils2D.getStroke(graphics);
                for (int i = 0; i < symbol.g2dStroke.size(); ++i) {
                    Utils2D.setStroke(graphics, symbol.g2dStroke.elementAt(i));
                    graphics.setColor((Color)symbol.g2dStrokeColours.elementAt(i));
                    graphics.drawPolyline(nArray, nArray2, n);
                }
            } else {
                graphics.setColor(symbol.outlineColor);
                graphics.drawPolyline(nArray, nArray2, n);
            }
            Utils2D.setStroke(graphics, object);
            Utils2D.setComposite(graphics, object2);
        }
    }

    static void textAlongLine(Graphics graphics, Shape shape, String string, Projection projection, Symbol symbol, Dimension dimension) {
        Utils2D.textAlongLine(graphics, shape, string, projection, symbol, dimension, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void textAlongLine(Graphics graphics, Shape shape, String string, Projection projection, Symbol symbol, Dimension dimension, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (string == null || shape == null || shape.xCoords == null) {
            return;
        }
        double[] dArray = shape.xCoords;
        int n6 = dArray.length;
        if (n6 < 2) {
            return;
        }
        int n7 = string.length();
        if (n7 <= 0) {
            return;
        }
        char[] cArray = new char[n7];
        int[] nArray = new int[n7];
        int[] nArray2 = new int[n7];
        double[] dArray2 = new double[n7];
        float[] fArray = new float[n7];
        float[] fArray2 = new float[n7];
        int n8 = 0;
        int n9 = dimension.width;
        int n10 = dimension.height;
        double[] dArray3 = shape.yCoords;
        int[] nArray3 = new int[n6];
        int[] nArray4 = new int[n6];
        for (int i = 0; i < n6; ++i) {
            n5 = (int)((dArray[i] + projection.shift.x) * projection.zoom);
            int n11 = (int)((-dArray3[i] + projection.shift.y) * projection.zoom);
            nArray3[i] = n5;
            nArray4[i] = n11;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        n5 = fontMetrics.getAscent() + fontMetrics.getLeading();
        char[] cArray2 = new char[n7];
        int[] nArray5 = new int[n7];
        int n12 = 0;
        for (n4 = 0; n4 < n7; ++n4) {
            cArray2[n4] = string.charAt(n4);
            nArray5[n4] = n3 = fontMetrics.charWidth(cArray2[n4]);
            if (n12 >= n3) continue;
            n12 = n3;
        }
        int n13 = n4 = n5 > n12 ? n5 : n12;
        if (n4 <= 0) {
            return;
        }
        n3 = 0;
        int n14 = 0;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n6 - 1; ++i) {
            d += Math.sqrt((nArray3[i + 1] - nArray3[i]) * (nArray3[i + 1] - nArray3[i]) + (nArray4[i + 1] - nArray4[i]) * (nArray4[i + 1] - nArray4[i]));
        }
        switch (symbol.position) {
            case 0: 
            case 4: 
            case 8: {
                d2 = (d - (double)(n7 * n4)) / 2.0;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                d2 = d - (double)((n7 + 1) * n4);
            }
        }
        if (d2 > 0.0 || !bl) {
            for (int i = 0; i < n6 - 1; ++i) {
                double d3 = Math.sqrt((nArray3[i + 1] - nArray3[i]) * (nArray3[i + 1] - nArray3[i]) + (nArray4[i + 1] - nArray4[i]) * (nArray4[i + 1] - nArray4[i]));
                if (d2 > d3) {
                    d2 -= d3;
                    continue;
                }
                n3 = i;
                if (d3 == 0.0) continue;
                double d4 = d2 / d3;
                int n15 = i;
                nArray3[n15] = (int)((double)nArray3[n15] + (double)(nArray3[i + 1] - nArray3[i]) * d4);
                int n16 = i;
                nArray4[n16] = (int)((double)nArray4[n16] + (double)(nArray4[i + 1] - nArray4[i]) * d4);
                break;
            }
        }
        switch (symbol.position) {
            case 1: 
            case 7: 
            case 8: {
                n14 = -n5 / 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n14 = n5 / 2;
            }
        }
        if (nArray3[n3] > nArray3[n3 + 1]) {
            n2 = -1;
            n = n7 - 1;
        } else {
            n2 = 1;
            n = 0;
        }
        int n17 = n;
        Color color = symbol.outline ? symbol.outlineColor : null;
        Color color2 = symbol.fillColor;
        Object object = Utils2D.getTransform(graphics);
        try {
            boolean bl2 = false;
            float f = 0.0f;
            float f2 = 0.0f;
            for (int i = n3; i < n6 - 1; ++i) {
                float f3;
                float f4;
                int n18 = nArray3[i];
                int n19 = nArray4[i];
                float f5 = nArray3[i + 1] - n18;
                float f6 = nArray4[i + 1] - n19;
                float f7 = Math.abs(f5) / (float)n4;
                float f8 = Math.abs(f6) / (float)n4;
                f = f2;
                if (f7 > f8) {
                    f4 = f5 / f7;
                    f3 = f6 / f7;
                    f += f7;
                } else {
                    f4 = f5 / f8;
                    f3 = f6 / f8;
                    f += f8;
                }
                double d5 = Math.atan2(dArray3[i] - dArray3[i + 1], dArray[i + 1] - dArray[i]);
                int n20 = (int)f;
                float f9 = f2;
                f2 = f - (float)n20;
                for (int j = 0; j < n20; ++j) {
                    float f10 = (float)n18 + f4 * ((float)j + 0.5f - f9);
                    float f11 = (float)n19 + (float)n14 + f3 * ((float)j + 0.5f - f9);
                    if (!bl || f10 > 0.0f && (n9 == 0 || f10 < (float)n9) && f11 > 0.0f && (n10 == 0 || f11 < (float)n10)) {
                        if (!bl2) {
                            n17 = n;
                            bl2 = true;
                        }
                        fArray[n8] = f10;
                        fArray2[n8] = f11;
                        nArray[n8] = (int)(f10 - (float)(nArray5[n17] / 2));
                        nArray2[n8] = (int)((double)f11 + (double)n5 * 0.3);
                        cArray[n8] = cArray2[n17];
                        dArray2[n8] = d5;
                        if ((n17 += n2) >= n7) {
                            n17 = 0;
                        } else if (n17 < 0) {
                            n17 = n7 - 1;
                        }
                        if (++n8 < n7) continue;
                        for (int k = 0; k < n8; ++k) {
                            AffineTransform affineTransform = new AffineTransform();
                            if (n2 < 0) {
                                affineTransform.scale(-1.0, -1.0);
                                affineTransform.translate(-fArray[k] * 2.0f, -fArray2[k] * 2.0f);
                            }
                            affineTransform.rotate(dArray2[k], fArray[k], fArray2[k]);
                            Utils2D.setTransform(graphics, affineTransform);
                            if (color != null) {
                                graphics.setColor(color);
                                graphics.drawChars(cArray, k, 1, nArray[k] + 1, nArray2[k] + 1);
                            }
                            graphics.setColor(color2);
                            graphics.drawChars(cArray, k, 1, nArray[k], nArray2[k]);
                        }
                        return;
                    }
                    bl2 = false;
                }
            }
        }
        finally {
            Utils2D.setTransform(graphics, object);
        }
    }

    public static Cursor createCursor(Image image, String string) throws Exception {
        Cursor cursor = null;
        if (image != null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Point point = new Point(1, 1);
            cursor = (Cursor)createCustomCursor.invoke((Object)toolkit, image, point, string);
        }
        return cursor;
    }

    public static Font createTTF(Font font, int n, float f) throws Exception {
        Font font2 = null;
        if (font != null) {
            font2 = (Font)deriveFont.invoke((Object)font, new Integer(n), new Float(f));
        }
        return font2;
    }

    static {
        int n;
        have2d = false;
        setStroke = null;
        setPaint = null;
        setComposite = null;
        setTransform = null;
        getStroke = null;
        getPaint = null;
        getComposite = null;
        getTransform = null;
        setRenderingHint = null;
        rotate = null;
        createCustomCursor = null;
        graphics2dClass = null;
        renderingHintsClass = null;
        oneArgument = new Object[1];
        deriveFont = null;
        String string = System.getProperty("java.version");
        System.out.println("Java v." + string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n2 = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : 1;
        int n3 = n = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : 3;
        if (n2 > 1 || n > 2) {
            try {
                Object object;
                GenericDeclaration genericDeclaration;
                graphics2dClass = Class.forName("java.awt.Graphics2D");
                renderingHintsClass = Class.forName("java.awt.RenderingHints");
                Class<?> clazz = Class.forName("java.awt.Paint");
                Class<?> clazz2 = Class.forName("java.awt.Stroke");
                Class<?> clazz3 = Class.forName("java.awt.Composite");
                Class<?> clazz4 = Class.forName("java.awt.geom.AffineTransform");
                Class[] classArray = new Class[]{clazz2};
                setStroke = graphics2dClass.getMethod("setStroke", classArray);
                classArray[0] = clazz;
                setPaint = graphics2dClass.getMethod("setPaint", classArray);
                classArray[0] = clazz3;
                setComposite = graphics2dClass.getMethod("setComposite", classArray);
                classArray[0] = clazz4;
                setTransform = graphics2dClass.getMethod("setTransform", classArray);
                getStroke = graphics2dClass.getMethod("getStroke", null);
                getPaint = graphics2dClass.getMethod("getPaint", null);
                getComposite = graphics2dClass.getMethod("getComposite", null);
                getTransform = graphics2dClass.getMethod("getTransform", null);
                Class<?> clazz5 = Class.forName("java.awt.RenderingHints$Key");
                setRenderingHint = graphics2dClass.getMethod("setRenderingHint", clazz5, new Object().getClass());
                Method[] methodArray = clazz4.getMethods();
                int n4 = methodArray.length;
                for (int i = 0; i < n4; ++i) {
                    genericDeclaration = methodArray[i];
                    if (!"rotate".equals(((Method)genericDeclaration).getName()) || (object = ((Method)genericDeclaration).getParameterTypes()) == null || ((Class<?>[])object).length != 3) continue;
                    rotate = genericDeclaration;
                    break;
                }
                Class<?> clazz6 = Class.forName("java.awt.Toolkit");
                genericDeclaration = Class.forName("java.awt.Image");
                createCustomCursor = clazz6.getMethod("createCustomCursor", new Class[]{genericDeclaration, new Point().getClass(), new String().getClass()});
                object = Class.forName("java.awt.Font");
                deriveFont = ((Class)object).getMethod("deriveFont", Integer.TYPE, Float.TYPE);
                have2d = true;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}

