/*
 * Decompiled with CFR 0.152.
 */
package org.alov.util;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.StringTokenizer;
import org.alov.data.SQLConst;
import org.alov.map.MapUtils;

public class Strings {
    private static String TRUE = "true";
    private static String COLON = ":";
    private static byte[] alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes();

    private Strings() {
    }

    public static int arrayContains(String string, String[] stringArray) {
        if (string != null && stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equalsIgnoreCase(stringArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean checkSuffix(String string, String string2) {
        if (Strings.isNullOrBlank(string2)) {
            int n = string.lastIndexOf(".");
            return n < 0 || n < string.length() - 4;
        }
        int n = string.toUpperCase().lastIndexOf(string2.toUpperCase());
        int n2 = string.length() - string2.length();
        return n > 0 && n == n2;
    }

    public static String changeSuffix(String string, String string2) {
        if (Strings.checkSuffix(string, string2)) {
            return string;
        }
        int n = string.lastIndexOf("/");
        int n2 = string.lastIndexOf("\\");
        int n3 = string.lastIndexOf(".");
        if (n3 > n && n3 > n2) {
            string = string.substring(0, n3);
        }
        return string + string2;
    }

    public static boolean isNullOrBlank(String string) {
        return string == null || string.trim().length() < 1;
    }

    public static String doubleToStr(double d, int n) {
        String string = (double)n > 1000000.0 || n == 0 ? String.valueOf(d) : (n == 1 ? String.valueOf(Math.round(d)) : (n > 0 ? String.valueOf((double)Math.round(d * (double)n) / (1.0 * (double)n)) : String.valueOf(Math.round(d / (double)n) * (long)n)));
        return string;
    }

    public static int strToInt(String string, int n) {
        try {
            return string == null ? n : Integer.parseInt(string.trim());
        }
        catch (Exception exception) {
            return n;
        }
    }

    public static int objToInt(Object object, int n) {
        try {
            if (object == null) {
                return n;
            }
            if (object instanceof Number) {
                return ((Number)object).intValue();
            }
            return Double.valueOf((String)object).intValue();
        }
        catch (Exception exception) {
            return n;
        }
    }

    public static boolean isNumeric(String string) {
        try {
            if (Strings.isNullOrBlank(string)) {
                return false;
            }
            Double.valueOf(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Object strToObject(String string, int n) throws Exception {
        if (Strings.isNullOrBlank(string) && (SQLConst.isNumber(n) || n == 1002 || n == 1001)) {
            string = "0";
        }
        switch (n) {
            case -7: 
            case -6: {
                return new Byte(string);
            }
            case 5: {
                return new Short(string);
            }
            case 4: 
            case 1001: {
                return new Integer(string);
            }
            case -5: {
                return new Long(string);
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 1002: {
                return new Float(string);
            }
            case 8: {
                return new Double(string);
            }
            case 1: 
            case 12: 
            case 1003: {
                return string == null ? "" : string;
            }
            case 1005: {
                char c = Character.toUpperCase(string.charAt(0));
                return new Boolean(c == 'Y' || c == 'T' || c == '1');
            }
            case 91: 
            case 92: {
                DateFormat dateFormat = DateFormat.getInstance();
                try {
                    return dateFormat.parse(string);
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                    return null;
                }
            }
            case 1004: {
                int n2 = 0;
                StringTokenizer stringTokenizer = new StringTokenizer(string, COLON);
                int n3 = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : 0;
                int n4 = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : 0;
                int n5 = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : 0;
                int n6 = n2 = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : 255;
                if (n3 < 0 || n4 < 0 || n5 < 0 || n2 < 0 || n3 > 255 || n4 > 255 || n5 > 255 || n2 > 255) {
                    throw new Exception("Color parameter outside of expected range. ");
                }
                try {
                    return new Color(n3, n4, n5, n2);
                }
                catch (Throwable throwable) {
                    return new Color(n3, n4, n5);
                }
            }
            case 1006: {
                int n7 = 0;
                int n8 = 11;
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                string = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens()) {
                    n7 = Integer.valueOf(stringTokenizer.nextToken());
                }
                if (stringTokenizer.hasMoreTokens()) {
                    n8 = Integer.valueOf(stringTokenizer.nextToken());
                }
                return MapUtils.createAndVerifyFont(string, n7, n8, null);
            }
        }
        return null;
    }

    public static String setObj(String string, char c, String string2) {
        int n;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = string.indexOf(c, n2)) >= 0) {
            stringBuffer.append(string.substring(n2, n)).append(string2);
            n2 = n + 1;
        }
        if (n2 < string.length()) {
            stringBuffer.append(string.substring(n2));
        }
        return stringBuffer.toString();
    }

    public static String decode(String string) throws UnsupportedEncodingException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = string.replace('+', ' ');
        int n2 = 0;
        byte[] byArray = null;
        while ((n = string2.indexOf(37, n2)) >= 0) {
            stringBuffer.append(string2.substring(n2, n));
            n2 = n;
            int n3 = string2.length();
            while (n + 2 < n3 && string2.charAt(n) == '%') {
                n += 3;
            }
            if (byArray == null || byArray.length < (n - n2) / 3) {
                byArray = new byte[(n - n2) / 3];
            }
            int n4 = 0;
            while (n2 < n) {
                String string3 = string2.substring(n2 + 1, n2 + 3);
                try {
                    byArray[n4] = (byte)Integer.parseInt(string3, 16);
                    ++n4;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                n2 += 3;
            }
            stringBuffer.append(new String(byArray, 0, n4));
            n2 = n;
        }
        if (n2 < string2.length()) {
            stringBuffer.append(string2.substring(n2));
        }
        return stringBuffer.toString();
    }

    public static String encodeBASE64(byte[] byArray) throws IOException {
        int n;
        boolean bl = false;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 4 / 3);
        while ((n = byteArrayInputStream.read()) != -1) {
            int n2 = byteArrayInputStream.read();
            if (n2 == -1) {
                Strings.writeChars(n, 0, 0, 2, stringBuffer);
                continue;
            }
            int n3 = byteArrayInputStream.read();
            if (n3 == -1) {
                Strings.writeChars(n, n2, 0, 1, stringBuffer);
                continue;
            }
            Strings.writeChars(n, n2, n3, 0, stringBuffer);
        }
        return stringBuffer.toString();
    }

    private static final void writeChars(int n, int n2, int n3, int n4, StringBuffer stringBuffer) throws IOException {
        stringBuffer.append((char)alphabet[n >> 2]);
        stringBuffer.append((char)alphabet[(n & 3) << 4 | n2 >> 4]);
        if (n4 != 2) {
            if (n4 == 1) {
                stringBuffer.append((char)alphabet[(n2 & 0xF) << 2 | n3 >> 6]);
            } else {
                stringBuffer.append((char)alphabet[(n2 & 0xF) << 2 | n3 >> 6]);
                stringBuffer.append((char)alphabet[n3 & 0x3F]);
            }
        }
    }

    public static double time2DeltaExtDate(String string) {
        char[] cArray = new char[]{'y', 'm', 'd', 'h', 'M', 's'};
        double[] dArray = new double[]{365.25, 31.0, 1.0, 0.041666666666666664, 6.944444444444444E-4, 1.1574074074074073E-5};
        double d = 0.0;
        if (!Strings.isNullOrBlank(string)) {
            double d2 = 365.25;
            String string2 = string;
            int n = -1;
            for (int i = 0; i < 6; ++i) {
                n = string2.indexOf(cArray[i]);
                if (0 > n) continue;
                string2 = string2.substring(0, n).trim();
                d2 = dArray[i];
                break;
            }
            try {
                d = Double.valueOf(string2) * d2;
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Error: " + numberFormatException.getMessage() + "\tString: " + string);
            }
        }
        return d;
    }

    public static String includeLastSymbol(String string, char c) {
        if (string.charAt(string.length() - 1) != c) {
            return string + c;
        }
        return string;
    }

    public static String excludeLastSymbol(String string, char c) {
        if (string.charAt(string.length() - 1) == c) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String extractFileName(String string) {
        return string.substring(Math.max(string.lastIndexOf(47), string.lastIndexOf(92)) + 1);
    }

    public static String extractDir(String string) {
        int n = (string = string.replace('\\', '/')).lastIndexOf(47);
        return n > 0 ? string.substring(0, n + 1) : string;
    }

    public static String getAbsPath(String string, String string2) {
        if (string2 != null && string2.indexOf("://") < 0 && string2.indexOf("file:/") < 0) {
            if (string2.indexOf(":\\") == 1 || string2.indexOf(":/") == 1) {
                return "file:/" + string2;
            }
            while ((string2.startsWith("../") || string2.startsWith("..\\")) && string.length() > 0) {
                string = string.substring(0, string.length() - 1);
                string = string.substring(0, string.lastIndexOf(47) + 1);
                string2 = string2.substring(3);
            }
            return string + string2;
        }
        return string2;
    }

    public static void deleteSpaces(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        int n2 = 0;
        int n3 = 0;
        char c = ' ';
        while (n2 < n) {
            char c2;
            if (Character.isWhitespace(c2 = stringBuffer.charAt(n2++)) && Character.isWhitespace(c)) continue;
            stringBuffer.setCharAt(n3++, c2);
            c = c2;
        }
        if (n3 > 0 && Character.isWhitespace(c)) {
            --n3;
        }
        stringBuffer.setLength(n3);
    }
}

