/*
 * Decompiled with CFR 0.152.
 */
package org.alov.util;

import java.awt.Color;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import org.alov.map.FloatRectangle;

public class Writers {
    private static final String EMPTY = "";

    private Writers() {
    }

    public static void writeUTFCond(DataOutputStream dataOutputStream, String string) throws IOException {
        if (string != null) {
            dataOutputStream.write(1);
            dataOutputStream.writeUTF(string);
        } else {
            dataOutputStream.write(0);
        }
    }

    public static void writeString(DataOutputStream dataOutputStream, String string, String string2) throws IOException {
        dataOutputStream.writeUTF(string == null ? string2 : string);
    }

    public static void writeColor(OutputStream outputStream, Color color) throws IOException {
        outputStream.write(color.getRed());
        outputStream.write(color.getGreen());
        outputStream.write(color.getBlue());
    }

    public static void writeFloat(OutputStream outputStream, float f) throws IOException {
        int n = Float.floatToIntBits(f);
        outputStream.write(n & 0xFF);
        outputStream.write((n & 0xFF00) >> 8);
        outputStream.write((n & 0xFF0000) >> 16);
        outputStream.write((n & 0xFF000000) >> 24);
    }

    public static void writeDouble(OutputStream outputStream, double d) throws IOException {
        long l = Double.doubleToLongBits(d);
        outputStream.write((int)l & 0xFF);
        outputStream.write((int)(l & 0xFFL) >> 8);
        outputStream.write((int)(l & 0xFFL) >> 16);
        outputStream.write((int)(l & 0xFFL) >> 24);
        outputStream.write((int)(l & 0xFFL) >> 32);
        outputStream.write((int)(l & 0xFFL) >> 40);
        outputStream.write((int)(l & 0xFFL) >> 48);
        outputStream.write((int)(l & 0xFFL) >> 56);
    }

    public static void writeInt4(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n & 0xFF);
        outputStream.write((n & 0xFF00) >> 8);
        outputStream.write((n & 0xFF0000) >> 16);
        outputStream.write((n & 0xFF000000) >> 24);
    }

    public static void writeRect(OutputStream outputStream, FloatRectangle floatRectangle) throws IOException {
        Writers.writeFloat(outputStream, (float)floatRectangle.x);
        Writers.writeFloat(outputStream, (float)floatRectangle.y);
        Writers.writeFloat(outputStream, (float)floatRectangle.x2);
        Writers.writeFloat(outputStream, (float)floatRectangle.y2);
    }

    public static void writeObject(DataOutputStream dataOutputStream, Object object, int n) throws IOException {
        try {
            switch (n) {
                case -7: 
                case -6: {
                    dataOutputStream.write(object == null ? 0 : (int)((Byte)object).byteValue());
                    break;
                }
                case 5: {
                    dataOutputStream.writeShort(object == null ? 0 : (int)((Short)object).shortValue());
                    break;
                }
                case 4: {
                    dataOutputStream.writeInt(object == null ? 0 : (Integer)object);
                    break;
                }
                case -5: {
                    dataOutputStream.writeLong(object == null ? 0L : (Long)object);
                    break;
                }
                case 2: 
                case 3: {
                    dataOutputStream.writeFloat(object == null ? 0.0f : ((BigDecimal)object).floatValue());
                    break;
                }
                case 6: 
                case 7: {
                    if (object instanceof Double) {
                        dataOutputStream.writeFloat(object == null ? 0.0f : ((Double)object).floatValue());
                        break;
                    }
                    dataOutputStream.writeFloat(object == null ? 0.0f : ((Float)object).floatValue());
                    break;
                }
                case 8: {
                    dataOutputStream.writeDouble(object == null ? 0.0 : (Double)object);
                    break;
                }
                case 1: {
                    dataOutputStream.writeUTF(object == null ? EMPTY : object.toString());
                    break;
                }
                case -1: 
                case 12: {
                    String string = object == null ? EMPTY : (String)object;
                    dataOutputStream.writeUTF(string);
                    break;
                }
                case 91: 
                case 92: {
                    dataOutputStream.writeDouble(object == null ? 0.0 : (Double)object);
                }
            }
        }
        catch (ClassCastException classCastException) {
            String string = object.toString();
            switch (n) {
                case -7: 
                case -6: {
                    dataOutputStream.write(Byte.parseByte(string));
                    break;
                }
                case 5: {
                    dataOutputStream.writeShort(Short.parseShort(string));
                    break;
                }
                case 4: {
                    dataOutputStream.writeInt(Integer.parseInt(string));
                    break;
                }
                case -5: {
                    dataOutputStream.writeLong(Long.parseLong(string));
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: {
                    dataOutputStream.writeFloat(Float.parseFloat(string));
                }
                case 8: {
                    dataOutputStream.writeDouble(Double.parseDouble(string));
                    break;
                }
                case -1: 
                case 12: {
                    dataOutputStream.writeUTF(string);
                }
            }
        }
    }
}

