/*
 * Decompiled with CFR 0.152.
 */
package org.alov.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.alov.util.AlovMapException;
import org.alov.util.Log;
import org.alov.util.Strings;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;
import org.alov.util.closeTag;
import org.alov.util.defTag;
import org.alov.util.infoTag;

public class XmlParser {
    public static Vector messages = null;
    private static int currentPos = 0;
    private static int counter = 0;

    public static int indexOf(char[] cArray, int n, int n2, int n3) {
        for (int i = n2; i < n3; ++i) {
            if (cArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(StringBuffer stringBuffer, int n, int n2, int n3) {
        for (int i = n2; i < n3; ++i) {
            if (stringBuffer.charAt(i) != n) continue;
            return i;
        }
        return -1;
    }

    public static int getFirstWhitespace(StringBuffer stringBuffer, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (!Character.isWhitespace(stringBuffer.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(char[] cArray, String string, int n, int n2) {
        char c = string.charAt(0);
        int n3 = string.length();
        for (int i = n; i < n2; ++i) {
            if (cArray[i] != c) continue;
            boolean bl = true;
            for (int j = 1; j < n3; ++j) {
                if (cArray[j + i] == string.charAt(j)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return i;
        }
        return -1;
    }

    public static XmlElement parseXml(String string) throws AlovMapException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        return XmlParser.parseXml(byteArrayInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XmlElement parseXml(InputStream inputStream) throws AlovMapException {
        Stack<Object> stack;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            messages = new Vector();
            Object object = null;
            currentPos = 0;
            int n = 0;
            InputStreamReader inputStreamReader = null;
            String string = "ISO-8859-1";
            ByteArrayInputStream byteArrayInputStream = null;
            try {
                int n2;
                stack = new Stack<Object>();
                boolean bl = true;
                boolean bl2 = false;
                boolean bl3 = false;
                String string2 = ">";
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
                byte[] byArray = new byte[8192];
                while ((n2 = inputStream.read(byArray)) > 0) {
                    byteArrayOutputStream.write(byArray, 0, n2);
                }
                byArray = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream = null;
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                inputStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, "ISO-8859-1");
                char[] cArray = new char[8192];
                StringBuffer stringBuffer2 = new StringBuffer();
                boolean bl4 = true;
                while ((n2 = inputStreamReader.read(cArray)) > -1) {
                    n += n2;
                    currentPos = 0;
                    while (currentPos < n2) {
                        Object object2;
                        int n3;
                        int n4;
                        if (bl4) {
                            stringBuffer.setLength(0);
                            n4 = XmlParser.indexOf(cArray, 60, currentPos, n2);
                            bl2 = false;
                            if (n4 > currentPos) {
                                stringBuffer2.append(cArray, currentPos, n4 - currentPos);
                            }
                            if (n4 == -1) {
                                stringBuffer2.append(cArray, currentPos, n2 - currentPos);
                                currentPos = n2;
                            } else if (n4 == n2 - 1) {
                                bl4 = false;
                                currentPos = n2;
                            }
                            if (currentPos == n2) {
                                continue;
                            }
                        } else {
                            n4 = -1;
                        }
                        if (n4 > -1) {
                            currentPos = n4 + 1;
                        }
                        if ((n3 = XmlParser.indexOf(cArray, 62, currentPos, n2)) <= -1) {
                            stringBuffer.append(cArray, currentPos, n2 - currentPos);
                            bl4 = false;
                            currentPos = n2;
                            continue;
                        }
                        stringBuffer.append(cArray, currentPos, n3 - currentPos);
                        if (stringBuffer.length() < 1) {
                            throw new AlovMapException("Empty tag. ");
                        }
                        if (!bl3) {
                            switch (stringBuffer.charAt(0)) {
                                case '!': {
                                    bl3 = true;
                                    if (XmlUtils.subBuffer(stringBuffer, 1, 3).toString().equals("--")) {
                                        string2 = "--";
                                        break;
                                    }
                                    if (XmlUtils.subBuffer(stringBuffer, 1, 2).toString().equals("[")) {
                                        string2 = "]";
                                        break;
                                    }
                                    bl3 = false;
                                }
                            }
                        }
                        if (bl3 && !stringBuffer.toString().endsWith(string2)) {
                            bl4 = false;
                            stringBuffer.append('>');
                            currentPos = n3 + 1;
                            continue;
                        }
                        int n5 = stringBuffer.length() - 1;
                        if (stringBuffer.charAt(n5) == '/') {
                            stringBuffer = XmlUtils.subBuffer(stringBuffer, 0, n5);
                            bl2 = true;
                        }
                        Object object3 = XmlParser.parseTag(stringBuffer);
                        bl4 = true;
                        if (object3 instanceof infoTag) {
                            string = XmlUtils.getString("encoding", (XmlElement)object3, "ISO-8859-1");
                            if (!string.equals("ISO-8859-1") && bl) {
                                if (string.equals("UTF-8")) {
                                    string = "UTF8";
                                }
                                byteArrayInputStream.reset();
                                inputStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, string);
                                stringBuffer.setLength(0);
                                bl = false;
                                n2 = -1;
                                n = 0;
                            }
                        } else if (object3 instanceof defTag) {
                            String string3;
                            bl3 = false;
                            object2 = (defTag)object3;
                            if (Strings.isNullOrBlank(((defTag)object2).name) && !Strings.isNullOrBlank(string3 = (String)((defTag)object2).attributes.get("CDATA")) && !stack.empty()) {
                                XmlElement xmlElement = (XmlElement)stack.peek();
                                xmlElement.value = string3;
                            }
                        } else if (object3 instanceof closeTag) {
                            if (stack.empty()) {
                                throw new AlovMapException("Tag missing with name \"" + ((closeTag)object3).name + "\".");
                            }
                            object2 = (XmlElement)stack.peek();
                            if (!((XmlElement)object2).tagName.equals(((closeTag)object3).name)) throw new AlovMapException("End tag \"" + ((closeTag)object3).name + "\" does not correspond start tag \"" + ((XmlElement)object2).tagName + "\".");
                            if (((XmlElement)object2).children.size() == 0 && stringBuffer2.length() > 0) {
                                if (((XmlElement)object2).value == null) {
                                    ((XmlElement)object2).value = XmlUtils.removeObjs(stringBuffer2).trim();
                                }
                                stringBuffer2 = new StringBuffer();
                            }
                            stack.pop();
                            object = object2;
                        } else {
                            stringBuffer2 = new StringBuffer();
                            if (!stack.empty()) {
                                object2 = (XmlElement)stack.peek();
                                ((XmlElement)object2).addChild((XmlElement)object3);
                            }
                            if (!bl2) {
                                stack.push(object3);
                            } else {
                                object = (XmlElement)object3;
                            }
                        }
                        currentPos = n3 < 0 ? n2 : n3 + 1;
                    }
                }
            }
            catch (Exception exception) {
                String string4 = exception.getMessage();
                if (byteArrayInputStream != null) {
                    byteArrayInputStream.reset();
                    Hashtable hashtable = XmlParser.getPos(byteArrayInputStream, n, currentPos, string);
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        String string5 = (String)enumeration.nextElement();
                        Object v = hashtable.get(string5);
                        string4 = string4 + string5 + v + " ";
                    }
                }
                exception.printStackTrace();
                throw new AlovMapException(string4);
            }
            stack = object;
            Object var26_31 = null;
            if (messages.size() <= 0) return stack;
        }
        catch (Throwable throwable) {
            Object var26_32 = null;
            if (messages.size() <= 0) throw throwable;
            for (int i = 0; i < messages.size(); ++i) {
                Log.log(0, (String)messages.elementAt(i));
            }
            throw throwable;
        }
        for (int i = 0; i < messages.size(); ++i) {
            Log.log(0, (String)messages.elementAt(i));
        }
        return stack;
    }

    private static Hashtable getPos(ByteArrayInputStream byteArrayInputStream, int n, int n2, String string) {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        int n3 = 0;
        try {
            int n4;
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, string);
            int n5 = 0;
            int n6 = 0;
            char[] cArray = new char[8192];
            while ((n4 = inputStreamReader.read(cArray)) > -1) {
                n6 += n4;
                int n7 = 0;
                while (n7 < n4) {
                    int n8 = XmlParser.indexOf(cArray, 10, n7, n4);
                    if (n8 > -1) {
                        ++n3;
                        n5 = n7;
                        n7 = n8 + 1;
                    } else {
                        n7 = n4;
                    }
                    if (n6 < n || n7 < n2) continue;
                    hashtable.put("Line number:", new Integer(n3));
                    hashtable.put("Column:", new Integer(n2 - n5 + 1));
                    return hashtable;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashtable;
    }

    private static void parseEl(XmlElement xmlElement, StringBuffer stringBuffer, int n, int n2) throws AlovMapException {
        String string;
        int n3;
        int n4 = 0;
        if (n2 - n < 4) {
            return;
        }
        while ((n3 = XmlParser.indexOf(stringBuffer, 61, n, n2)) > 0) {
            int n5 = XmlParser.indexOf(stringBuffer, 34, n3, n2);
            if (n5 < 0) {
                throw new AlovMapException("Start quote not found.");
            }
            n4 = XmlParser.indexOf(stringBuffer, 34, n5 + 1, n2);
            if (n4 < 0) {
                throw new AlovMapException("End quote not found.");
            }
            string = XmlUtils.subBuffer(stringBuffer, n, n3).toString().trim();
            XmlParser.verifyName(string, n, false);
            xmlElement.addAttribute(string, XmlUtils.removeObjs(XmlUtils.subBuffer(stringBuffer, n5 + 1, n4)));
            n = n4 + 1;
        }
        if (n4 >= 0 && !Strings.isNullOrBlank(string = XmlUtils.subBuffer(stringBuffer, n4 + 1).toString().trim())) {
            messages.addElement("Garbage in element " + xmlElement.tagName + ": " + string);
        }
    }

    public static String getTagName(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    private static Object parseTag(StringBuffer stringBuffer) throws AlovMapException {
        int n = stringBuffer.length();
        char c = stringBuffer.charAt(0);
        switch (c) {
            case '/': {
                String string = XmlUtils.subBuffer(stringBuffer, 1).toString();
                XmlParser.verifyName(string, 1, true);
                closeTag closeTag2 = new closeTag(string);
                return closeTag2;
            }
            case '?': {
                if (stringBuffer.charAt(n - 1) != '?') {
                    throw new AlovMapException("Invalid tag format: <" + XmlUtils.subBuffer(stringBuffer, 0, 10).toString() + "...> ");
                }
                int n2 = XmlParser.getFirstWhitespace(stringBuffer = XmlUtils.subBuffer(stringBuffer, 1, n - 1), 0, n -= 2);
                if (n2 < 0) {
                    return new infoTag(stringBuffer.toString());
                }
                infoTag infoTag2 = new infoTag(XmlUtils.subBuffer(stringBuffer, 0, n2).toString());
                XmlParser.parseEl(infoTag2, stringBuffer, n2 + 1, n);
                return infoTag2;
            }
            case '!': {
                return defTag.parseBuf(stringBuffer, 1);
            }
        }
        int n3 = XmlParser.getFirstWhitespace(stringBuffer, 0, n);
        if (n3 < 0) {
            String string = stringBuffer.toString();
            XmlParser.verifyName(string, 0, true);
            return new XmlElement(XmlParser.getTagName(string));
        }
        String string = XmlUtils.subBuffer(stringBuffer, 0, n3).toString().trim();
        XmlParser.verifyName(string, 0, true);
        XmlElement xmlElement = new XmlElement(XmlParser.getTagName(string));
        XmlParser.parseEl(xmlElement, stringBuffer, n3 + 1, n);
        return xmlElement;
    }

    private static void verifyName(String string, int n, boolean bl) throws AlovMapException {
        if (string.length() < 1) {
            throw new AlovMapException("Empty name is not allowed. ");
        }
        char c = string.charAt(0);
        if (!Character.isLetter(c) && c != '_' && c != ':') {
            ++currentPos;
            throw new AlovMapException("Invalid start character '" + c + "': \"" + string + "\". ");
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        for (int i = 0; i < n2; ++i) {
            c = cArray[i];
            if (Character.isLetterOrDigit(c) || c == '-' || c == '_' || c == '.' || c == ':') continue;
            currentPos += n;
            if (bl) {
                currentPos += i;
            }
            throw new AlovMapException("Invalid character '" + c + "': \"" + string + "\". ");
        }
    }
}

