/*
 * Decompiled with CFR 0.152.
 */
package org.alov.util;

import java.awt.Color;
import java.awt.Font;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.alov.map.FloatRectangle;
import org.alov.util.AlovMapException;
import org.alov.util.Log;
import org.alov.util.Strings;
import org.alov.util.XmlElement;
import org.alov.util.XmlParser;

public class XmlUtils {
    private static String COLON = ":";
    private static String WRONG_OBJECT = "WRONG OBJECT: ";
    public static boolean hasErrors = false;
    public static boolean caseSensitive = false;
    private static final String EQUAL_SPACE = "= ";
    private static final String SPACE_EQUAL = " =";

    public static boolean getElBoolean(String string, XmlElement xmlElement, boolean bl) {
        return (Boolean)XmlUtils.elementValue(string, xmlElement, new Boolean(bl), 1005);
    }

    public static int getElInt(String string, XmlElement xmlElement, int n) {
        return (Integer)XmlUtils.elementValue(string, xmlElement, new Integer(n), 1001);
    }

    public static float getElFloat(String string, XmlElement xmlElement, float f) {
        return ((Float)XmlUtils.elementValue(string, xmlElement, new Float(f), 1002)).floatValue();
    }

    public static String getElString(String string, XmlElement xmlElement, String string2) {
        return (String)XmlUtils.elementValue(string, xmlElement, string2, 1003);
    }

    public static Color getElColor(String string, XmlElement xmlElement, Color color) {
        return (Color)XmlUtils.elementValue(string, xmlElement, color, 1004);
    }

    public static Font getElFont(String string, XmlElement xmlElement, Font font) {
        return (Font)XmlUtils.elementValue(string, xmlElement, font, 1006);
    }

    public static FloatRectangle getElRect(XmlElement xmlElement) {
        FloatRectangle floatRectangle = new FloatRectangle(XmlUtils.getElFloat("xmin", xmlElement, 0.0f), XmlUtils.getElFloat("ymin", xmlElement, 0.0f), XmlUtils.getElFloat("xmax", xmlElement, 0.0f), XmlUtils.getElFloat("ymax", xmlElement, 0.0f));
        if (floatRectangle.x == 0.0 && floatRectangle.y == 0.0 && floatRectangle.x2 == 0.0 && floatRectangle.y2 == 0.0) {
            return null;
        }
        return floatRectangle;
    }

    public static boolean getBoolean(String string, XmlElement xmlElement, boolean bl) {
        return (Boolean)XmlUtils.attrValue(string, xmlElement, new Boolean(bl), 1005);
    }

    public static int getInt(String string, XmlElement xmlElement, int n) {
        return (Integer)XmlUtils.attrValue(string, xmlElement, new Integer(n), 1001);
    }

    public static float getFloat(String string, XmlElement xmlElement, float f) {
        return ((Float)XmlUtils.attrValue(string, xmlElement, new Float(f), 1002)).floatValue();
    }

    public static String getString(String string, XmlElement xmlElement, String string2) {
        return (String)XmlUtils.attrValue(string, xmlElement, string2, 1003);
    }

    public static Color getColor(String string, XmlElement xmlElement, Color color) {
        return (Color)XmlUtils.attrValue(string, xmlElement, color, 1004);
    }

    public static Font getFont(String string, XmlElement xmlElement, Font font) {
        return (Font)XmlUtils.attrValue(string, xmlElement, font, 1006);
    }

    public static FloatRectangle getRect(XmlElement xmlElement) {
        FloatRectangle floatRectangle = new FloatRectangle(XmlUtils.getFloat("xmin", xmlElement, 0.0f), XmlUtils.getFloat("ymin", xmlElement, 0.0f), XmlUtils.getFloat("xmax", xmlElement, 0.0f), XmlUtils.getFloat("ymax", xmlElement, 0.0f));
        return floatRectangle.isZero() ? null : floatRectangle;
    }

    public static String getLangString(String string, XmlElement xmlElement, String string2, String string3) {
        if (string3 != null && string3.length() > 0) {
            XmlElement xmlElement2 = xmlElement.getLangElementByName(string, string3, caseSensitive);
            if (xmlElement2 == null && (string.equals("name") || string.equals("label"))) {
                xmlElement2 = xmlElement.getLangElementByName("title", string3, caseSensitive);
            }
            if (xmlElement2 != null && !Strings.isNullOrBlank(xmlElement2.value)) {
                return xmlElement2.value;
            }
        }
        return XmlUtils.getString(string, xmlElement, string2);
    }

    private static Object getValueUsingScheme(String string, Object object, int n) {
        if (Strings.isNullOrBlank(string)) {
            return object;
        }
        try {
            Object object2 = Strings.strToObject(string, n);
            if (object2 != null) {
                return object2;
            }
        }
        catch (Exception exception) {
            String string2 = "Parameter par=" + string + ". " + exception.getMessage();
            Log.addMessage(114, null, null, string2);
            Log.addMessage(0, null, null, "Assign to default value \"" + object + "\"");
        }
        return object;
    }

    private static Object attrValue(String string, XmlElement xmlElement, Object object, int n) {
        String string2 = xmlElement.getAttributeValue(string);
        return XmlUtils.getValueUsingScheme(string2, object, n);
    }

    private static Object elementValue(String string, XmlElement xmlElement, Object object, int n) {
        String string2 = xmlElement.getElValue(string, null, caseSensitive);
        return XmlUtils.getValueUsingScheme(string2, object, n);
    }

    public static Properties getText(String string, XmlElement xmlElement) {
        XmlElement xmlElement2 = xmlElement.getFirstElementByName(string, caseSensitive);
        return xmlElement2 == null ? null : XmlUtils.makeProperties(xmlElement2.value, " \n\r");
    }

    public static XmlElement parseStream(InputStream inputStream, String string) throws AlovMapException {
        return XmlParser.parseXml(inputStream);
    }

    public static String removeObjs(StringBuffer stringBuffer) {
        int n = -1;
        StringBuffer stringBuffer2 = new StringBuffer();
        int n2 = stringBuffer.length();
        for (int i = 0; i < n2; ++i) {
            char c = stringBuffer.charAt(i);
            if (n < 0) {
                if (c == '&') {
                    n = i;
                    continue;
                }
                stringBuffer2.append(c);
                continue;
            }
            if (c != ';') continue;
            if (stringBuffer.charAt(n + 1) == 'a' && stringBuffer.charAt(n + 2) == 'm' && stringBuffer.charAt(n + 3) == 'p') {
                stringBuffer2.append('&');
            } else if (stringBuffer.charAt(n + 1) == 'l' && stringBuffer.charAt(n + 2) == 't') {
                stringBuffer2.append('<');
            } else if (stringBuffer.charAt(n + 1) == 'g' && stringBuffer.charAt(n + 2) == 't') {
                stringBuffer2.append('>');
            } else if (stringBuffer.charAt(n + 1) == 'q' && stringBuffer.charAt(n + 2) == 'u' && stringBuffer.charAt(n + 3) == 'o' && stringBuffer.charAt(n + 4) == 't') {
                stringBuffer2.append('\"');
            } else if (stringBuffer.charAt(n + 1) == 'a' && stringBuffer.charAt(n + 2) == 'p' && stringBuffer.charAt(n + 3) == 'o' && stringBuffer.charAt(n + 4) == 's') {
                stringBuffer2.append('\'');
            } else {
                String string = XmlUtils.subBuffer(stringBuffer, n + 2, i).toString();
                c = '\u0000';
                try {
                    int n3 = Integer.parseInt(string);
                    stringBuffer2.append((char)n3);
                }
                catch (NumberFormatException numberFormatException) {
                    Log.addMessage(114, null, null, WRONG_OBJECT + XmlUtils.subBuffer(stringBuffer, n, i + 1).toString() + ". ");
                }
            }
            n = -1;
        }
        return stringBuffer2.toString();
    }

    static StringBuffer subBuffer(StringBuffer stringBuffer, int n, int n2) {
        int n3;
        int n4;
        if (n < 0) {
            n = 0;
        }
        if (n2 > (n4 = stringBuffer.length())) {
            n2 = n4 - 1;
        }
        if ((n3 = n2 - n) <= 0) {
            return new StringBuffer();
        }
        char[] cArray = new char[n3];
        stringBuffer.getChars(n, n2, cArray, 0);
        StringBuffer stringBuffer2 = new StringBuffer(n3);
        return stringBuffer2.append(cArray);
    }

    static StringBuffer subBuffer(StringBuffer stringBuffer, int n) {
        return XmlUtils.subBuffer(stringBuffer, n, stringBuffer.length());
    }

    public static String setObjs(String string) {
        string = Strings.setObj(string, '&', "amp");
        string = Strings.setObj(string, '<', "lt");
        string = Strings.setObj(string, '>', "gt");
        string = Strings.setObj(string, '\"', "quot");
        return Strings.setObj(string, '\'', "apos");
    }

    public static String getEncoding(XmlElement xmlElement) {
        char c;
        if (xmlElement.value != null) {
            for (int i = 0; i < xmlElement.value.length(); ++i) {
                c = xmlElement.value.charAt(i);
                if (c <= '\u007f') continue;
                return "UTF-8";
            }
        }
        Enumeration enumeration = xmlElement.attributes.keys();
        while (enumeration.hasMoreElements()) {
            String string = xmlElement.getAttributeValue((String)enumeration.nextElement());
            for (int i = 0; i < string.length(); ++i) {
                c = string.charAt(i);
                if (c <= '\u007f') continue;
                return "UTF-8";
            }
        }
        for (int i = 0; i < xmlElement.children.size(); ++i) {
            if (!XmlUtils.getEncoding((XmlElement)xmlElement.children.elementAt(i)).equalsIgnoreCase("UTF-8")) continue;
            return "UTF-8";
        }
        return "ISO-8859-1";
    }

    public static void writeElement(XmlElement xmlElement, OutputStreamWriter outputStreamWriter, int n) throws Exception {
        if (xmlElement == null) {
            return;
        }
        String string = new String();
        for (int i = 0; i < n; ++i) {
            string = string + ' ';
        }
        XmlUtils.writeBytes(outputStreamWriter, string + "<" + xmlElement.tagName);
        Enumeration enumeration = xmlElement.attributes.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            XmlUtils.writeBytes(outputStreamWriter, " " + string2 + "=\"" + XmlUtils.setObjs(xmlElement.getAttributeValue(string2)) + "\"");
        }
        int n2 = xmlElement.children.size();
        if (n2 == 0 && xmlElement.value == null) {
            XmlUtils.writeBytes(outputStreamWriter, "/>\n");
        } else if (n2 != 0) {
            XmlUtils.writeBytes(outputStreamWriter, ">\n");
            for (int i = 0; i < n2; ++i) {
                XmlUtils.writeElement((XmlElement)xmlElement.children.elementAt(i), outputStreamWriter, n + 3);
            }
            XmlUtils.writeBytes(outputStreamWriter, string + "</" + xmlElement.tagName + ">\n");
        } else {
            XmlUtils.writeBytes(outputStreamWriter, '>' + XmlUtils.setObjs(xmlElement.value) + "</" + xmlElement.tagName + ">\n");
        }
    }

    private static void writeBytes(OutputStreamWriter outputStreamWriter, String string) throws Exception {
        outputStreamWriter.write(string, 0, string.length());
    }

    public static void writeStream(XmlElement xmlElement, DataOutputStream dataOutputStream, String string) throws Exception {
        XmlUtils.writeStream(xmlElement, dataOutputStream, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStream(XmlElement xmlElement, DataOutputStream dataOutputStream, String string, String string2) throws Exception {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)dataOutputStream, string);
        try {
            if (string.equalsIgnoreCase("UTF-8")) {
                dataOutputStream.writeBytes("\u00ef\u00bb\u00bf");
            }
            XmlUtils.writeBytes(outputStreamWriter, "<?xml version=\"1.0\" encoding=\"" + string + "\"?>\n");
            if (string2 != null) {
                XmlUtils.writeBytes(outputStreamWriter, string2 + "\n");
            }
            XmlUtils.writeElement(xmlElement, outputStreamWriter, 0);
        }
        finally {
            outputStreamWriter.close();
        }
    }

    public static void writeStream(XmlElement xmlElement, DataOutputStream dataOutputStream) throws Exception {
        XmlUtils.writeStream(xmlElement, dataOutputStream, XmlUtils.getEncoding(xmlElement));
    }

    public static String convertColor(Color color) {
        return String.valueOf(color.getRed()) + COLON + String.valueOf(color.getGreen()) + COLON + String.valueOf(color.getBlue());
    }

    public static Properties makeProperties(String string, String string2) {
        int n;
        if (Strings.isNullOrBlank(string)) {
            return null;
        }
        while ((n = string.indexOf(EQUAL_SPACE)) > 0) {
            string = string.substring(0, n) + '=' + string.substring(n + 2);
        }
        while ((n = string.indexOf(SPACE_EQUAL)) > 0) {
            string = string.substring(0, n) + '=' + string.substring(n + 2);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        Properties properties = new Properties();
        String string3 = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            int n2 = string4.indexOf(61);
            if (n2 < 0) {
                string3 = string3 + string4;
                continue;
            }
            string3 = string3 + string4.substring(0, n2).trim();
            String string5 = string4.substring(n2 + 1, string4.length()).trim();
            if (!string3.equals("")) {
                ((Hashtable)properties).put(string3.toLowerCase().trim(), string5);
            }
            string3 = "";
        }
        return properties;
    }

    public static void addAll(Vector vector, Vector vector2) {
        if (vector != null && vector2 != null) {
            int n = vector2.size();
            for (int i = 0; i < n; ++i) {
                if (vector.indexOf(vector2.elementAt(i)) >= 0) continue;
                vector.addElement(vector2.elementAt(i));
            }
        }
    }

    public static void xorAddAll(Vector vector, Vector vector2) {
        if (vector != null && vector2 != null) {
            int n = vector2.size();
            for (int i = 0; i < n; ++i) {
                int n2 = vector.indexOf(vector2.elementAt(i));
                if (n2 < 0) {
                    vector.addElement(vector2.elementAt(i));
                    continue;
                }
                vector.remove(n2);
            }
        }
    }
}

