/*
 * Decompiled with CFR 0.152.
 */
package org.alov.viewer;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import org.alov.map.Carte;
import org.alov.map.CarteAttribute;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.FieldDef;
import org.alov.map.LayerVector;
import org.alov.map.MapUtils;
import org.alov.map.Record;
import org.alov.map.RecordsArray;
import org.alov.map.StatusListener;
import org.alov.util.Strings;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;
import org.alov.viewer.EditListener;
import org.alov.viewer.FrameAlign;
import org.alov.viewer.GridCellEventListener;
import org.alov.viewer.LightForm;
import org.alov.viewer.LightGrid;

public class FrameRes
extends FrameAlign
implements ActionListener,
GridCellEventListener,
CarteHostListener,
CarteAttribute,
ItemListener,
StatusListener {
    private static final String PAR_SHOWONMAP = "showonmap";
    private static final String PAR_CLOSEONEXTENTCHANGE = "close_on_extentchange";
    private static final String BTN_WEBLINK = "btn_weblink";
    private static final String BTN_SHOWWEBLINK = "btn_showweblink";
    private static final String BTN_ONMAP = "btn_onmap";
    private static final String BTN_CLOSE = "btn_close";
    private static final String LBL_WEBLINK = "lbl_weblink";
    private static final String LBL_RECNO = "lbl_recno";
    private static final String BTN_NEXT = "btn_next";
    private static final String BTN_PREVIOUS = "btn_previous";
    private static final String BTN_FIRSTRECORD = "btn_firstrecord";
    private static final String BTN_LASTRECORD = "btn_lastrecord";
    private static final String BTN_APPLY = "btn_apply";
    private static final String BTN_APPLYALLRECORDS = "btn_applyallrecords";
    private static final String EDITFORM = "editform";
    private static final String LST_ZOOMTO = "lst_zoomto";
    private String currWebLink = null;
    private int fi_description = 0;
    private int fi_description_original = 0;
    private boolean showOnClick = false;
    private boolean closeOnExtentChange = false;
    private float[] zoomto_values = null;
    private Choice chZoomTo = null;
    protected Carte map = null;
    protected CarteHost host = null;
    protected LayerVector layer;
    protected LightGrid sg = null;
    protected LightForm lf = null;
    protected EditListener ef = null;
    private int minWidth = 330;
    private int xPos;
    private int yPos;
    private int wPos;
    private int hPos = -1;

    public FrameRes() {
        this.enableEvents(1L);
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        int n = componentEvent.getID();
        switch (n) {
            case 101: {
                int n2;
                Rectangle rectangle = this.getBounds();
                if (rectangle.width < this.minWidth) {
                    rectangle.width = this.minWidth;
                }
                if (rectangle.height < 300) {
                    rectangle.height = 300;
                }
                super.setBounds(rectangle);
                if (null == this.layer || null == this.sg) {
                    return;
                }
                int n3 = 0;
                for (n2 = 0; n2 < this.sg.colCount; ++n2) {
                    n3 += this.sg.getColWidth(n2);
                }
                n2 = this.sg.getViewportSize().width - n3;
                this.sg.setColumnWidth(this.fi_description, this.sg.getColWidth(this.fi_description) + n2 >= this.fi_description_original ? this.sg.getColWidth(this.fi_description) + n2 : this.fi_description_original);
                this.sg.endUpdate();
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Component) {
            String string = ((Component)object).getName();
            if (string.equalsIgnoreCase(BTN_WEBLINK) || string.equalsIgnoreCase(BTN_SHOWWEBLINK)) {
                this.map.showURL(this.currWebLink);
            } else if (string.equalsIgnoreCase(BTN_ONMAP)) {
                float f;
                float f2 = this.layer.zoom_for_select;
                if (this.chZoomTo != null && (f = this.zoomto_values[this.chZoomTo.getSelectedIndex()]) >= 0.0f) {
                    this.layer.zoom_for_select = f;
                }
                this.showOnMap();
                this.layer.zoom_for_select = f2;
            } else if (string.equalsIgnoreCase(BTN_CLOSE)) {
                ((Component)this).setVisible(false);
            } else if (this.lf != null) {
                if (string.equalsIgnoreCase(BTN_NEXT)) {
                    this.lf.next();
                } else if (string.equalsIgnoreCase(BTN_PREVIOUS)) {
                    this.lf.previous();
                } else if (string.equalsIgnoreCase(BTN_FIRSTRECORD)) {
                    this.lf.firstRecord();
                } else if (string.equalsIgnoreCase(BTN_LASTRECORD)) {
                    this.lf.lastRecord();
                }
                this.setLabels(this.lf.getCell(this.lf.colCount - 1, this.lf.currRow), this.lf.currRow + ":" + (this.lf.rowCount - 1));
            } else if (this.sg != null) {
                if (string.equalsIgnoreCase(BTN_NEXT)) {
                    this.sg.next();
                } else if (string.equalsIgnoreCase(BTN_PREVIOUS)) {
                    this.sg.previous();
                } else if (string.equalsIgnoreCase(BTN_FIRSTRECORD)) {
                    this.sg.firstRecord();
                } else if (string.equalsIgnoreCase(BTN_LASTRECORD)) {
                    this.sg.lastRecord();
                } else if (string.equalsIgnoreCase(BTN_APPLYALLRECORDS)) {
                    if (this.ef != null && this.ef.isEdited()) {
                        this.ef.saveFields();
                        this.sg.setGridColumn(this.ef.getFields());
                        this.sg.updateAll();
                    }
                } else if (string.equalsIgnoreCase(BTN_APPLY)) {
                    if (this.ef != null && this.ef.isEdited()) {
                        this.sg.lastCurrRow = this.sg.currRow;
                        this.ef.saveFields();
                        this.sg.setGridRow(this.ef.getFields());
                        this.sg.updateAll();
                    }
                    if (this.sg.wasEdited) {
                        this.saveChangesToLayer();
                        this.map.updateMap();
                    }
                }
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    private void setLabels(String string, String string2) {
        Component component = MapUtils.findComp(this, LBL_RECNO);
        if (component instanceof Label) {
            ((Label)component).setText(string2);
        }
        if (Strings.isNullOrBlank(string)) {
            return;
        }
        Record record = this.layer.findById(string);
        this.currWebLink = this.map.getProject().getWebLink(this.layer, record);
        if (this.currWebLink == null) {
            this.currWebLink = "";
        }
        if ((component = MapUtils.findComp(this, BTN_SHOWWEBLINK)) != null) {
            component.setEnabled(!Strings.isNullOrBlank(this.currWebLink));
        }
        if ((component = MapUtils.findComp(this, BTN_WEBLINK)) != null) {
            component.setEnabled(!Strings.isNullOrBlank(this.currWebLink));
        }
        if ((component = MapUtils.findComp(this, LBL_WEBLINK)) instanceof Label) {
            ((Label)component).setText(this.currWebLink);
        }
    }

    private void showOnMap() {
        String string = null;
        if (this.sg != null) {
            string = this.sg.getCell(this.sg.colCount - 1, this.sg.currRow);
        } else if (this.lf != null) {
            string = this.lf.getCell(this.lf.colCount - 1, this.lf.currRow);
        }
        if (!Strings.isNullOrBlank(string)) {
            this.map.selectObjectsById(this.layer.id, string);
        }
    }

    private void saveChangesToLayer() {
        Record record = null;
        int n = 0;
        for (int i = 1; i < this.sg.rowCount; ++i) {
            if (!this.sg.rowWasEdited[i]) continue;
            String string = this.sg.getCell(this.sg.colCount - 1, i);
            record = this.layer.findById(string);
            for (int j = 0; j < this.sg.colCount - 1; ++j) {
                n = this.sg.getColDefIndex(j);
                record.setField(n, this.sg.getCell(j, i));
            }
            if (this.ef != null) {
                this.ef.applyChanges(string, record);
            }
            this.map.broadcastMessage(122, this.layer.getName() + " " + record.index);
        }
    }

    public void gridCellClicked(Point point, InputEvent inputEvent) {
        this.setLabels(this.sg.getCell(this.sg.colCount - 1, this.sg.currRow), this.sg.currRow + ":" + (this.sg.rowCount - 1));
        if (this.sg.lastCurrRow != this.sg.currRow) {
            if (this.ef != null) {
                if (this.ef.isEdited()) {
                    this.ef.saveFields();
                    this.sg.setGridRow(this.ef.getFields());
                    this.sg.updateAll();
                }
                String[] stringArray = this.sg.getGridRow(this.sg.currRow);
                this.ef.setFields(stringArray);
            }
            this.sg.lastCurrRow = this.sg.currRow;
        }
        if (this.showOnClick && point != null && inputEvent != null) {
            this.showOnMap();
        }
    }

    private void loadToGrid(LayerVector layerVector, RecordsArray recordsArray) {
        String string;
        int n;
        if (this.sg == null && this.lf == null) {
            return;
        }
        int n2 = layerVector.getFieldCount();
        int n3 = recordsArray.size();
        this.layer = layerVector;
        boolean bl = this.sg != null;
        FontMetrics fontMetrics = null;
        int n4 = 0;
        if (bl) {
            this.sg.beginUpdate();
            Graphics graphics = this.sg.getGraphics();
            fontMetrics = graphics.getFontMetrics();
            n4 = fontMetrics.getHeight() + 2;
            graphics.dispose();
            this.sg.colType = new int[n2];
            this.sg.setDimension(n2 + 1, 1, n4);
        } else {
            this.lf.colType = new int[n2];
            this.lf.setDimension(n2 + 1, n3 + 1);
        }
        int n5 = 0;
        for (n = 0; n < n2; ++n) {
            FieldDef fieldDef = layerVector.getFieldDef(n);
            if (fieldDef == null || !fieldDef.visible) continue;
            if (n == this.layer.fi_description) {
                this.fi_description = n;
            }
            string = fieldDef.label;
            if (bl) {
                this.sg.colType[n5] = fieldDef.type;
                int n6 = fontMetrics.stringWidth(string + "W");
                this.sg.setColumnWidth(n5, n6);
                this.sg.setCell(n5, 0, string);
                this.sg.addColDef(string, fieldDef.type, fieldDef.editable, fieldDef.index);
            } else {
                this.lf.colType[n5] = fieldDef.type;
                this.lf.setCell(n5, 0, string);
            }
            ++n5;
        }
        if (bl) {
            this.sg.setRowHeight(0, n4);
            this.sg.setDimension(n5 + 1, n3 + 1, n4);
            this.sg.setCell(n5, 0, "");
            if (n5 > 0) {
                this.sg.setColumnWidth(n5, 0);
            }
        } else {
            this.lf.setDimension(n5 + 1, n3 + 1);
            this.lf.setCell(n5, 0, "");
        }
        for (n = 0; n < n3; ++n) {
            Record record = recordsArray.getRecord(n, 1);
            int n7 = 0;
            if (n5 > 0) {
                for (int i = 0; i < n2; ++i) {
                    if (!layerVector.getFieldDef((int)i).visible) continue;
                    string = layerVector.getFieldString(record, i);
                    if (bl) {
                        int n8 = fontMetrics.stringWidth(string + "W");
                        if (n8 > this.sg.getColWidth(n7)) {
                            this.sg.setColumnWidth(n7, n8);
                        }
                        this.sg.setCell(n7, n + 1, string);
                    } else {
                        this.lf.setCell(n7, n + 1, string);
                    }
                    ++n7;
                }
            }
            if (bl) {
                this.fi_description_original = this.sg.getColWidth(this.fi_description);
                this.sg.setCell(n5, n + 1, String.valueOf(layerVector.getId(record)));
                continue;
            }
            this.lf.setCell(n5, n + 1, String.valueOf(layerVector.getId(record)));
        }
        if (bl) {
            this.sg.endUpdate();
            int n9 = 0;
            for (n = 0; n < n5; ++n) {
                n9 += this.sg.getColWidth(n) + 1;
            }
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setBounds(10, 10, (n9 += this.sg.getVScrollbarWidth()) + 10 > dimension.width ? dimension.width - 10 : (n9 < this.minWidth ? this.minWidth : n9), 300);
            this.processComponentEvent(new ComponentEvent(this, 101));
            this.sg.setUnEdited();
            if (this.ef != null) {
                int n10 = this.sg.cols.size();
                boolean[] blArray = new boolean[n10];
                boolean bl2 = this.ef.isEditableLayer(layerVector);
                for (int i = 0; i < n10; ++i) {
                    blArray[i] = bl2 && this.sg.getColDefEditable(i);
                }
                this.ef.setEditable(blArray);
                String[] stringArray = this.sg.getGridRow(0);
                this.ef.loadLabels(stringArray);
                this.sg.lastCurrRow = 0;
            }
            this.gridCellClicked(null, null);
        } else {
            this.lf.loadLabels();
            this.lf.updateView();
            this.setLabels(this.lf.getCell(this.lf.colCount - 1, this.lf.currRow), this.lf.currRow + ":" + (this.lf.rowCount - 1));
            if (this.hPos > 0) {
                this.setBounds(this.xPos, this.yPos, this.wPos, this.hPos);
            }
        }
    }

    private void setBtn(String string) {
        MapUtils.addActionListener(this, this, string);
        Component component = MapUtils.findComp(this, string);
        if (component != null && component instanceof Button) {
            ((Button)component).setLabel(this.map.getResource(((Button)component).getLabel()));
        }
    }

    public void setParameters(CarteHost carteHost, XmlElement xmlElement) {
        Vector vector;
        int n;
        Object object;
        this.host = carteHost;
        this.map = carteHost.getMapByName(xmlElement);
        this.map.statusListeners.addElement(this);
        this.showOnClick = XmlUtils.getBoolean(PAR_SHOWONMAP, xmlElement, false);
        this.closeOnExtentChange = XmlUtils.getBoolean(PAR_CLOSEONEXTENTCHANGE, xmlElement, false);
        String string = XmlUtils.getString("bounds", xmlElement, null);
        if (string != null) {
            try {
                object = new StringTokenizer(string, ",");
                this.xPos = Integer.valueOf(((StringTokenizer)object).nextToken());
                this.yPos = Integer.valueOf(((StringTokenizer)object).nextToken());
                this.wPos = Integer.valueOf(((StringTokenizer)object).nextToken());
                this.hPos = Integer.valueOf(((StringTokenizer)object).nextToken());
            }
            catch (Exception exception) {
                this.hPos = -1;
            }
        }
        if ((object = xmlElement.findElementByAttrib("object", "name", LST_ZOOMTO, true)) != null && (n = (vector = ((XmlElement)object).getElementsByTagName("item")).size()) > 0) {
            this.zoomto_values = new float[n];
            for (int i = 0; i < n; ++i) {
                object = (XmlElement)vector.elementAt(i);
                this.zoomto_values[i] = XmlUtils.getFloat("id", (XmlElement)object, -1.0f);
            }
        }
    }

    public void stop() {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void showAttributes(LayerVector layerVector, RecordsArray recordsArray) {
        if (layerVector != null && layerVector.getMap() == this.map && MapUtils.isNotEmptyRecs(recordsArray)) {
            this.loadToGrid(layerVector, recordsArray);
            this.show();
            this.requestFocus();
        }
    }

    public void afterProjectLoaded(boolean bl) {
        if (bl) {
            this.setTitle(this.map.getResource("Attribute Data"));
            this.setBtn(BTN_SHOWWEBLINK);
            this.setBtn(BTN_WEBLINK);
            this.setBtn(BTN_ONMAP);
            this.setBtn(BTN_CLOSE);
            this.setBtn(BTN_NEXT);
            this.setBtn(BTN_PREVIOUS);
            this.setBtn(BTN_FIRSTRECORD);
            this.setBtn(BTN_LASTRECORD);
            this.setBtn(BTN_APPLY);
            this.setBtn(BTN_APPLYALLRECORDS);
            this.chZoomTo = (Choice)MapUtils.findComp(this, LST_ZOOMTO);
            this.sg = (LightGrid)MapUtils.findComp(this, "lightgrid");
            if (this.sg != null) {
                this.sg.setGridCellEventListener(this);
                this.sg.colSizing = true;
                this.ef = (EditListener)((Object)MapUtils.findComp(this, EDITFORM));
                if (this.ef != null) {
                    if (this.ef instanceof Component) {
                        Dimension dimension = ((Component)((Object)this.ef)).getSize();
                        this.minWidth += dimension.width;
                    }
                    this.ef.setEditObject(this.host.findByClass("org.alov.edit.EditObject"));
                }
            } else {
                this.lf = (LightForm)MapUtils.findComp(this, "lightform");
            }
            this.addWindowListener(new WindowEventHandler());
            this.pack();
        }
    }

    public void notifyStatus(int n, Object object) {
        if (this.closeOnExtentChange && n == 109) {
            ((Component)this).setVisible(false);
        }
    }

    private class WindowEventHandler
    extends WindowAdapter {
        private WindowEventHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            ((Component)FrameRes.this).setVisible(false);
        }
    }
}

