/*
 * Decompiled with CFR 0.152.
 */
package org.alov.viewer;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.MapUtils;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

public class ImageButton
extends Component
implements CarteHostListener {
    private static final String IMAGE_DISABLED = "image_disabled";
    private static final String IMAGE_HOT = "image_hot";
    private static final String IMAGE_PRESSED = "image_down";
    private static final String _FLAT = "flat";
    private static final String _DOWN = "down";
    Image image = null;
    Image imageDisabled = null;
    Image imageHot = null;
    Image imagePressed = null;
    boolean isFlat = false;
    private String linkmask = null;
    private String targetPage = null;
    String hint;
    boolean isDown = false;
    CarteHost host;
    public int group = -1;
    public boolean drawBorder = true;
    private ActionListener actListener = null;
    private boolean isHot = false;
    private boolean tempDown = false;
    private static int _num = 0;

    public ImageButton() {
        this(null);
    }

    public Dimension getPreferredSize() {
        return this.getSize();
    }

    public ImageButton(Image image) {
        this.image = image;
        this.hint = "";
        this.isDown = false;
        this.enableEvents(16L);
        this.setName("imagebutton" + _num);
        ++_num;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setHint(String string) {
        this.hint = string;
    }

    public String getHint() {
        return this.hint;
    }

    public void setDown(boolean bl) {
        this.isHot = false;
        Container container = this.getParent();
        if (container != null && this.group >= 0 && bl) {
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                if (!(component instanceof ImageButton) || this.equals(component)) continue;
                ImageButton imageButton = (ImageButton)component;
                if (imageButton.group != this.group || !imageButton.isDown) continue;
                imageButton.isDown = false;
                imageButton.repaint();
            }
        }
        this.isDown = bl;
        this.repaint();
    }

    public static void setAllUp(Container container, int n) {
        if (n >= 0) {
            int n2 = container.getComponentCount();
            for (int i = 0; i < n2; ++i) {
                Component component = container.getComponent(i);
                if (!(component instanceof ImageButton)) continue;
                ImageButton imageButton = (ImageButton)component;
                if (imageButton.group != n || !imageButton.isDown) continue;
                imageButton.isDown = false;
                imageButton.repaint();
            }
        }
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        Image image = null;
        image = this.isEnabled() ? (this.isDown || this.tempDown ? this.imagePressed : (this.isHot ? this.imageHot : this.image)) : this.imageDisabled;
        if (image == null) {
            image = this.image;
        }
        if (null != image) {
            int n = (dimension.width - image.getWidth(this)) / 2;
            int n2 = (dimension.height - image.getHeight(this)) / 2;
            graphics.drawImage(image, n, n2, this);
        }
        if (this.drawBorder) {
            if (this.isDown || this.tempDown) {
                graphics.setColor(SystemColor.controlDkShadow);
                graphics.drawLine(dimension.width, 0, 0, 0);
                graphics.drawLine(0, 0, 0, dimension.height);
                if (!this.isFlat) {
                    graphics.setColor(SystemColor.controlShadow);
                    graphics.drawLine(dimension.width, 1, 1, 1);
                    graphics.drawLine(1, 1, 1, dimension.height);
                    graphics.setColor(SystemColor.controlHighlight);
                    graphics.drawLine(dimension.width - 2, 1, dimension.width - 2, dimension.height);
                    graphics.drawLine(dimension.width, dimension.height - 2, 1, dimension.height - 2);
                }
                graphics.setColor(SystemColor.controlLtHighlight);
                graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height);
                graphics.drawLine(dimension.width, dimension.height - 1, 0, dimension.height - 1);
            } else if (!this.isFlat || this.isHot) {
                graphics.setColor(SystemColor.controlLtHighlight);
                graphics.drawLine(dimension.width, 0, 0, 0);
                graphics.drawLine(0, 0, 0, dimension.height);
                if (!this.isFlat) {
                    graphics.setColor(SystemColor.controlHighlight);
                    graphics.drawLine(dimension.width, 1, 1, 1);
                    graphics.drawLine(1, 1, 1, dimension.height);
                    graphics.setColor(SystemColor.controlShadow);
                    graphics.drawLine(dimension.width - 2, 1, dimension.width - 2, dimension.height);
                    graphics.drawLine(dimension.width, dimension.height - 2, 1, dimension.height - 2);
                }
                graphics.setColor(SystemColor.controlDkShadow);
                graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height);
                graphics.drawLine(dimension.width, dimension.height - 1, 0, dimension.height - 1);
            }
            graphics.setColor(this.getBackground());
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.isEnabled()) {
            int n = mouseEvent.getID();
            switch (n) {
                case 501: {
                    if (this.tempDown) break;
                    this.tempDown = true;
                    this.repaint();
                    break;
                }
                case 502: {
                    if (this.tempDown) {
                        this.tempDown = false;
                        if (this.group >= 0) {
                            this.setDown(true);
                        }
                    }
                    if (this.group < 0) {
                        this.setDown(false);
                    }
                    this.processActionEvent(new ActionEvent(this, mouseEvent.getID(), this.getName()));
                    if (this.linkmask == null) break;
                    this.host.showURL(this.linkmask, this.targetPage);
                    break;
                }
                case 504: {
                    if (this.imageHot != null && this.isEnabled() && !this.isDown && !this.tempDown && !this.isHot) {
                        this.isHot = true;
                        this.repaint();
                    }
                    super.processMouseEvent(mouseEvent);
                    break;
                }
                case 505: {
                    if (this.imageHot != null && this.isEnabled() && !this.isDown && !this.tempDown && this.isHot) {
                        this.isHot = false;
                        this.repaint();
                    }
                }
                default: {
                    super.processMouseEvent(mouseEvent);
                }
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        int n = mouseEvent.getID();
        this.processActionEvent(new ActionEvent(this, mouseEvent.getID(), null));
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this.actListener != null) {
            this.actListener.actionPerformed(actionEvent);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actListener = AWTEventMulticaster.add(this.actListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actListener = AWTEventMulticaster.remove(this.actListener, actionListener);
    }

    public void setParameters(CarteHost carteHost, XmlElement xmlElement) {
        this.group = XmlUtils.getInt("group", xmlElement, -1);
        this.image = carteHost.getImage(XmlUtils.getString("image", xmlElement, null));
        this.imageDisabled = carteHost.getImage(XmlUtils.getString(IMAGE_DISABLED, xmlElement, null));
        this.imageHot = carteHost.getImage(XmlUtils.getString(IMAGE_HOT, xmlElement, null));
        this.imagePressed = carteHost.getImage(XmlUtils.getString(IMAGE_PRESSED, xmlElement, null));
        String string = XmlUtils.getString("style", xmlElement, "3D");
        this.drawBorder = true;
        this.isFlat = true;
        if (XmlUtils.getBoolean(_FLAT, xmlElement, false) || "none".equalsIgnoreCase(string)) {
            this.drawBorder = false;
        } else if ("3D".equalsIgnoreCase(string)) {
            this.isFlat = false;
        }
        if (this.imageHot == null && this.isFlat) {
            this.imageHot = this.image;
        }
        this.host = carteHost;
        this.linkmask = XmlUtils.getLangString("linkmask", xmlElement, null, MapUtils.language);
        if (this.linkmask != null) {
            this.linkmask = MapUtils.parameterArgument(carteHost, this.linkmask);
        }
        this.targetPage = XmlUtils.getString("target", xmlElement, null);
        this.isDown = XmlUtils.getBoolean(_DOWN, xmlElement, false);
    }

    public void stop() {
    }
}

