/*
 * Decompiled with CFR 0.152.
 */
package org.alov.viewer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import org.alov.map.DisplayContext;
import org.alov.map.Layer;
import org.alov.map.LayerGroup;
import org.alov.map.MapUtils;
import org.alov.map.Renderer;
import org.alov.map.RendererChart;
import org.alov.map.RendererDef;
import org.alov.map.RendererDot;
import org.alov.map.RendererEvolution;
import org.alov.map.RendererGrad;
import org.alov.map.RendererLabel;
import org.alov.map.Symbol;
import org.alov.viewer.LayerCtl;
import org.alov.viewer.LayerCtlImpl;
import org.alov.viewer.LayerItemButton;

class LayerControlItem {
    int cwidth = 120;
    private static final int buttonSize = 10;
    private static final int checkX = 2;
    private static final int expandX = 14;
    private static final int captionX = 24;
    private boolean drawSeparator = false;
    private boolean drawSelection = true;
    private boolean compactSingleRend = false;
    private boolean isCompact = false;
    private Color foreColor = Color.black;
    Color backColor = Color.white;
    private Color networkColor;
    private Color selectionColor = this.networkColor = new Color(208, 208, 238);
    private Color disabledColor = Color.gray;
    private Color failureColor = Color.gray;
    private Font fontBold;
    private Font fontPlain;
    private Image imageClock = null;
    private Image imageZoomIn = null;
    private Image imageZoomOut = null;
    private Image imageNetwork = null;
    private Image imageOutExt = null;
    private Image imageKey = null;
    private Image imageChecked = null;
    private Image imageUncheck = null;
    private int headHeight;
    private int itemSampleHeight;
    private Rectangle bounds = new Rectangle();
    Object animation = null;
    private Layer layer;
    LayerCtlImpl layerCtl;
    private Vector visibleRenderers = new Vector();
    private Vector notPaintedRenderers = new Vector();
    private Vector buttons = new Vector();

    LayerControlItem(Layer layer, LayerCtlImpl layerCtlImpl) {
        this.layerCtl = layerCtlImpl;
        this.layer = layer;
        if (layerCtlImpl != null) {
            this.foreColor = layerCtlImpl.getForeground();
            this.backColor = layerCtlImpl.getBackground();
            this.networkColor = layerCtlImpl.networkColor;
            this.selectionColor = layerCtlImpl.selectionColor;
            this.disabledColor = layerCtlImpl.disabledColor;
            this.failureColor = layerCtlImpl.failureColor;
            this.drawSeparator = layerCtlImpl.drawSeparator;
            this.drawSelection = layerCtlImpl.drawSelection;
            this.compactSingleRend = layerCtlImpl.compactSingleRend;
            this.fontBold = layerCtlImpl.fontBold;
            this.fontPlain = layerCtlImpl.fontPlain;
            this.imageClock = layerCtlImpl.imageClock;
            this.imageZoomIn = layerCtlImpl.imageZoomIn;
            this.imageZoomOut = layerCtlImpl.imageZoomOut;
            this.imageNetwork = layerCtlImpl.imageNetwork;
            this.imageOutExt = layerCtlImpl.imageOutExt;
            this.imageKey = layerCtlImpl.imageKey;
            this.imageChecked = layerCtlImpl.imageChecked;
            this.imageUncheck = layerCtlImpl.imageUncheck;
        } else {
            this.fontBold = MapUtils.defaultBoldFont;
            this.fontPlain = MapUtils.defaultPlainFont;
        }
    }

    private int calcControlWidth() {
        return this.layerCtl != null ? this.layerCtl.getWidth() : this.cwidth;
    }

    protected void updateBounds(DisplayContext displayContext) {
        this.visibleRenderers.removeAllElements();
        Graphics graphics = displayContext.getDrawToGraphics();
        if (graphics == null) {
            return;
        }
        int n = this.calcControlWidth();
        int n2 = 0;
        int n3 = 0;
        this.itemSampleHeight = 0;
        graphics.setFont(this.fontBold);
        this.headHeight = MapUtils.textHeight(this.layer.getName(), graphics, n - 24 - 4, this.layer.legendWrapText) + 4;
        graphics.setFont(MapUtils.defaultBoldFont);
        if (this.layer.isInvisibleInLegend(displayContext)) {
            n3 = 0;
        } else if (this.layer.notPrepared || this.layer.metadata.loadFailed || !this.layer.isPassResolved() || this.layer.isOutOfRange(displayContext) != 0 || this.layer.isOutOfExtent(displayContext)) {
            n3 = this.headHeight;
        } else {
            Vector vector = this.layer.renderers;
            int n4 = vector.size();
            for (int i = 0; i < n4; ++i) {
                Renderer renderer = (Renderer)vector.elementAt(i);
                if (!renderer.isRendererVisible(displayContext) || !renderer.legendVisible) continue;
                renderer.sampleHeight = this.getRendererHeight(renderer, graphics, n - 14);
                if (!renderer.enabled && renderer.allowToggle && renderer.legendVisible && renderer.sampleHeight == 0 && this.notPaintedRenderers.indexOf(renderer) == -1) {
                    this.notPaintedRenderers.addElement(renderer);
                }
                if (renderer.sampleHeight <= 0 && (!renderer.allowToggle || !renderer.legendVisible)) continue;
                n2 += renderer.sampleHeight + 3;
                if (renderer.label != null) {
                    renderer.rendLabelHeight = MapUtils.textHeight(renderer.label, graphics, n - 14, this.layer.legendWrapText);
                    n2 += renderer.rendLabelHeight;
                }
                this.visibleRenderers.addElement(renderer);
            }
            this.itemSampleHeight = n2;
            boolean bl = this.isCompact = this.compactSingleRend && this.itemSampleHeight > 0 && this.itemSampleHeight < this.headHeight * 2;
            if (this.isCompact) {
                this.headHeight = MapUtils.textHeight(this.layer.getName(), graphics, n - 24 - this.itemSampleHeight - 2, this.layer.legendWrapText) + 4;
                n3 = Math.max(this.headHeight, this.itemSampleHeight);
            } else {
                n3 = this.layer.legendExpanded ? this.headHeight + this.itemSampleHeight : this.headHeight;
            }
        }
        this.bounds = new Rectangle(0, 0, n, n3);
    }

    protected boolean isNotPaintedRenderer(Renderer renderer) {
        int n = this.notPaintedRenderers.indexOf(renderer);
        if (n != -1) {
            this.notPaintedRenderers.removeElementAt(n);
            return true;
        }
        return false;
    }

    int getRendererHeight(Renderer renderer, Graphics graphics, int n) {
        int n2;
        int n3 = 0;
        if (renderer instanceof RendererChart) {
            int n4 = MapUtils.getCurrentFontHeight(graphics);
            n3 = n4 > 20 ? n4 : 20;
            n3 = ((RendererChart)renderer).fields == null ? 0 : n3 * ((RendererChart)renderer).fields.length;
        } else if (renderer instanceof RendererLabel) {
            int n5 = renderer.getSymbolCount();
            if (n5 > 0) {
                for (int i = 0; i < n5; ++i) {
                    Symbol symbol = renderer.getSymbol(i);
                    if (!symbol.legendVisible || symbol.sampleFont == null) continue;
                    graphics.setFont(symbol.sampleFont);
                    int n6 = MapUtils.getCurrentFontHeight(graphics);
                    symbol.sampleSize.setSize(n6, n6);
                    n3 += n6;
                }
                graphics.setFont(MapUtils.defaultBoldFont);
            }
        } else if ((renderer instanceof RendererGrad || renderer instanceof RendererDef || renderer instanceof RendererDot || renderer instanceof RendererEvolution) && (n2 = renderer.getSymbolCount()) > 0) {
            Layer layer = renderer.getLayer();
            for (int i = 0; i < n2; ++i) {
                Symbol symbol = renderer.getSymbol(i);
                if (symbol == null) continue;
                int n7 = 1;
                if (!symbol.drawMarker) {
                    n7 = layer.isObjectType(-1) ? layer.legendObjectType : layer.dataStorage.getObjectType();
                }
                this.calcSymbolSize(symbol, graphics, n, n7, layer.legendWrapText);
                n3 += Math.max(symbol.sampleSize.height, symbol.sampleSize.width);
            }
        }
        return n3;
    }

    private void calcSymbolSize(Symbol symbol, Graphics graphics, int n, int n2, boolean bl) {
        if (symbol.legendVisible) {
            int n3 = 0;
            if (n2 == 1) {
                n3 = (symbol.image == null ? symbol.size : symbol.image.getHeight(MapUtils.getGlobalImageObserver())) + 2;
            }
            if (n3 < 20) {
                n3 = 20;
            }
            int n4 = MapUtils.textHeight(symbol.label, graphics, n - n3 - 4, bl);
            symbol.sampleSize.setSize(n3, n4);
        } else {
            symbol.sampleSize.setSize(0, 0);
        }
    }

    public void setLocation(int n, int n2) {
        this.bounds.x = n;
        this.bounds.y = n2;
    }

    public void setSize(int n, int n2) {
        this.bounds.width = n;
        this.bounds.height = n2;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public int getHeight() {
        return this.bounds.height;
    }

    public Layer getLayer() {
        return this.layer;
    }

    private void drawCheckbox(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        if (this.imageChecked == null || this.imageUncheck == null) {
            graphics.drawRect(n, n2, n3, n4);
            if (bl) {
                graphics.fillRect(n + 2, n2 + 2, n3 - 3, n4 - 3);
            }
        } else {
            graphics.drawImage(bl ? this.imageChecked : this.imageUncheck, n, n2, MapUtils.getGlobalImageObserver());
        }
    }

    void paint(boolean bl, boolean bl2, DisplayContext displayContext) {
        Graphics graphics = displayContext.getDrawToGraphics();
        try {
            boolean bl3;
            this.buttons.removeAllElements();
            int n = this.bounds.x;
            int n2 = this.bounds.y;
            int n3 = 0;
            int n4 = this.bounds.width;
            int n5 = this.bounds.height;
            int n6 = this.bounds.x;
            int n7 = this.bounds.y;
            int n8 = n4;
            boolean bl4 = false;
            if (n5 <= 0 || n4 <= 0) {
                return;
            }
            int n9 = n7 + (this.headHeight - 10) / 2;
            int n10 = n6 + 6;
            int n11 = n6 + 2;
            if (this.layer.metadata.networkActivity) {
                graphics.setColor(this.networkColor);
            } else if (bl && this.drawSelection) {
                graphics.setColor(this.selectionColor);
            } else if (this.layer.legendColor != null) {
                graphics.setColor(this.layer.legendColor);
            } else {
                graphics.setColor(this.backColor);
            }
            graphics.fillRect(n6, n7, n4, n5);
            if (this.drawSeparator) {
                graphics.setColor(this.disabledColor);
                graphics.drawLine(n6, n7 + n5 - 1, n4, n7 + n5 - 1);
            }
            int n12 = this.layer.isOutOfRange(displayContext);
            boolean bl5 = bl3 = this.layer.metadata.loadFailed || !this.layer.isPassResolved() || n12 != 0 || this.layer.notPrepared;
            if (this.layer.metadata.loadFailed) {
                graphics.setColor(this.failureColor);
                graphics.setFont(this.fontBold);
                graphics.drawString("!", n10 + 4, n7 + this.headHeight - 4);
            } else {
                graphics.setColor(this.foreColor);
                if (this.layer.metadata.networkActivity && this.imageNetwork != null) {
                    bl2 = false;
                    graphics.drawImage(this.imageNetwork, n11, n9, MapUtils.getGlobalImageObserver());
                }
                if (!this.layer.isPassResolved()) {
                    if (this.imageKey != null) {
                        graphics.drawImage(this.imageKey, n11, n9, MapUtils.getGlobalImageObserver());
                    } else {
                        graphics.drawOval(n10, n9, 4, 4);
                        graphics.drawLine(n10 + 4, n9 + 2, n10 + 10, n9 + 2);
                        graphics.drawLine(n10 + 10, n9 + 2, n10 + 10, n9 + 4);
                    }
                } else if (n12 != 0) {
                    if (Math.abs(n12) == 2) {
                        if (this.imageClock == null) {
                            graphics.drawOval(n10, n9, 10, 10);
                            graphics.drawLine(n10 + 5, n9, n10 + 5, n9 + 5);
                            graphics.drawLine(n10 + 3, n9 + 3, n10 + 5, n9 + 5);
                        } else {
                            graphics.drawImage(this.imageClock, n11, n9, MapUtils.getGlobalImageObserver());
                        }
                    } else if (this.imageZoomIn != null && n12 > 0) {
                        graphics.drawImage(this.imageZoomIn, n11, n9, MapUtils.getGlobalImageObserver());
                    } else if (this.imageZoomOut != null && n12 < 0) {
                        graphics.drawImage(this.imageZoomOut, n11, n9, MapUtils.getGlobalImageObserver());
                    } else {
                        graphics.drawOval(n10, n9, 8, 8);
                        graphics.drawLine(n10 + 2, n9 + 4, n10 + 6, n9 + 4);
                        if (n12 > 0) {
                            graphics.drawLine(n10 + 4, n9 + 2, n10 + 4, n9 + 6);
                        }
                        graphics.drawLine(n10 + 7, n9 + 7, n10 + 9, n9 + 9);
                    }
                } else if (this.layer.isOutOfExtent(displayContext)) {
                    if (this.imageOutExt != null) {
                        graphics.drawImage(this.imageOutExt, n11, n9, MapUtils.getGlobalImageObserver());
                    } else {
                        graphics.drawRect(n10, n9, 6, 6);
                        graphics.drawRect(n10 + 3, n9 + 3, 6, 6);
                    }
                } else {
                    boolean bl6;
                    graphics.setColor(this.foreColor);
                    if (bl2) {
                        if (this.layer.visible_always) {
                            graphics.setColor(this.disabledColor);
                        }
                        this.drawCheckbox(graphics, n6 + 2, n9, 9, 9, this.layer.isVisible());
                        if (!this.layer.visible_always) {
                            this.buttons.addElement(new LayerItemButton(new Rectangle(n6 + 2, n9 - n7, 9, 9), this.layer));
                        }
                        if (this.layer.visible_always) {
                            graphics.setColor(this.foreColor);
                        }
                    }
                    Vector vector = this.visibleRenderers;
                    int n13 = vector.size();
                    n10 += 10;
                    boolean bl7 = bl6 = (n13 > 0 || this.layer instanceof LayerGroup || this.layer.isEmpty() && this.layer.isDataOnServer) && bl2 && !this.isCompact;
                    if (this.layer.legendExpanded) {
                        Object object;
                        if (bl6) {
                            int n14 = 10;
                            int[] nArray = new int[]{n10, n10 + n14 / 2, n10 + n14};
                            object = new int[]{n9 + n14 / 3, n9 + n14 / 3 + n14 / 2, n9 + n14 / 3};
                            graphics.fillPolygon(nArray, (int[])object, 3);
                        }
                        if (!bl3) {
                            n3 += this.headHeight;
                            graphics.setFont(this.fontPlain);
                            Rectangle rectangle = new Rectangle();
                            for (int i = 0; i < n13; ++i) {
                                object = (Renderer)vector.elementAt(i);
                                graphics.setColor(this.foreColor);
                                if (bl2 && ((Renderer)object).allowToggle && !this.layer.visible_always) {
                                    this.drawCheckbox(graphics, n6 + 2 + 2, n7 + n3 + 2, 7, 7, ((Renderer)object).enabled);
                                    this.buttons.addElement(new LayerItemButton(new Rectangle(n6 + 2, n3 + 2, 9, 9), object));
                                }
                                if (((Renderer)object).rendLabelHeight > 0) {
                                    MapUtils.drawText(graphics, ((Renderer)object).label, n6 + 14, n7 + n3, n8 - n6 - 14, ((Renderer)object).rendLabelHeight, this.layer.legendWrapText, false);
                                    n3 += ((Renderer)object).rendLabelHeight;
                                }
                                int n15 = ((Renderer)object).sampleHeight;
                                if (this.isCompact) {
                                    rectangle.setBounds(n8 - n15 - 2, n7 + (this.bounds.height - n15) / 2, n8 - 2, n15);
                                } else {
                                    rectangle.setBounds(n6 + 14, n7 + n3, n4 - 14, n15);
                                }
                                LayerCtl.paintSample(graphics, rectangle, (Renderer)object);
                                n3 += n15;
                                if (i >= n13 - 1 || n15 <= 0) continue;
                                graphics.setColor(this.disabledColor);
                                graphics.drawLine(n6 + 5, n7 + n3 + 1, n6 + n4 - 6, n7 + n3 + 1);
                                n3 += 3;
                            }
                        }
                    } else if (bl6) {
                        graphics.drawRect(n6 + 2, n9, 9, 9);
                        int[] nArray = new int[]{n10, n10 + 5, n10};
                        int[] nArray2 = new int[]{n9, n9 + 5, n9 + 10};
                        graphics.fillPolygon(nArray, nArray2, 3);
                    }
                }
            }
            if (bl3) {
                if (this.layer.metadata.loadFailed) {
                    graphics.setColor(this.failureColor);
                } else {
                    graphics.setColor(this.disabledColor);
                }
            } else {
                graphics.setColor(this.foreColor);
            }
            graphics.setFont(this.fontBold);
            MapUtils.drawText(graphics, this.layer.getName(), n6 + 24 + 4, n7 - 2, n8 - n6 - 24 - 4, this.headHeight, this.layer.legendWrapText, this.layer.linkLegend != null);
            if (bl && this.drawSelection) {
                graphics.setColor(this.foreColor);
                graphics.drawRect(n6, n7, n4 - 1, n5 - 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isExpandButton(Point point) {
        return !this.isCompact && point.x > 14 && point.x < 24 && point.y < this.headHeight;
    }

    public Object getCheckboxObject(Point point) {
        int n = this.buttons.size();
        Object object = null;
        for (int i = 0; i < n; ++i) {
            LayerItemButton layerItemButton = (LayerItemButton)this.buttons.elementAt(i);
            if (!layerItemButton.rect.contains(point)) continue;
            object = layerItemButton.object;
            break;
        }
        return object;
    }

    boolean isLayerNameClicked(Point point) {
        if (this.layer.linkLegend != null) {
            int n = this.bounds.x + 24 + 4;
            int n2 = this.bounds.width - n + 6;
            int n3 = this.headHeight;
            int n4 = 2;
            return point.x >= n && point.y >= n4 && point.x <= n2 && point.y <= n3;
        }
        return false;
    }

    void expandClicked() {
        this.layer.setExpanded(!this.layer.legendExpanded);
        this.bounds.height = this.isCompact ? Math.max(this.headHeight, this.itemSampleHeight) : (this.layer.legendExpanded ? this.headHeight + this.itemSampleHeight : this.headHeight);
    }
}

