/*
 * Decompiled with CFR 0.152.
 */
package org.alov.viewer;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.Vector;
import org.alov.map.Carte;
import org.alov.map.DisplayContext;
import org.alov.map.DisplayContextImpl;
import org.alov.map.Layer;
import org.alov.map.LayerGroup;
import org.alov.map.MapUtils;
import org.alov.map.Renderer;
import org.alov.viewer.LayerControlItem;
import org.alov.viewer.LayerCtl;
import org.alov.viewer.MyDisplayContext;

class LayerCtlImpl
extends Canvas
implements MouseListener,
ComponentListener,
MouseMotionListener {
    Color selectionColor = Color.white;
    Color networkColor = new Color(208, 208, 238);
    Color disabledColor = Color.gray;
    Color failureColor = Color.gray;
    boolean drawSeparator = false;
    boolean drawSelection = true;
    boolean compactSingleRend = false;
    boolean bOnLayersFirstInLegend = false;
    Font fontBold = MapUtils.defaultBoldFont;
    Font fontPlain = MapUtils.defaultPlainFont;
    Image imageClock = null;
    Image imageZoomIn = null;
    Image imageZoomOut = null;
    Image imageNetwork = null;
    Image imageOutExt = null;
    Image imageKey = null;
    Image imageChecked = null;
    Image imageUncheck = null;
    private Image backImage = null;
    private boolean repaintNeeded = false;
    Vector sync_with = new Vector();
    int legendWidth = 120;
    private static final int minItemHeight = 16;
    private int itemWidth = 24;
    private int selection = -1;
    Dimension minSize = null;
    LayerCtl parentCtl;
    LayerControlItem[] items = null;
    Carte map = null;

    LayerCtlImpl(LayerCtl layerCtl) {
        this.parentCtl = layerCtl;
        this.minSize = new Dimension(this.legendWidth, 10);
        this.setSize(this.minSize);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void repaint() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            try {
                this.paint(graphics);
            }
            finally {
                graphics.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void paint(Graphics graphics) {
        if (graphics != null) {
            boolean bl = this.repaintNeeded;
            this.repaintNeeded = false;
            if ((this.backImage == null || bl) && this.items != null) {
                Dimension dimension = this.getSize();
                if (dimension == null || dimension.width <= 0 || dimension.height <= 0) {
                    return;
                }
                this.backImage = this.createImage(dimension.width, dimension.height);
                if (this.backImage == null) {
                    return;
                }
                Graphics graphics2 = this.backImage.getGraphics();
                try {
                    DisplayContextImpl displayContextImpl = new DisplayContextImpl(this.map, graphics2, this.map.getProjection(), this.map.getLastExtent());
                    LayerCtlImpl.paintItems(this.items, displayContextImpl, this.selection, true);
                }
                finally {
                    graphics2.dispose();
                }
            }
            if (this.backImage != null) {
                graphics.drawImage(this.backImage, 0, 0, null);
            }
        }
    }

    private static void paintItems(LayerControlItem[] layerControlItemArray, DisplayContext displayContext, int n, boolean bl) {
        int n2 = layerControlItemArray.length;
        for (int i = 0; i < n2; ++i) {
            LayerControlItem layerControlItem = layerControlItemArray[i];
            int n3 = layerControlItem.getHeight();
            if (n3 <= 0) continue;
            layerControlItem.paint(i == n, bl, displayContext);
        }
    }

    void synchronyzeLegends(String string) {
        Layer layer;
        if (this.map != null && (layer = this.map.getProject().getLayerById(string)) != null) {
            Object[] objectArray = new Object[]{layer.datasetId, new Boolean(layer.isVisible())};
            int n = this.sync_with.size();
            for (int i = 0; i < n; ++i) {
                LayerCtl layerCtl = (LayerCtl)this.sync_with.elementAt(i);
                layerCtl.notifyStatus(118, objectArray);
            }
        }
    }

    void changeLayerVisibility(Object[] objectArray) {
        Layer layer;
        if (this.map != null && (layer = this.map.getProject().getLayerByDsId((String)objectArray[0])) != null) {
            layer.setVisible((Boolean)objectArray[1]);
        }
    }

    void setMap(Carte carte) {
        this.map = carte;
    }

    void clear() {
        this.items = null;
    }

    void setLayers(Vector vector) {
        this.items = LayerCtlImpl.refreshItemList(vector, this);
        this.mapUpdated();
    }

    public int getWidth() {
        Dimension dimension = this.getSize();
        return dimension.width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BufferedImage paintLayers(Vector vector, DisplayContext displayContext, Color color, int n, int n2) {
        Object object;
        if (n <= 0) {
            n = 200;
        }
        LayerControlItem[] layerControlItemArray = LayerCtlImpl.refreshItemList(vector, null);
        int n3 = layerControlItemArray.length;
        for (int i = 0; i < n3; ++i) {
            layerControlItemArray[i].cwidth = n;
        }
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        Graphics graphics = bufferedImage.getGraphics();
        if (graphics != null) {
            try {
                object = new MyDisplayContext(graphics, displayContext);
                LayerCtlImpl.updateItemBounds(layerControlItemArray, (DisplayContext)object);
            }
            finally {
                graphics.dispose();
            }
        }
        object = LayerCtlImpl.updateItemLocations(layerControlItemArray, n, n2);
        ((Dimension)object).width += 10;
        ((Dimension)object).height = n2 > 0 ? n2 : (((Dimension)object).height += 20);
        BufferedImage bufferedImage2 = new BufferedImage(((Dimension)object).width, ((Dimension)object).height, 2);
        Graphics graphics2 = bufferedImage2.getGraphics();
        if (graphics2 != null) {
            try {
                for (int i = 0; i < layerControlItemArray.length; ++i) {
                    layerControlItemArray[i].backColor = color;
                }
                graphics2.setColor(color);
                graphics2.fillRect(0, 0, ((Dimension)object).width, ((Dimension)object).height);
                DisplayContextImpl displayContextImpl = new DisplayContextImpl(displayContext, graphics2, displayContext.getProjection(), displayContext.getLastExtent());
                LayerCtlImpl.paintItems(layerControlItemArray, displayContextImpl, -1, false);
            }
            finally {
                graphics2.dispose();
            }
        }
        return bufferedImage2;
    }

    void selectItem(String string) {
        if (this.items != null && string != null) {
            String string2 = this.parentCtl.getName();
            for (int i = 0; i < this.items.length; ++i) {
                Layer layer = this.items[i].getLayer();
                if (!layer.id.equals(string) || !layer.isBelongToLegend(string2) || !layer.legendVisible) continue;
                this.selection = i;
                return;
            }
        }
        this.selection = -1;
    }

    public Layer getSelected() {
        if (this.selection >= 0 && this.selection < this.items.length) {
            return this.items[this.selection].getLayer();
        }
        return null;
    }

    public void mapUpdated() {
        if (this.items == null) {
            return;
        }
        this.updateItemBounds();
        this.updateItemLocations();
        Layer layer = this.map.getActiveLayer();
        if (layer != null) {
            this.selectItem(layer.id);
        }
        this.repaintNeeded = true;
        this.repaint();
    }

    private static void updateItemBounds(LayerControlItem[] layerControlItemArray, DisplayContext displayContext) {
        int n = layerControlItemArray.length;
        for (int i = 0; i < n; ++i) {
            layerControlItemArray[i].updateBounds(displayContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateItemBounds() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            try {
                MyDisplayContext myDisplayContext = new MyDisplayContext(graphics, this.map);
                LayerCtlImpl.updateItemBounds(this.items, myDisplayContext);
            }
            finally {
                graphics.dispose();
            }
        }
    }

    private static LayerControlItem[] refreshItemList(Vector vector, LayerCtlImpl layerCtlImpl) {
        int n;
        int n2 = vector.size();
        LayerControlItem[] layerControlItemArray = new LayerControlItem[n2];
        int n3 = 0;
        String string = layerCtlImpl == null ? null : layerCtlImpl.parentCtl.getName();
        for (n = 0; n < n2; ++n) {
            Layer layer = (Layer)vector.elementAt(n);
            if (string != null && !layer.isBelongToLegend(string)) continue;
            LayerControlItem layerControlItem = new LayerControlItem(layer, layerCtlImpl);
            layerControlItem.layerCtl = layerCtlImpl;
            layerControlItemArray[n3++] = layerControlItem;
        }
        boolean bl = false;
        while (!bl) {
            bl = true;
            for (int i = 1; i < n3; ++i) {
                n = layerControlItemArray[i - 1].getLayer().legendOrder;
                int n4 = layerControlItemArray[i].getLayer().legendOrder;
                if (n >= n4) continue;
                LayerControlItem layerControlItem = layerControlItemArray[i - 1];
                layerControlItemArray[i - 1] = layerControlItemArray[i];
                layerControlItemArray[i] = layerControlItem;
                bl = false;
            }
        }
        LayerControlItem[] layerControlItemArray2 = new LayerControlItem[n3];
        System.arraycopy(layerControlItemArray, 0, layerControlItemArray2, 0, n3);
        return layerControlItemArray2;
    }

    void sortItems(String string) {
        block9: {
            int n = this.items.length;
            if (this.map == null || n <= 0) break block9;
            Layer layer = null;
            if (string != null) {
                layer = this.map.getProject().getLayerById(string);
            }
            for (int i = 0; i < n; ++i) {
                block11: {
                    int n2;
                    LayerControlItem layerControlItem;
                    block10: {
                        if (string != null && this.items[i].getLayer() != layer) continue;
                        boolean bl = this.items[i].getLayer().isVisible();
                        layerControlItem = this.items[i];
                        if (!bl) break block10;
                        if (string == null && i > 0 && this.items[i - 1].getLayer().isVisible()) break block11;
                        for (n2 = i; n2 > 0; --n2) {
                            this.items[n2] = this.items[n2 - 1];
                        }
                        this.items[0] = layerControlItem;
                        if (string != null) {
                            this.map.setActiveLayer(layer);
                            this.parentCtl.setScrollPosition(0, 0);
                        } else {
                            --i;
                        }
                        break block11;
                    }
                    if (string != null) {
                        for (n2 = i; n2 < n; ++n2) {
                            if (n2 + 1 == n) {
                                this.items[n2] = layerControlItem;
                                continue;
                            }
                            if (this.items[n2 + 1].getLayer().isVisible()) {
                                this.items[n2] = this.items[n2 + 1];
                                continue;
                            }
                            this.items[n2] = layerControlItem;
                            break;
                        }
                    }
                }
                if (string != null) break;
            }
        }
    }

    private static Dimension updateItemLocations(LayerControlItem[] layerControlItemArray, int n, int n2) {
        int n3 = layerControlItemArray.length;
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            LayerControlItem layerControlItem = layerControlItemArray[i];
            layerControlItem.setLocation(0, n4);
            int n5 = layerControlItem.getHeight();
            n4 += n5;
            layerControlItem.setSize(n, n5);
        }
        return new Dimension(n, n4);
    }

    void updateItemLocations() {
        Dimension dimension = this.parentCtl.getSize();
        Insets insets = this.parentCtl.getInsets();
        int n = dimension.width - insets.left - insets.left;
        Dimension dimension2 = LayerCtlImpl.updateItemLocations(this.items, n, dimension.height);
        if (dimension.height - insets.top - insets.top < dimension2.height) {
            LayerCtlImpl.updateItemLocations(this.items, n -= this.parentCtl.getVScrollbarWidth(), dimension.height);
        }
        this.minSize = new Dimension(n, dimension2.height);
        this.setSize(n, dimension2.height);
        this.parentCtl.doLayout();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        boolean bl = true;
        if (point.y >= 0 && this.items != null) {
            int n = this.items.length;
            for (int i = 0; i < n && bl; ++i) {
                LayerControlItem layerControlItem = this.items[i];
                Point point2 = new Point(point.x, point.y - this.items[i].getBounds().y);
                if (!layerControlItem.isLayerNameClicked(point2)) continue;
                bl = false;
            }
        }
        if (bl) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mousePressed(MouseEvent mouseEvent) {
        Object object;
        int n;
        int n2;
        int n3;
        if (this.items == null || this.items.length == 0) {
            return;
        }
        Point point = mouseEvent.getPoint();
        int n4 = this.selection;
        int n5 = -1;
        LayerControlItem layerControlItem = null;
        int n6 = point.y;
        if (n6 >= 0) {
            n3 = this.items.length;
            n2 = 0;
            for (n = 0; n < n3; ++n) {
                int n7 = this.items[n].getHeight();
                if (n6 >= (n2 += n7) || n7 <= 0) continue;
                n5 = n;
                layerControlItem = this.items[n];
                break;
            }
        }
        n3 = 0;
        n2 = 0;
        n = 0;
        this.selection = n5;
        Layer layer = null;
        if (n5 >= 0) {
            n3 = n5 != n4 ? 1 : 0;
            object = new Point(point.x, point.y - layerControlItem.getBounds().y);
            boolean bl = layerControlItem.isExpandButton((Point)object);
            boolean bl2 = layerControlItem.isLayerNameClicked((Point)object);
            Object object2 = layerControlItem.getCheckboxObject((Point)object);
            int n8 = n = object2 != null ? 1 : 0;
            if (n != 0) {
                layer = layerControlItem.getLayer();
                n2 = layer.controlledLayers != null && layer.controlledLayers.size() > 0 ? 1 : 0;
                n3 = 1;
                if (object2 instanceof Layer) {
                    layer.setVisible(!layer.isVisible());
                } else if (object2 instanceof Renderer) {
                    Renderer renderer = (Renderer)object2;
                    boolean bl3 = renderer.enabled = !renderer.enabled;
                    if (layerControlItem.isNotPaintedRenderer(renderer)) {
                        this.map.updateMap();
                        this.updateItemBounds();
                        this.updateItemLocations();
                        n2 = 1;
                        n3 = 0;
                    }
                }
            } else if (bl) {
                layerControlItem.expandClicked();
                this.updateItemBounds();
                this.updateItemLocations();
                n2 = 1;
            } else if (bl2) {
                layer = layerControlItem.getLayer();
                this.map.showURL(layer.getWebLink(layer.linkLegend, null, null, null, null));
            }
        }
        if (this.map != null) {
            boolean bl = false;
            if (n5 >= 0 && n4 != n5) {
                bl = MapUtils.isNotEmptyRecs(this.map.getActiveLayer().getSelection());
            }
            Layer layer2 = null;
            if (this.selection >= 0 && this.selection < this.items.length && (layer2 = this.items[this.selection].getLayer()) instanceof LayerGroup) {
                layer2 = null;
                this.selection = n4;
            }
            if (this.drawSelection) {
                this.map.setActiveLayer(layer2);
            } else {
                this.map.broadcastMessage(123, layer == null ? layer2.getName() : layer.getName());
            }
            if (bl || n != 0) {
                this.map.updateMap();
            }
        }
        if (n2 != 0) {
            this.repaintNeeded = true;
            this.repaint();
        } else {
            object = this.getGraphics();
            if (object != null) {
                try {
                    DisplayContextImpl displayContextImpl = new DisplayContextImpl(this.map, (Graphics)object, this.map.getProjection(), this.map.getLastExtent());
                    if (n3 != 0 && this.selection >= 0) {
                        this.items[this.selection].paint(true, true, displayContextImpl);
                    }
                    if (n4 != this.selection && n4 >= 0) {
                        this.items[n4].paint(false, true, displayContextImpl);
                    }
                }
                finally {
                    ((Graphics)object).dispose();
                }
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.repaintNeeded = true;
        this.setBounds(0, 0, this.minSize.width, this.minSize.height);
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }
}

