/*
 * Decompiled with CFR 0.152.
 */
package org.alov.viewer;

import java.awt.Adjustable;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.SystemColor;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import org.alov.data.SQLConst;
import org.alov.viewer.GridCellEventListener;

public class LightGrid
extends ScrollPane
implements AdjustmentListener {
    private static final int DEFAULT_COLUMN_WIDTH = 40;
    private static final int DEFAULT_ROW_HEIGHT = 17;
    public int rowHeight = 17;
    public static final String _GRID = "lightgrid";
    private static final byte HEADER = 0;
    private static final byte SELECTED = 1;
    private static final byte NORMAL = 2;
    private static final int MIN_COL_SIZE = 10;
    private static final int EPS = 5;
    protected String[][] cells = null;
    protected int[] colWidths = null;
    protected boolean[] colSort = null;
    public int[] colType = null;
    protected int[] rowHeights = null;
    protected int[] colX = null;
    protected int[] rowY = null;
    private GridCellEventListener gridCellEventListener = null;
    private boolean dontRefresh = false;
    private boolean needUpdate;
    private GridPanel panel;
    private int topVisibleRow = 0;
    private int bottomVisibleRow = 0;
    public boolean colSizing = false;
    private int col = -1;
    private Point lastPressed = null;
    private Cursor oldCursor = null;
    protected boolean[] rowWasEdited = null;
    protected boolean wasEdited = false;
    protected Vector cols = null;
    protected int lastCurrRow = 0;
    public int colCount = 0;
    public int rowCount = 0;
    public int currRow = 1;
    public ColorSelector colorSelector = new DefaultColorSelector();

    public LightGrid() {
        super(1);
        this.setName(_GRID);
        this.setBackground(SystemColor.window);
        this.panel = new GridPanel(this);
        this.add(this.panel);
        Adjustable adjustable = this.getVAdjustable();
        adjustable.setUnitIncrement(17);
        adjustable.setBlockIncrement(85);
        adjustable.addAdjustmentListener(this);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        int n = adjustmentEvent.getValue();
        Adjustable adjustable = (Adjustable)adjustmentEvent.getSource();
        double d = (double)n * 1.0 / (double)this.rowHeight;
        int n2 = n / this.rowHeight;
        if (d > (double)n2 * 1.0) {
            adjustable.setValue((n2 + 1) * this.rowHeight);
        }
    }

    public String getCell(int n, int n2) {
        if (n >= this.colCount || n2 >= this.rowCount || n < 0 || n2 < 0) {
            return null;
        }
        return this.cells[n2][n];
    }

    public void setCell(int n, int n2, String string) {
        if (n < this.colCount && n2 < this.rowCount && n >= 0 && n2 >= 0) {
            this.cells[n2][n] = string;
        }
    }

    public GridCellEventListener getGridCellEventListener() {
        return this.gridCellEventListener;
    }

    public void setGridCellEventListener(GridCellEventListener gridCellEventListener) {
        this.gridCellEventListener = gridCellEventListener;
    }

    public int getColWidth(int n) {
        if (n >= this.colCount || n < 0) {
            return 0;
        }
        return this.colWidths[n];
    }

    public int getRowHeight(int n) {
        if (n >= this.rowCount || n < 0) {
            return 0;
        }
        return this.rowHeights[n];
    }

    public void setColumnWidth(int n, int n2) {
        if (n >= this.colCount || n < 0) {
            return;
        }
        this.colWidths[n] = n2;
        this.updated();
    }

    public void setRowHeight(int n, int n2) {
        if (n >= this.rowCount || n < 0) {
            return;
        }
        this.rowHeights[n] = n2;
        this.updated();
    }

    public void firstRecord() {
        Adjustable adjustable = this.getVAdjustable();
        this.setScrollPosition(new Point(0, adjustable.getMinimum()));
        this.currRow = 0;
        this.cellClick();
        this.updated();
    }

    public void lastRecord() {
        Adjustable adjustable = this.getVAdjustable();
        this.setScrollPosition(new Point(0, adjustable.getMaximum()));
        this.currRow = this.rowCount - 1;
        this.cellClick();
        this.updated();
    }

    public void next() {
        if (this.currRow < this.rowCount - 1) {
            this.setCurrRow(this.currRow + 1);
            this.cellClick();
        }
    }

    public void previous() {
        if (this.currRow > 1) {
            this.setCurrRow(this.currRow - 1);
            this.cellClick();
        }
    }

    private void cellClick() {
        GridCellEventListener gridCellEventListener = this.getGridCellEventListener();
        if (gridCellEventListener != null) {
            gridCellEventListener.gridCellClicked(new Point(0, this.currRow), null);
        }
    }

    public void setCurrRow(int n) {
        if (this.currRow != n) {
            this.currRow = n;
            Adjustable adjustable = this.getVAdjustable();
            int n2 = adjustable.getValue();
            if (this.currRow < this.topVisibleRow) {
                adjustable.setValue(n2 - this.rowHeight);
            } else if (this.currRow > this.bottomVisibleRow) {
                adjustable.setValue(n2 + this.rowHeight);
            }
            this.updated();
        }
    }

    protected String[] getGridRow(int n) {
        if (this.cells != null) {
            String[] stringArray = new String[this.colCount - 1];
            for (int i = 0; i < this.colCount - 1; ++i) {
                stringArray[i] = this.getCell(i, n);
            }
            return stringArray;
        }
        return null;
    }

    protected void setGridRow(String[] stringArray) {
        if (this.cells != null && this.lastCurrRow > 0) {
            this.wasEdited = true;
            this.rowWasEdited[this.lastCurrRow] = true;
            for (int i = 0; i < this.colCount - 1; ++i) {
                this.setCell(i, this.lastCurrRow, stringArray[i]);
            }
        }
    }

    protected void setGridColumn(String[] stringArray) {
        if (this.cells != null && this.lastCurrRow > 0) {
            int n;
            this.wasEdited = true;
            for (n = 0; n < this.colCount - 1; ++n) {
                if (this.getCell(n, this.currRow).equalsIgnoreCase(stringArray[n])) continue;
                for (int i = 1; i < this.rowCount; ++i) {
                    this.setCell(n, i, stringArray[n]);
                }
            }
            for (n = 0; n < this.rowWasEdited.length; ++n) {
                this.rowWasEdited[n] = true;
            }
        }
    }

    public void sort(int n, int n2, int n3, boolean bl, Compare compare) {
        int n4;
        do {
            n4 = n;
            int n5 = n2;
            int n6 = (n + n2) / 2;
            do {
                if (bl) {
                    while (compare.compare(this.getCell(n3, n6), this.getCell(n3, n4)) < 0) {
                        ++n4;
                    }
                    while (compare.compare(this.getCell(n3, n6), this.getCell(n3, n5)) > 0) {
                        --n5;
                    }
                } else {
                    while (compare.compare(this.getCell(n3, n4), this.getCell(n3, n6)) < 0) {
                        ++n4;
                    }
                    while (compare.compare(this.getCell(n3, n5), this.getCell(n3, n6)) > 0) {
                        --n5;
                    }
                }
                if (n4 > n5) continue;
                for (int i = 0; i < this.colCount; ++i) {
                    String string = this.getCell(i, n4);
                    this.setCell(i, n4, this.getCell(i, n5));
                    this.setCell(i, n5, string);
                }
                if (n6 == n4) {
                    n6 = n5;
                } else if (n6 == n5) {
                    n6 = n4;
                }
                ++n4;
                --n5;
            } while (n4 <= n5);
            if (n < n5) {
                this.sort(n, n5, n3, bl, compare);
            }
            n = n4;
        } while (n4 < n2);
    }

    public void beginUpdate() {
        this.dontRefresh = true;
        this.needUpdate = false;
    }

    public void endUpdate() {
        this.dontRefresh = false;
        if (this.needUpdate) {
            this.updateColRowXY();
            this.updateAll();
        }
    }

    private void updated() {
        if (this.dontRefresh) {
            this.needUpdate = true;
        } else {
            this.updateAll();
        }
    }

    public void updateAll() {
        int n = this.colCount > 0 ? this.colX[this.colCount - 1] + this.colWidths[this.colCount - 1] : 0;
        int n2 = this.rowCount > 0 ? this.rowY[this.rowCount - 1] + this.rowHeights[this.rowCount - 1] : 0;
        this.panel.setSize(n, n2);
        this.doLayout();
        this.panel.repaint();
    }

    public boolean setDimension(int n, int n2, int n3) {
        int n4;
        int n5;
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (this.colCount == n && this.rowCount == n2) {
            return false;
        }
        if (this.cols == null) {
            this.cols = new Vector();
        }
        this.colSort = new boolean[n];
        String[][] stringArrayArray = new String[n2][];
        for (n5 = 0; n5 < n2; ++n5) {
            stringArrayArray[n5] = new String[n];
        }
        n5 = n < this.colCount ? n : this.colCount;
        int n6 = n2 < this.rowCount ? n2 : this.rowCount;
        for (int i = 0; i < n2; ++i) {
            int n7 = 0;
            if (i >= n6) continue;
            System.arraycopy(this.cells[i], 0, stringArrayArray[i], 0, n5);
            n7 = n5;
        }
        this.rowHeight = n3 > 0 ? n3 : 17;
        Adjustable adjustable = this.getVAdjustable();
        adjustable.setUnitIncrement(this.rowHeight);
        if (n2 != this.rowCount) {
            int[] nArray = new int[n2];
            if (n6 > 0) {
                System.arraycopy(this.rowHeights, 0, nArray, 0, n6);
            }
            for (n4 = n6; n4 < n2; ++n4) {
                nArray[n4] = this.rowHeight;
            }
            this.rowHeights = nArray;
        }
        if (n != this.colCount) {
            int[] nArray = new int[n];
            if (n5 > 0) {
                System.arraycopy(this.colWidths, 0, nArray, 0, n5);
            }
            for (n4 = n5; n4 < n; ++n4) {
                nArray[n4] = 40;
            }
            this.colWidths = nArray;
        }
        this.colCount = n;
        this.rowCount = n2;
        this.cells = stringArrayArray;
        this.updateColRowXY();
        this.setScrollPosition(0, 0);
        this.currRow = 1;
        this.updated();
        return true;
    }

    public void updateColRowXY() {
        int n;
        int n2 = this.colCount;
        int n3 = this.rowCount;
        int[] nArray = this.colX;
        int[] nArray2 = this.rowY;
        if (nArray == null || nArray.length != n2) {
            nArray = new int[n2];
        }
        if (nArray2 == null || nArray2.length != n3) {
            nArray2 = new int[n3];
        }
        if (n2 > 0) {
            nArray[0] = 0;
        }
        if (n3 > 0) {
            nArray2[0] = 0;
        }
        for (n = 1; n < n2; ++n) {
            nArray[n] = nArray[n - 1] + this.colWidths[n - 1];
        }
        for (n = 1; n < n3; ++n) {
            nArray2[n] = nArray2[n - 1] + this.rowHeights[n - 1];
        }
        this.colX = nArray;
        this.rowY = nArray2;
    }

    public Rectangle getVisibleArea() {
        int n;
        Point point = this.getScrollPosition();
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        int n2 = this.colCount;
        int n3 = this.rowCount;
        int[] nArray = this.colX;
        int[] nArray2 = this.rowY;
        int[] nArray3 = this.colWidths;
        int[] nArray4 = this.rowHeights;
        int n4 = point.x;
        int n5 = point.y;
        int n6 = n4 + dimension.width - 1;
        int n7 = n5 + dimension.height - 1;
        int n8 = -1;
        int n9 = -2;
        int n10 = -1;
        int n11 = -2;
        for (n = 0; n < n2; ++n) {
            if (nArray[n] <= n6 && nArray[n] + nArray3[n] >= n4) {
                if (n8 < 0) {
                    n8 = n;
                }
                n9 = n;
                continue;
            }
            if (n8 >= 0) break;
        }
        for (n = 0; n < n3; ++n) {
            if (nArray2[n] <= n7 && nArray2[n] + nArray4[n] > n5) {
                if (n10 < 0) {
                    n10 = n;
                }
                n11 = n;
                continue;
            }
            if (n10 >= 0) break;
        }
        this.topVisibleRow = n10 + 1;
        this.bottomVisibleRow = n11;
        return new Rectangle(n8, n10, n9 - n8 + 1, n11 - n10 + 1);
    }

    public Point getCellAt(Point point) {
        int n;
        int n2;
        int n3 = point.x;
        int n4 = -1;
        int n5 = this.colCount;
        for (n2 = 0; n2 < n5; ++n2) {
            n = this.colX[n2];
            if (n3 < n || n3 >= n + this.colWidths[n2]) continue;
            n4 = n2;
            break;
        }
        if (n4 < 0) {
            return null;
        }
        n2 = -1;
        n = point.y;
        int n6 = this.rowCount;
        Point point2 = this.getScrollPosition();
        if (n6 > 0 && n - point2.y < this.rowHeights[0]) {
            n2 = 0;
        } else {
            for (int i = 0; i < n6; ++i) {
                int n7 = this.rowY[i];
                if (n < n7 || n >= n7 + this.rowHeights[i]) continue;
                n2 = i;
                break;
            }
        }
        if (n2 < 0) {
            return null;
        }
        return new Point(n4, n2);
    }

    protected void drawCell2(Rectangle rectangle, Graphics graphics, String string, byte by, int n, int n2) {
        int n3;
        graphics.setColor(this.colorSelector.getCellColor(n, n2, by == 0, by == 1));
        if (by == 0) {
            int n4 = rectangle.x;
            n3 = rectangle.y;
            int n5 = rectangle.width;
            int n6 = rectangle.height;
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(SystemColor.controlShadow);
            graphics.drawLine(n4 + n5 - 2, n3, n4 + n5 - 2, n3 + n6 - 2);
            graphics.drawLine(n4, n3 + n6 - 2, n4 + n5 - 2, n3 + n6 - 2);
            graphics.setColor(SystemColor.controlLtHighlight);
            graphics.drawLine(n4, n3, n4 + n5 - 1, n3);
            graphics.drawLine(n4, n3, n4, n3 + n6 - 1);
            graphics.setColor(SystemColor.controlDkShadow);
            graphics.drawLine(n4 + n5 - 1, n3, n4 + n5 - 1, n3 + n6 - 1);
            graphics.drawLine(n4, n3 + n6 - 1, n4 + n5 - 1, n3 + n6 - 1);
        } else {
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(this.getForeground());
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        graphics.setColor(this.colorSelector.getFontColor(n, n2, by == 0, by == 1));
        Font font = graphics.getFont();
        n3 = rectangle.y + (rectangle.height + font.getSize()) / 2 - 2;
        if (string != null) {
            graphics.drawString(string, rectangle.x + 2, n3);
        }
    }

    protected void setUnEdited() {
        this.wasEdited = false;
        this.rowWasEdited = new boolean[this.rowCount];
    }

    public void addColDef(String string, int n, boolean bl, int n2) {
        ColDef colDef = new ColDef(string, n, bl, n2);
        this.cols.addElement(colDef);
    }

    protected int getColDefIndex(int n) {
        ColDef colDef = (ColDef)this.cols.get(n);
        return colDef.index;
    }

    protected boolean getColDefEditable(int n) {
        ColDef colDef = (ColDef)this.cols.get(n);
        return colDef.editable;
    }

    private class ColDef {
        String label;
        int colType;
        boolean editable;
        int index;

        public ColDef(String string, int n, boolean bl, int n2) {
            this.label = string;
            this.colType = n;
            this.editable = bl;
            this.index = n2;
        }
    }

    private class DefaultColorSelector
    implements ColorSelector {
        private DefaultColorSelector() {
        }

        public Color getCellColor(int n, int n2, boolean bl, boolean bl2) {
            return bl ? SystemColor.control : (bl2 ? SystemColor.activeCaption : LightGrid.this.getBackground());
        }

        public Color getFontColor(int n, int n2, boolean bl, boolean bl2) {
            return bl2 ? SystemColor.activeCaptionText : LightGrid.this.getForeground();
        }
    }

    public static interface ColorSelector {
        public Color getCellColor(int var1, int var2, boolean var3, boolean var4);

        public Color getFontColor(int var1, int var2, boolean var3, boolean var4);
    }

    private class GridPanel
    extends Canvas
    implements MouseListener,
    KeyListener,
    MouseMotionListener {
        private LightGrid parentGrid = null;

        GridPanel(LightGrid lightGrid2) {
            this.parentGrid = lightGrid2;
            this.addMouseListener(this);
            this.addKeyListener(this);
            this.addMouseMotionListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void repaint() {
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                try {
                    this.paint(graphics);
                }
                finally {
                    graphics.dispose();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics graphics) {
            LightGrid lightGrid = this.parentGrid;
            if (lightGrid.cells == null) {
                return;
            }
            Rectangle rectangle = lightGrid.getVisibleArea();
            if (rectangle == null) {
                return;
            }
            int n = rectangle.x;
            int n2 = rectangle.y;
            int n3 = n + rectangle.width - 1;
            int n4 = n2 + rectangle.height - 1;
            if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0) {
                return;
            }
            Rectangle rectangle2 = new Rectangle();
            int n5 = lightGrid.colX[n];
            int n6 = lightGrid.colX[n3] + lightGrid.getColWidth(n3);
            int n7 = lightGrid.rowY[n2];
            int n8 = n6 - n5;
            int n9 = lightGrid.rowY[n4] + lightGrid.getRowHeight(n4);
            int n10 = n9 - n7;
            Image image = this.createImage(n8, n10);
            if (image == null) {
                return;
            }
            Graphics graphics2 = image.getGraphics();
            try {
                int n11;
                int n12;
                graphics2.setColor(this.getBackground());
                graphics2.fillRect(0, 0, n8, n10);
                int n13 = LightGrid.this.currRow;
                if (LightGrid.this.currRow <= n2) {
                    LightGrid.this.currRow = n2 + 1;
                } else if (LightGrid.this.currRow > n4 && n4 > 0) {
                    LightGrid.this.currRow = n4;
                }
                for (int i = n; i <= n3; ++i) {
                    n12 = lightGrid.colX[i] - n5;
                    int n14 = lightGrid.getColWidth(i);
                    graphics2.setClip(null);
                    graphics2.clipRect(n12, 0, n14, n10);
                    for (n11 = n2; n11 <= n4; ++n11) {
                        rectangle2.setBounds(n12, lightGrid.rowY[n11] - n7, n14, lightGrid.getRowHeight(n11));
                        LightGrid.this.drawCell2(rectangle2, graphics2, lightGrid.cells[n11][i], n11 == LightGrid.this.currRow ? (byte)1 : 2, n11, i);
                    }
                }
                Point point = lightGrid.getScrollPosition();
                n12 = point.y;
                Adjustable adjustable = LightGrid.this.getVAdjustable();
                n11 = adjustable.getValue();
                for (int i = n; i <= n3; ++i) {
                    int n15 = lightGrid.colX[i] - n5;
                    int n16 = lightGrid.getColWidth(i);
                    graphics2.setClip(null);
                    graphics2.clipRect(n15, n12 - n7, n16, lightGrid.getRowHeight(0));
                    rectangle2.setBounds(n15, n12 - n7, n16, lightGrid.getRowHeight(0));
                    graphics2.setColor(this.getBackground());
                    graphics2.fillRect(n15, n12 - n7, n16, lightGrid.getRowHeight(0));
                    LightGrid.this.drawCell2(rectangle2, graphics2, LightGrid.this.cells[0][i], (byte)0, 0, i);
                }
                graphics.setClip(null);
                graphics.setColor(this.getBackground());
                Dimension dimension = this.getSize();
                graphics.fillRect(0, 0, dimension.width, dimension.height);
                graphics.drawImage(image, n5, n7, null);
                image.flush();
                if (LightGrid.this.currRow != n13) {
                    LightGrid.this.cellClick();
                }
            }
            finally {
                graphics2.dispose();
            }
        }

        public Dimension getPreferredSize() {
            LightGrid lightGrid = this.parentGrid;
            int n = lightGrid.colCount;
            int n2 = lightGrid.rowCount;
            if (n2 <= 0 || n2 <= 0) {
                return new Dimension(0, 0);
            }
            return new Dimension(lightGrid.colX[--n] + lightGrid.getColWidth(n), lightGrid.rowY[--n2] + lightGrid.getRowHeight(n2));
        }

        protected void CheckMousePos(MouseEvent mouseEvent) {
            boolean bl;
            LightGrid.this.lastPressed = mouseEvent.getPoint();
            Point point = LightGrid.this.getCellAt(LightGrid.this.lastPressed);
            boolean bl2 = bl = null != point && 0 == point.y;
            if (bl) {
                LightGrid.this.col = point.x;
                if (((LightGrid)LightGrid.this).lastPressed.x - LightGrid.this.colX[LightGrid.this.col] <= 5) {
                    --LightGrid.this.col;
                } else if (LightGrid.this.colX[LightGrid.this.col] + LightGrid.this.colWidths[LightGrid.this.col] - ((LightGrid)LightGrid.this).lastPressed.x > 5) {
                    LightGrid.this.col = -1;
                    LightGrid.this.lastPressed = null;
                    bl = false;
                }
            } else {
                LightGrid.this.lastPressed = null;
                LightGrid.this.col = -1;
            }
            if (bl) {
                if (null == LightGrid.this.oldCursor) {
                    LightGrid.this.oldCursor = this.getCursor();
                    this.setCursor(new Cursor(10));
                }
            } else if (null != LightGrid.this.oldCursor) {
                this.setCursor(LightGrid.this.oldCursor);
                LightGrid.this.oldCursor = null;
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (LightGrid.this.dontRefresh) {
                return;
            }
            Point point = this.parentGrid.getCellAt(mouseEvent.getPoint());
            if (point != null) {
                GridCellEventListener gridCellEventListener = this.parentGrid.getGridCellEventListener();
                if (point.y == 0) {
                    this.parentGrid.beginUpdate();
                    if (SQLConst.isNumber(this.parentGrid.colType[point.x])) {
                        this.parentGrid.sort(1, this.parentGrid.rowCount - 1, point.x, this.parentGrid.colSort[point.x], new CompareNumber());
                    } else {
                        this.parentGrid.sort(1, this.parentGrid.rowCount - 1, point.x, this.parentGrid.colSort[point.x], new CompareString());
                    }
                    this.parentGrid.endUpdate();
                    this.parentGrid.updateAll();
                    boolean bl = this.parentGrid.colSort[point.x] = !this.parentGrid.colSort[point.x];
                }
                if (point.y > 0) {
                    this.parentGrid.setCurrRow(point.y);
                }
                if (gridCellEventListener != null) {
                    gridCellEventListener.gridCellClicked(point, mouseEvent);
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (LightGrid.this.colSizing && 16 == mouseEvent.getModifiers()) {
                this.CheckMousePos(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (null != LightGrid.this.oldCursor) {
                this.setCursor(LightGrid.this.oldCursor);
            }
            if (LightGrid.this.colSizing && 16 == mouseEvent.getModifiers() && 0 <= LightGrid.this.col && null != LightGrid.this.lastPressed) {
                int n = mouseEvent.getPoint().x - ((LightGrid)LightGrid.this).lastPressed.x;
                if (0 < LightGrid.this.col && 0 > n && -n >= LightGrid.this.colWidths[LightGrid.this.col] - 10) {
                    n = -(LightGrid.this.colWidths[LightGrid.this.col] - 10);
                }
                int n2 = LightGrid.this.col++;
                LightGrid.this.colWidths[n2] = LightGrid.this.colWidths[n2] + n;
                int n3 = LightGrid.this.col;
                while (n3 < LightGrid.this.colCount) {
                    int n4 = n3++;
                    LightGrid.this.colX[n4] = LightGrid.this.colX[n4] + n;
                }
                LightGrid.this.col = -1;
                LightGrid.this.lastPressed = null;
                this.repaint();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (null != LightGrid.this.oldCursor) {
                this.setCursor(LightGrid.this.oldCursor);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (LightGrid.this.colSizing) {
                this.CheckMousePos(mouseEvent);
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (LightGrid.this.dontRefresh) {
                return;
            }
            int n = keyEvent.getKeyCode();
            if (n == 40 || n == 38) {
                int n2 = this.parentGrid.currRow;
                if (n2 > 0) {
                    if (n == 38 && n2 > 1) {
                        --n2;
                    } else if (n == 40 && n2 < this.parentGrid.rowCount - 1) {
                        ++n2;
                    }
                }
                this.parentGrid.setCurrRow(n2);
                GridCellEventListener gridCellEventListener = this.parentGrid.getGridCellEventListener();
                if (gridCellEventListener != null) {
                    gridCellEventListener.gridCellClicked(new Point(0, n2), keyEvent);
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    private class CompareNumber
    implements Compare {
        private CompareNumber() {
        }

        public int compare(String string, String string2) {
            Float f = new Float(Float.parseFloat(string));
            Float f2 = new Float(Float.parseFloat(string2));
            return f.compareTo(f2);
        }
    }

    private class CompareString
    implements Compare {
        private CompareString() {
        }

        public int compare(String string, String string2) {
            return string.compareTo(string2);
        }
    }

    public static interface Compare {
        public int compare(String var1, String var2);
    }
}

