/*
 * Decompiled with CFR 0.152.
 */
package org.alov.viewer;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.MapUtils;
import org.alov.util.Strings;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

public class LinkLabel
extends Component
implements CarteHostListener,
MouseListener {
    private static int _num = 0;
    private String linkmask = null;
    private String target = "";
    private CarteHost host = null;
    private boolean isTransparent = true;
    private boolean isCaptionAsURL = false;
    private String text = "";
    private float m_nHAlign = 0.0f;
    private float m_nVAlign = 0.5f;
    private int baseline;
    private FontMetrics fm;
    static final String TRANSPARENT = "transparent";

    public LinkLabel() {
        this("");
    }

    public LinkLabel(String string) {
        this.text = string;
        this.setName("linklabel" + _num);
        ++_num;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        if (this.isCaptionAsURL) {
            this.linkmask = string;
        }
        this.text = string;
    }

    public void paint(Graphics graphics) {
        int n;
        if (graphics == null || this.text == null) {
            return;
        }
        int n2 = 0;
        this.fm = this.getFontMetrics(this.getFont());
        this.baseline = this.fm.getMaxAscent();
        Dimension dimension = this.getSize();
        if (!this.isTransparent) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        Vector vector = MapUtils.wrapString(graphics, this.text, dimension.width);
        if (this.m_nVAlign == 0.5f) {
            n = dimension.height / 2;
            n2 = n - vector.size() * this.fm.getHeight() / 2;
        } else if (this.m_nVAlign == 1.0f) {
            n2 = dimension.height - vector.size() * this.fm.getHeight();
        }
        graphics.setColor(this.getForeground());
        n = vector.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)vector.elementAt(i);
            this.drawAlignedString(graphics, string, 0, n2, dimension.width);
            n2 += this.fm.getHeight();
            string = null;
        }
        vector.removeAllElements();
        this.fm = null;
    }

    protected void drawAlignedString(Graphics graphics, String string, int n, int n2, int n3) {
        int n4 = n;
        int n5 = n2 + this.baseline;
        int n6 = this.fm.stringWidth(string);
        if (this.m_nHAlign != 0.0f) {
            if (this.m_nHAlign == 0.5f) {
                n4 += (n3 - n6) / 2;
            } else if (this.m_nHAlign == 1.0f) {
                n4 = n4 + n3 - n6;
            }
        }
        graphics.drawString(string, n4, n5);
        if (!Strings.isNullOrBlank(this.linkmask)) {
            graphics.drawLine(n4, n5 + 1, n6, n5 + 1);
        }
    }

    public void setParameters(CarteHost carteHost, XmlElement xmlElement) {
        this.linkmask = XmlUtils.getString("linkmask", xmlElement, null);
        this.target = XmlUtils.getString("target", xmlElement, "");
        this.isTransparent = XmlUtils.getBoolean(TRANSPARENT, xmlElement, true);
        this.isCaptionAsURL = XmlUtils.getBoolean("direct", xmlElement, false);
        this.setText(XmlUtils.getString("caption", xmlElement, ""));
        this.host = carteHost;
        if (!Strings.isNullOrBlank(this.linkmask)) {
            this.linkmask = MapUtils.parameterArgument(carteHost, this.linkmask);
            this.addMouseListener(this);
        }
    }

    public void stop() {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.host.showURL(this.linkmask, this.target);
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }
}

