/*
 * Decompiled with CFR 0.152.
 */
package org.alov.viewer;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import org.alov.map.Carte;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.CarteListener;
import org.alov.map.FloatPoint;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.MapUtils;
import org.alov.map.Record;
import org.alov.map.StatusListener;
import org.alov.util.SimpleTimer;
import org.alov.util.Strings;
import org.alov.util.TimeInterval;
import org.alov.util.TimerListener;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

class StatusPanel
extends Canvas
implements CarteHostListener,
CarteListener,
StatusListener,
TimerListener {
    private static final int NS_TOOLTIP = 1;
    private static final int NS_SYSTEM = 2;
    private static final int NS_FAILURE = 3;
    private static final int NS_MAP = 4;
    private static final int NS_OTHER = 5;
    private String lblXY = "";
    private String lblZoom = "";
    private String lblStatus = null;
    private String oldStatus = null;
    private Color colorStatus;
    private Color oldColor;
    int loadPercent = 0;
    boolean showZoom = true;
    private String showParams = null;
    private int mapUnits;
    private int MapUnitsFormat = 100;
    private Color progressColor = Color.blue;
    private Color colorOther = null;
    private Color colorMap = null;
    private Color colorFailure = null;
    private Color colorNetwork = null;
    private Color colorTips = null;
    private String zoom_label;
    private Carte map;
    private SimpleTimer st;
    private Point ptForSearch = null;
    private int reset = 0;
    private static final String _ZOOM = "Zoom";
    private final String MSG_TIME = "Time ranges: ";
    private final String MSG_TILDA = " ~ ";

    StatusPanel() {
    }

    void setXY(String string) {
        this.lblXY = string;
        this.repaint();
    }

    void setZoom(String string) {
        this.lblZoom = string;
        this.repaint();
    }

    void setStatus(String string, int n) {
        switch (n) {
            case 1: {
                this.colorStatus = this.colorTips;
                break;
            }
            case 2: {
                this.colorStatus = this.colorNetwork;
                break;
            }
            case 3: {
                this.colorStatus = this.colorFailure;
                break;
            }
            case 4: {
                this.colorStatus = this.colorMap;
                break;
            }
            default: {
                this.colorStatus = this.colorOther;
            }
        }
        this.lblStatus = string;
        this.repaint();
    }

    void saveStatus() {
        if (this.colorStatus != this.colorNetwork) {
            this.oldColor = this.colorStatus;
            this.oldStatus = this.lblStatus;
        }
    }

    void restoreStatus() {
        if (this.oldStatus != null) {
            this.colorStatus = this.oldColor;
            this.lblStatus = this.oldStatus;
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (dimension == null) {
            return;
        }
        int n = dimension.width;
        if (this.showZoom) {
            int n2 = this.showParams.charAt(0) == '1' ? graphics.getFontMetrics().stringWidth(this.lblXY) : 0;
            int n3 = this.showParams.charAt(1) == '1' ? graphics.getFontMetrics().stringWidth(this.lblZoom) : 0;
            n -= Math.max(n2, n3);
        }
        if (this.showParams.charAt(2) == '1') {
            if (this.loadPercent > 0) {
                graphics.setColor(this.progressColor);
                graphics.fillRect(0, 1, n / 100 * this.loadPercent, 8);
            } else {
                graphics.setColor(this.getForeground());
                graphics.clearRect(0, 0, n, dimension.height);
            }
        }
        if (this.showParams.charAt(3) == '1' && this.lblStatus != null) {
            graphics.setColor(this.colorStatus);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            StringTokenizer stringTokenizer = new StringTokenizer(this.lblStatus, " ");
            String string = "";
            int n4 = 0;
            int n5 = fontMetrics.getHeight();
            int n6 = 8 + n5;
            if (n6 > dimension.height) {
                n6 = dimension.height - 2;
            }
            n -= 10;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken() + " ";
                int n7 = fontMetrics.stringWidth(string2) + 3;
                if (n4 + n7 > n) {
                    graphics.drawString(string, 2, n6);
                    n6 += n5;
                    n4 = 0;
                    string = new String(string2);
                    continue;
                }
                n4 += n7;
                string = string + string2;
            }
            if (!Strings.isNullOrBlank(string)) {
                graphics.drawString(string, 2, n6);
            }
        }
        if (this.showZoom) {
            graphics.setColor(this.getForeground());
            graphics.clearRect(n, 0, dimension.width, dimension.height);
            if (this.lblXY != null && this.showParams.charAt(0) == '1') {
                graphics.drawString(this.lblXY, dimension.width - graphics.getFontMetrics().stringWidth(this.lblXY) - 2, graphics.getFontMetrics().getHeight());
            }
            if (this.lblZoom != null && this.showParams.charAt(1) == '1') {
                graphics.drawString(this.lblZoom, dimension.width - graphics.getFontMetrics().stringWidth(this.lblZoom) - 2, graphics.getFontMetrics().getHeight() * 2);
            }
        }
    }

    public void setParameters(CarteHost carteHost, XmlElement xmlElement) {
        int n;
        this.colorOther = XmlUtils.getColor("forecolor", xmlElement, Color.darkGray);
        this.colorMap = XmlUtils.getColor("select_clr", xmlElement, Color.blue);
        this.colorFailure = XmlUtils.getColor("err_color", xmlElement, Color.red);
        this.colorNetwork = XmlUtils.getColor("net_color", xmlElement, Color.darkGray);
        this.colorTips = XmlUtils.getColor("tip_color", xmlElement, Color.magenta);
        this.progressColor = XmlUtils.getColor("progress_color", xmlElement, Color.blue);
        this.showParams = XmlUtils.getString("paint", xmlElement, "");
        while (this.showParams.length() < 4) {
            this.showParams = this.showParams + "1";
        }
        this.showZoom = XmlUtils.getBoolean("usezoom", xmlElement, true);
        String string = XmlUtils.getString("mapunits", xmlElement, null);
        if (string != null && (n = string.indexOf(44)) >= 0) {
            try {
                int n2 = Integer.parseInt(string.substring(n + 1));
                int n3 = this.MapUnitsFormat = Math.abs(n2) > 5 ? n2 : (int)Math.pow(10.0, Math.abs(n2));
                if (n2 < 0) {
                    this.MapUnitsFormat = -this.MapUnitsFormat;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            string = n > 0 ? string.substring(0, n - 1) : null;
        }
        this.mapUnits = MapUtils.setUnits(string, -1);
        this.map = carteHost.getMapByName(xmlElement);
        this.map.mapListeners.addElement(this);
        this.map.statusListeners.addElement(this);
        this.st = new SimpleTimer(500L, this);
    }

    public void stop() {
    }

    public void afterProjectLoaded(boolean bl) {
        this.zoom_label = this.map.getResource(_ZOOM);
        if (this.mapUnits < 0 && bl) {
            this.mapUnits = this.map.getProject().MapUnits;
            if (this.mapUnits < 0) {
                this.mapUnits = 0;
            }
        }
    }

    public void notifyStatus(int n, Object object) {
        int n2;
        if (n == 109) {
            String string = this.map.getResource("in");
            switch (this.map.getProject().ZoomUnits) {
                case 1: {
                    string = this.map.getResource("m");
                    break;
                }
                case 2: {
                    string = this.map.getResource("km");
                    break;
                }
                case 4: {
                    string = this.map.getResource("ft");
                    break;
                }
                case 5: {
                    string = this.map.getResource("mi");
                    break;
                }
                case 6: {
                    string = this.map.getResource("nmi");
                }
            }
            this.setZoom(this.zoom_label + "  " + (long)(((Float)object).floatValue() * 1000.0f) / 1000L + ' ' + string);
            return;
        }
        if (n == 108) {
            TimeInterval timeInterval = (TimeInterval)object;
            String string = this.map.getResource("Time ranges: ") + timeInterval.date1().toString() + " ~ " + timeInterval.date2().toString();
            this.setStatus(string, 4);
            return;
        }
        if (n == 13 || n == 11 && object == null) {
            this.restoreStatus();
            return;
        }
        if (n == 10 && object == null) {
            this.saveStatus();
            return;
        }
        if (n == 114 || n == 115) {
            this.oldStatus = null;
        }
        if (object == null || !(object instanceof String)) {
            return;
        }
        String string = (String)object;
        if (n == 12) {
            n2 = 1;
            this.saveStatus();
        } else {
            int n3 = n < 0 ? 3 : (n2 = n < 100 ? 2 : 4);
            if (n == 11) {
                this.loadPercent = 0;
            } else if (n == 4) {
                int n4 = string.indexOf(37);
                this.loadPercent = n4 > 0 ? Integer.parseInt(string.substring(0, n4)) : 0;
            }
            String string2 = this.map.getResource_((n2 == 4 ? "m" : "sp") + Math.abs(n));
            string = (string2 + "  " + string).trim();
        }
        this.setStatus(string, n2);
    }

    public void mouseMapPressed(MouseEvent mouseEvent) {
    }

    public void mouseMapReleased(FloatRectangle floatRectangle, MouseEvent mouseEvent) {
    }

    public void mouseMapMoved(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        FloatPoint floatPoint = this.map.screenToMap(point);
        if (floatPoint != null) {
            if (this.mapUnits == 0 && this.MapUnitsFormat < 100 && this.MapUnitsFormat > 97) {
                this.setXY(MapUtils.formatDegree(floatPoint.x, true, this.MapUnitsFormat == 98) + " " + MapUtils.formatDegree(floatPoint.y, false, this.MapUnitsFormat == 98));
            } else {
                this.setXY(Strings.doubleToStr(floatPoint.x, this.MapUnitsFormat) + ", " + Strings.doubleToStr(floatPoint.y, this.MapUnitsFormat));
            }
            this.ptForSearch = point;
            if (this.reset != 1) {
                this.reset = 0;
            }
        } else {
            this.setStatus("", 5);
        }
    }

    public void afterMapDraw(Graphics graphics) {
    }

    public void timerTick() {
        if (this.reset == 1 && this.ptForSearch != null) {
            String string;
            Record record;
            Layer layer = this.map.getActiveLayer();
            if (MapUtils.isTipsActive && layer != null && layer.isVisibleNow(this.map) && (record = layer.findAtScreenPoint(this.ptForSearch)) != null && (string = layer.getFieldString(record, layer.fi_description)).length() > 0) {
                this.setStatus(string + " [" + layer.getName() + ']', 4);
            }
            this.ptForSearch = null;
            this.reset = 0;
        } else {
            ++this.reset;
        }
    }
}

