/*
 * Decompiled with CFR 0.152.
 */
package org.alov.viewer;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.alov.map.Carte;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.ClientLog;
import org.alov.map.StatusListener;
import org.alov.util.Log;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;
import org.alov.viewer.FrameStatus;

public class SysLog
extends Button
implements CarteHostListener,
StatusListener,
ActionListener {
    private static SysLog instance = null;
    private Carte map;
    private Color colorFailure = Color.red;
    private Color backColor = SystemColor.control;
    private String label_log;
    private String label_error;
    FrameStatus frameStatus = null;
    private boolean isInvisible = false;

    public SysLog() {
        instance = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBtnStatus(String string) {
        Graphics graphics;
        if (string != null && (graphics = this.getGraphics()) != null) {
            try {
                int n = graphics.getFontMetrics().stringWidth(string + "  " + "  ");
                this.setSize(n, this.getSize().height);
                this.setLabel(string);
            }
            finally {
                graphics.dispose();
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this) {
            if (this.isInvisible) {
                this.setVisible(false);
            }
            if (this.frameStatus == null || !this.frameStatus.isVisible()) {
                this.frameStatus = new FrameStatus(this.map);
            }
            SysLog.showLog(this.map);
            this.setBackground(this.backColor);
            this.setBtnStatus(this.label_log);
        }
    }

    public static void showLog(Carte carte) {
        ClientLog clientLog = (ClientLog)Log.getInstance();
        if (instance == null || clientLog == null) {
            return;
        }
        if (SysLog.instance.frameStatus == null || !SysLog.instance.frameStatus.isVisible()) {
            SysLog.instance.frameStatus = new FrameStatus(carte);
        }
        SysLog.instance.frameStatus.load(clientLog.getStatus());
        SysLog.instance.frameStatus.show();
        SysLog.instance.frameStatus.requestFocus();
    }

    public void setParameters(CarteHost carteHost, XmlElement xmlElement) {
        this.colorFailure = XmlUtils.getColor("err_color", xmlElement, Color.red);
        this.backColor = this.getBackground();
        this.map = carteHost.getMapByName(xmlElement);
        this.map.statusListeners.addElement(this);
        this.addActionListener(this);
    }

    public void stop() {
        if (this.frameStatus != null) {
            ((Component)this.frameStatus).setVisible(false);
            this.frameStatus.dispose();
            this.frameStatus = null;
        }
    }

    public void afterProjectLoaded(boolean bl) {
        this.label_log = this.map.getResource("LOG");
        this.label_error = this.map.getResource("ERROR");
        if (bl) {
            this.setBtnStatus(this.label_log);
        } else {
            boolean bl2 = this.isInvisible = !this.isVisible();
            if (this.isInvisible) {
                this.setVisible(true);
            }
            this.setBackground(this.colorFailure);
            this.setBtnStatus(this.label_error);
        }
    }

    public void notifyStatus(int n, Object object) {
        if (n < 0) {
            boolean bl = this.isInvisible = !this.isVisible();
            if (this.isInvisible) {
                this.setVisible(true);
            }
            this.setBackground(this.colorFailure);
            this.setBtnStatus(this.label_error);
        }
    }
}

