/*
 * Decompiled with CFR 0.152.
 */
package org.alov.viewer;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import org.alov.map.Carte;
import org.alov.map.MapUtils;

class TipRect
extends Canvas {
    private Carte map;
    private Container containerOnWhichTheTooltipShows;
    private String caption;
    private int x;
    private int y;
    private int width;
    private int height;
    private Font tooltipFont;
    private boolean fill;
    private boolean outline;
    private Color fillColor;
    private Color outlineColor;
    private boolean bWrap = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TipRect(String string, Font font, Carte carte, Point point, boolean bl, boolean bl2, Color color, Color color2, int n) {
        this.map = carte;
        this.containerOnWhichTheTooltipShows = carte.getParent();
        this.containerOnWhichTheTooltipShows.add(this);
        this.caption = string;
        this.tooltipFont = font;
        FontMetrics fontMetrics = null;
        Graphics graphics = carte.getGraphics();
        try {
            if (font != null) {
                graphics.setFont(font);
            }
            fontMetrics = graphics.getFontMetrics();
            this.width = fontMetrics.stringWidth(string) + 3;
            if (n > 0 && this.width > n) {
                this.bWrap = true;
                Dimension dimension = MapUtils.getTextDimension(string, graphics, n, true);
                this.height = dimension.height + 4;
                this.width = dimension.width + 10;
            } else {
                this.height = fontMetrics.getHeight() + 2;
            }
        }
        finally {
            graphics.dispose();
        }
        point.y -= this.height;
        if (point.x < 0) {
            point.x = 0;
        }
        if (point.y < 0) {
            point.y = 0;
        }
        if (point.x + this.width > this.containerOnWhichTheTooltipShows.getSize().width) {
            point.x = this.containerOnWhichTheTooltipShows.getSize().width - this.width;
        }
        if (point.y + this.height > this.containerOnWhichTheTooltipShows.getSize().height) {
            point.y = this.containerOnWhichTheTooltipShows.getSize().height - this.height;
        }
        this.x = point.x;
        this.y = point.y;
        this.fill = bl;
        this.outline = bl2;
        this.fillColor = color;
        this.outlineColor = color2;
    }

    void dispose() {
        this.containerOnWhichTheTooltipShows.remove(this);
        this.map.updateMap();
    }

    public void paint(Graphics graphics) {
        if (this.fill) {
            graphics.setColor(this.fillColor);
            graphics.fillRect(this.x, this.y, this.width, this.height);
        }
        graphics.setColor(this.outlineColor);
        if (this.outline) {
            graphics.drawRect(this.x, this.y, this.width, this.height);
        }
        if (this.tooltipFont != null) {
            graphics.setFont(this.tooltipFont);
        }
        if (this.bWrap) {
            MapUtils.drawText(graphics, this.caption, this.x + 2, this.y, this.width, this.height, true, false);
        } else {
            graphics.drawString(this.caption, this.x + 2, this.y + this.height - 4);
        }
    }
}

