/*
 * Decompiled with CFR 0.152.
 */
package org.alov.viewer;

import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.StringTokenizer;
import org.alov.map.Carte;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.Layer;
import org.alov.map.MapUtils;
import org.alov.map.Project;
import org.alov.map.StatusListener;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;
import org.alov.viewer.ImageButton;

public class ToolBar
extends Panel
implements CarteHostListener,
ItemListener,
KeyListener,
ActionListener,
StatusListener {
    private static final String BTN_STATUS = "btn_status";
    private static final String BTN_ZOOMFULL = "btn_zoomfull";
    private static final String BTN_ZOOMLYR = "btn_zoomlayer";
    private static final String BTN_GETDATA = "btn_getdata";
    private static final String BTN_SEARCH = "btn_search";
    private static final String BTN_TIPS = "btn_tips";
    private static final String BTN_HELP = "btn_help";
    private static final String LST_DOMAINS = "lst_domains";
    private static final String LST_THEMES = "lst_themes";
    private static final String TXT_SEARCH = "txt_search";
    private static final String TF_SEARCH = "tf_search";
    private Carte map = null;
    private boolean isExact = false;
    private String helpFile = null;
    private TextField searchField = null;
    private Color SF_ENABLED_COLOR = null;
    private Color SF_DISABLED_COLOR = null;
    private static String STR_DISABLED_COLOR = "txt_search_disabled";
    public String searchLayer = null;

    private void execSearch() {
        if (this.searchField != null && this.map != null) {
            this.map.searchAttribute(this.searchLayer, this.searchField.getText(), this.isExact ? 1 : 2);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Component) {
            String string = ((Component)object).getName();
            byte by = Carte.getToolCode(string);
            if (by != 0) {
                this.map.setTool(by);
            } else if (string.equalsIgnoreCase(BTN_ZOOMFULL)) {
                this.map.zoomToFullExtent();
                this.map.updateMap();
            } else if (string.equalsIgnoreCase(BTN_ZOOMLYR)) {
                this.map.zoomToLayer(this.map.getActiveLayer());
            } else if (string.equalsIgnoreCase(BTN_GETDATA)) {
                this.map.showAttribForSelection(null, 30, null);
            } else if (string.equalsIgnoreCase(BTN_TIPS)) {
                MapUtils.isTipsActive = !MapUtils.isTipsActive;
                ((ImageButton)object).setDown(MapUtils.isTipsActive);
            } else if (string.equalsIgnoreCase(BTN_SEARCH)) {
                this.execSearch();
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 10) {
            this.execSearch();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Component component = (Component)itemEvent.getSource();
        String string = (String)itemEvent.getItem();
        String string2 = component.getName();
        if (string2.equalsIgnoreCase(LST_DOMAINS)) {
            this.map.zoomToDomain(string);
            this.map.updateMap();
        } else if (string2.equalsIgnoreCase(LST_THEMES)) {
            this.map.setThematicMap(string);
            this.map.updateMap();
        }
    }

    public void setParameters(CarteHost carteHost, XmlElement xmlElement) {
        this.SF_DISABLED_COLOR = XmlUtils.getColor(STR_DISABLED_COLOR, xmlElement, null);
        this.isExact = XmlUtils.getBoolean("equal", xmlElement, false);
        this.helpFile = XmlUtils.getLangString("helpdoc", xmlElement, "help_en.html", MapUtils.language);
        this.searchLayer = XmlUtils.getString("layer", xmlElement, null);
        this.map = carteHost.getMapByName(xmlElement);
        this.map.statusListeners.addElement(this);
    }

    public void stop() {
    }

    public void afterProjectLoaded(boolean bl) {
        if (bl) {
            Component component;
            StringTokenizer stringTokenizer;
            Project project = this.map.getProject();
            Choice choice = (Choice)MapUtils.findComp(this, LST_DOMAINS);
            if (choice != null) {
                choice.removeAll();
                stringTokenizer = new StringTokenizer(project.domainsNames, "\n\r");
                while (stringTokenizer.hasMoreTokens()) {
                    choice.add(stringTokenizer.nextToken());
                }
                choice.addItemListener(this);
                if (project.startExtentName != null) {
                    choice.select(project.startExtentName);
                }
            }
            if ((choice = (Choice)MapUtils.findComp(this, LST_THEMES)) != null) {
                stringTokenizer = new StringTokenizer(project.themesNames, "\n\r");
                while (stringTokenizer.hasMoreTokens()) {
                    choice.add(stringTokenizer.nextToken());
                }
                choice.addItemListener(this);
                if (project.startTheme != null) {
                    choice.select(project.startTheme);
                }
            }
            this.searchField = (TextField)MapUtils.findComp(this, TXT_SEARCH);
            if (this.searchField == null) {
                this.searchField = (TextField)MapUtils.findComp(this, TF_SEARCH);
            }
            if (this.searchField != null) {
                this.SF_ENABLED_COLOR = this.searchField.getBackground();
                this.searchField.addKeyListener(this);
            }
            MapUtils.addActionListener(this, this);
            if (MapUtils.isTipsActive && (component = MapUtils.findComp(this, BTN_TIPS)) != null) {
                ((ImageButton)component).setDown(true);
            }
        }
    }

    public void notifyStatus(int n, Object object) {
        Choice choice;
        if (n == 112) {
            Component component;
            String string = Carte.getToolName(this.map.getTool());
            if (string != null && (component = MapUtils.findComp(this, string)) != null) {
                ((ImageButton)component).setDown(true);
            }
        } else if (n == 107 || n == 11 && object == null) {
            boolean bl;
            Object object2;
            Layer layer = this.map.getActiveLayer();
            if (layer != null) {
                object2 = layer.linkSearch != null ? layer.linkSearch : this.map.getProject().linkSearch;
                bl = layer.canSearch && (layer.fi_description >= 0 || layer.isGeocoding || object2 != null);
            } else {
                bl = false;
            }
            if (this.searchField != null) {
                this.searchField.setEnabled(bl);
                object2 = bl ? this.SF_ENABLED_COLOR : this.SF_DISABLED_COLOR;
                this.searchField.setBackground((Color)object2);
            }
            object2 = null;
            object2 = MapUtils.findComp(this, BTN_SEARCH);
            if (object2 != null) {
                ((Component)object2).setEnabled(bl);
            }
        } else if (n == 106 && object != null && (choice = (Choice)MapUtils.findComp(this, LST_THEMES)) != null) {
            String string = (String)object;
            choice.select(string);
        }
    }
}

